/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Perl;

import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Script.Perl.OpenPerlAction;
import UI_Script.Perl.PerlListener;
import UI_Script.Perl.PerlTokenizer;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.io.File;
import javax.swing.JMenuItem;
import kernal.Tokenizers.Tokenizer;

public class PerlScriptHandler
extends ScriptHandler {
    @Override
    public boolean canRunSelection() {
        return true;
    }

    public PerlScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".pl";
        this.ext[1] = ".PL";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new PerlTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.pl");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Perl";
    }

    @Override
    public String getExecuteLabel() {
        return "Execute " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        String args = "";
        String input = BBxt.getWindowText();
        if (input == null) {
            return;
        }
        Tokenizer tok = new Tokenizer();
        tok.setBuffer(input);
        tok.addQuotation("\"", "\"", '\\');
        args = tok.getValueForToken("ARGS", true);
        String[] items = args != null ? new String[]{"perl", file.getPath(), args} : new String[]{"perl", file.getPath()};
        ProcessManager fp = new ProcessManager("Perl");
        fp.launch(items, null, false, null, false);
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.pl");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return PerlListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Perl");
        item.addActionListener(new OpenPerlAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("pl", "Perl Script");
        return filter;
    }
}

