/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Perl;

import UI_Desktop.Cutter;
import UI_Script.Perl.PERLFunctionsRsrc;
import UI_Script.Rib.RibTokenizer;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class PerlTokenizer
extends RibTokenizer {
    public static final String SPECIAL_VARIABLE = "special_variable";
    private static ResourceBundle PERLFunctionsRes;
    private static Hashtable<String, String> language;
    public static boolean _debug;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = PERLFunctionsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((PERLFunctionsRsrc)PERLFunctionsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read PERLFunctionsRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < PerlTokenizer.numLanguageItems(); ++i) {
            language.put(((PERLFunctionsRsrc)PERLFunctionsRes).getKey(i), ((PERLFunctionsRsrc)PERLFunctionsRes).getContent(i));
        }
    }

    public PerlTokenizer() {
        this.addComment("#", "\n");
        this.addQuotation("\"", "\"", '\\');
        this.setSyntaxLength(1);
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.addEscape("\\\"", "");
        this.addEscape("\\\\", "");
        this.addEscape("\\'", "");
        String[] ext = new String[]{"pl", "PL"};
        Tokenizer.addToRegistry(PerlTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean isUserVariable(String str) {
        return false;
    }

    public boolean isGlobalSpecialVariable(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals(SPECIAL_VARIABLE);
        }
        return false;
    }

    public boolean isCommandSubstitution(String str) {
        return str.charAt(0) == '[';
    }

    @Override
    public boolean isComment(String str) {
        return str.charAt(0) == '#';
    }

    @Override
    public boolean isSystemHeader(String str) {
        return false;
    }

    @Override
    public boolean isFunction(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("function");
        }
        return false;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("language");
        }
        return false;
    }

    public String __getNextStr() {
        char c;
        boolean literal = false;
        boolean perlReference = false;
        boolean endOfString = false;
        boolean endOfComment = false;
        if (this.debug) {
            Cutter.setLog("Entered GetNextStr");
        }
        if ((c = this.readChar()) == '\u0000') {
            if (_debug) {
                Cutter.setLog("GetNextStr, readChar() ERROR, char = >" + c + "< index = " + this.getBufferIndex());
            }
            return "";
        }
        this.outBuff.setLength(0);
        if (_debug) {
            Cutter.setLog("\nGetNextStr, read first char =  >" + c + "<");
        }
        if (this.isSpace(c)) {
            c = this.removeSpace();
        }
        if (c == '\u0000') {
            return "";
        }
        if (_debug) {
            Cutter.setLog("GetNextStr, appending =  >" + c + "<");
        }
        this.outBuff.append(c);
        if (c == ';') {
            return this.outBuff.toString();
        }
        if (c == '#' && this.getComments) {
            if (_debug) {
                Cutter.setLog("GetNextStr, found #");
            }
            if ((c = this.readChar()) == '\u0000' || c == '\r' || c == '\n') {
                return this.outBuff.toString();
            }
            do {
                if (_debug) {
                    Cutter.setLog("GetNextStr, in comment loop");
                }
                this.outBuff.append(c);
                c = this.readChar();
                if (c != '\u0000') continue;
                return this.outBuff.toString();
            } while (c != '\r' && c != '\n');
            this.ungetChar();
            return this.outBuff.toString();
        }
        if (this.isDelimitor(c)) {
            if (_debug) {
                Cutter.setLog("GetNextStr, " + c + " is punctuation. Returning >" + this.outBuff.toString() + "<");
            }
            return this.outBuff.toString();
        }
        if (c == '\"') {
            if (_debug) {
                Cutter.setLog("GetNextStr, found kQuotes. Setting literal to true");
            }
            literal = true;
        }
        if (c == '\\') {
            char nextChar = this.peekNextChar();
            if (Character.isDigit(c) || nextChar == '$' || nextChar == '@' || nextChar == '&' || nextChar == '%' || nextChar == '\"') {
                if (_debug) {
                    Cutter.setLog("GetNextStr, found kBSlash. Setting perlReference to true");
                }
                perlReference = true;
            }
        }
        if (_debug) {
            Cutter.setLog("GetNextStr, entering main loop |" + c + "|");
        }
        if (_debug) {
            Cutter.setLog("GetNextStr, literal " + literal);
        }
        if (_debug) {
            Cutter.setLog("GetNextStr, perlReference " + perlReference);
        }
        block11: while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            if (_debug) {
                Cutter.setLog("GetNextStr, main loop literal " + literal + " c = |" + c + "|");
            }
            switch (c) {
                case '\u0000': {
                    return this.outBuff.toString();
                }
                case '\\': {
                    if (perlReference) {
                        if (!_debug) break;
                        Cutter.setLog("GetNextStr, kBSlash break for perlReference");
                        break;
                    }
                    if (literal) break;
                    if (_debug) {
                        Cutter.setLog("GetNextStr, kBSlash nobreak for perlReference");
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\"': {
                    if (perlReference) {
                        if (!_debug) break;
                        Cutter.setLog("GetNextStr, kQuotes break for perlReference");
                        break;
                    }
                    if (literal) {
                        if (this.peekPrevChar(2) == '\\') {
                            this.outBuff.append(c);
                            continue block11;
                        }
                        this.outBuff.append(c);
                        return this.outBuff.toString();
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '$': {
                    if (this.peekPrevChar(2) == '\\') {
                        this.outBuff.append(c);
                        continue block11;
                    }
                }
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '}': {
                    if (literal) break;
                    if (_debug) {
                        Cutter.setLog("Parenthesis c = " + c + " buff = |" + this.outBuff.toString() + "|");
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\t': 
                case ' ': {
                    if (literal || perlReference) {
                        if (!_debug) break;
                        Cutter.setLog("GetNextStr, kSpace break");
                        break;
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\n': 
                case '\r': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '/': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        if (_debug) {
            Cutter.setLog("getNextStr() is returning:" + this.outBuff.toString());
        }
        return this.outBuff.toString();
    }

    @Override
    public boolean isEscaped(char c0, char c1) {
        if (c0 != '\\') {
            return false;
        }
        switch (c1) {
            case '\t': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\\': {
                return true;
            }
            case '\'': {
                return true;
            }
        }
        return false;
    }

    public boolean isReference(String str) {
        if (str.length() < 2) {
            return false;
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(1);
        return c0 == '\\' && (Character.isDigit(c1) || c1 == '$' || c1 == '@' || c1 == '&' || c1 == '%' || c1 == '\"');
    }

    static {
        language = new Hashtable();
        try {
            PERLFunctionsRes = ResourceBundle.getBundle("UI_Script.Perl.PERLFunctionsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: PERLFunctionsRsrc = " + mre);
        }
        PerlTokenizer.initHashTable();
        _debug = false;
        try {
            Field[] fields = new Field[]{PerlTokenizer.class.getDeclaredField("_debug")};
            Cutter.addDebug(PerlTokenizer.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: PerlTokenizer.static - " + ex.toString());
        }
    }
}

