/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.AbstractDevkit;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.C.CDocumentation;
import UI_Script.C.CTokenizer;
import UI_Script.Cpp.CppTokenizer;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.KCompletionManager;
import UI_Script.Help.Url;
import UI_Script.PixarDev.AbstractDevkit.DevkitTokenizer;
import UI_Script.PixarDev.AbstractDevkit.HeaderLookup;
import UI_Script.Rib.RibHelp;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Find.FindTool;
import Utilities.RibDocsUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Segment;

public abstract class DevkitHelp
extends KAbstractHelp {
    private static Hashtable<String, String> languageTable;
    private static Hashtable<String, String> c_Table;
    private DevkitTokenizer devkitTok = new DevkitTokenizer();
    protected String defaultDocURL = "";

    public DevkitHelp(KTextPane textpane) {
        super(textpane);
        this.setDefaultDocURL();
        this.completer.completionActivate();
        char[] delims = KCaret.getDefaultDelimitors();
        char[] modified = new char[delims.length - 1];
        int counter = 0;
        for (int n = 0; n < delims.length; ++n) {
            if (delims[n] == '#') continue;
            modified[counter] = delims[n];
            ++counter;
        }
        this.completer.setWordStartDelims(modified);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        if (str.startsWith("#")) {
            return true;
        }
        if (str.startsWith("k_") && str.length() > 3) {
            return true;
        }
        return str.length() >= KCompletionManager.MIN_LEN;
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    protected abstract void setDefaultDocURL();

    protected String getUrlForItem(String item) {
        String className = null;
        Object methodName = null;
        String docUrl = item == null || item.trim().length() == 0 ? this.defaultDocURL : (item.equals("RslContext") ? Url.ri.appnote_classRslContext_html : (item.equals("RslArg") ? Url.ri.appnote_classRslArg_html : (item.equals("RslIter") || item.equals("RslFloatIter") || item.equals("RslPointIter") ? Url.ri.appnote_classRslIter_html : (item.equals("RslArrayIter") ? Url.ri.appnote_classRslArrayIter_html : ((className = this.devkitTok.isMethod(item)) != null ? (className.equals("RslContextMethod") ? Url.ri.appnote_classRslContext_html : (className.equals("RslArgMethod") ? Url.ri.appnote_classRslArg_html : this.defaultDocURL)) : this.defaultDocURL)))));
        return Url.join(RibHelp.getRPSDocsRoot(), docUrl);
    }

    @Override
    protected void lookup(String item) {
        Cutter.setLog("DevkitHelp.lookup() item is \"" + item + "\"");
        String url = null;
        if (item.startsWith("Ri")) {
            item = item.substring(2);
            Cutter.setLog("DevkitHelp.lookup() item \"" + item + "\"");
            url = RibDocsUtils.lookupURL(item);
        } else {
            url = CDocumentation.stdioTable.containsKey(item) ? "http://www.cplusplus.com/reference/cstdio/" + item : (CDocumentation.stringTable.containsKey(item) ? "http://www.cplusplus.com/reference/cstring/" + item : (CDocumentation.mathTable.containsKey(item) ? "http://www.cplusplus.com/reference/cmath/" + item : (CDocumentation.stdlibTable.containsKey(item) ? "http://www.cplusplus.com/reference/cstdlib/" + item : (CDocumentation.stddefTable.containsKey(item) ? "http://www.cplusplus.com/reference/cstddef/" + item : (CDocumentation.ctypesTable.containsKey(item) ? "http://www.cplusplus.com/reference/cctype/" + item : "http://www.cplusplus.com/reference")))));
        }
        this.setHelpPage(url);
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        if (e.getModifiersEx() < 20) {
            Cutter.setLog("    Debug:DevkitHelp.showDocFor() - return false because e.getModifiers() < 20");
            return false;
        }
        this.useCutterBrowser = false;
        Cutter.setLog("DevkitHelp.showDocFor() useCutterBrowser is set to " + this.useCutterBrowser);
        return this.launchBrowser(item);
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
        this.popupOnlineHelp(pnt, BBxt.getSelection(), insertAt, e);
    }

    protected KAbstractHelp.KPopupMenu getDefaultDevkitPopup(String title, final String sel, int at) {
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        final KAbstractHelp.KPopupMenuItem lookupmenu = new KAbstractHelp.KPopupMenuItem(title);
        popup.add(lookupmenu);
        lookupmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String header;
                String selection = sel;
                if (sel.trim().length() == 0) {
                    Segment seg = BBxt.getSelection(null);
                    selection = seg.toString();
                }
                if ((header = HeaderLookup.tableDB.get(selection)) == null || header.trim().length() == 0) {
                    Cutter.setLog("    Error:RixPatterHelp.openHeader() - no header file for >" + selection + "<");
                    return;
                }
                String path = null;
                if (path == null || path.trim().length() == 0) {
                    path = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
                }
                if (path == null || path.trim().length() == 0) {
                    Cutter.setLog("    Debug:DevkitHelp.getDefaultDevkitPopup().actionPerformed() - cannot find path to pro-server installation");
                    return;
                }
                File includeDir = new File(path, "include");
                final File headerFile = new File(includeDir, header);
                Cutter.setLog("    Debug:DevkitHelp.getDefaultDevkitPopup().actionPerformed() - headerFile \"" + headerFile.getPath() + "\"");
                if (!headerFile.exists()) {
                    Cutter.setLog("    Debug:DevkitHelp.getDefaultDevkitPopup().actionPerformed() - headerFile does not exist \"" + headerFile.getPath() + "\"");
                    JOptionPane.showMessageDialog(KDesktop.desktopPane, "Unable to find,\n     \"" + headerFile.getPath() + "\"\nOpen the Preferences Tool and choose the\n     Languages->Pixar Devkit tab.\nEnsure the path to RenderManProSever is correct.\n\n", "Cannot Find Header File", 0);
                    return;
                }
                final FindTool finder = FindTool.init();
                if (!finder.isVisible()) {
                    finder.showSelf();
                }
                final String target = selection;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BBxt.newDocument(headerFile);
                        FindTool.setFindText(target, false);
                        FindTool.ignoreCase(false);
                        FindTool.wholeWord(true);
                        1 v0 = this;
                        v0.finder.clickFindButton();
                    }
                });
            }
        });
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Segment seg = BBxt.getSelection(null);
                String selection = seg.toString();
                String header = HeaderLookup.tableDB.get(selection);
                if (header == null || header.trim().length() == 0) {
                    lookupmenu.setEnabled(false);
                } else {
                    lookupmenu.setEnabled(true);
                    lookupmenu.setText("Find in \"" + header + "\"");
                }
            }
        });
        return popup;
    }

    public boolean isFunction(String str) {
        if (!c_Table.containsKey(str)) {
            return false;
        }
        return c_Table.get(str).equals("function");
    }

    static {
        String str;
        languageTable = new Hashtable();
        c_Table = new Hashtable();
        Enumeration<String> e = DevkitTokenizer.devkitTypes.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        e = HeaderLookup.tableDB.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        e = CppTokenizer.language.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        e = CTokenizer.language.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
            c_Table.put(str, CTokenizer.language.get(str));
        }
        e = languageTable.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            if (!str.startsWith("#")) continue;
            languageTable.put(str, str.substring(1));
        }
    }
}

