/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.AbstractDevkit;

import Preferences.Preferences;
import UI_Script.PixarDev.AbstractDevkit.DevkitTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import java.awt.Color;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public abstract class DevkitListener
extends SyntaxListener {
    private DevkitTokenizer devkitTok = new DevkitTokenizer();

    public DevkitListener(KTextPane textpane) {
        super(textpane, new DevkitTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    public DevkitListener(KTextPane textpane, Tokenizer tok) {
        super(textpane, tok);
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.languageStyle, Color.blue);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_C_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_DATATYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_MIC_VARIABLE).darker());
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_MIC_VARIABLE).brighter());
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.equals("SHADEOP_TABLE") || str.equals("SHADEOP_INIT") || str.equals("SHADEOP_CLEANUP") || str.equals("SHADEOP")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (str.equals("RSLEXPORT")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (str.equals("ConvertParameters") || str.equals("Subdivide") || str.equals("Free") || str.equals("SHADEOP")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (str.equals("FIELDCREATE")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (this.devkitTok.isMethod(str) != null) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle4, true);
            return true;
        }
        if (this.devkitTok.isClass(str) != null) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        return false;
    }
}

