/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.AbstractDevkit;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Bat.BatTokenizer;
import UI_Script.BuildMsgListener;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Make.MakeTokenizer;
import UI_Script.PixarDev.BrickMap.BrickMapScriptHandler;
import UI_Script.PixarDev.DeepTexture.DeepTextureScriptHandler;
import UI_Script.PixarDev.ImplicitPlugin.ImplicitPluginScriptHandler;
import UI_Script.PixarDev.PointCloud.PointCloudScriptHandler;
import UI_Script.PixarDev.ProceduralPrimitive.ProceduralPrimitiveScriptHandler;
import UI_Script.PixarDev.RifPlugin.RifPluginScriptHandler;
import UI_Script.PixarDev.RixPlugins.RixPluginScriptHandler;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptParser;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Monitor.Monitor;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Tabs.Options.DevkitOptionsTabPanel;
import UI_Tools.Rman.Tabs.Options.subpanels.PostBuildPanel;
import Utilities.DevkitUtils;
import Utilities.DialogUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import kernal.Tokenizers.Tokenizer;

public abstract class DevkitScriptHandler
extends ScriptHandler
implements ProcListener {
    public static final String[] errorStrs = new String[]{"error", "Undefined Symbols"};
    public static final String PROCEDURAL = "_PROCEDURAL_NAME_";
    public static final String IMPLICIT = "_IMPLICIT_PLUGIN_NAME_";
    public static final String RIXPLUGIN = "_RIX_PLUGIN_NAME_";
    public static final String BRICKMAP = "_BRICKMAP_EXE_NAME_";
    public static final String POINTCLOUD = "_POINTCLOUD_EXE_NAME_";
    public static final String DEEPTEXTURE = "_DEEPTEXTURE_EXE_NAME_";
    protected String compile_OSX = null;
    protected String compile_WIN = null;
    protected String compile_LIN = null;
    protected String DSO_EXE_STR = null;
    private final String _DEVKIT_PATH_ = "(_DEVKIT_PATH_)";
    private final String _OTHER_INCLUDE_DIRS_ = "(_OTHER_INCLUDE_DIRS_)";
    private final String _OTHER_LIB_DIRS_ = "(_OTHER_LIB_DIRS_)";
    private final String _OTHER_LIBS_ = "(_OTHER_LIBS_)";
    private final String _OTHER_OBJS_ = "(_OTHER_OBJS_)";
    private final String _OTHER_SRCS_ = "(_OTHER_SRCS_)";
    private final String _USER_FLAGS_ = "(_USER_FLAGS_)";
    private final String _PATH_TO_RENDERER_ = "(_PATH_TO_RENDERER_)";
    private final String _RIX_PLUGIN_PATH_ = "(_RIX_PLUGIN_PATH_)";
    private final String _OUT_PATH_ = "(_OUT_PATH_)";
    private final String _OUT_OBJ_ = "(_OUT_OBJ_)";
    private final String _OUT_LIB_ = "(_OUT_LIB_)";
    private final String _OUT_EXP_ = "(_OUT_EXP_)";
    private final String USER_BAT = "Build: Users custom VS .bat";
    private final String USER_MAKEFILE = "Build: Users custom makefile";
    private final String USER_TEMPLATE_BAT = "Build: Users custom VS .bat";
    private final String USER_TEMPLATE_MAKEFILE = "Build: Users custom makefile";
    private final String CUTR_BAT = "Build: Cutter generated VS .bat";
    private final String CUTR_MAKEFILE = "Build: Cutter generated makefile";
    private String monitorInitText = null;
    private String usersMakefileName = "";
    protected File dsoDestFile = null;
    protected File cppSrcFile = null;
    private boolean buildFromTemplate = false;
    protected boolean failure = false;
    protected Vector<BuildMsgListener> buildListeners = new Vector();
    private Tokenizer tok = null;

    public void addBuildListener(BuildMsgListener bl) {
        for (int n = 0; n < this.buildListeners.size(); ++n) {
            if (this.buildListeners.elementAt(n) != bl) continue;
            return;
        }
        this.buildListeners.add(bl);
    }

    public void removeBuildListener(BuildMsgListener bl) {
        this.buildListeners.remove(bl);
    }

    public DevkitScriptHandler() {
        this.setMakefileName_OSX();
        this.setMakefileName_LIN();
        this.setMakefileName_WIN();
        this.setMakefileDSO_EXE_STR();
    }

    @Override
    public void deleteTmpFile() {
        for (int n = 0; n < this.ext.length; ++n) {
            File tmp = new File(FileUtils.getPWD(), "temp" + this.ext[n]);
            if (!tmp.exists()) continue;
            tmp.delete();
        }
    }

    @Override
    public KFileFilter getFileFilter() {
        return null;
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        return null;
    }

    @Override
    public abstract String getScriptName();

    protected abstract void setMakefileName_OSX();

    protected abstract void setMakefileName_LIN();

    protected abstract void setMakefileName_WIN();

    protected abstract void setMakefileDSO_EXE_STR();

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        String name = DevkitUtils.getDevkitHelpFullName(textpane.getFrameFile());
        KAbstractHelp helper = KAbstractHelp.getInstanceByName(name, textpane);
        Cutter.setLog("    Debug:getHelper for name \"" + name + "\" obtained \"" + helper + "\"\n");
        return helper;
    }

    public ScriptHandler getSpecificHandler(File file) {
        BrickMapScriptHandler bmsh = new BrickMapScriptHandler();
        if (bmsh.canHandle(file)) {
            return bmsh;
        }
        DeepTextureScriptHandler dtsh = new DeepTextureScriptHandler();
        if (dtsh.canHandle(file)) {
            return dtsh;
        }
        ImplicitPluginScriptHandler ipsh = new ImplicitPluginScriptHandler();
        if (ipsh.canHandle(file)) {
            return ipsh;
        }
        PointCloudScriptHandler pcsh = new PointCloudScriptHandler();
        if (pcsh.canHandle(file)) {
            return pcsh;
        }
        ProceduralPrimitiveScriptHandler ppsh = new ProceduralPrimitiveScriptHandler();
        if (ppsh.canHandle(file)) {
            return ppsh;
        }
        RifPluginScriptHandler rfsh = new RifPluginScriptHandler();
        if (rfsh.canHandle(file)) {
            return rfsh;
        }
        RixPluginScriptHandler rxsh = new RixPluginScriptHandler();
        return rxsh;
    }

    @Override
    public abstract String getSyntaxListenerClassName(KTextPane var1);

    @Override
    public boolean canHandle(String extension) {
        return false;
    }

    @Override
    public boolean canHandle(File file) {
        int scriptType = DevkitUtils.getDevkitScriptType(file);
        return scriptType != DevkitUtils.NOT_DEVKIT;
    }

    @Override
    public File convertSelectionToFile(String sel) {
        File defaultDir;
        File devkitSrcDir;
        File f;
        if (sel == null || sel.trim().length() == 0) {
            return null;
        }
        String p = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        if (p != null && p.trim().length() > 0 && (f = new File(devkitSrcDir = new File(p, "include"), sel)).exists()) {
            return f;
        }
        if (!EnvUtils.isWinEnvironment() && p != null && p.trim().length() > 0 && (f = new File(defaultDir = new File("/usr/include"), sel)).exists()) {
            return f;
        }
        if (EnvUtils.isWinEnvironment() && p != null && p.trim().length() > 0 && (f = new File(defaultDir = new File("C:\\Program Files\\Microsoft Visual Studio 8\\VC\\include"), sel)).exists()) {
            return f;
        }
        if (Cutter.input.debug) {
            Cutter.setLog("    Debug:DevkitScriptHandler.convertSelectionToFile() - cannot convert " + sel);
        }
        return null;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    public static void createDocument(String title, String docType) {
    }

    private String inferSrcsFromIncludes(File srcFile) {
        this.tok = this.tokenizer;
        String[][] includes = null;
        ScriptParser sp = null;
        Vector<String> outList = new Vector<String>();
        try {
            sp = new ScriptParser(this.tok, FileUtils.read(srcFile));
            includes = sp.getImports();
        }
        catch (Exception ee) {
            Cutter.setLog("    Error:DevkitScriptHandler.inferSrcsFromIncludes()\n        " + ee.toString());
            return "";
        }
        if (includes == null || includes[1] == null || includes[1].length == 0) {
            return "";
        }
        File parentDir = srcFile.getParentFile();
        for (int n = 0; n < includes[1].length; ++n) {
            includes[1][n] = TextUtils.removeExtension(includes[1][n]);
            File fc = new File(parentDir, includes[1][n] + ".c");
            File fcpp = new File(parentDir, includes[1][n] + ".cpp");
            if (fc.exists() && fcpp.exists()) {
                Cutter.setLog("    Warning:DevkitScriptHandler.inferSrcsFromIncludes()\n        a '.c' and a '.cpp' with the same name has been found in\n        \"" + parentDir.getPath() + "\". Cutter will add the '.c'\n        to the build and will ignore the '.cpp' source code file.");
            }
            if (fc.exists()) {
                outList.addElement(includes[1][n] + ".c");
                continue;
            }
            if (!fcpp.exists()) continue;
            outList.addElement(includes[1][n] + ".cpp");
        }
        return VectorUtils.vectorToSpacedString(outList);
    }

    private String inferObjsFromIncludes(File srcFile) {
        this.tok = this.tokenizer;
        String[][] includes = null;
        ScriptParser sp = null;
        Vector<String> outList = new Vector<String>();
        try {
            sp = new ScriptParser(this.tok, FileUtils.read(srcFile));
            includes = sp.getImports();
        }
        catch (Exception ee) {
            Cutter.setLog("    Error:DevkitScriptHandler.inferSrcsFromIncludes()\n        " + ee.toString());
            return "";
        }
        if (includes == null || includes[1] == null || includes[1].length == 0) {
            return "";
        }
        File parentDir = srcFile.getParentFile();
        for (int n = 0; n < includes[1].length; ++n) {
            String ext;
            includes[1][n] = TextUtils.removeExtension(includes[1][n]);
            File fc = new File(parentDir, includes[1][n] + ".c");
            File fcpp = new File(parentDir, includes[1][n] + ".cpp");
            if (fc.exists() && fcpp.exists()) {
                Cutter.setLog("    Warning:DevkitScriptHandler.inferObjsFromIncludes()\n        a '.c' and a '.cpp' with the same name has been found in\n        \"" + parentDir.getPath() + "\". Cutter will add the '.c'\n        to the build and will ignore the '.cpp' source code file.");
            }
            String string = ext = EnvUtils.isWinEnvironment() ? ".obj" : ".o";
            if (!fc.exists() && !fcpp.exists()) continue;
            outList.addElement(includes[1][n] + ext);
        }
        return VectorUtils.vectorToSpacedString(outList);
    }

    protected boolean _doBuildFromTemplate(File buildFile) {
        boolean result = true;
        if (buildFile.exists()) {
            String text = FileUtils.read(buildFile);
            Tokenizer tok = new MakeTokenizer();
            if (EnvUtils.isWinEnvironment()) {
                tok = new BatTokenizer();
            }
            ScriptParser parser = new ScriptParser(tok, text);
            ScriptStructure struct = parser.getStructure();
            Object firstComment = null;
            if (struct != null) {
                String[] comments = struct.getComments();
                if (comments == null) {
                    return false;
                }
                if (comments.length >= 1 && comments[0].startsWith("Maintained by Cutter")) {
                    return true;
                }
                if (comments.length >= 1 && !comments[0].startsWith("Maintained by Cutter")) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp" + this.ext[0]);
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    public void execute(File file, boolean shiftDown) {
        this.execute(file);
    }

    @Override
    public void execute(File file) {
        int devkitType = DevkitUtils.getDevkitScriptType(file);
        Cutter.setLog("    Debug:DevkitScriptHandler.execute() - devkitType = " + devkitType);
        String devkitTypeStr = DevkitUtils.devkitTypeToString(devkitType);
        Cutter.setLog("    Debug:DevkitScriptHandler.execute() - DevkitUtils.devkitTypeToString = " + devkitTypeStr);
        String outpath = DevkitUtils.getDsoExeOutPath(file);
        String buildDirPath = DevkitUtils.getBuildDirPath(devkitType);
        if (buildDirPath.trim().length() == 0 || !new File(buildDirPath).exists()) {
            buildDirPath = file.getParent();
        }
        String dsoSrcParentDir = file.getParent();
        this.cppSrcFile = file;
        String dsoName = TextUtils.removeExtension(this.cppSrcFile.getName());
        this.dsoDestFile = new File(outpath);
        this.usersMakefileName = !EnvUtils.isWinEnvironment() ? "Makefile." + dsoName : "Build_" + dsoName + ".bat";
        File templateMakeFile = this.getTemplateMakefile();
        File usersMakeFile = null;
        if (templateMakeFile == null) {
            this.noTemplateError();
            return;
        }
        String srcParentPath = file.getParent();
        String pathToDevkit = "";
        if ((pathToDevkit = FileUtils.trimRight(pathToDevkit)).trim().length() == 0 && (pathToDevkit = Preferences.get(Preferences.PATH_PIXAR_PROSERVER)).trim().length() == 0 && (pathToDevkit = Preferences.get(Preferences.PATH_PIXAR_RMS)).trim().length() == 0) {
            String[] msg = new String[]{"To compile and build a plugin the path to:", "    RenderManProServer-XX.x", "\nMust be set in,", "   Preferences->RMan->Pixar->RPS Root.\n"};
            DialogUtils.showErrorMessage("Cannot Find Plugin Development Resources", msg);
            return;
        }
        pathToDevkit = pathToDevkit.replace('\\', '/');
        String libFlag = EnvUtils.isWinEnvironment() ? "-libpath:" : "-L";
        String pathsToIncludes = FileUtils.prefStrToFlaggedList("-I", Preferences.PATH_DEVKIT_USER_INCLUDE_DIRECTORIES);
        String pathsToLibs = FileUtils.prefStrToFlaggedList(libFlag, Preferences.PATH_DEVKIT_USER_LIB_DIRECTORIES);
        String otherLibs = FileUtils.prefStrToFlaggedList("", Preferences.PATH_DEVKIT_USER_LIBS);
        String otherObjs = FileUtils.prefStrToFlaggedList("", Preferences.PATH_DEVKIT_USER_OBJS);
        String userFlags = FileUtils.prefStrToFlaggedList("", Preferences.DEVKIT_USER_FLAGS);
        String inferedObjs = this.inferObjsFromIncludes(this.cppSrcFile);
        String inferedSources = this.inferSrcsFromIncludes(this.cppSrcFile);
        Cutter.setLog("==================================");
        Cutter.setLog("     Info: DevkitSciptHandler.execute() - inferedObjs >" + inferedObjs + "<");
        Cutter.setLog("     Info: DevkitSciptHandler.execute() - inferedSources >" + inferedSources + "<");
        Cutter.setLog("==================================");
        if (EnvUtils.isWinEnvironment()) {
            String winEnvScript = this.getTemplateWinEnvScript();
            String batStr = FileUtils.read(templateMakeFile);
            Cutter.setLog("---------------------templateMakeFile-------------------------");
            Cutter.setLog(batStr);
            Cutter.setLog("----------------------------------------------");
            batStr = batStr.replaceAll("(_SRC_FILENAME_)", this.cppSrcFile.getName());
            batStr = batStr.replaceAll("(" + this.DSO_EXE_STR + ")", dsoName);
            batStr = batStr.replaceAll("(_OTHER_INCLUDE_DIRS_)", pathsToIncludes);
            batStr = batStr.replaceAll("(_OTHER_LIB_DIRS_)", pathsToLibs);
            batStr = batStr.replaceAll("(_OTHER_LIBS_)", otherLibs);
            otherObjs = otherObjs + " " + inferedObjs;
            batStr = batStr.replaceAll("(_OTHER_OBJS_)", otherObjs);
            batStr = batStr.replaceAll("(_USER_FLAGS_)", userFlags);
            File dsoTmp = new File(outpath);
            String dsoNameWithExt = dsoTmp.getName();
            dsoTmp = new File(srcParentPath, dsoNameWithExt);
            outpath = dsoTmp.getPath();
            if (!buildDirPath.equals(dsoSrcParentDir)) {
                buildDirPath = FileUtils.convertToWindowsPathSeparator(buildDirPath);
                buildDirPath = TextUtils.trimTrailingChar(buildDirPath, '\\');
                batStr = batStr + "\n";
                batStr = batStr + "move " + dsoName + ".dll \"" + buildDirPath + "\\" + dsoName + ".dll\"\n";
                batStr = batStr + "echo \"" + buildDirPath + "\\" + dsoName + ".dll\"\n";
            }
            outpath = FileUtils.convertToWindowsPathSeparator(outpath);
            outpath = FileUtils.doubleEscapes(outpath);
            batStr = batStr.replaceAll("(_OUT_PATH_)", "\"" + outpath + "\"");
            batStr = batStr.replaceAll("(_OUT_OBJ_)", dsoName + ".obj");
            String libPath = dsoName + ".lib";
            String expPath = dsoName + ".exp";
            batStr = batStr.replaceAll("(_OUT_LIB_)", libPath);
            batStr = batStr.replaceAll("(_OUT_EXP_)", expPath);
            batStr = batStr.replaceAll("(_DEVKIT_PATH_)", pathToDevkit);
            batStr = inferedSources == null || inferedSources.trim().length() == 0 ? batStr.replaceAll("(_OTHER_SRCS_)", "") : batStr.replaceAll("(_OTHER_SRCS_)", inferedSources);
            File batFile = new File(file.getParentFile(), this.usersMakefileName);
            String fullBatText = winEnvScript + "\t\n" + batStr.replace('/', '\\');
            if (Cutter.input.debug) {
                Cutter.setLog("-------debug fullBatText--------\n" + fullBatText);
            }
            FileUtils.writeFile(batFile, fullBatText);
            this.monitorInitText = "Build: Cutter generated VS .bat";
            String[] item = new String[]{"cmd", "/Q", "/C", batFile.getName()};
            if (Cutter.input.debug) {
                Cutter.setLog("-------debug item array--------");
                Cutter.setLog(item);
            }
            DevkitScriptHandler dsh = this;
            ProcessManager fp = new ProcessManager(this.getScriptName());
            fp.launch(item, file.getParentFile(), true, this, false);
        } else {
            String makeStr = FileUtils.read(templateMakeFile);
            makeStr = makeStr.replaceAll("(" + this.DSO_EXE_STR + ")", dsoName);
            makeStr = makeStr.replaceAll("(_OTHER_INCLUDE_DIRS_)", pathsToIncludes);
            makeStr = makeStr.replaceAll("(_OTHER_LIB_DIRS_)", pathsToLibs);
            makeStr = makeStr.replaceAll("(_OTHER_LIBS_)", otherLibs);
            makeStr = makeStr.replaceAll("(_USER_FLAGS_)", userFlags);
            makeStr = makeStr.replaceAll("(_OUT_PATH_)", outpath);
            if (inferedObjs != null && inferedObjs.trim().length() > 0) {
                String target_dso = dsoName + ".o";
                StringBuffer buf = new StringBuffer();
                String[] tokens = TextUtils.tokenize(inferedObjs);
                for (int n = 0; n < tokens.length; ++n) {
                    String token = tokens[n].trim();
                    if (token.equals(target_dso)) continue;
                    buf.append(token).append(" ");
                }
                inferedObjs = buf.toString().trim();
                otherObjs = otherObjs + " " + inferedObjs;
            }
            makeStr = makeStr.replaceAll("(_OTHER_OBJS_)", otherObjs);
            makeStr = makeStr.replaceAll("(_DEVKIT_PATH_)", pathToDevkit);
            String binPath = RenderInfo.getBinPath();
            if (binPath.trim().length() > 0) {
                makeStr = RenderInfo.activeRendererIs("pixar") ? makeStr.replaceAll("(_PATH_TO_RENDERER_)", "\\$(RMANTREE)/bin/prman") : makeStr.replaceAll("(_PATH_TO_RENDERER_)", binPath + "/" + RenderInfo.get(3));
            }
            usersMakeFile = new File(file.getParentFile(), this.usersMakefileName);
            FileUtils.writeFile(usersMakeFile, makeStr);
            Monitor.setPanelText(this.getScriptName(), "Using make with a makefile created by Cutter.");
            this.monitorInitText = "Build: Cutter generated makefile";
            ProcessManager fp = new ProcessManager(this.getScriptName());
            String[] item = new String[]{"make", "-f", usersMakeFile.getName()};
            fp.launch(item, file.getParentFile(), true, this, false);
        }
    }

    private boolean failureHappened(String output) {
        for (int n = 0; n < errorStrs.length; ++n) {
            if (!TextUtils.contains(output, errorStrs[n], true)) continue;
            for (int i = 0; i < this.buildListeners.size(); ++i) {
                this.buildListeners.elementAt(i).buildFailed("Pixar Devkit: Build Failed 2");
            }
            return true;
        }
        return false;
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
        this.failure = false;
        Monitor.initErrorStrings(this.getScriptName(), errorStrs);
        for (int n = 0; n < this.buildListeners.size(); ++n) {
            this.buildListeners.elementAt(n).buildStarted();
        }
    }

    @Override
    public void processSentString(String procName, String output) {
        if (this.failure) {
            return;
        }
        this.failure = this.failureHappened(output);
        for (int n = 0; n < this.buildListeners.size(); ++n) {
            this.buildListeners.elementAt(n).buildSentString(output);
        }
    }

    @Override
    public void processFinished(String[] progarray) {
        String boolStr;
        int usersPostScriptMode = DevkitOptionsTabPanel.postScriptMode();
        if (!this.failure) {
            boolean didDup;
            String msg = "\nBuild Successful.\n";
            if (usersPostScriptMode == PostBuildPanel.SCRIPT_PRE) {
                this.runPostBuildScript(PostBuildPanel.SCRIPT_PRE);
                msg = "A post-build script has been run.\n";
            }
            if (didDup = this.doDuplicatePlugin()) {
                msg = msg + "The plugin has been duplicated.";
            }
            if (usersPostScriptMode == PostBuildPanel.SCRIPT_POST) {
                this.runPostBuildScript(PostBuildPanel.SCRIPT_POST);
                msg = "\nA post-build script has been run.";
            }
            for (int n = 0; n < this.buildListeners.size(); ++n) {
                this.buildListeners.elementAt(n).buildFinished(msg.trim());
            }
        } else {
            for (int n = 0; n < this.buildListeners.size(); ++n) {
                this.buildListeners.elementAt(n).buildFinished("Devkit: Build Failed");
            }
        }
        if ((boolStr = Preferences.get(Preferences.CPP_MAKEFILE_CLEANUP)).equals("true")) {
            File makeFile = new File(this.cppSrcFile.getParent(), this.usersMakefileName);
            makeFile.delete();
        }
    }

    protected void runPostBuildScript(int mode) {
        final String name = DevkitOptionsTabPanel.getScriptName();
        File scriptSrc = new File(this.cppSrcFile.getParentFile(), name);
        File scriptDst = new File(this.dsoDestFile.getParentFile(), name);
        String modeStr = mode == PostBuildPanel.SCRIPT_PRE ? "before duplication" : "after duplication";
        final File script = scriptSrc.exists() ? scriptSrc : scriptDst;
        if (!script.exists()) {
            String[] msg = new String[]{"Cannot find \"" + name + "\" in either:", "\"" + this.cppSrcFile.getParentFile() + "\"", "or,", "\"" + this.dsoDestFile.getParentFile() + "\"\n"};
            DialogUtils.showErrorMessage("Error: Post Build User Script", msg);
            return;
        }
        Cutter.setLog("    Info:DevkitScriptHandler.runPostBuildScript() - \n         Running users post build script " + modeStr + ".\n         \"" + script.getPath() + "\"");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EnvUtils.isWinEnvironment()) {
                    File envDir = script.getParentFile();
                    script.setExecutable(true);
                    String[] item = new String[]{"cmd", "/Q", "/C", name, DevkitScriptHandler.this.cppSrcFile.getPath(), DevkitScriptHandler.this.dsoDestFile.getPath()};
                    ProcessManager fp = new ProcessManager();
                    fp.launch(item, envDir, true, null, true);
                } else {
                    script.setExecutable(true);
                    File envDir = script.getParentFile();
                    String[] item = new String[]{"./" + name, DevkitScriptHandler.this.cppSrcFile.getPath(), DevkitScriptHandler.this.dsoDestFile.getPath()};
                    ProcessManager fp2 = new ProcessManager();
                    fp2.launch(item, envDir, true, null, true);
                }
            }
        });
    }

    protected boolean doDuplicatePlugin() {
        String dupDirPath = this.getDuplicateDirPath();
        if (dupDirPath == null) {
            return false;
        }
        if (!this.dsoDestFile.exists()) {
            return false;
        }
        byte[] bytes = FileUtils.readAsBinary(this.dsoDestFile.getPath());
        File dupPlugin = new File(dupDirPath, this.dsoDestFile.getName());
        FileUtils.writeAsBinary(dupPlugin, bytes);
        String msg = "\n\"" + this.dsoDestFile.getName() + "\" has been duplicated to:\n \"" + dupDirPath + "/\"";
        Monitor.appendPanelText(this.getScriptName(), msg);
        return true;
    }

    protected String getDuplicateDirPath() {
        int scriptType = DevkitUtils.getDevkitScriptType(this.cppSrcFile);
        if (scriptType == DevkitUtils.NOT_DEVKIT) {
            return null;
        }
        String dupPath = DevkitUtils.getDupDirectory(scriptType);
        if (dupPath == null) {
            return null;
        }
        File f = new File(dupPath);
        if (!f.exists()) {
            Cutter.setLog("    Error:DevkitScriptHandler.getDuplicateDirPath() - duplication directory");
            Cutter.setLog("        \"" + f.getPath() + "\"");
            Cutter.setLog("    does not exist!!");
            return null;
        }
        return dupPath;
    }

    protected String parseUsersIncludes(String commaSeparatedPaths) {
        if (commaSeparatedPaths.trim().length() == 0) {
            return "";
        }
        String[] tokens = TextUtils.tokenize(commaSeparatedPaths, ",");
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < tokens.length; ++n) {
            File includeFile = new File(tokens[n]);
            buf.append("-I");
            String path = null;
            if (includeFile.isDirectory()) {
                path = includeFile.getPath().replace('\\', '/');
            } else if (includeFile.getParent() != null) {
                path = includeFile.getParent().replace('\\', '/');
            }
            if (path == null) continue;
            buf.append("\"").append(path).append("\" ");
        }
        return buf.toString();
    }

    protected File getTemplateMakefile() {
        File pwd = FileUtils.getPWDFile();
        File f = null;
        if (EnvUtils.isWinEnvironment()) {
            f = new File(pwd, "custom_templates/Bat/" + this.compile_WIN);
            if (!f.exists()) {
                f = new File(pwd, "Cutter_Help/templates/Bat/" + this.compile_WIN);
            } else {
                Cutter.setLog("    Info:DevkitScriptHandler.getTemplateMakefile() - using custom template.");
            }
        } else if (EnvUtils.isOSXEnvironment()) {
            f = new File(pwd, "custom_templates/MakeFile/" + this.compile_OSX);
            if (!f.exists()) {
                f = new File(pwd, "Cutter_Help/templates/MakeFile/" + this.compile_OSX);
            } else {
                Cutter.setLog("    Info:DevkitScriptHandler.getTemplateMakefile() - using custom template.");
            }
        } else {
            f = new File(pwd, "custom_templates/MakeFile/" + this.compile_LIN);
            if (!f.exists()) {
                f = new File(pwd, "Cutter_Help/templates/MakeFile/" + this.compile_LIN);
                if (f.exists()) {
                    Cutter.setLog("    Info:DevkitScriptHandler.getTemplateMakefile() - using Cutter's default template.");
                }
            } else {
                Cutter.setLog("    Info:DevkitScriptHandler.getTemplateMakefile() - using custom template.");
            }
        }
        return !f.exists() ? null : f;
    }

    protected String getTemplateWinEnvScript() {
        String WinEnvScript = null;
        String varspath = Preferences.get(Preferences.PATH_CPP_VCVARSX86_AMD64_BAT);
        if (varspath.trim().length() == 0) {
            String[] msg = new String[]{"To build a plugin Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file has not been specified in Cutter's Preferences", "    Languages->Cpp", "Or, the wrong path has been specified.\n"};
            DialogUtils.showErrorMessage("Path to vcvars bat not Set in Prefs", msg);
            return "";
        }
        File f = new File(varspath);
        if (f == null || !f.exists()) {
            String[] msg = new String[]{"To build a plugin Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file does NOT exist.\n"};
            DialogUtils.showErrorMessage("Cannot File vcvars bat", msg);
            return "";
        }
        if (f.isDirectory()) {
            String[] msg = new String[]{"To build a plugin Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file has not been specified correctly in ", "Cutter's Preferences", "    Languages->Cpp", "The path incorrectly specified is,", "\"" + varspath + "\"\n"};
            DialogUtils.showErrorMessage("Path to vcvars bat Incorrectly Set in Prefs", msg);
            return "";
        }
        WinEnvScript = FileUtils.read(f);
        WinEnvScript = "@call \"" + varspath + "\"";
        if (WinEnvScript == null || WinEnvScript.trim().length() == 0) {
            String[] msg = new String[]{"To build a plugin Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The file appears to be empty.\n"};
            DialogUtils.showErrorMessage("Empty vcvars bat ??", msg);
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(WinEnvScript);
        Cutter.setLog("    Info:DevkitScriptHandler.getTemplateWinEnvScript() - WinEnvCommand is\n" + WinEnvScript + "\n");
        return WinEnvScript == null ? "" : buf.toString();
    }

    protected void noTemplateError() {
        String templateName = this.compile_WIN;
        if (EnvUtils.isOSXEnvironment()) {
            templateName = this.compile_OSX;
        } else if (EnvUtils.isLinuxEnvironment()) {
            templateName = this.compile_LIN;
        }
        String language = this.ext[0] == ".c" || this.ext[1] == ".C" ? "C" : "C++";
        JOptionPane.showMessageDialog(KDesktop.desktopPane, "\nCutter references a template makefile when compiling a '" + language + "'\nlanguage file that implements a RenderMan " + this.getScriptName() + ".\nCutter searches the following directories for the template:\n        \"custom_templates/Bat\",\n        \"Cutter_Help/templates/Bat\"\nThe template is named \"" + templateName + "\" and\nwithout it Cutter cannot continue.\n\n", "Error - Cannot Find Template File", 0);
    }

    @Override
    public String getExecuteLabel() {
        return "Build";
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }
}

