/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.AbstractDevkit;

import UI_Desktop.Cutter;
import UI_Script.Cpp.CppTokenizer;
import UI_Script.PixarDev.AbstractDevkit.DevkitTypesRsrc;
import Utilities.HashTableUtils;
import Utilities.VectorUtils;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DevkitTokenizer
extends CppTokenizer {
    public static final String RSLPLUGIN_CLASS = "RslPlugin";
    public static final String RSLPLUGIN_TYPE = "RslType";
    public static final String RSLCONTEXT_METHOD = "RslContextMethod";
    public static final String RSLARG_METHOD = "RslArgMethod";
    public static final String RIXINTERFACES_CLASS = "RixInterfaces";
    public static final String RIFCONTEXT_METHOD = "RifContextMethod";
    public static final String RIFINTERFACES_CLASS = "RifInterfaces";
    public static final String RIFPLUGIN_CLASS = "RifPlugin";
    public static final String RIFPLUGIN_METHOD = "RifPluginMethod";
    public static final String RIFARG_METHOD = "RifArgMethod";
    public static final String RI_TYPE = "RiType";
    public static final String RI_FUNCTION = "RiFunc";
    public static final String IMPLICIT_FIELD_CLASS = "ImplicitClass";
    public static final String IMPLICIT_METHOD = "ImplicitType";
    public static final String RXLIBRARY_CLASS = "RxClass";
    public static final String RXLIBRARY_METHOD = "RxMethod";
    public static final String DEEPTEXTURE_TYPE = "dtexType";
    public static final String DEEPTEXTURE_FUNCTION = "dtexFunc";
    public static final String POINTCLOUD_TYPE = "pointCloudType";
    public static final String POINTCLOUD_FUNCTION = "ptcFunc";
    private static ResourceBundle devkitTypesRes;
    public static Hashtable<String, String> devkitTypes;
    public boolean getComments = false;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = devkitTypesRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((DevkitTypesRsrc)devkitTypesRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("Cannot read DevkitTypesRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < DevkitTokenizer.numLanguageItems(); ++i) {
            devkitTypes.put(((DevkitTypesRsrc)devkitTypesRes).getKey(i), ((DevkitTypesRsrc)devkitTypesRes).getContent(i));
        }
    }

    public DevkitTokenizer() {
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
    }

    public String isClass(String str) {
        if (devkitTypes.containsKey(str)) {
            if (devkitTypes.get(str).equals(RSLPLUGIN_CLASS)) {
                return RSLPLUGIN_CLASS;
            }
            if (devkitTypes.get(str).equals(RIFINTERFACES_CLASS)) {
                return RIFINTERFACES_CLASS;
            }
            if (devkitTypes.get(str).equals(RIFPLUGIN_CLASS)) {
                return RIFPLUGIN_CLASS;
            }
            if (devkitTypes.get(str).equals(IMPLICIT_FIELD_CLASS)) {
                return IMPLICIT_FIELD_CLASS;
            }
            if (devkitTypes.get(str).equals(RIXINTERFACES_CLASS)) {
                return RIXINTERFACES_CLASS;
            }
            if (devkitTypes.get(str).equals(IMPLICIT_FIELD_CLASS)) {
                return IMPLICIT_FIELD_CLASS;
            }
        }
        return null;
    }

    public String isMethod(String str) {
        if (devkitTypes.containsKey(str)) {
            if (devkitTypes.get(str).equals(RSLARG_METHOD)) {
                return RSLARG_METHOD;
            }
            if (devkitTypes.get(str).equals(RSLCONTEXT_METHOD)) {
                return RSLCONTEXT_METHOD;
            }
            if (devkitTypes.get(str).equals(RIFCONTEXT_METHOD)) {
                return RIFCONTEXT_METHOD;
            }
            if (devkitTypes.get(str).equals(RIFPLUGIN_METHOD)) {
                return RIFPLUGIN_METHOD;
            }
            if (devkitTypes.get(str).equals(RIFARG_METHOD)) {
                return RIFARG_METHOD;
            }
            if (devkitTypes.get(str).equals(IMPLICIT_METHOD)) {
                return IMPLICIT_METHOD;
            }
            if (devkitTypes.get(str).equals(DEEPTEXTURE_FUNCTION)) {
                return IMPLICIT_METHOD;
            }
        }
        return null;
    }

    @Override
    public boolean isFunction(String str) {
        if (devkitTypes.containsKey(str)) {
            if (devkitTypes.get(str).equals("function")) {
                return true;
            }
            if (devkitTypes.get(str).equals(RI_FUNCTION)) {
                return true;
            }
            if (devkitTypes.get(str).equals(POINTCLOUD_FUNCTION)) {
                return true;
            }
        }
        return super.isFunction(str);
    }

    @Override
    public boolean isDataType(String str) {
        if (devkitTypes.containsKey(str)) {
            if (devkitTypes.get(str).equals(RSLPLUGIN_TYPE)) {
                return true;
            }
            if (devkitTypes.get(str).equals(RI_TYPE)) {
                return true;
            }
            if (devkitTypes.get(str).equals(DEEPTEXTURE_TYPE)) {
                return true;
            }
            if (devkitTypes.get(str).equals(POINTCLOUD_TYPE)) {
                return true;
            }
        }
        return super.isDataType(str);
    }

    @Override
    public String[] getDataTypes() {
        String[] rsl = HashTableUtils.getAllValuesWithKey(devkitTypes, RSLPLUGIN_TYPE);
        String[] supers = super.getDataTypes();
        return VectorUtils.toStringArray(rsl, supers);
    }

    static {
        devkitTypes = new Hashtable();
        try {
            devkitTypesRes = ResourceBundle.getBundle("UI_Script.PixarDev.AbstractDevkit.DevkitTypesRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Exception:DevkitTokenizer - " + mre);
        }
        DevkitTokenizer.initHashTable();
    }
}

