/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.DeepTexture;

import Preferences.Preferences;
import Processes.ProcListener;
import UI_Script.Help.KAbstractHelp;
import UI_Script.PixarDev.AbstractDevkit.DevkitScriptHandler;
import UI_Script.PixarDev.DeepTexture.DeepTextureHelp;
import UI_Script.PixarDev.DeepTexture.DeepTextureListener;
import UI_Script.PixarDev.DeepTexture.DeepTextureTokenizer;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.RegExpUtils;
import java.io.File;

public class DeepTextureScriptHandler
extends DevkitScriptHandler
implements ProcListener {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public DeepTextureScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".c";
        this.ext[1] = ".C";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new DeepTextureTokenizer();
    }

    @Override
    protected void setMakefileName_OSX() {
        this.compile_OSX = "Makefile.deepTexture_OSX";
    }

    @Override
    protected void setMakefileName_LIN() {
        this.compile_LIN = "Makefile.deepTexture_LINUX";
    }

    @Override
    protected void setMakefileName_WIN() {
        this.compile_WIN = "Build_deepTexture.bat";
    }

    @Override
    protected void setMakefileDSO_EXE_STR() {
        this.DSO_EXE_STR = "_DEEPTEXTURE_EXE_NAME_";
    }

    @Override
    public String getScriptName() {
        return "DeepTexture";
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(DeepTextureHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return DeepTextureListener.class.getName();
    }

    @Override
    public boolean canHandle(File file) {
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        if (path == null) {
            return false;
        }
        String srcText = FileUtils.read(path);
        if (srcText == null || srcText.trim().length() == 0) {
            return false;
        }
        return RegExpUtils.split(srcText, "(int\\s*main\\s*\\(\\s*int)") != null && (RegExpUtils.split(srcText, "DtexCache", false) != null || RegExpUtils.split(srcText, "DtexImage", false) != null || RegExpUtils.split(srcText, "DtexFile", false) != null || RegExpUtils.split(srcText, "DtexPixel", false) != null || RegExpUtils.split(srcText, "DtexCreateCache", false) != null);
    }

    @Override
    public File convertSelectionToFile(String sel) {
        File userSrcDir;
        File f = super.convertSelectionToFile(sel);
        if (f != null) {
            return f;
        }
        String p = Preferences.get(Preferences.PATH_DEVKIT_USER_INCLUDE_DIRECTORIES);
        if (p != null && p.trim().length() > 0 && (f = new File(userSrcDir = new File(p), sel)).exists()) {
            return f;
        }
        return null;
    }
}

