/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.ImplicitPlugin;

import Preferences.Preferences;
import Processes.ProcListener;
import UI_Script.Help.KAbstractHelp;
import UI_Script.PixarDev.AbstractDevkit.DevkitScriptHandler;
import UI_Script.PixarDev.ImplicitPlugin.ImplicitPluginHelp;
import UI_Script.PixarDev.ImplicitPlugin.ImplicitPluginListener;
import UI_Script.PixarDev.ImplicitPlugin.ImplicitPluginTokenizer;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.RegExpUtils;
import java.io.File;

public class ImplicitPluginScriptHandler
extends DevkitScriptHandler
implements ProcListener {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public ImplicitPluginScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".cpp";
        this.ext[1] = ".CPP";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new ImplicitPluginTokenizer();
    }

    @Override
    protected void setMakefileName_OSX() {
        this.compile_OSX = "Makefile.implicitPlugin_OSX";
    }

    @Override
    protected void setMakefileName_LIN() {
        this.compile_LIN = "Makefile.implicitPlugin_LINUX";
    }

    @Override
    protected void setMakefileName_WIN() {
        this.compile_WIN = "Build_implicitPlugin.bat";
    }

    @Override
    protected void setMakefileDSO_EXE_STR() {
        this.DSO_EXE_STR = "_IMPLICIT_PLUGIN_NAME_";
    }

    @Override
    public String getScriptName() {
        return "ImplicitPlugin";
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(ImplicitPluginHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return ImplicitPluginListener.class.getName();
    }

    @Override
    public boolean canHandle(File file) {
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        if (path == null) {
            return false;
        }
        String srcText = FileUtils.read(path);
        if (srcText == null || srcText.trim().length() == 0) {
            return false;
        }
        return RegExpUtils.split(srcText, "(:\\s*public\\s*ImplicitField\\s*\\{)") != null;
    }

    @Override
    public File convertSelectionToFile(String sel) {
        File userSrcDir;
        File f = super.convertSelectionToFile(sel);
        if (f != null) {
            return f;
        }
        String p = Preferences.get(Preferences.PATH_DEVKIT_USER_INCLUDE_DIRECTORIES);
        if (p != null && p.trim().length() > 0 && (f = new File(userSrcDir = new File(p), sel)).exists()) {
            return f;
        }
        return null;
    }
}

