/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.PointCloud;

import Preferences.Preferences;
import Processes.ProcListener;
import UI_Script.Help.KAbstractHelp;
import UI_Script.PixarDev.AbstractDevkit.DevkitScriptHandler;
import UI_Script.PixarDev.PointCloud.PointCloudHelp;
import UI_Script.PixarDev.PointCloud.PointCloudListener;
import UI_Script.PixarDev.PointCloud.PointCloudTokenizer;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.RegExpUtils;
import java.io.File;

public class PointCloudScriptHandler
extends DevkitScriptHandler
implements ProcListener {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public PointCloudScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".c";
        this.ext[1] = ".C";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new PointCloudTokenizer();
    }

    @Override
    protected void setMakefileName_OSX() {
        this.compile_OSX = "Makefile.pointCloud_OSX";
    }

    @Override
    protected void setMakefileName_LIN() {
        this.compile_LIN = "Makefile.pointCloud_LINUX";
    }

    @Override
    protected void setMakefileName_WIN() {
        this.compile_WIN = "Build_pointcloud.bat";
    }

    @Override
    protected void setMakefileDSO_EXE_STR() {
        this.DSO_EXE_STR = "_POINTCLOUD_EXE_NAME_";
    }

    @Override
    public String getScriptName() {
        return "PointCloud";
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(PointCloudHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return PointCloudListener.class.getName();
    }

    @Override
    public boolean canHandle(File file) {
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        if (path == null) {
            return false;
        }
        String srcText = FileUtils.read(path);
        if (srcText == null || srcText.trim().length() == 0) {
            return false;
        }
        return RegExpUtils.split(srcText, "(int\\s*main\\s*\\(\\s*int)") != null && (RegExpUtils.split(srcText, "PtcSafeOpenPointCloudFile", false) != null || RegExpUtils.split(srcText, "PtcOpenPointCloudFile", false) != null || RegExpUtils.split(srcText, "PtcFinishPointCloudFile", false) != null || RegExpUtils.split(srcText, "PtcReadDataPoint", false) != null || RegExpUtils.split(srcText, "PtcClosePointCloudFile", false) != null || RegExpUtils.split(srcText, "PtcGetPointCloudInfo", false) != null || RegExpUtils.split(srcText, "PtcFinishPointCloudFile", false) != null || RegExpUtils.split(srcText, "PtcCreatePointCloudFile", false) != null);
    }

    @Override
    public File convertSelectionToFile(String sel) {
        File userSrcDir;
        File f = super.convertSelectionToFile(sel);
        if (f != null) {
            return f;
        }
        String p = Preferences.get(Preferences.PATH_DEVKIT_USER_INCLUDE_DIRECTORIES);
        if (p != null && p.trim().length() > 0 && (f = new File(userSrcDir = new File(p), sel)).exists()) {
            return f;
        }
        return null;
    }
}

