/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.ProceduralPrimitive;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.Url;
import UI_Script.Osl.OslRis22RibGenerator;
import UI_Script.PixarDev.AbstractDevkit.DevkitHelp;
import UI_Script.Rib.RibHelp;
import UI_Text.KTextPane.KTextPane;
import Utilities.DevkitUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;

public class ProceduralPrimitiveHelp
extends DevkitHelp {
    private static String procPrimDocsPath = Url.join(RibHelp.getRPSDocsRoot(), Url.ri.appnote_procPrim_html);
    static File procPrimRib = new File(FileUtils.getPWDFile(), "/Cutter_Help/procedural/rib_tester.rib");

    @Override
    protected String getUrlForItem(String item) {
        return procPrimDocsPath;
    }

    public ProceduralPrimitiveHelp(KTextPane textpane) {
        super(textpane);
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        int begin = insertAt - selection.length();
        KAbstractHelp.KPopupMenu popup = super.getDefaultDevkitPopup("Find in header", selection, insertAt);
        popup.add(this.generateRibTester());
        popup.add(new JSeparator());
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        popup.add(defaultMenu);
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:RixPatternHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    protected KAbstractHelp.KPopupMenuItem generateRibTester() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Generate Rib for Testing");
        mi.setEnabled(false);
        mi.setEnabled(true);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fullpath = DevkitUtils.getDsoExeOutPath(ProceduralPrimitiveHelp.this.textpane.getFrameFile());
                String dso_home = "";
                String dso_name = "";
                String dso_ext = "dll";
                if (fullpath == null || fullpath.trim().length() == 0) {
                    Cutter.setLog("    Warning:ProceduralPrimitiveHelp.generateRibTester() - cannot get DSO home dir");
                } else {
                    dso_home = new File(fullpath).getParent();
                    dso_name = new File(fullpath).getName();
                    dso_ext = FileUtils.getExtension(dso_name);
                    dso_ext = dso_ext.substring(1);
                    dso_name = TextUtils.removeExtension(dso_name);
                }
                String testerRib = FileUtils.read(procPrimRib);
                testerRib = testerRib.replaceAll("(PATH_TO_DSO_PLUGINS)", dso_home);
                testerRib = testerRib.replaceAll("(DSO_NAME)", dso_name);
                testerRib = testerRib.replaceAll("(DSO_EXT)", dso_ext);
                testerRib = testerRib.replaceAll("(DSO_INPUTS)", "INPUTS_GO_HERE");
                String options = OslRis22RibGenerator.getSharedOptions().trim();
                testerRib = testerRib.replaceAll("(__SHARED_OPTIONS__)", options);
                BBxt.newDocument(dso_name.trim().length() == 0 ? "untitled.rib" : dso_name + "_tester.rib", testerRib);
            }
        };
        mi.addActionListener(action);
        return mi;
    }

    @Override
    protected void setDefaultDocURL() {
        this.defaultDocURL = Url.ri.appnote_procPrim_html;
    }
}

