/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RifPlugin;

import Preferences.Preferences;
import Processes.ProcListener;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.PixarDev.AbstractDevkit.DevkitScriptHandler;
import UI_Script.PixarDev.RifPlugin.RifPluginHelp;
import UI_Script.PixarDev.RifPlugin.RifPluginListener;
import UI_Script.PixarDev.RifPlugin.RifPluginTokenizer;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.RegExpUtils;
import java.io.File;

public class RifPluginScriptHandler
extends DevkitScriptHandler
implements ProcListener {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public RifPluginScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".cpp";
        this.ext[1] = ".CPP";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new RifPluginTokenizer();
    }

    @Override
    protected void setMakefileName_OSX() {
        this.compile_OSX = "Makefile.rixplugin_OSX";
    }

    @Override
    protected void setMakefileName_LIN() {
        this.compile_LIN = "Makefile.rixplugin_LINUX";
    }

    @Override
    protected void setMakefileName_WIN() {
        this.compile_WIN = "Build_rixplugin.bat";
    }

    @Override
    protected void setMakefileDSO_EXE_STR() {
        this.DSO_EXE_STR = "_RIX_PLUGIN_NAME_";
    }

    @Override
    public String getScriptName() {
        return "RifPlugin";
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(RifPluginHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return RifPluginListener.class.getName();
    }

    @Override
    public boolean canHandle(File file) {
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        if (path == null) {
            return false;
        }
        String ext = FileUtils.getExtension(path);
        if (ext == null || ext.trim().length() == 0) {
            return false;
        }
        if (!ext.equalsIgnoreCase(".cpp")) {
            return false;
        }
        String srcText = FileUtils.read(path);
        if (srcText == null || srcText.trim().length() == 0) {
            return false;
        }
        if (RegExpUtils.split(srcText, "(:\\s*public\\s*RifPlugin\\s*\\{)") != null) {
            Cutter.setLog("    Debug:RifPluginScriptHandler.canHandle(File) - found \":public RifPlugin {\"");
            return true;
        }
        if (RegExpUtils.split(srcText, "(RifPlugin.h)") != null) {
            Cutter.setLog("    Debug:RifPluginScriptHandler.canHandle(File) - found \"RifPlugin.h\"");
            return true;
        }
        if (RegExpUtils.split(srcText, "(RifPluginManufacture)") != null) {
            Cutter.setLog("    Debug:RifPluginScriptHandler.canHandle(File) - found \"RifPluginManufacture\"");
            return true;
        }
        return false;
    }

    @Override
    public File convertSelectionToFile(String sel) {
        File userSrcDir;
        File f = super.convertSelectionToFile(sel);
        if (f != null) {
            return f;
        }
        String p = Preferences.get(Preferences.PATH_DEVKIT_USER_INCLUDE_DIRECTORIES);
        if (p != null && p.trim().length() > 0 && (f = new File(userSrcDir = new File(p), sel)).exists()) {
            return f;
        }
        return null;
    }
}

