/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins;

import UI_Script.Args.ArgsItem;
import UI_Script.Args.ArgsItemParser;
import UI_Tools.Rman.RenderInfo;
import Utilities.DateTimeUtils;
import Utilities.TextUtils;
import java.io.File;

public abstract class HelperBase {
    protected ArgsItemParser.ArgsDB argsDB;
    protected int numOutputs = 0;
    protected int numInputs = 0;
    protected boolean isRix22 = false;

    public HelperBase(ArgsItemParser.ArgsDB argsDB) {
        this.argsDB = argsDB;
        this.numOutputs = argsDB.outputs.size();
        this.numInputs = argsDB.inputs.size();
        if (RenderInfo.prmanMajorVersionNumber() >= 22) {
            this.isRix22 = true;
        }
    }

    public abstract String substitutions();

    protected String commonSubstitutions(String cppTextIn) {
        String out = cppTextIn.replaceAll("(_CLASSNAME_)", this.argsDB.getCppClassName());
        File f = new File(this.argsDB.getArgsParentDir(), this.argsDB.getArgsFileName());
        out = out.replaceAll("(_ARGS_SOURCE_PATH_)", "" + f.getPath());
        out = out.replaceAll("(_DATE_TIME_)", "" + DateTimeUtils.getDateStamp());
        return out;
    }

    public String getCppClassName() {
        return this.argsDB.getCppClassName();
    }

    protected String listAsPointers(int tabs, String ptrName) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold") || item.getArgDataType().equals("string")) continue;
            String ptrname = ptrName + "->" + item.getPointerName() + "\n";
            buff.append(tStr).append(ptrname);
        }
        return TextUtils.trimTrailingChar(buff.toString(), '\n');
    }

    protected String declareAsListOfNames(int tabs) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) continue;
            String ptrname = item.getPointerName();
            buff.append(tStr).append(ptrname).append(",");
            if (tabs <= 0 || n >= this.numInputs - 1) continue;
            buff.append("\n");
        }
        return TextUtils.trimTrailingChar(buff.toString(), ',');
    }

    protected String declare(int tabs, String prefix, char endChar) {
        return this.declare(tabs, prefix, endChar, true);
    }

    protected String declare(int tabs, String prefix, char endChar, boolean declareAsConst) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) continue;
            String name = prefix.equals("m_") ? item.variableName : item.getPointerName();
            String ptrname = prefix + name + endChar;
            if (this.isRix22) {
                String rtType = item.getRtType();
                if (rtType.equals("RtConstString")) {
                    rtType = "RtUString";
                    if (prefix.equals("m_")) continue;
                }
                if (declareAsConst) {
                    buff.append(tStr).append(rtType).append(" const ").append(ptrname);
                } else {
                    buff.append(tStr).append(rtType).append(" ").append(ptrname);
                }
            } else if (item.getRtType().equals("RtConstString")) {
                buff.append(tStr).append(item.getRtType()).append(" ").append(ptrname);
            } else if (declareAsConst) {
                buff.append(tStr).append(item.getRtType()).append(" const ").append(ptrname);
            } else {
                buff.append(tStr).append(item.getRtType()).append(" ").append(ptrname);
            }
            if (n >= this.numInputs - 1) continue;
            buff.append("\n");
        }
        if (endChar == ';') {
            return buff.toString();
        }
        return TextUtils.trimTrailingChar(buff.toString(), endChar);
    }

    protected String assignByPointer(int tabs) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) continue;
            String ptrname = item.getPointerName();
            String m_ptrname = "m_" + ptrname;
            buff.append(tStr).append(m_ptrname).append("(").append(ptrname).append("),");
            if (n >= this.numInputs - 1) continue;
            buff.append("\n");
        }
        return TextUtils.trimTrailingChar(buff.toString(), ',');
    }

    protected String assignByValue(int tabs) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getRtType().equals("RtConstString") || item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) continue;
            buff.append(tStr);
            buff.append(item.getDeclareMemberDefaultValue());
            if (n >= this.numInputs - 1) continue;
            buff.append(",\n");
        }
        if (buff.length() > 0) {
            String str = buff.toString();
            str = TextUtils.trimTrailingChar(str, '\n');
            str = TextUtils.trimTrailingChar(str, ',');
            buff.setLength(0);
            buff.append(str);
        }
        return buff.toString();
    }

    protected String assignByEvalParam(int tabs) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) continue;
            String ptrName = "&" + item.getPointerName();
            String memberName = "&" + item.getMemberName();
            if (item.getArgDataType().equals("string")) {
                buff.append(tStr).append("ctx->EvalParam(");
                if (this.isRix22) {
                    buff.append(item.rixIndexName).append(", -1, ").append(ptrName).append(",(RtUString*)&Rix::k_empty").append(");\n");
                    continue;
                }
                buff.append(item.rixIndexName).append(", -1, ").append(ptrName).append(");\n");
                continue;
            }
            buff.append(tStr).append("ctx->EvalParam(").append(item.rixIndexName).append(", -1, ");
            if (item.connectable) {
                buff.append(ptrName).append(", ").append(memberName).append(", varying);\n");
                continue;
            }
            buff.append(ptrName).append(", ").append(memberName).append(", uniform);\n");
        }
        return buff.toString();
    }

    protected String declareAsParamTable(int tabs) {
        String name;
        String item_name;
        ArgsItem item;
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        if (this.numOutputs == 1) {
            buff.append("\t\t// Output\n");
        } else if (this.numOutputs > 1) {
            buff.append("\t\t// Outputs\n");
        }
        for (n = 0; n < this.numOutputs; ++n) {
            item = this.argsDB.outputs.elementAt(n);
            item_name = this.isRix22 ? "RtUString(\"" + item.name + "\")" : "\"" + item.name + "\"";
            name = item_name + ", ";
            buff.append("\t\tRixSCParamInfo(").append(name).append(item.getRixType()).append(", k_RixSCOutput),\n");
        }
        if (this.numInputs == 1) {
            buff.append("\t\t// Input\n");
        } else if (this.numInputs > 1) {
            buff.append("\t\t// Inputs\n");
        }
        for (n = 0; n < this.numInputs; ++n) {
            item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) {
                if (this.isRix22) {
                    buff.append("\t\tRixSCParamInfo(RtUString(\"PxrManifold\"), RtUString(\"manifold\"), k_RixSCStructBegin),\n");
                    buff.append("\t\t   RixSCParamInfo(RtUString(\"Q\"), k_RixSCPoint),\n");
                    buff.append("\t\t   RixSCParamInfo(RtUString(\"Qradius\"), k_RixSCFloat),\n");
                    buff.append("\t\tRixSCParamInfo(RtUString(\"PxrManifold\"), RtUString(\"manifold\"), k_RixSCStructEnd),\n");
                    continue;
                }
                buff.append("\t\tRixSCParamInfo(\"PxrManifold\", \"manifold\", k_RixSCStructBegin),\n");
                buff.append("\t\t   RixSCParamInfo(\"Q\", k_RixSCPoint),\n");
                buff.append("\t\t   RixSCParamInfo(\"Qradius\", k_RixSCFloat),\n");
                buff.append("\t\tRixSCParamInfo(\"PxrManifold\", \"manifold\", k_RixSCStructEnd),\n");
                continue;
            }
            item_name = this.isRix22 ? "RtUString(\"" + item.name + "\")" : "\"" + item.name + "\"";
            name = item_name + ", ";
            buff.append("\t\tRixSCParamInfo(").append(name).append(item.getRixType()).append("),\n");
        }
        buff.append("\t\tRixSCParamInfo() // end of table");
        return buff.toString();
    }

    protected String enumParamIds(int tabs) {
        ArgsItem item;
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numOutputs; ++n) {
            item = this.argsDB.outputs.elementAt(n);
            buff.append("\t").append(item.rixIndexName);
            if (n == 0) {
                buff.append(" = 0");
            }
            if (this.numOutputs + this.numInputs > 1) {
                buff.append(",\n");
                continue;
            }
            buff.append("\n");
        }
        for (n = 0; n < this.numInputs; ++n) {
            item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) {
                buff.append("\t").append("k_manifold").append(",\n");
                buff.append("\t").append("    k_manifoldQ").append(",\n");
                buff.append("\t").append("    k_manifoldQradius").append(",\n");
                buff.append("\t").append("k_manifoldEnd");
            } else {
                buff.append("\t").append(item.rixIndexName);
            }
            if (n == this.numInputs - 1) continue;
            buff.append(",\n");
        }
        return buff.toString();
    }

    protected String declareAsStruct(int tabs, String structName, String[] extras) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        buff.append(tStr).append("struct ").append(structName).append(" {\n");
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) continue;
            String name = " " + item.name + ";\n";
            buff.append(tStr).append("\t").append(item.getRtType()).append(name);
        }
        if (extras != null) {
            for (n = 0; n < extras.length; ++n) {
                buff.append(tStr).append("\t").append(extras[n]).append(";\n");
            }
        }
        buff.append(tStr).append("\t};");
        return buff.toString();
    }

    protected String assignToPointer(int tabs, String ptrName, String[] extras) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) continue;
            String name = item.name + " = ";
            String ptrStr = ptrName + "->";
            String asRtDeclaration = item.getDeclareDefaultAsRt();
            if (asRtDeclaration == null) continue;
            buff.append(tStr).append(ptrStr).append(name).append(item.getDeclareDefaultAsRt()).append(";\n");
        }
        if (extras != null) {
            for (n = 0; n < extras.length; ++n) {
                buff.append(tStr).append(extras[n]).append(";\n");
            }
        }
        return buff.toString();
    }

    protected String declareStrings(int tabs) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (!item.getArgDataType().trim().equals("string")) continue;
            String name = item.name + " = ";
            String value = "\"" + item.defaultValue + "\";\n";
            buff.append(tStr).append("RtConstString ").append(name).append(value);
        }
        return buff.toString();
    }

    protected String _assignByChannel(int tabs, String def) {
        int n;
        String aov = def;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (!item.getArgDataType().equals("string")) continue;
            aov = item.defaultValue;
            break;
        }
        return buff.toString();
    }
}

