/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins.Rix21;

import UI_Desktop.Cutter;
import UI_Script.Args.ArgsItem;
import UI_Script.Args.ArgsItemParser;
import UI_Script.PixarDev.RixPlugins.HelperBase;
import Utilities.FileUtils;
import java.io.File;

public class HelperDisplayFilter
extends HelperBase {
    static final File PWD = FileUtils.getPWDFile();
    static final File RISROOT = new File(PWD, "/Cutter_Help/ris/rix_plugin_v21");
    static final File DISPLAY_FILTER_TEMPLATE = new File(RISROOT, "template_displayfilter.cpp");

    public HelperDisplayFilter(ArgsItemParser.ArgsDB argsDB) {
        super(argsDB);
    }

    @Override
    public String substitutions() {
        String cppTextIn = FileUtils.read(DISPLAY_FILTER_TEMPLATE);
        if (cppTextIn == null) {
            Cutter.setLog("    Error:HelperDisplayFilter_v21.substitutions() - cannot read:");
            Cutter.setLog("       " + DISPLAY_FILTER_TEMPLATE.getPath());
            return null;
        }
        String cppTextOut = this.commonSubstitutions(cppTextIn);
        String[] dspyExtras = new String[]{"RixChannelId channelId"};
        cppTextOut = cppTextOut.replaceAll("(_DECLARE_DSPY_PARAMS_STRUCT_)", this.declareAsStruct(2, "dspyParams", dspyExtras));
        String[] dpExtras = new String[]{"dp->channelId = k_InvalidChannelId"};
        cppTextOut = cppTextOut.replaceAll("(_ASSIGN_TO_DSPY_PARAMS_PTR_)", this.assignToPointer(1, "dp", dpExtras));
        cppTextOut = cppTextOut.replaceAll("(_DECLARE_STRINGS_)", this.declareStrings(1));
        cppTextOut = cppTextOut.replaceAll("(_EVAL_INPUTS_)", this.assignByEvalParam(1, "dp"));
        cppTextOut = cppTextOut.replaceAll("(_CLASS_NAME_AS_STRING_)", this.argsDB.getArgsFileName());
        String aov = "Ci";
        for (int n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (!item.getArgDataType().equals("string")) continue;
            aov = item.defaultValue;
            break;
        }
        cppTextOut = cppTextOut.replaceAll("(_CHANNEL_VARNAME_)", "\\\"" + aov + "\\\"");
        cppTextOut = cppTextOut.replaceAll("(_LIST_OF_POINTERS_)", this.listAsPointers(3, "dp"));
        cppTextOut = cppTextOut.replaceAll("(_FILL_PARAM_TABLE_)", this.declareAsParamTable(1));
        cppTextOut = cppTextOut.replaceAll("(_FILL_PARAM_ENUMERATION_)", this.enumParamIds(1));
        cppTextOut = cppTextOut.replaceAll("(_EVAL_INPUTS_)", this.assignByEvalParam(2));
        return cppTextOut;
    }

    protected String assignParamInfo(int tabs) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            buff.append(tStr).append("params->GetParamInfo(").append(item.rixIndexName).append(", &type, &cinfo, &len);\n");
        }
        return buff.toString();
    }

    protected String assignByEvalParam(int tabs, String ptrName) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            String name = item.getArgDataType().equals("string") ? "&" + item.name : "&" + ptrName + "->" + item.name;
            String id = item.rixIndexName.trim();
            buff.append(tStr).append("params->EvalParam(").append(id).append(", 0, ").append(name).append(");\n");
        }
        return buff.toString();
    }
}

