/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins.Rix22;

import UI_Desktop.Cutter;
import UI_Script.Args.ArgsItem;
import UI_Script.Args.ArgsItemParser;
import UI_Script.PixarDev.RixPlugins.HelperBase;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;

public class HelperPattern
extends HelperBase {
    static final File PWD = FileUtils.getPWDFile();
    static final File RISROOT = new File(PWD, "/Cutter_Help/ris/rix_plugin_v22");
    static final File PATTERN_TEMPLATE = new File(RISROOT, "template_pattern.cpp");
    static final File read_manifold = new File(RISROOT, "read_manifold.cpp");
    static final File patt_inner_loop_manifold = new File(RISROOT, "inner_loop_manifold.cpp");
    static final File get_primvar_st = new File(RISROOT, "get_primvar_st.cpp");
    static final File patt_inner_loop_st = new File(RISROOT, "inner_loop_st.cpp");
    private boolean manifoldActive = false;

    public HelperPattern(ArgsItemParser.ArgsDB argsDB) {
        super(argsDB);
    }

    @Override
    public String substitutions() {
        int n;
        String stEvalScript;
        ArgsItem item;
        StringBuffer buff = new StringBuffer();
        String cppTextIn = FileUtils.read(PATTERN_TEMPLATE);
        if (cppTextIn == null) {
            Cutter.setLog("    Error:HelperPattern.substitutions() - cannot read:");
            Cutter.setLog("       " + PATTERN_TEMPLATE.getPath());
            return null;
        }
        String cppTextOut = this.commonSubstitutions(cppTextIn);
        cppTextOut = cppTextOut.replaceAll("(_NUM_OUTPUTS_)", "" + this.numOutputs);
        cppTextOut = cppTextOut.replaceAll("(_FILL_PARAM_TABLE_)", this.declareAsParamTable(1));
        cppTextOut = cppTextOut.replaceAll("(_FILL_PARAM_ENUMERATION_)", this.enumParamIds(1));
        buff.setLength(0);
        for (int n2 = 0; n2 < this.numInputs; ++n2) {
            item = this.argsDB.inputs.elementAt(n2);
            if (item.getRtType().equals("RtConstString") || item.getArgDataType().equals("struct") || item.name.equalsIgnoreCase("manifold")) continue;
            buff.append("\t\t");
            if (item.getRtType().length() < 10) {
                buff.append(item.getRtType()).append("\t\t").append("m_").append(item.variableName).append(";\n");
                continue;
            }
            buff.append(item.getRtType()).append("\t").append(item.getMemberName()).append(";\n");
        }
        if (buff.length() > 0) {
            String str = buff.toString();
            str = TextUtils.trimTrailingChar(str, '\n');
            buff.setLength(0);
            buff.append(str);
        }
        cppTextOut = cppTextOut.replaceAll("(_DECLARE_INPUTS_AS_MEMBERS_)", this.declare(2, "m_", ';'));
        cppTextOut = cppTextOut.replaceAll("(_ASSIGN_BY_VALUE_)", this.assignByValue(1));
        cppTextOut = cppTextOut.replaceAll("(_DECLARE_COMPUTE_OUTPUT_PARAMS_POINTERS_)", this.declare(1, "*", ';'));
        cppTextOut = cppTextOut.replaceAll("(_EVAL_INPUTS_)", this.assignByEvalParam(1));
        cppTextOut = cppTextOut.replaceAll("(_MANIFOLD_ST_PRIMVAR_DECLARATIONS_)", this.declareSTManifold(1));
        buff.setLength(0);
        if (this.manifoldActive) {
            String innerLoopManifoldStr = FileUtils.read(patt_inner_loop_manifold);
            if (innerLoopManifoldStr != null) {
                buff.append(innerLoopManifoldStr);
                cppTextOut = cppTextOut.replaceAll("(_MANIFOLD_USE_)", buff.toString());
            }
        } else {
            cppTextOut = cppTextOut.replaceAll("(_MANIFOLD_USE_)", "");
        }
        buff.setLength(0);
        if (!this.manifoldActive && (stEvalScript = FileUtils.read(get_primvar_st)) != null) {
            buff.append(stEvalScript);
        }
        cppTextOut = cppTextOut.replaceAll("(_ST_EVAL_PRIMVAR_)", buff.toString());
        buff.setLength(0);
        if (!this.manifoldActive) {
            String innerLoopSTStr = FileUtils.read(patt_inner_loop_st);
            if (innerLoopSTStr != null) {
                buff.append(innerLoopSTStr);
                cppTextOut = cppTextOut.replaceAll("(_ST_USE_)", buff.toString());
            }
        } else {
            cppTextOut = cppTextOut.replaceAll("(_ST_USE_)", "");
        }
        buff.setLength(0);
        buff.append("\tOutputSpec *outSpec = pool.AllocForPattern<OutputSpec>(").append(this.numOutputs).append(");\n");
        buff.append("\t*outputs = outSpec;\n");
        cppTextOut = cppTextOut.replaceAll("(_ALLOCATE_OUTSPEC_MEMORY_)", buff.toString());
        buff.setLength(0);
        for (n = 0; n < this.numOutputs; ++n) {
            item = this.argsDB.outputs.elementAt(n);
            buff.append("\t");
            buff.append(item.getRtType()).append("\t*").append(item.variableName).append(" = pool.AllocForPattern");
            buff.append("<").append(item.getRtType()).append(">(ctx->numPts);\n");
        }
        cppTextOut = cppTextOut.replaceAll("(_DECLARE_OUTPUTS_MEMORY_)", buff.toString());
        buff.setLength(0);
        for (n = 0; n < this.numOutputs; ++n) {
            item = this.argsDB.outputs.elementAt(n);
            String k_name = item.rixIndexName;
            buff.append("\toutSpec[").append(n).append("].paramId = ").append(k_name).append(";\n");
            buff.append("\toutSpec[").append(n).append("].detail = k_RixSCVarying;\n");
            buff.append("\toutSpec[").append(n).append("].value = ").append(item.variableName).append(";\n");
        }
        cppTextOut = cppTextOut.replaceAll("(_PREPARE_OUTSPEC_FIELDS_)", buff.toString());
        buff.setLength(0);
        ArgsItem outC = this.argsDB.getOutputOfType("color");
        ArgsItem outF = this.argsDB.getOutputOfType("float");
        ArgsItem inC = this.argsDB.getInputOfType("color");
        ArgsItem inF = this.argsDB.getInputOfType("float");
        if (outC != null && inC != null) {
            buff.append("\t\t\t").append(outC.variableName).append("[i].r = ").append(inC.variableName).append("[i].r;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].g = ").append(inC.variableName).append("[i].g;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].b = ").append(inC.variableName).append("[i].b;\n");
            buff.append("\t\t\t}\n");
            buff.append("\t\telse\n");
            buff.append("\t\t\t{\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].r = 1.0;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].g = 1.0;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].b = 1.0;\n");
            buff.append("\t\t\t}");
        } else if (outC != null && inF != null) {
            buff.append("\t\t\t").append(outC.variableName).append("[i].r = ").append(inF.variableName).append("[i];\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].g = ").append(inF.variableName).append("[i];\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].b = ").append(inF.variableName).append("[i];\n");
            buff.append("\t\t\t}\n");
            buff.append("\t\telse\n");
            buff.append("\t\t\t{\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].r = 1.0;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].g = 1.0;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].b = 1.0;\n");
            buff.append("\t\t\t}");
        } else if (outF != null && inC != null) {
            buff.append("\t\t\t").append(outF.variableName).append("[i] = ").append(inC.variableName).append("[i].r;\n");
            buff.append("\t\t\t}\n");
            buff.append("\t\telse\n");
            buff.append("\t\t\t{\n");
            buff.append("\t\t\t").append(outF.variableName).append("[i] = 0;\n");
            buff.append("\t\t\t}");
        } else if (outF != null && inF != null) {
            buff.append("\t\t\t").append(outF.variableName).append("[i] = ").append(inF.variableName).append("[i];\n");
            buff.append("\t\t\t}\n");
            buff.append("\t\telse\n");
            buff.append("\t\t\t{\n");
            buff.append("\t\t\t").append(outF.variableName).append("[i] = 0;\n");
            buff.append("\t\t\t}");
        } else if (outC != null) {
            buff.append("\t\t\t").append(outC.variableName).append("[i].r = 1.0;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].g = 1.0;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].b = 1.0;\n");
            buff.append("\t\t\t}\n");
            buff.append("\t\telse\n");
            buff.append("\t\t\t{\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].r = 0.0;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].g = 0.0;\n");
            buff.append("\t\t\t").append(outC.variableName).append("[i].b = 0.0;\n");
            buff.append("\t\t\t}");
        } else if (outF != null) {
            buff.append("\t\t\t").append(outF.variableName).append("[i] = 1.0;\n");
            buff.append("\t\t\t}\n");
            buff.append("\t\telse\n");
            buff.append("\t\t\t{\n");
            buff.append("\t\t\t").append(outF.variableName).append("[i] = 0.0;\n");
            buff.append("\t\t\t}");
        }
        cppTextOut = cppTextOut.replaceAll("(_ASSIGN_INPUT_TO_OUTPUT_)", buff.toString());
        return cppTextOut;
    }

    protected String declareSTManifold(int tabs) {
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (int n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        String getManifoldStr = FileUtils.read(read_manifold);
        if (getManifoldStr != null) {
            for (int n = 0; n < this.numInputs; ++n) {
                ArgsItem item = this.argsDB.inputs.elementAt(n);
                if (!item.getArgDataType().equals("struct") || !item.name.equalsIgnoreCase("manifold")) continue;
                buff.append(getManifoldStr);
                this.manifoldActive = true;
            }
        }
        return buff.toString();
    }
}

