/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins.Rix22;

import UI_Desktop.Cutter;
import UI_Script.Args.ArgsItem;
import UI_Script.Args.ArgsItemParser;
import UI_Script.PixarDev.RixPlugins.HelperBase;
import Utilities.FileUtils;
import java.io.File;

public class HelperProjection
extends HelperBase {
    static final File PWD = FileUtils.getPWDFile();
    static final File RISROOT = new File(PWD, "/Cutter_Help/ris/rix_plugin_v22");
    static final File PROJECTION_TEMPLATE = new File(RISROOT, "template_projection.cpp");

    public HelperProjection(ArgsItemParser.ArgsDB argsDB) {
        super(argsDB);
    }

    @Override
    public String substitutions() {
        ArgsItem item;
        int n;
        String cppTextIn = FileUtils.read(PROJECTION_TEMPLATE);
        if (cppTextIn == null) {
            Cutter.setLog("    Error:HelperProjection.substitutions() - cannot read:");
            Cutter.setLog("       " + PROJECTION_TEMPLATE.getPath());
            return null;
        }
        StringBuffer buff = new StringBuffer();
        String cppTextOut = this.commonSubstitutions(cppTextIn);
        cppTextOut = cppTextOut.replaceAll("(_NUM_OUTPUTS_)", "" + this.numOutputs);
        cppTextOut = cppTextOut.replaceAll("(_FILL_PARAM_TABLE_)", this.declareAsParamTable(1));
        cppTextOut = cppTextOut.replaceAll("(_FILL_PARAM_ENUMERATION_)", this.enumParamIds(1));
        boolean declareAsConst = false;
        cppTextOut = cppTextOut.replaceAll("(_DECLARE_INPUTS_AS_MEMBERS_)", this.declare(2, "m_", ';', declareAsConst));
        cppTextOut = cppTextOut.replaceAll("(_EVAL_INPUTS_)", this.assignByEvalParam(1));
        cppTextOut = cppTextOut.replaceAll("(_ASSIGN_BY_VALUE_)", this.assignByValue(1));
        cppTextOut = cppTextOut.replaceAll("(_DECLARE_COMPUTE_OUTPUT_PARAMS_POINTERS_)", this.declare(1, "*", ';'));
        buff.setLength(0);
        buff.append("\tOutputSpec *outSpec = pool.AllocForPattern<OutputSpec>(").append(this.numOutputs).append(");\n");
        buff.append("\t*outputs = outSpec;\n");
        cppTextOut = cppTextOut.replaceAll("(_ALLOCATE_OUTSPEC_MEMORY_)", buff.toString());
        buff.setLength(0);
        for (n = 0; n < this.numOutputs; ++n) {
            item = this.argsDB.outputs.elementAt(n);
            buff.append("\t");
            buff.append(item.getRtType()).append("\t*").append(item.variableName).append(" = pool.AllocForPattern");
            buff.append("<").append(item.getRtType()).append(">(ctx->numPts);\n");
        }
        cppTextOut = cppTextOut.replaceAll("(_DECLARE_OUTPUTS_MEMORY_)", buff.toString());
        buff.setLength(0);
        for (n = 0; n < this.numOutputs; ++n) {
            item = this.argsDB.outputs.elementAt(n);
            String k_name = item.rixIndexName;
            buff.append("\toutSpec[").append(n).append("].paramId = ").append(k_name).append(";\n");
            buff.append("\toutSpec[").append(n).append("].detail = k_RixSCVarying;\n");
            buff.append("\toutSpec[").append(n).append("].value = ").append(item.variableName).append(";\n");
        }
        cppTextOut = cppTextOut.replaceAll("(_PREPARE_OUTSPEC_FIELDS_)", buff.toString());
        buff.setLength(0);
        cppTextOut = cppTextOut.replaceAll("(_ASSIGN_INPUT_TO_OUTPUT_)", buff.toString());
        return cppTextOut;
    }

    @Override
    protected String assignByEvalParam(int tabs) {
        int n;
        StringBuffer buff = new StringBuffer();
        String tStr = "";
        for (n = 0; n < tabs; ++n) {
            tStr = tStr + "\t";
        }
        for (n = 0; n < this.numInputs; ++n) {
            ArgsItem item = this.argsDB.inputs.elementAt(n);
            if (item.getArgDataType().equals("struct") && item.name.equalsIgnoreCase("manifold")) continue;
            String ptrName = "&" + item.getPointerName();
            String memberName = "&" + item.getMemberName();
            if (item.getArgDataType().equals("string")) {
                buff.append(tStr).append("params->EvalParam(").append(item.rixIndexName).append(", 0, ");
                buff.append(ptrName).append(");\n");
                continue;
            }
            buff.append(tStr).append("params->EvalParam(").append(item.rixIndexName).append(", 0, ");
            buff.append(memberName).append(");\n");
        }
        return buff.toString();
    }
}

