/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Args.ArgsItem;
import UI_Script.Args.ArgsItemParser;
import UI_Script.Args.ArgsTokenizer;
import UI_Script.PixarDev.RixPlugins.HelperBase;
import UI_Script.PixarDev.RixPlugins.Rix21.HelperBxdf;
import UI_Script.PixarDev.RixPlugins.Rix22.HelperDisplayFilter;
import UI_Script.PixarDev.RixPlugins.Rix22.HelperPattern;
import UI_Script.PixarDev.RixPlugins.Rix22.HelperProjection;
import UI_Script.PixarDev.RixPlugins.Rix22.HelperSampleFilter;
import UI_Tools.Rman.RenderInfo;
import Utilities.DialogUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;

public class RixCppWriter {
    protected static final int PATTERN_TYPE = 1;
    protected static final int BXDF_TYPE = 2;
    protected static final int INTEGRATOR_TYPE = 3;
    public static final Hashtable<String, String> ACCEPTABLE_SHADER_TYPES = new Hashtable();
    public static final File PWD;
    public static final File RISROOT;
    private File argsFile;
    private String nodeType = null;
    private String argsText = null;
    private HelperBase helper = null;

    public static RixCppWriter getInstance(File argsFile) {
        String argsText;
        if (!BBxt.isSaved()) {
            BBxt.save();
        }
        if ((argsText = FileUtils.read(argsFile)) == null) {
            String[] msg = new String[]{"An unknown error occurred trying to read,", "    \"" + argsFile.getPath() + "\""};
            DialogUtils.showInfoMessage("Error: Cannot Read Args File", msg);
            return null;
        }
        if (argsText.trim().length() == 0) {
            String[] msg = new String[]{"The args file,", "    \"" + argsFile.getPath() + "\"", "is empty!!"};
            DialogUtils.showInfoMessage("Error: Empty Args File", msg);
            return null;
        }
        ArgsTokenizer tok = new ArgsTokenizer();
        tok.setBuffer(argsText);
        String nodeType = tok.getShaderType();
        if (nodeType == null) {
            String[] msg = new String[]{"The args script does not specify a \"shaderType\".", "It should contain the following tags.", "    <shaderType>", "        <tag value=\"NODE_TYPE\"/>", "    </shaderType>", "  ", "Where \"NODE_TYPE\" is either", "    bxdf, displacement, displayfilter, integrator,\n    light, lightfilter, pattern, projection or\n    samplefilter."};
            DialogUtils.showInfoMessage("Error: <shaderType> Not Defined", msg);
            return null;
        }
        if (!ACCEPTABLE_SHADER_TYPES.containsKey(nodeType)) {
            String[] msg = new String[]{"C++ code can only be generated for,\n    <shaderType>\n        <tag value=\"pattern\"/> \n    </shaderType>"};
            DialogUtils.showInfoMessage("Error: Unsupported <shaderType>", msg);
            return null;
        }
        return new RixCppWriter(argsFile, argsText, nodeType);
    }

    private RixCppWriter(File argsFile, String argsText, String nodeType) {
        this.argsFile = argsFile;
        this.argsText = argsText;
        this.nodeType = nodeType;
        Cutter.setLog("    Debug:RixCppWriter.RixCppWriter() - RenderInfo.prmanMajorVersionNumber() = " + RenderInfo.prmanMajorVersionNumber());
        this.helper = RenderInfo.prmanMajorVersionNumber() <= 21 ? this.getHelper_21() : this.getHelper_22();
    }

    private HelperBase getHelper_21() {
        HelperBase helper = null;
        if (this.nodeType.equals("pattern")) {
            helper = new UI_Script.PixarDev.RixPlugins.Rix21.HelperPattern(this.getArgsDB());
        } else if (this.nodeType.equals("bxdf")) {
            helper = new HelperBxdf(this.getArgsDB());
        } else if (this.nodeType.equals("displayfilter")) {
            helper = new UI_Script.PixarDev.RixPlugins.Rix21.HelperDisplayFilter(this.getArgsDB());
        } else if (this.nodeType.equals("samplefilter")) {
            helper = new UI_Script.PixarDev.RixPlugins.Rix21.HelperSampleFilter(this.getArgsDB());
        } else if (this.nodeType.equals("projection")) {
            helper = new UI_Script.PixarDev.RixPlugins.Rix21.HelperProjection(this.getArgsDB());
        }
        return helper;
    }

    private HelperBase getHelper_22() {
        HelperBase helper = null;
        if (this.nodeType.equals("pattern")) {
            helper = new HelperPattern(this.getArgsDB());
        } else if (this.nodeType.equals("bxdf")) {
            helper = new UI_Script.PixarDev.RixPlugins.Rix22.HelperBxdf(this.getArgsDB());
        } else if (this.nodeType.equals("displayfilter")) {
            helper = new HelperDisplayFilter(this.getArgsDB());
        } else if (this.nodeType.equals("samplefilter")) {
            helper = new HelperSampleFilter(this.getArgsDB());
        } else if (this.nodeType.equals("projection")) {
            helper = new HelperProjection(this.getArgsDB());
        }
        return helper;
    }

    private ArgsItemParser.ArgsDB getArgsDB() {
        ArgsItem item;
        String argsName = this.argsFile.getName();
        if (argsName.endsWith(" [NOT EDITABLE]")) {
            argsName = argsName.substring(0, argsName.length() - " [NOT EDITABLE]".length());
        }
        String cppClassName = TextUtils.removeExtension(argsName);
        ArgsItemParser argsParser = new ArgsItemParser();
        ArgsItemParser.ArgsDB argsDB = argsParser.getDB(this.argsText);
        argsDB.setCppClassName(cppClassName);
        argsDB.setArgsFileName(cppClassName + ".args");
        argsDB.setArgsParentDir(this.argsFile.getParentFile());
        argsDB.setArgsFile(this.argsFile);
        Iterator<ArgsItem> iter = argsDB.inputs.iterator();
        while (iter.hasNext()) {
            item = iter.next();
            if (!item.isVstructPlug) continue;
            Cutter.setLog("    Info:RixCppWriter.createDoc() - ignoring input vstuct \"" + item.name + "\"");
            iter.remove();
        }
        iter = argsDB.outputs.iterator();
        while (iter.hasNext()) {
            item = iter.next();
            if (!item.isVstructPlug) continue;
            Cutter.setLog("    Info:RixCppWriter.createDoc() - ignoring output vstuct \"" + item.name + "\"");
            iter.remove();
        }
        return argsDB;
    }

    public boolean createDoc() {
        if (this.helper != null) {
            String cppTextOut = this.helper.substitutions();
            if (cppTextOut == null) {
                return false;
            }
            String cppClassName = this.helper.getCppClassName();
            BBxt.newDocument(cppClassName + ".cpp", cppTextOut);
            return true;
        }
        Cutter.setLog("    Debug:RixCppWriter.RixCppWriter() - helper is null");
        return false;
    }

    static {
        for (int n = 0; n < ArgsTokenizer.SHADER_TYPE_NAMES.length; ++n) {
            ACCEPTABLE_SHADER_TYPES.put(ArgsTokenizer.SHADER_TYPE_NAMES[n], ArgsTokenizer.SHADER_TYPE_NAMES[n]);
        }
        ACCEPTABLE_SHADER_TYPES.remove("displacement");
        ACCEPTABLE_SHADER_TYPES.remove("integrator");
        ACCEPTABLE_SHADER_TYPES.remove("light");
        ACCEPTABLE_SHADER_TYPES.remove("lightfilter");
        if (!Cutter.input.debug) {
            ACCEPTABLE_SHADER_TYPES.remove("bxdf");
            ACCEPTABLE_SHADER_TYPES.remove("displayfilter");
            ACCEPTABLE_SHADER_TYPES.remove("projection");
            ACCEPTABLE_SHADER_TYPES.remove("samplefilter");
        }
        PWD = FileUtils.getPWDFile();
        RISROOT = new File(PWD, "/Cutter_Help/ris/rix_plugin");
    }
}

