/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins;

import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.Url;
import UI_Script.PixarDev.AbstractDevkit.DevkitHelp;
import UI_Script.PixarDev.AbstractDevkit.DevkitTokenizer;
import UI_Script.PixarDev.RixPlugins.RixColorUtilsCalls;
import UI_Script.PixarDev.RixPlugins.RixShadingContextCalls;
import UI_Script.PixarDev.RixPlugins.RixShadingUtilsCalls;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.RenderInfo;
import Utilities.FileUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;

public class RixPatternHelp
extends DevkitHelp {
    static final File RISROOT = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris");
    private DevkitTokenizer _devkitTok = new DevkitTokenizer();
    private File floatAttrFile;
    private File colorAttrFile;
    private File stringAttrFile;
    private File intUserAttrFile;
    private File intNonUserAttrFile;
    private File pointUserAttrFile;
    private File floatOptFile;
    private File colorOptFile;
    private File stringOptFile;
    private File intUserOptFile;
    private File intNonUserOptFile;
    private boolean isRix22 = false;

    public RixPatternHelp(KTextPane textpane) {
        super(textpane);
        if (RenderInfo.prmanMajorVersionNumber() == 22) {
            this.isRix22 = true;
        }
        this.configurePaths();
    }

    private void configurePaths() {
        File rixVersion = this.isRix22 ? new File(RISROOT, "rix_plugin_v22") : new File(RISROOT, "rix_plugin_v21");
        this.floatAttrFile = new File(rixVersion, "getattr/floatAttr.cpp");
        this.colorAttrFile = new File(rixVersion, "getattr/rgbAttr.cpp");
        this.stringAttrFile = new File(rixVersion, "getattr/stringAttr.cpp");
        this.intUserAttrFile = new File(rixVersion, "getattr/intUserAttr.cpp");
        this.intNonUserAttrFile = new File(rixVersion, "getattr/intNonUserAttr.cpp");
        this.pointUserAttrFile = new File(rixVersion, "getattr/pointUserAttr.cpp");
        this.floatOptFile = new File(rixVersion, "getopt/floatOpt.cpp");
        this.colorOptFile = new File(rixVersion, "getopt/rgbOpt.cpp");
        this.stringOptFile = new File(rixVersion, "getopt/stringOpt.cpp");
        this.intUserOptFile = new File(rixVersion, "getopt/intUserOpt.cpp");
        this.intNonUserOptFile = new File(rixVersion, "getopt/intNonUserOpt.cpp");
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        JMenu ms;
        JMenu pp;
        JMenu vv;
        JMenu nt;
        JMenu m;
        JMenu o;
        int begin = insertAt - selection.length();
        KAbstractHelp.KPopupMenu popup = super.getDefaultDevkitPopup("Find in header", selection, insertAt);
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        JMenu funcsmenu = this.getUtilFunc("Utility Functions", selection, insertAt);
        popup.add(funcsmenu);
        popup.add(new JSeparator());
        JMenu optmenu = new JMenu("GetOption");
        KAbstractHelp.KPopupMenuItem mi = this.getOption(this.floatOptFile, "float", selection, insertAt);
        if (mi != null) {
            optmenu.add(mi);
        }
        if ((mi = this.getOption(this.colorOptFile, "color", selection, insertAt)) != null) {
            optmenu.add(mi);
        }
        if ((mi = this.getOption(this.stringOptFile, "string", selection, insertAt)) != null) {
            optmenu.add(mi);
        }
        if ((o = this.getOption(this.intUserOptFile, this.intNonUserOptFile, "int", selection, insertAt)) != null) {
            optmenu.add(o);
        }
        popup.add(optmenu);
        JMenu attrmenu = new JMenu("GetAttribute");
        mi = this.getAttribute(this.floatAttrFile, "float", selection, insertAt);
        if (mi != null) {
            attrmenu.add(mi);
        }
        if ((mi = this.getAttribute(this.pointUserAttrFile, "point", selection, insertAt)) != null) {
            attrmenu.add(mi);
        }
        if ((mi = this.getAttribute(this.colorAttrFile, "color", selection, insertAt)) != null) {
            attrmenu.add(mi);
        }
        if ((mi = this.getAttribute(this.stringAttrFile, "string", selection, insertAt)) != null) {
            attrmenu.add(mi);
        }
        if ((m = this.getAttribute(this.intUserAttrFile, this.intNonUserAttrFile, "int", selection, insertAt)) != null) {
            attrmenu.add(m);
        }
        popup.add(attrmenu);
        JMenu builtinmenu = new JMenu("GetBuiltinVar");
        JMenu pm = this.getBuiltin_P(selection, insertAt);
        if (pm != null) {
            builtinmenu.add(pm);
        }
        if ((nt = this.getBuiltin_NT(selection, insertAt)) != null) {
            builtinmenu.add(nt);
        }
        if ((vv = this.getBuiltin_VV(selection, insertAt)) != null) {
            builtinmenu.add(vv);
        }
        if ((pp = this.getBuiltin_Param(selection, insertAt)) != null) {
            builtinmenu.add(pp);
        }
        if ((ms = this.getBuiltin_Misc(selection, insertAt)) != null) {
            builtinmenu.add(ms);
        }
        popup.add(builtinmenu);
        JMenu transformmenu = this.getTransforms(selection, insertAt);
        if (transformmenu != null) {
            popup.add(transformmenu);
        }
        popup.add(new JSeparator());
        popup.add(defaultMenu);
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:RixPatternHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    private JMenu getUtilFunc(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        RixShadingUtilsCalls rixutils = new RixShadingUtilsCalls(this.textpane);
        menu.add(rixutils.BoxStep(sel, at));
        menu.add(rixutils.Clamp(sel, at));
        menu.add(rixutils.DegreesToRadians(sel, at));
        menu.add(rixutils.Fractional(sel, at));
        menu.add(rixutils.GaussStep(sel, at));
        menu.add(rixutils.IsFinite(sel, at));
        menu.add(rixutils.LinearStep(sel, at));
        menu.add(rixutils.Max(sel, at));
        menu.add(rixutils.Min(sel, at));
        menu.add(rixutils.Mix(sel, at));
        menu.add(rixutils.Mod(sel, at));
        menu.add(rixutils.RadiansToDegress(sel, at));
        menu.add(rixutils.Reflect(sel, at));
        menu.add(rixutils.Reflect2(sel, at));
        menu.add(rixutils.Refract(sel, at));
        menu.add(rixutils.SinCos(sel, at));
        menu.add(rixutils.SmoothMix(sel, at));
        menu.add(rixutils.SmoothStep(sel, at));
        menu.add(new JSeparator());
        RixColorUtilsCalls colorutils = new RixColorUtilsCalls(this.textpane);
        menu.add(colorutils.HsvToRgb(sel, at));
        menu.add(colorutils.RgbToHsv(sel, at));
        menu.add(colorutils.HslToRgb(sel, at));
        menu.add(colorutils.RgbToHsl(sel, at));
        menu.add(colorutils.XyzToRgb(sel, at));
        menu.add(colorutils.RgbToXyz(sel, at));
        menu.add(new JSeparator());
        menu.add(rixutils.AbsDot(sel, at));
        menu.add(rixutils.Dot(sel, at));
        menu.add(rixutils.Cross(sel, at));
        menu.add(rixutils.NormCopy(sel, at));
        menu.add(rixutils.Normalize(sel, at));
        return menu;
    }

    private JMenu getBuiltin_P(final String sel, final int at) {
        JMenu menu = new JMenu("Shading Point");
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("P Position");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.P(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("P Radius");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.PRadius(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("dPdu Derivative");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.DPdu(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("dPdv Derivative");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.DPdv(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("dPdtime Vector");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.DPdtime(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu getBuiltin_NT(final String sel, final int at) {
        JMenu menu = new JMenu("Normal & Tangent");
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Shading Normal");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.Nn(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("Geometric Normal");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.Ngn(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("Shading Tangent");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.Tn(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu getBuiltin_VV(final String sel, final int at) {
        JMenu menu = new JMenu("Viewing Vector");
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("View Vector");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.Vn(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("P-P Length");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.VLen(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu getBuiltin_Param(final String sel, final int at) {
        JMenu menu = new JMenu("UV Parameters");
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("U");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.U(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("V");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.V(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("Du");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.Du(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("Dv");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.Dv(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu getBuiltin_Misc(final String sel, final int at) {
        JMenu menu = new JMenu("Misc");
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Curvature");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.Curvature(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("Micropolygon Size");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.MpSize(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("GPrim \"Id\"");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.GetBuiltinVar.Id(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu getTransforms(final String sel, final int at) {
        JMenu menu = new JMenu("Transform");
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Surface Point \"P\"");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.Transform.P(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("Shading Normal \"Nn\"");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.Transform.Nn(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("View Vector \"Vn\"");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.Transform.Vn(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("HSV to RGB");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.Transform.HsvToRgb(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("RGB to HSV");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(RixShadingContextCalls.Transform.RgbToHsv(), at - sel.length(), at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private KAbstractHelp.KPopupMenuItem getOption(final File srcfile, String datatype, final String sel, final int at) {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(datatype);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(FileUtils.read(srcfile), at - sel.length(), at);
            }
        });
        return mi;
    }

    private JMenu getOption(final File userFile, final File nonUserFile, String datatype, final String sel, final int at) {
        JMenu menu = new JMenu(datatype);
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("\"user\"");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(FileUtils.read(userFile), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("standard");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(FileUtils.read(nonUserFile), at - sel.length(), at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private KAbstractHelp.KPopupMenuItem getAttribute(final File srcfile, String datatype, final String sel, final int at) {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(datatype);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(FileUtils.read(srcfile), at - sel.length(), at);
            }
        });
        return mi;
    }

    private JMenu getAttribute(final File userFile, final File nonUserFile, String datatype, final String sel, final int at) {
        JMenu menu = new JMenu(datatype);
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("\"user\"");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(FileUtils.read(userFile), at - sel.length(), at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("standard");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RixPatternHelp.this.insertParamStr(FileUtils.read(nonUserFile), at - sel.length(), at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private void insertParamStr(String str, int begin, int end) {
        try {
            this.textpane.setSelectionStart(begin);
            this.textpane.setSelectionEnd(end);
            this.textpane.replaceSelection(str);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:RixPatternHelp.insertParamStr()\n        " + e.toString());
            return;
        }
    }

    @Override
    protected void setDefaultDocURL() {
        this.defaultDocURL = Url.ri.patternRef_html;
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }
}

