/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins;

import Preferences.Preferences;
import Processes.ProcListener;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.PixarDev.AbstractDevkit.DevkitScriptHandler;
import UI_Script.PixarDev.RixPlugins.RixPatternHelp;
import UI_Script.PixarDev.RixPlugins.RixPatternListener;
import UI_Script.PixarDev.RixPlugins.RixPatternTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.RenderInfo;
import Utilities.DevkitUtils;
import java.io.File;

public class RixPluginScriptHandler
extends DevkitScriptHandler
implements ProcListener {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public RixPluginScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".cpp";
        this.ext[1] = ".CPP";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new RixPatternTokenizer();
    }

    @Override
    protected void setMakefileName_OSX() {
        this.compile_OSX = "Makefile.rixplugin_OSX";
    }

    @Override
    protected void setMakefileName_LIN() {
        this.compile_LIN = "Makefile.rixplugin_LINUX";
    }

    @Override
    protected void setMakefileName_WIN() {
        int majorVersion = RenderInfo.prmanMajorVersionNumber();
        this.compile_WIN = majorVersion < 23 ? "Build_rixplugin.bat" : "Build_rixplugin_v23.bat";
        Cutter.setLog("    Debug: RixPluginScriptHandler.setMakefileName_WIN() - using \"" + this.compile_WIN + "\"");
    }

    @Override
    protected void setMakefileDSO_EXE_STR() {
        this.DSO_EXE_STR = "_RIX_PLUGIN_NAME_";
    }

    @Override
    public String getScriptName() {
        return "PxrDevkit";
    }

    public KAbstractHelp __getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(RixPatternHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return RixPatternListener.class.getName();
    }

    @Override
    public boolean canHandle(File file) {
        return DevkitUtils.getDevkitScriptType(file) != DevkitUtils.NOT_DEVKIT;
    }

    @Override
    public File convertSelectionToFile(String sel) {
        File userSrcDir;
        File f = super.convertSelectionToFile(sel);
        if (f != null) {
            return f;
        }
        String p = Preferences.get(Preferences.PATH_DEVKIT_USER_INCLUDE_DIRECTORIES);
        if (p != null && p.trim().length() > 0 && (f = new File(userSrcDir = new File(p), sel)).exists()) {
            return f;
        }
        return null;
    }
}

