/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins;

public class RixShadingContextCalls {

    public static class GetBuiltinVar {
        private static String template = "\t_COMMENT_\n\t_DATATYPE_ const  *_VAR_;\n\tctx->GetBuiltinVar(RixShadingContext::_K_, &_VAR_);";

        private static String subst(String[] items) {
            String out = template;
            if (!items[0].trim().equals("")) {
                out = out.replaceAll("(_COMMENT_)", items[0]);
            }
            out = out.replaceAll("(_DATATYPE_)", items[1]);
            out = out.replaceAll("(_VAR_)", items[2]);
            out = out.replaceAll("(_K_)", items[3]);
            return out + "\n";
        }

        public static String P() {
            String[] items = new String[]{"// Assign an array of surface positions to P.", "RtPoint3", "P", "k_P"};
            return GetBuiltinVar.subst(items);
        }

        public static String PRadius() {
            String[] items = new String[]{"// ", "RtFloat", "PRadius", "k_PRadius"};
            return GetBuiltinVar.subst(items);
        }

        public static String DPdu() {
            String[] items = new String[]{"// Derivative of surface position along u.", "RtFloat", "DPdu", "k_dPdu"};
            return GetBuiltinVar.subst(items);
        }

        public static String DPdv() {
            String[] items = new String[]{"// Derivative of surface position along v.", "RtFloat", "DPdv", "k_dPdv"};
            return GetBuiltinVar.subst(items);
        }

        public static String DPdtime() {
            String[] items = new String[]{"// Change in surface position over time.", "RtVector3", "DPdtime", "k_dPdtime"};
            return GetBuiltinVar.subst(items);
        }

        public static String Nn() {
            String[] items = new String[]{"// Assign an array of normalized shading normals to Nn.", "RtNormal3", "Nn", "k_Nn"};
            return GetBuiltinVar.subst(items);
        }

        public static String Ngn() {
            String[] items = new String[]{"// Assign an array of normalized geometric normals to Ngn.", "RtNormal3", "Ngn", "k_Ngn"};
            return GetBuiltinVar.subst(items);
        }

        public static String Tn() {
            String[] items = new String[]{"// Assign an array of normalized shading tangents to Tn.", "RtNormal3", "Tn", "k_Tn"};
            return GetBuiltinVar.subst(items);
        }

        public static String Vn() {
            String[] items = new String[]{"// Assign an array of normalized view vectors to Vn \n// pointing away from the shading points.", "RtVector3", "Vn", "k_Vn"};
            return GetBuiltinVar.subst(items);
        }

        public static String VLen() {
            String[] items = new String[]{"// Length of V: from the P to previous P.", "RtFloat", "VLen", "k_VLen"};
            return GetBuiltinVar.subst(items);
        }

        public static String Curvature() {
            String[] items = new String[]{"// Local surface curvature.", "RtFloat", "Curvature", "k_curvature"};
            return GetBuiltinVar.subst(items);
        }

        public static String MpSize() {
            String[] items = new String[]{"// Size of micropolygon that incident ray hit.", "RtFloat", "MpSize", "k_mpSize"};
            return GetBuiltinVar.subst(items);
        }

        public static String Id() {
            String[] items = new String[]{"// The RtInt assigned via Attribute \"identifier\" \"id\".", "RtInt", "Id", "k_Id"};
            return GetBuiltinVar.subst(items);
        }

        public static String U() {
            String[] items = new String[]{"// Surface parameter.", "RtFloat", "U", "k_u"};
            return GetBuiltinVar.subst(items);
        }

        public static String V() {
            String[] items = new String[]{"// Surface parameter.", "RtFloat", "V", "k_v"};
            return GetBuiltinVar.subst(items);
        }

        public static String Du() {
            String[] items = new String[]{"// Change in 'u' parameterization.", "RtFloat", "Du", "k_du"};
            return GetBuiltinVar.subst(items);
        }

        public static String Dv() {
            String[] items = new String[]{"// Change in 'v' parameterization.", "RtFloat", "Dv", "k_dv"};
            return GetBuiltinVar.subst(items);
        }
    }

    public static class Transform {
        public static String P() {
            StringBuffer b = new StringBuffer();
            b.append("\t// Assign an array of surface positions to P.\n");
            b.append("\tRtPoint3 const  *P;\n");
            b.append("\tctx->GetBuiltinVar(RixShadingContext::k_P, &P);\n");
            b.append("\n");
            b.append("\t// Copy the original P data to the transP array.\n");
            b.append("\tRtPoint3 *transP = pool.AllocForPattern<RtPoint3>(ctx->numPts);\n");
            b.append("\tmemcpy(transP, P, sizeof(RtPoint3) * ctx->numPts);\n");
            b.append("\n");
            b.append("\t// Transform will over-write the original transP data.\n");
            b.append("\tctx->Transform(RixShadingContext::k_AsPoints,  RtUString(\"current\"),  RtUString(\"object\"), transP, NULL);\n");
            return b.toString();
        }

        public static String Nn() {
            StringBuffer b = new StringBuffer();
            b.append("\t// Assign an array of normalized shading normals to Nn.\n");
            b.append("\tRtNormal3 const  *Nn;\n");
            b.append("\tctx->GetBuiltinVar(RixShadingContext::k_Nn, &Nn);\n");
            b.append("\n");
            b.append("\t// Copy the original Nn data to tformNn.\n");
            b.append("\n");
            b.append("\tRtNormal3 *tNn = pool.AllocForPattern<RtNormal3>(ctx->numPts);\n");
            b.append("\tmemcpy(tNn, Nn, sizeof(RtNormal3) * ctx->numPts);\n");
            b.append("\n");
            b.append("\t// Transform will over-write the original tNn data.\n");
            b.append("\tctx->Transform(RixShadingContext::k_AsNormals, \"current\", \"object\", tNn, NULL);\n");
            return b.toString();
        }

        public static String Vn() {
            StringBuffer b = new StringBuffer();
            b.append("\t// Assign an array of normalized view vectors to Vn.\n");
            b.append("\tRtVector3 const  *Vn;\n");
            b.append("\tctx->GetBuiltinVar(RixShadingContext::k_Vn, &Vn);\n");
            b.append("\n");
            b.append("\t// Copy the original Vn data to tformVn.\n");
            b.append("\tRtFloat3 *tVn = pool.AllocForPattern<RtFloat3>(ctx->numPts);\n");
            b.append("\tmemcpy(tVn, Vn, sizeof(RtFloat3) * ctx->numPts);\n");
            b.append("\n");
            b.append("\t// Transform will over-write the original tNn data.\n");
            b.append("\tctx->Transform(RixShadingContext::k_AsVectors, \"current\", \"object\", tVn, NULL);\n");
            return b.toString();
        }

        public static String HsvToRgb() {
            StringBuffer b = new StringBuffer();
            b.append("\t// Don't forget to #include <RixColorUtils.h>\n");
            b.append("\tRtColorRGB src_hsv(0.5, 1, 1);\n");
            b.append("\tRtColorRGB dst_rgb;\n");
            b.append("\tRixHsvToRgb(src_hsv, dst_rgb);\n");
            b.append("\n");
            return b.toString();
        }

        public static String RgbToHsv() {
            StringBuffer b = new StringBuffer();
            b.append("\t// Don't forget to #include <RixColorUtils.h>\n");
            b.append("\tRtColorRGB src_rgb(0.5, 1, 1);\n");
            b.append("\tRtColorRGB dst_hsv;\n");
            b.append("\tRixRgbToHsv(src_rgb, dst_hsv);\n");
            b.append("\n");
            return b.toString();
        }
    }
}

