/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.PixarDev.RixPlugins;

import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class RixShadingUtilsCalls {
    private KTextPane textpane = null;
    static String BOXSTEP = "\tRtFloat bstep = RixBoxStep(RtFloat min, RtFloat val);";
    static String CLAMP = "\tRtFloat clamped = RixClamp(RtFloat x, RtFloat min, RtFloat max);";
    static String D2R = "\tRtFloat radians = RixDegreesToRadians(RtFloat degrees);";
    static String FRACTIONAL = "\tRtFloat fractional = RixFractional(RtFloat x);";
    static String GAUSSSTEP = "\tRtFloat gstep = RixGaussStep(RtFloat min, RtFloat max, RtFloat val);";
    static String ISINFINITE = "\tint isFinite = RixIsFinite(float x);";
    static String LINEARSTEP = "\tRtFloat lstep = RixLinearStep(RtFloat min, RtFloat max, RtFloat val);";
    static String MAX = "\tRtFloat maxvalue = RixMax(RtFloat x, RtFloat y);";
    static String MIN = "\tRtFloat minval = RixMin(RtFloat x, RtFloat y);";
    static String MIX = "\tSomeType mixval = RixMix(const T &v0, const T &v1, RtFloat m);";
    static String MOD = "\tRtFloat modval = RixMod(float x, float y);";
    static String R2D = "\tRtFloat degrees = RixRadiansToDegress(RtFloat rads);";
    static String REFLECT_2 = "\tRtVector3 reflvect = RixReflect(const RtVector3 &Vn, const RtNormal3 &Nn);";
    static String REFLECT_3 = "\tRtVector3 reflvect = RixReflect(RtVector3 const &Vn, RtVector3 const &Nn, RtFloat VdN);";
    static String REFRACT = "\tRtVector3 refrvect = RixRefract(const RtVector3 &Vn, const RtNormal3 &Nn, RtFloat eta, RtVector3 &Tn);";
    static String SINCOS = "\tRtFloat sinangle, cosangle;\n\tRixSinCos(RtFloat phi, RtFloat *sinphi, RtFloat *cosphi);";
    static String SMOOTHMIX = "\tSomeType smoothedval = RixSmoothMix(const T &x1, const T &x2, RtFloat t);";
    static String SMOOTHSTEP = "\tRtFloat sstep = RixSmoothStep(RtFloat min, RtFloat max, RtFloat val);";
    static String ABSDOT = "\tfloat ad = AbsDot(RtFloat3 &v1, RtFloat3 &v2);";
    static String DOT = "\tfloat dot = Dot(RtFloat3 &v1, RtFloat3 &v2);";
    static String CROSS = "\tRtFloat3 cross = Cross(RtFloat3 &v1, RtFloat3 &v2);";
    static String NORMCOPY = "\tRtFloat3 nc = NormalizeCopy(RtFloat3 &v);";
    static String NORMALIZE = "\tNormalize(RtFloat3 &v);";

    public RixShadingUtilsCalls(KTextPane textpane) {
        this.textpane = textpane;
    }

    public JMenuItem BoxStep(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixBoxStep");
        mi.addActionListener(new RixAction(BOXSTEP, sel, at));
        return mi;
    }

    public JMenuItem Clamp(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixClamp");
        mi.addActionListener(new RixAction(CLAMP, sel, at));
        return mi;
    }

    public JMenuItem DegreesToRadians(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixDegreesToRadians");
        mi.addActionListener(new RixAction(D2R, sel, at));
        return mi;
    }

    public JMenuItem Fractional(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixFractional");
        mi.addActionListener(new RixAction(FRACTIONAL, sel, at));
        return mi;
    }

    public JMenuItem GaussStep(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixGaussStep");
        mi.addActionListener(new RixAction(GAUSSSTEP, sel, at));
        return mi;
    }

    public JMenuItem IsFinite(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixIsFinite");
        mi.addActionListener(new RixAction(ISINFINITE, sel, at));
        return mi;
    }

    public JMenuItem LinearStep(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixLinearStep");
        mi.addActionListener(new RixAction(LINEARSTEP, sel, at));
        return mi;
    }

    public JMenuItem Max(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixMax");
        mi.addActionListener(new RixAction(MAX, sel, at));
        return mi;
    }

    public JMenuItem Min(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixMin");
        mi.addActionListener(new RixAction(MIN, sel, at));
        return mi;
    }

    public JMenuItem Mix(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixMix");
        mi.addActionListener(new RixAction(MIX, sel, at));
        return mi;
    }

    public JMenuItem Mod(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixMod");
        mi.addActionListener(new RixAction(MOD, sel, at));
        return mi;
    }

    public JMenuItem RadiansToDegress(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixRadiansToDegress");
        mi.addActionListener(new RixAction(R2D, sel, at));
        return mi;
    }

    public JMenuItem Reflect(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixReflect");
        mi.addActionListener(new RixAction(REFLECT_2, sel, at));
        return mi;
    }

    public JMenuItem Reflect2(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixReflect");
        mi.addActionListener(new RixAction(REFLECT_3, sel, at));
        return mi;
    }

    public JMenuItem Refract(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixRefract");
        mi.addActionListener(new RixAction(REFRACT, sel, at));
        return mi;
    }

    public JMenuItem SinCos(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixSinCos");
        mi.addActionListener(new RixAction(SINCOS, sel, at));
        return mi;
    }

    public JMenuItem SmoothMix(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixSmoothMix");
        mi.addActionListener(new RixAction(SMOOTHMIX, sel, at));
        return mi;
    }

    public JMenuItem SmoothStep(String sel, int at) {
        JMenuItem mi = new JMenuItem("RixSmoothStep");
        mi.addActionListener(new RixAction(SMOOTHSTEP, sel, at));
        return mi;
    }

    public JMenuItem AbsDot(String sel, int at) {
        JMenuItem mi = new JMenuItem("AbsDot");
        mi.addActionListener(new RixAction(ABSDOT, sel, at));
        return mi;
    }

    public JMenuItem Dot(String sel, int at) {
        JMenuItem mi = new JMenuItem("Dot");
        mi.addActionListener(new RixAction(DOT, sel, at));
        return mi;
    }

    public JMenuItem Cross(String sel, int at) {
        JMenuItem mi = new JMenuItem("Cross");
        mi.addActionListener(new RixAction(CROSS, sel, at));
        return mi;
    }

    public JMenuItem NormCopy(String sel, int at) {
        JMenuItem mi = new JMenuItem("NormalizedCopy");
        mi.addActionListener(new RixAction(NORMCOPY, sel, at));
        return mi;
    }

    public JMenuItem Normalize(String sel, int at) {
        JMenuItem mi = new JMenuItem("Normalize");
        mi.addActionListener(new RixAction(NORMALIZE, sel, at));
        return mi;
    }

    private void insertParamStr(String str, int begin, int end) {
        try {
            this.textpane.setSelectionStart(begin);
            this.textpane.setSelectionEnd(end);
            this.textpane.replaceSelection(str);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:RixPatternHelp.insertParamStr()\n        " + e.toString());
            return;
        }
    }

    private class RixAction
    implements ActionListener {
        String payload;
        String selection;
        int offset;

        public RixAction(String text, String sel, int at) {
            this.payload = text;
            this.selection = sel;
            this.offset = at;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int span = this.offset - this.selection.length();
            RixShadingUtilsCalls.this.insertParamStr(this.payload, span, this.offset);
        }
    }
}

