/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.ProjectManagement.CProjectManager;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.C.CTokenizer;
import UI_Script.ProjectManagement.MultipleMainException;
import UI_Script.ProjectManagement.NoMainFunctionException;
import UI_Script.ProjectManagement.ProjectManager;
import UI_Script.ScriptParser.ScriptParser;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;

public class CProjectManager
extends ProjectManager {
    static String[] c = new String[]{".c"};
    static String[] h = new String[]{".h"};

    public CProjectManager() {
        super(new CTokenizer(), c, h);
    }

    @Override
    protected void getCompileCommand() {
        String bin = Preferences.get(Preferences.PATH_CPP_COMPILER_BIN).trim();
        this.compileCmnd = Preferences.get(Preferences.EXE_CPP_COMPILE);
        if (this.compileCmnd == null || this.compileCmnd.trim().length() == 0) {
            return;
        }
        if (bin.length() != 0) {
            this.compileCmnd = bin.trim() + File.separatorChar + this.compileCmnd;
        }
        this.compileCmnd = FileUtils.applyFileSeparator(this.compileCmnd);
    }

    @Override
    public String[] getCompileDirective(File srcFile) {
        String[] items;
        int n;
        Vector<String> list = new Vector<String>();
        String srcText = FileUtils.read(srcFile.getPath());
        this.getAllUserIncludes(list, srcText, srcFile.getParentFile());
        this.getCompileCommand();
        String[] includes = VectorUtils.toStringArray(list);
        if (includes != null && includes.length != 0) {
            for (int n2 = 0; n2 < includes.length; ++n2) {
                File f = new File(includes[n2]);
                if (f.exists() || !(f = new File(srcFile.getParentFile(), includes[n2])).exists()) continue;
                includes[n2] = f.getPath();
            }
            this.saveDesktopFiles(includes);
            Cutter.setLog("CProjectManager.getCompileDirective() all #included files are _____");
            Cutter.setLog(includes);
            Cutter.setLog("_________________________________");
        }
        Object otherSrc = null;
        if (includes != null) {
            otherSrc = this.getRelatedSourcesFrom(includes);
        }
        if (otherSrc != null) {
            this.saveDesktopFiles((String[])otherSrc);
            String path = srcFile.getPath();
            Vector<String> v = new Vector<String>();
            for (n = 0; n < ((String[])otherSrc).length; ++n) {
                if (otherSrc[n].equals(path)) continue;
                v.addElement(otherSrc[n]);
            }
            otherSrc = v.size() == 0 ? null : VectorUtils.toStringArray(v);
        }
        File dir = srcFile.getParentFile();
        String[] options = null;
        if (dir != null && dir.exists() && (options = CProjectManager.getProjectCompilerOptions(dir, "IncludesBegin", "IncludesEnd")) != null && options.length > 0) {
            for (n = 0; n < options.length; ++n) {
                options[n] = "-I" + options[n];
            }
        }
        if (otherSrc == null) {
            items = new String[]{this.compileCmnd, "-c", srcFile.getPath()};
        } else {
            items = new String[((String[])otherSrc).length + 3];
            items[0] = this.compileCmnd;
            items[1] = "-c";
            items[2] = srcFile.getPath();
            for (int n3 = 0; n3 < ((String[])otherSrc).length; ++n3) {
                items[n3 + 3] = otherSrc[n3];
            }
        }
        if (options != null) {
            return VectorUtils.toStringArray(items, options);
        }
        return items;
    }

    @Override
    public String[] getMakeDirective(File srcFile) {
        int n;
        int n2;
        String[] temp = this.getCompileDirective(srcFile);
        String srcDirPath = srcFile.getParent();
        File makefile = new File(srcDirPath, "makefile");
        if (!makefile.exists()) {
            makefile = new File(srcDirPath, "Makefile");
        }
        if (makefile.exists()) {
            this.exePath = TextUtils.removeExtension(temp[2]);
            if (EnvUtils.isWinEnvironment()) {
                this.exePath = this.exePath + ".exe";
            }
            String[] items = new String[]{"make", "-C", srcDirPath};
            String[] tokens = TextUtils.tokenize(temp[0], File.separator);
            if (tokens != null && tokens.length > 0 && tokens[tokens.length - 1].equals("dmc")) {
                items[1] = "-f";
                items[2] = items[2] + File.separator + "makefile";
            }
            Cutter.setLog("    Info: CProjectManager.getMakeDirective() detected a makefile.");
            return items;
        }
        String[] out = EnvUtils.isLinuxEnvironment() ? new String[temp.length + 2] : new String[temp.length + 1];
        out[0] = temp[0];
        out[1] = "-o";
        this.exePath = TextUtils.removeExtension(temp[2]);
        if (EnvUtils.isWinEnvironment()) {
            this.exePath = this.exePath + ".exe";
        }
        out[2] = this.exePath;
        if (EnvUtils.isLinuxEnvironment()) {
            out[3] = "-lm";
            for (n2 = 4; n2 < out.length; ++n2) {
                out[n2] = temp[n2 - 2];
            }
        } else {
            for (n2 = 3; n2 < out.length; ++n2) {
                out[n2] = temp[n2 - 1];
            }
        }
        File dir = srcFile.getParentFile();
        String[] options = null;
        if (dir != null && dir.exists() && (options = CProjectManager.getProjectCompilerOptions(dir, "LibrariesBegin", "LibrariesEnd")) != null && options.length > 0) {
            for (int n3 = 0; n3 < options.length; ++n3) {
                options[n3] = "-L" + options[n3];
            }
        }
        if (options == null || options.length == 0) {
            return out;
        }
        String[] all = new String[out.length + options.length];
        for (n = 0; n < out.length; ++n) {
            all[n] = out[n];
        }
        for (n = 0; n < options.length; ++n) {
            all[n + out.length] = options[n];
        }
        return all;
    }

    @Override
    public boolean buildDateIsValid(File srcFile) {
        if (srcFile == null || this.exePath == null || this.srcExt == null || this.hdrExt == null) {
            return false;
        }
        String[] items = this.getMakeDirective(srcFile);
        if (items == null) {
            return false;
        }
        File exeFile = new File(items[2]);
        if (!exeFile.exists()) {
            return false;
        }
        long exeModifiedAt = exeFile.lastModified();
        for (int n = 3; n < items.length; ++n) {
            File file = new File(items[n]);
            if (file.equals(exeFile) || file.lastModified() <= exeModifiedAt) continue;
            Cutter.setLog("CProjectManager.buildDateIsValid() " + file.getName() + " was edited after " + exeFile.getName() + " was last built");
            return false;
        }
        return true;
    }

    @Override
    public boolean isRunnableScript(File file) {
        if (file == null) {
            return false;
        }
        String[] path = new String[]{file.getPath()};
        try {
            this.getFilesContainingMain(path);
        }
        catch (NoMainFunctionException e) {
            Cutter.setLog("    Debug:CProjectManager.isRunnableScript()\n" + e.toString());
            return false;
        }
        return true;
    }

    @Override
    public KAbstractWindow getWindowWithMain() throws MultipleMainException, NoMainFunctionException {
        KAbstractWindow[] w = KAbstractDesktop.getAllWindows();
        if (w == null || w.length == 0) {
            throw new NoMainFunctionException("Cannot find a document that implements a \"main\" function");
        }
        Vector<KAbstractWindow> list = new Vector<KAbstractWindow>();
        for (int n = 0; n < w.length; ++n) {
            File f;
            if (w[n].isIcon() || (f = w[n].getFile()) == null || !ScriptParser.containsProcNamed(f, "main")) continue;
            list.addElement(w[n]);
        }
        if (list.size() == 0) {
            throw new NoMainFunctionException("Cannot find an open window whose source code\nimplements a main() function. Unless your\nproject is being managed by a \"Makefile\" your\nmain source code file must be open on\nCutters desktop.\n");
        }
        if (list.size() > 1) {
            throw new MultipleMainException("Only one open window can implement a \"main\" function.\nMinimize the windows that have a \"main\" function\nand try executing your code again.\n");
        }
        return (KAbstractWindow)list.elementAt(0);
    }
}

