/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.ProjectManagement;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Comment;
import UI_Script.ProjectManagement.MultipleMainException;
import UI_Script.ProjectManagement.NoMainFunctionException;
import UI_Script.ScriptParser.ScriptParser;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;
import kernal.Tokenizers.TokenizerRegistryItem;

public abstract class ProjectManager {
    private static final String COMPILER_OPTIONS_FILENAME = "compiler_options.ini";
    protected String[] srcExt = null;
    protected String[] hdrExt = null;
    protected Comment[] comments;
    protected String exePath = null;
    protected String compileCmnd = null;
    protected Tokenizer tok = null;

    public abstract String[] getMakeDirective(File var1);

    public abstract String[] getCompileDirective(File var1);

    public abstract boolean buildDateIsValid(File var1);

    protected abstract void getCompileCommand();

    public abstract boolean isRunnableScript(File var1);

    public abstract KAbstractWindow getWindowWithMain() throws MultipleMainException, NoMainFunctionException;

    public static String[] getProjectCompilerOptions(File dir, String beginStr, String endStr) {
        if (dir == null || !dir.exists()) {
            return null;
        }
        File compilerOptionsFile = new File(dir, COMPILER_OPTIONS_FILENAME);
        if (!compilerOptionsFile.exists()) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        Tokenizer tok = new Tokenizer();
        try {
            String line;
            BufferedReader inn = new BufferedReader(new FileReader(compilerOptionsFile), 1024);
            boolean beginFound = false;
            boolean endFound = false;
            tok.setDelimitor(" ");
            while ((line = inn.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                tok.setBuffer(line);
                String str = tok.getNextStr();
                if (str.equals("")) break;
                if (str.equalsIgnoreCase(beginStr)) {
                    beginFound = true;
                    continue;
                }
                if (str.equalsIgnoreCase(endStr)) {
                    endFound = true;
                }
                if (!beginFound || endFound || str.trim().length() <= 0) continue;
                list.addElement(str);
            }
            inn.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception:ProjectManager.getProjectCompilerOptions()");
            Cutter.setLog(e.toString());
            return null;
        }
        return VectorUtils.toStringArray(list);
    }

    public static void deleteCompilerOptionsFile(File dir) {
        File compilerOptionsFile = new File(dir, COMPILER_OPTIONS_FILENAME);
        if (compilerOptionsFile.exists()) {
            compilerOptionsFile.delete();
        }
    }

    public static void saveCompilerOptions(File dir, String[] includes, String[] libs) {
        File compilerOptionsFile = new File(dir, COMPILER_OPTIONS_FILENAME);
        try {
            int n;
            BufferedWriter out = new BufferedWriter(new FileWriter(compilerOptionsFile));
            out.write("# This file is maintained by Cutter. It should not be edited manually.");
            out.newLine();
            out.write("IncludesBegin");
            out.newLine();
            if (includes != null) {
                for (n = 0; n < includes.length; ++n) {
                    out.write("\t" + includes[n]);
                    out.newLine();
                }
            }
            out.write("IncludesEnd");
            out.newLine();
            out.write("LibrariesBegin");
            out.newLine();
            if (libs != null) {
                for (n = 0; n < libs.length; ++n) {
                    out.write("\t" + libs[n]);
                    out.newLine();
                }
            }
            out.write("LibrariesEnd");
            out.newLine();
            out.flush();
            out.close();
            out = null;
        }
        catch (IOException e) {
            Cutter.setLog("    Error:ProjectManager.saveCompilerOptions()");
            Cutter.setLog(e.toString());
            return;
        }
        KAbstractWindow w = KAbstractDesktop.getWindowWithFile(compilerOptionsFile);
        if (w != null) {
            KAbstractDesktop.toFront(w);
            BBxt.reReadFromFile();
        }
    }

    public ProjectManager(Tokenizer tok, String[] srcExtensions, String[] headerExtensions) {
        TokenizerRegistryItem mem;
        int n;
        this.tok = tok;
        this.addToSrcExt(srcExtensions);
        this.addToHdrExt(headerExtensions);
        if (this.srcExt != null) {
            for (n = 0; n < this.srcExt.length; ++n) {
                mem = Tokenizer.getMemberWithExt(this.srcExt[n]);
                if (mem == null) continue;
                this.addComments(mem.cmnt);
            }
        }
        if (this.hdrExt != null) {
            for (n = 0; n < this.hdrExt.length; ++n) {
                mem = Tokenizer.getMemberWithExt(this.hdrExt[n]);
                if (mem == null) continue;
                this.addComments(mem.cmnt);
            }
        }
    }

    protected void addToSrcExt(String[] in) {
        if (in == null || in.length == 0) {
            return;
        }
        this.srcExt = VectorUtils.toStringArray(this.srcExt, in);
    }

    protected void addToHdrExt(String[] in) {
        if (in == null || in.length == 0) {
            return;
        }
        this.hdrExt = VectorUtils.toStringArray(this.hdrExt, in);
    }

    protected void addComments(Comment[] in) {
        int n;
        Vector<Comment> v = new Vector<Comment>();
        if (this.comments != null) {
            for (n = 0; n < this.comments.length; ++n) {
                v.addElement(this.comments[n]);
            }
        }
        for (n = 0; n < in.length; ++n) {
            v.addElement(in[n]);
        }
        this.comments = new Comment[v.size()];
        for (n = 0; n < v.size(); ++n) {
            this.comments[n] = (Comment)v.elementAt(n);
        }
    }

    public String getPathToExecutable() {
        return this.exePath;
    }

    protected String[] getRelatedSourcesFrom(String[] pathsOfHeaders) {
        Vector<String> list = new Vector<String>();
        for (int n = 0; n < pathsOfHeaders.length; ++n) {
            String str = TextUtils.removeExtension(pathsOfHeaders[n]);
            for (int i = 0; i < this.srcExt.length; ++i) {
                File f = new File(str + this.srcExt[i]);
                if (!new File(str + this.srcExt[i]).exists() || list.contains(f.getPath())) continue;
                list.addElement(str + this.srcExt[i]);
            }
        }
        return VectorUtils.toStringArray(list);
    }

    private String[] getUserIncludes(String srcText) {
        if (srcText == null || srcText.trim().length() == 0) {
            return null;
        }
        ScriptParser sp = new ScriptParser(this.tok, srcText);
        String[][] imports = sp.getImports();
        return imports == null || imports.length < 2 ? null : imports[1];
    }

    protected void getAllUserIncludes(Vector<String> outList, String srcText, File parentDir) {
        int n;
        String[] includes = this.getUserIncludes(srcText);
        if (includes == null) {
            return;
        }
        for (n = 0; n < includes.length; ++n) {
            File f = new File(includes[n]);
            File pd = f.getParentFile();
            if (pd != null && pd.equals(parentDir) || !(f = new File(parentDir, includes[n])).exists()) continue;
            includes[n] = f.getPath();
        }
        for (n = 0; n < includes.length; ++n) {
            String text;
            String path = includes[n];
            if (path == null || path.trim().length() == 0) continue;
            if (!outList.contains(path)) {
                outList.addElement(path);
            }
            if ((text = FileUtils.read(path)) == null || text.trim().length() == 0) continue;
            this.getAllUserIncludes(outList, text, new File(path).getParentFile());
        }
    }

    public String[] getFilesContainingMain(String[] paths) throws NoMainFunctionException {
        Vector<String> filesWithMainFunction = new Vector<String>();
        for (int n = 0; n < paths.length; ++n) {
            File file = new File(paths[n]);
            if (!ScriptParser.containsProcNamed(file, "main")) continue;
            filesWithMainFunction.addElement(paths[n]);
        }
        if (filesWithMainFunction.size() == 0) {
            throw new NoMainFunctionException("Cannot find a source file that implements a main() function in the project folder.\n");
        }
        return VectorUtils.toStringArray(filesWithMainFunction);
    }

    public void saveDesktopFiles(String[] paths) {
        if (paths != null) {
            for (int n = 0; n < paths.length; ++n) {
                File f = new File(paths[n]);
                KAbstractWindow w = KAbstractDesktop.getWindowWithFile(f);
                if (w == null) continue;
                w.saveFile();
            }
        }
    }

    public String[] getDirectoryListing(File hostDir, String[] ext) {
        FileUtils.SourceFileFilter filter = null;
        Vector<String> out = new Vector<String>();
        for (int n = 0; n < ext.length; ++n) {
            String[] tmp;
            filter = new FileUtils.SourceFileFilter(ext[n]);
            if (filter == null || (tmp = hostDir.list(filter)) == null) continue;
            for (int i = 0; i < tmp.length; ++i) {
                String name = tmp[i];
                if (name == null) continue;
                out.addElement(new File(hostDir, name).getPath());
            }
        }
        return VectorUtils.toStringArray(out);
    }
}

