/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Python;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.KCompletionManager;
import UI_Script.Mel.MelHelp;
import UI_Script.Mel.MelTokenizer;
import UI_Script.Python.PySide2;
import UI_Script.Python.PythonTokenizer;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.DelayedFinder;
import UI_Window.KWindow.HTMLWindow;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.RibDocsUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class PythonHelp
extends KAbstractHelp {
    protected static KAbstractHelp PythonHelp = null;
    public static final String HTTP_PYTHON_ORG = "http://docs.python.org/3/";
    public static final String BUILTIN_FUNCTIONS_PAGE = "library/functions.html";
    public static final String STRING_METHODS_PAGE = "library/stdtypes.html";
    public static final String STRING_FORMATTING_PAGE = "library/string.html";
    public static final String MODULE_INDEX_PAGE = "py-modindex.html";
    public static final String REGSUB_PREFIX = "(\\b(\\w+\\.)*";
    public static final String REGSUB_POSTFIX = "(\\.\\w+)*\\b)";
    final File ri_binding_html = new File(FileUtils.getPWDFile(), "/Cutter_Help/prman/python/ri_bindings.html");
    private static Hashtable<String, String> languageTable = new Hashtable();
    private String module = null;
    private String function = null;
    private Hashtable<String, String> tableOfMelFuncs = new Hashtable();
    private String pathToPyMelDocs = null;
    static boolean debug_completer;

    public static void initPaths() {
    }

    private String lookUpWebPage(String str) {
        Cutter.setLog("    Debug: PythonHelp.lookUpWebPage() >" + str + "<");
        String result = null;
        if (PythonTokenizer.pythonOrgModulLUT == null) {
            Cutter.setLog("    Error: PythonHelp.lookUpWebPage() - PythonTokenizer.pythonOrgModulLUT is null");
            return null;
        }
        if (str == null || str.trim().length() == 0) {
            result = null;
            return result;
        }
        if (PythonTokenizer.pythonOrgModulLUT.get(str) != null) {
            result = "library/" + str + ".html";
        } else {
            if (str.equals("string")) {
                result = "library/stdtypes.html#string-methods";
                return result;
            }
            if (str.equals("str")) {
                result = "library/stdtypes.html#string-methods";
                return result;
            }
            if (str.equals("list")) {
                result = "tutorial/datastructures.html#more-on-lists";
                return result;
            }
            if (str.equals("tuple")) {
                result = "tutorial/datastructures.html#tuples-and-sequences";
                return result;
            }
            if (str.equals("dictionary") || str.equals("dict")) {
                result = "tutorial/datastructures.html#dictionaries";
                return result;
            }
            if (str.equals("file")) {
                result = "tutorial/inputoutput.html#reading-and-writing-files";
                return result;
            }
            if (str.equals("def")) {
                result = "tutorial/controlflow.html#more-on-defining-functions";
                return result;
            }
        }
        PythonTokenizer pt = new PythonTokenizer();
        if (pt.isBuiltIn(str)) {
            result = "library/functions.html#" + str;
            return result;
        }
        if (PythonTokenizer.language.containsKey(str) && PythonTokenizer.language.get(str).equals("language")) {
            result = "reference/index.html";
        }
        if (str.startsWith("%")) {
            result = STRING_FORMATTING_PAGE;
        }
        if (str.indexOf(46) != -1) {
            result = this.lookUpWebPage(TextUtils.removeExtension(str));
        }
        if (str.equals("if") || str.equals("while") || str.equals("for") || str.equals("try") || str.equals("with") || str.equals("def")) {
            result = "reference/compound_stmts.html#" + str;
        } else if (str.equals("__init__") || str.equals("self") || str.equals("class")) {
            result = "tutorial/classes.html#class-definition-syntax";
        } else if (str.equals("__main__") || str.equals("__future__")) {
            result = "library/" + str + ".html";
        } else if (str.startsWith("__") && str.endsWith("__")) {
            result = "reference/import.html#" + str;
        } else if (str.equals("pass") || str.equals("del") || str.equals("return") || str.equals("yield") || str.equals("raise") || str.equals("break") || str.equals("continue") || str.equals("import") || str.equals("nonlocal") || str.equals("global") || str.equals("assert")) {
            result = "reference/simple_stmts.html#" + str;
        } else if (str.equals("and") || str.equals("or") || str.equals("not")) {
            result = "library/stdtypes.html#boolean-operations-and-or-not";
        } else if (str.equals("path")) {
            result = "library/os.path.html";
        }
        Cutter.setLog("    Debug: PythonHelp.lookUpWebPage() returning >" + result + "<");
        return result;
    }

    private String trimToTail(String str, String tail) {
        int n;
        if (str == null || tail == null || str.trim().length() == 0 || tail.trim().length() == 0) {
            return null;
        }
        String[] tokens = TextUtils.tokenize(str, '.');
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int tailIndex = -1;
        for (n = tokens.length - 1; n >= 0; --n) {
            if (!tokens[n].equals(tail)) continue;
            tailIndex = n;
            break;
        }
        if (tailIndex == -1) {
            return null;
        }
        for (n = 0; n <= tailIndex; ++n) {
            buf.append(tokens[n]);
            if (n >= tailIndex) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    private String getTail(String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf(46);
        return index == -1 ? str : str.substring(index + 1);
    }

    private String[] resolveNoData() {
        int offset = this.textpane.getSelectionStart();
        String ch = this.textpane.getCharAt(offset);
        if (!ch.equals("%")) {
            ch = this.textpane.getCharAt(offset - 1);
        }
        ch = ch.equals("%") ? "%" : "";
        String[] out = new String[]{ch, ""};
        return out;
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        String tail;
        Cutter.setLog("    Debug:PythonHelp.showDocFor() - item >" + item + "<");
        if (e.getModifiersEx() < 20) {
            Cutter.setLog("    Debug:PythonHelp.showDocFor() - return false because e.getModifiers() < 20");
            return false;
        }
        if (item.trim().length() == 1) {
            this.useCutterBrowser = false;
            if (item.trim().equals("[") || item.trim().equals("]")) {
                return this.setHelpPage("http://docs.python.org/tutorial/datastructures.html#more-on-lists");
            }
            if (item.trim().equals("{") || item.trim().equals("}")) {
                return this.setHelpPage("http://docs.python.org/tutorial/datastructures.html#dictionaries");
            }
            if (item.trim().equals("(") || item.trim().equals(")")) {
                return this.setHelpPage("http://docs.python.org/tutorial/datastructures.html#tuples-and-sequences");
            }
            return false;
        }
        if (item == null || item.trim().length() == 0) {
            return false;
        }
        if (item != null) {
            String tail2 = PySide2.getURLTail(item);
            if (tail2 != null) {
                this.useCutterBrowser = false;
                String baseUrl = Preferences.get(Preferences.PATH_PYSIDE2_DOCS);
                if (baseUrl.endsWith("index.html")) {
                    baseUrl = baseUrl.substring(0, baseUrl.length() - 10);
                    baseUrl = baseUrl + "PySide/";
                    return this.setHelpPage(baseUrl + tail2);
                }
            } else if (item.equals("PySide2")) {
                String baseUrl = Preferences.get(Preferences.PATH_PYSIDE2_DOCS);
                this.useCutterBrowser = false;
                return this.setHelpPage(baseUrl);
            }
        }
        if (item != null) {
            Cutter.setLog("    Info:PythonHelp.showDocFor() - BBxt.isPyMelDocument() = " + BBxt.isPyMelDocument());
            if (BBxt.isPyMelDocument() && MelTokenizer.sortedFunctionNames != null) {
                if (this.tableOfMelFuncs.isEmpty()) {
                    if (this.pathToPyMelDocs == null) {
                        MelHelp.initPaths();
                        this.pathToPyMelDocs = FileUtils.removeTrailingSeparator(MelHelp.docsPath, '/', '\\');
                        this.pathToPyMelDocs = this.pathToPyMelDocs + "Python";
                    }
                    for (int n = 0; n < MelTokenizer.sortedFunctionNames.length; ++n) {
                        String func = MelTokenizer.sortedFunctionNames[n];
                        this.tableOfMelFuncs.put(func, func);
                    }
                }
                if (this.tableOfMelFuncs.containsKey(item)) {
                    this.useCutterBrowser = !e.isShiftDown();
                    return this.setHelpPage(this.pathToPyMelDocs + "/" + item + ".html");
                }
                Cutter.setLog("    Info:PythonHelp.showDocFor() - \"" + item + "\" tableOfMelFuncs.containsKey(item) = false");
            }
            if (BBxt.isPyRiDocument() && item.equals("prman")) {
                this.useCutterBrowser = false;
                return this.setHelpPage("https://renderman.pixar.com/resources/RenderMan_20/prmanForPython.html");
            }
            if (BBxt.isPyRiDocument() && (item.equalsIgnoreCase("Ri") || Character.isUpperCase(item.charAt(0)))) {
                boolean bl = this.useCutterBrowser = !e.isShiftDown();
                if (!this.useCutterBrowser) {
                    return this.setHelpPage(this.ri_binding_html.getPath());
                }
                String url = "file:" + this.ri_binding_html.getPath();
                return this.setHelpPage(url);
            }
        }
        char[] delims = new char[]{'.'};
        String[] data = null;
        if (item != null) {
            data = DocumentUtils.getTextJoinedBy(this.textpane.getDocument(), this.textpane.getSelectionStart(), delims);
        }
        if (data == null || data[0].trim().length() == 0) {
            data = this.resolveNoData();
            item = data[0];
        }
        String headtail = data[0];
        String terminal = data[1];
        String page = MODULE_INDEX_PAGE;
        String trimmedHeadTail = null;
        String str = this.lookUpWebPage(item);
        if (str == null) {
            trimmedHeadTail = this.trimToTail(headtail, item);
            str = this.lookUpWebPage(trimmedHeadTail);
        }
        if (str == null && trimmedHeadTail != null && !headtail.equals(trimmedHeadTail)) {
            str = this.lookUpWebPage(headtail);
        }
        if (str != null) {
            page = str;
        }
        if (str == null && headtail.indexOf(".") == -1 && PythonTokenizer.pythonBuiltinFunctionsLUT.get(headtail) != null) {
            page = BUILTIN_FUNCTIONS_PAGE;
            this.function = headtail;
            str = page;
        }
        if (str == null && PythonTokenizer.pythonStringMethodsLUT.get(tail = this.getTail(headtail)) != null) {
            page = STRING_METHODS_PAGE;
            this.function = tail;
            str = page;
        }
        final String url = HTTP_PYTHON_ORG + page;
        this.useCutterBrowser = false;
        if (!this.useCutterBrowser) {
            return this.setHelpPage(url);
        }
        String URL2 = url;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLWindow.editorPane.getDocument().putProperty("title", "Cutter Browser");
                Cutter.htmlWindow.setTitle("loading");
                KAbstractDesktop.toFront(Cutter.htmlWindow, true);
                try {
                    String regexp = "\\n" + PythonHelp.this.function + "\\s*\\([^)]+\\)";
                    DelayedFinder df = new DelayedFinder(regexp);
                    Cutter.htmlWindow.setDelayedFind(df);
                    Cutter.htmlWindow.setPage(url, null);
                    Cutter.htmlWindow.setVisible(true);
                }
                catch (Exception ex) {
                    Cutter.setLog("    Exception:PythonHelp.showDocFor()\n" + ex.toString());
                }
            }
        });
        return true;
    }

    public PythonHelp(KTextPane textpane) {
        super(textpane);
        UI_Script.Python.PythonHelp.initPaths();
        this.completer.completionActivate();
        this.completer.setWordStartDelims(null);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionDotIsValid(String str) {
        if (!debug_completer) {
            return false;
        }
        if (str == null) {
            return false;
        }
        if (str.equals("PySide2") || str.equals("PyQt5") || str.equals("PyQt4")) {
            return true;
        }
        boolean result = PySide2.getMethodsForModule(str) != null;
        return result;
    }

    @Override
    public String[] completionDotCandidates(String str) {
        if (!debug_completer) {
            return null;
        }
        if (str == null) {
            return null;
        }
        if (str.equals("PySide2") || str.equals("PyQt5")) {
            return PySide2.getPyQt5ModuleNames();
        }
        if (str.equals("PyQt4")) {
            return PySide2.getPyQt4ModuleNames();
        }
        String[] result = PySide2.getMethodsForModule(str);
        return result;
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (!debug_completer) {
            return false;
        }
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        if (str.length() == 2 && Character.isUpperCase(str.charAt(0)) && Character.isUpperCase(str.charAt(1))) {
            return true;
        }
        if (str.length() >= KCompletionManager.MIN_LEN && Character.isUpperCase(str.charAt(0)) && PySide2.pySideTableContains(str)) {
            return true;
        }
        return str.length() >= KCompletionManager.MIN_LEN && Character.isLowerCase(str.charAt(0));
    }

    @Override
    public String[] completionCandidates(String str) {
        if (!debug_completer) {
            return null;
        }
        String[] pysiders = PySide2.getAllPySiders(str);
        String[] lang = this.completionCandidates(str, languageTable);
        if (pysiders == null && lang == null) {
            return null;
        }
        if (pysiders == null && lang != null) {
            return this.completionCandidates(str, languageTable);
        }
        if (lang == null && pysiders != null) {
            return pysiders;
        }
        return VectorUtils.toStringArray(lang, pysiders);
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    @Override
    protected void lookup(String item) {
    }

    @Override
    protected JComponent[] getDefaultPopupItems(MouseEvent e, String initialSelection, int begin, int end) {
        this.initSelectionData(initialSelection, begin, end);
        this.mouseEvent = e;
        JComponent[] list = new JComponent[]{this.getDefaultSendMailMenu(), this.getDefaultOpenPathMenu(), this.getDefaultSelectBlockMenu(), this.getDefaultFileBrowseMenu(), this.getDefaultEditMenu(), this.getDefaultTextShiftMenu(), this.getDefaultCmntMenu(), this.getDefaultCaseMenu(), this.getDefaultEditRGBMenu(), this.getDefaultExportAsHtml(), this.getDefaultLineNumbering(), this.getDefaultTypingCompletion(), new JSeparator(), this.getDefaultExecute()};
        return list;
    }

    @Override
    public void popupOnlineHelp(Point pnt, final String selection, final int end, MouseEvent e) {
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, end - selection.length(), end);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        popup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                int begin = end - selection.length();
                if (begin >= 0 && end >= 0) {
                    BBxt.setSelection(begin, end);
                }
            }
        });
        popup.add(this.getLookupInPixarDocsMenu());
        popup.add(this.getLookupUsingHelpMenu());
        popup.add(new JSeparator());
        popup.add(defaultMenu);
        popup.pack();
        popup.show(this.textpane, pnt.x, pnt.y);
    }

    protected KAbstractHelp.KPopupMenuItem getLookupInPixarDocsMenu() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Lookup in Pixar Docs");
        mi.setEnabled(false);
        if (this.selRawStr != null && this.selRawStr.length() > 0 && !Character.isUpperCase(this.selRawStr.charAt(0))) {
            return mi;
        }
        if (RibDocsUtils.lookupURL(this.selRawStr) == null) {
            return mi;
        }
        mi.setEnabled(true);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonHelp.this.useCutterBrowser = false;
                PythonHelp.this.setHelpPage(RibDocsUtils.lookupURL(PythonHelp.this.selRawStr));
            }
        };
        mi.addActionListener(action);
        return mi;
    }

    protected KAbstractHelp.KPopupMenuItem getLookupUsingHelpMenu() {
        KAbstractHelp.KPopupMenuItem mi;
        String[] tokens;
        final String text = BBxt.getSelection();
        if (!(text != null && text.trim().length() != 0 || (tokens = TextUtils.tokenize(text)) != null && tokens.length <= 1)) {
            KAbstractHelp.KPopupMenuItem mi2 = new KAbstractHelp.KPopupMenuItem("help");
            mi2.setEnabled(false);
            return mi2;
        }
        boolean foundInQt = false;
        Enumeration<String> e = PySide2.ModulesTable.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Hashtable table = PySide2.ModulesTable.get(key);
            if (table == null || !table.containsKey(text)) continue;
            foundInQt = true;
            break;
        }
        if (!foundInQt && !text.equals("uic")) {
            mi = new KAbstractHelp.KPopupMenuItem("help");
            mi.setEnabled(false);
            return mi;
        }
        mi = new KAbstractHelp.KPopupMenuItem("help( " + text + " )");
        mi.setEnabled(true);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File outfile = new File(FileUtils.getPWDFile(), "temp_help.py");
                StringBuffer buf = new StringBuffer();
                buf.append("from PyQt5 import QtCore\n");
                buf.append("from PyQt5 import QtGui\n");
                buf.append("from PyQt5 import QtWidgets\n");
                buf.append("import PyQt5.QtCore\n");
                buf.append("import PyQt5.QtGui\n");
                buf.append("import PyQt5.QtWidgets\n");
                buf.append("from PyQt5.QtCore import *\n");
                buf.append("from PyQt5.QtGui import *\n");
                buf.append("from PyQt5 import uic\n");
                buf.append("from PyQt5.QtWidgets import *\n");
                buf.append("help(").append(text).append(")\n");
                FileUtils.writeFile(outfile, buf.toString());
                ScriptHandler handler = ScriptRegistry.getHandlerForExtension(".py");
                if (handler != null) {
                    handler.execute(outfile);
                }
            }
        };
        mi.addActionListener(action);
        return mi;
    }

    static {
        Enumeration<String> e = PythonTokenizer.language.keys();
        while (e.hasMoreElements()) {
            String str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        debug_completer = true;
    }
}

