/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Python;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Python.PythonTokenizer;
import UI_Script.ScriptParser.ScriptParser;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTabsListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import UI_Window.KWindow.KAbstractTextWindow;
import Utilities.DocumentUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;

public class PythonListener
extends SyntaxListener
implements KTabsListener {
    private Hashtable<String, String> tableOfImports = new Hashtable();
    private PythonModule pm = new PythonModule();
    private StringBuffer sb = new StringBuffer();

    public PythonListener(KTextPane textpane) {
        super(textpane, new PythonTokenizer());
        KAbstractTextWindow w = textpane.getFrame();
        this.initDelimitors(textpane);
        this.initStyles(textpane);
        textpane.addTabsListener(this);
    }

    @Override
    public void tabsAddedAt(int offset, int numTabs, int finalCaretOffset) {
        if (offset == 0) {
            return;
        }
        Segment seg = DocumentUtils.getSegment(this.textpane.getDocument(), offset);
        String str = seg.toString().trim();
        if (str.endsWith(":")) {
            try {
                this.textpane.getDocument().insertString(finalCaretOffset, "\t", null);
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Error: PythonListener.tabsAddedAt() - " + ex.getMessage());
            }
        }
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] items = new char[]{'-', '$'};
        textpane.addWordDelimitors(items, items);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.commentStyle2, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_BUILT_IN));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_MODULE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_METHOD));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
        StyleConstants.setForeground(textpane.styleContext.keywordStyle5, Preferences.getColor(Preferences.TEXT_COLOR_PYTHON_CONSTANT));
        StyleConstants.setUnderline(textpane.styleContext.keywordStyle5, true);
    }

    public String[][] getImports() {
        ScriptParser sp;
        String text = BBxt.getWindowText();
        if (text == null) {
            Cutter.setLog("    Error:PythonListener.getImports - Front window has no text.");
            return null;
        }
        try {
            sp = new ScriptParser(new PythonTokenizer(), text);
        }
        catch (Exception ee) {
            Cutter.setLog("    Error:PythonListener.getImports() - Cannot get ScriptParser.\n        " + ee.toString());
            return null;
        }
        String[][] imports = sp.getImports();
        return imports;
    }

    public String[] getImportedModules() {
        String[][] imports = this.getImports();
        if (imports == null) {
            Cutter.setLog("    Info:PythonListener.getImportedModules() - cannot find any import statements.");
            return null;
        }
        if (imports[2] == null || imports[2].length == 0) {
            Cutter.setLog("    Info:PythonListener.getImportedModules() - cannot find any import statements.");
            return null;
        }
        Vector<String> list = new Vector<String>();
        for (int n = 0; n < imports[2].length; ++n) {
            String[] tokens = TextUtils.tokenize(imports[2][n]);
            if (tokens == null) continue;
            if (tokens[0].equals("from") && tokens.length == 4 && !tokens[3].equals("*")) {
                list.addElement(tokens[3]);
                continue;
            }
            if (tokens[0].equals("import") && tokens.length == 4 && tokens[tokens.length - 2].equals("as")) {
                list.addElement(tokens[tokens.length - 1]);
                continue;
            }
            if (!tokens[0].equals("import") || tokens.length <= 1) continue;
            String remainder = imports[2][n].trim().substring(6).trim();
            String[] t = TextUtils.tokenize(remainder, ",");
            for (int i = 0; i < t.length; ++i) {
                list.addElement(t[i].trim());
            }
        }
        return VectorUtils.toStringArray(list);
    }

    @Override
    protected void parseAllWillHappen() {
        String[] entries = this.getImportedModules();
        this.tableOfImports.clear();
        if (entries == null) {
            return;
        }
        for (int n = 0; n < entries.length; ++n) {
            this.tableOfImports.put(entries[n], entries[n]);
        }
    }

    @Override
    protected synchronized void parse(Segment segment, int offset) {
        if (!this.colorationIsActive()) {
            Cutter.setLog("    Debug:PythonListener.parse(segment,offset) - cannot because colorationIsActive() is " + this.colorationIsActive());
            return;
        }
        long startTime = System.currentTimeMillis();
        if (segment == null || segment.count == 0) {
            return;
        }
        this.tok.setBuffer(segment);
        this.tok.getComments = true;
        this.str = this.tok.getNextStr();
        if (this.str == null) {
            Cutter.setLog("PythonListener.parse() - initial getNextStr() returned a null string");
            return;
        }
        if (_parse) {
            Cutter.setLog("PythonListener.parse() first str >" + this.str + "<");
        }
        this.editList = new StyleEdits(this);
        while (!this.str.equals("")) {
            int index = this.tok.getBufferIndex() - 1 < 0 ? 0 : this.tok.getBufferIndex();
            int begin = (index += offset) - this.str.length();
            if (this.tok.isLanguageType(this.str)) {
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.languageStyle, true);
            } else if (((PythonTokenizer)this.tok).isOpenComment(this.str)) {
                if (_parse) {
                    Cutter.setLog("PythonListener.parse() appling commentStyle1");
                }
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.commentStyle1, true);
            } else if (((PythonTokenizer)this.tok).isBuiltIn(this.str)) {
                if (_parse) {
                    Cutter.setLog("PythonListener.parse() appling built-in style");
                }
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.keywordStyle2, true);
            } else if (((PythonTokenizer)this.tok).isMethod(this.str)) {
                if (_parse) {
                    Cutter.setLog("PythonListener.parse() appling method style");
                }
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.keywordStyle4, true);
            } else if (((PythonTokenizer)this.tok).isFunction(this.str)) {
                if (_parse) {
                    Cutter.setLog("PythonListener.parse() appling function style");
                }
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.keywordStyle1, true);
            } else if (this.customSyntax(this.str, begin, this.editList)) {
                if (_parse) {
                    Cutter.setLog("PythonListener.parse() appling custom style");
                }
            } else if (this.str.charAt(0) == '\"') {
                if (_parse) {
                    Cutter.setLog("PythonListener.parse() appling string style");
                }
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.stringStyle1, true);
            } else if (((PythonTokenizer)this.tok).isConstant(this.str)) {
                if (_parse) {
                    Cutter.setLog("PythonListener.parse() appling string style");
                }
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.keywordStyle5, true);
            } else {
                if (_parse) {
                    Cutter.setLog("PythonListener.parse() appling plain style");
                }
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.plainStyle, true);
            }
            this.str = this.tok.getNextStr();
        }
        if (_parseTime) {
            Cutter.setLog("Parsed " + this.editList.getSize() + " items in " + (System.currentTimeMillis() - startTime) + " milli's.");
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PythonListener.this.editList.applyEdits((DefaultStyledDocument)PythonListener.this.textpane.getDocument());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (((PythonTokenizer)this.tok).isSingleQuoted(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle1, true);
            return true;
        }
        if (this.tok.isModule(str)) {
            PythonModule pm = this.grabModule(begin, str);
            if (pm == null) {
                return false;
            }
            pm.colorize(editList);
            return true;
        }
        if (this.tableOfImports.containsKey(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }

    public PythonModule grabModule(int begin, String str) {
        char c;
        if (!this.tok.isModule(str)) {
            return null;
        }
        int offset = this.tok.getBufferIndex();
        this.pm.init();
        this.pm.begin(begin);
        if (this.tok.peekNextChar() != '.') {
            this.pm.addToken(str);
            this.pm.end(this.tok.getBufferIndex());
            return this.pm;
        }
        this.sb.setLength(0);
        this.pm.addToken(str);
        while ((c = this.tok.readChar()) != '\u0000') {
            if (c == '.') {
                this.pm.addToken(this.sb.toString());
                this.sb.setLength(0);
                continue;
            }
            if (Character.isUnicodeIdentifierPart(c)) {
                this.sb.append(c);
                continue;
            }
            this.pm.addToken(this.sb.toString());
            this.pm.end(this.tok.getBufferIndex());
            this.tok.ungetChar();
            break;
        }
        return this.pm;
    }

    public class PythonModule {
        private Vector<String> list = new Vector();
        private int begin = -1;
        private int end = -1;

        public void init() {
            this.list.clear();
            this.begin = -1;
            this.end = -1;
        }

        public void begin(int startAt) {
            this.begin = startAt;
        }

        public void end(int endAt) {
            this.end = endAt;
        }

        public void addToken(String str) {
            if (str.trim().length() == 0) {
                return;
            }
            this.list.addElement(str);
        }

        public void colorize(StyleEdits editList) {
            editList.addEdit(this.begin, this.getLength(), PythonListener.this.textpane.styleContext.plainStyle, true);
            int[] items = this.getLengths();
            if (items == null) {
                return;
            }
            int absOffset = this.begin;
            int trim = items.length >= 2 ? 1 : 0;
            for (int n = 0; n < items.length - trim; ++n) {
                editList.addEdit(absOffset, items[n], PythonListener.this.textpane.styleContext.keywordStyle3, true);
                editList.addEdit(absOffset += items[n], 1, PythonListener.this.textpane.styleContext.plainStyle, true);
                ++absOffset;
            }
        }

        private int[] getLengths() {
            if (this.list.size() == 0) {
                return null;
            }
            int count = this.list.size();
            int[] out = new int[count];
            for (int n = 0; n < count; ++n) {
                out[n] = this.list.elementAt(n).length();
            }
            return out;
        }

        private int getLength() {
            int total = 0;
            for (int n = 0; n < this.list.size(); ++n) {
                total += this.list.elementAt(n).length();
                if (n >= this.list.size() - 1) continue;
                ++total;
            }
            return total;
        }

        public String toString() {
            StringBuffer out = new StringBuffer();
            for (int n = 0; n < this.list.size(); ++n) {
                out.append(this.list.elementAt(n));
                if (n >= this.list.size() - 1) continue;
                out.append(".");
            }
            return out.toString();
        }
    }
}

