/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Python;

import Preferences.Preferences;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Python.OpenPythonAction;
import UI_Script.Python.PythonHelp;
import UI_Script.Python.PythonListener;
import UI_Script.Python.PythonTokenizer;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class PythonScriptHandler
extends ScriptHandler {
    @Override
    public boolean canRunSelection() {
        return true;
    }

    public PythonScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".py";
        this.ext[1] = ".PY";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new PythonTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.py");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Python";
    }

    @Override
    public String getExecuteLabel() {
        return "Execute " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void doPreSaveOperation(KAbstractTextWindow Ktw) {
        int selectBegin = BBxt.getSelectionStart();
        int selectEnd = BBxt.getSelectionEnd();
        KTextPane textpane = Ktw.getTextPane();
        if (textpane == null) {
            Cutter.setLog("    Error:PythonScriptHandler.doPreSaveOperation() textpane is null!");
            return;
        }
        Document doc = textpane.getDocument();
        if (doc == null) {
            Cutter.setLog("    Error:PythonScriptHandler.doPreSaveOperation() - document is null!");
            return;
        }
        String text = BBxt.getWindowText();
        String[] lines = TextUtils.tokenizeAll(text);
        boolean promptForReplacement = false;
        if (lines == null) {
            return;
        }
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n];
            if (line.length() == 0 || line.charAt(0) != ' ') continue;
            promptForReplacement = true;
        }
        if (!promptForReplacement) {
            return;
        }
        boolean doReplace = true;
        if (!doReplace) {
            return;
        }
        textpane.suspendSyntaxColoration();
        String temp = "";
        StringBuffer buf = new StringBuffer();
        String regexp = "(    )";
        try {
            for (int n = 0; n < lines.length; ++n) {
                if (lines[n].length() == 0) {
                    buf.append('\n');
                    continue;
                }
                StringBuffer linebuf = new StringBuffer();
                String line = lines[n];
                for (int j = 0; j < line.length() && line.charAt(j) == ' '; ++j) {
                    linebuf.append(line.charAt(j));
                }
                String prefix = linebuf.toString().replaceAll(regexp, "\t");
                line = TextUtils.trimLeadingChar(line, ' ');
                buf.append(prefix).append(line).append('\n');
            }
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:PythonScriptHandler.doPreSaveOperation()\n          " + ex.toString());
            textpane.resumeSyntaxColoration();
            textpane.parseAll();
            return;
        }
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, buf.toString(), null);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Exception:PythonScriptHandler.doPreSaveOperation\n          " + ex);
        }
        if (selectBegin != -1 && selectEnd != -1) {
            BBxt.setSelection(selectBegin, selectEnd);
        }
        textpane.resumeSyntaxColoration();
        textpane.parseAll();
    }

    @Override
    public void doPostSaveOperation(KAbstractTextWindow Ktw) {
        File file = Ktw.getFile();
        KTextPane pane = Ktw.getTextPane();
        if (pane == null) {
            return;
        }
        Document doc = pane.getDocument();
        if (doc == null) {
            return;
        }
        String[] paras = DocumentUtils.getParagraphs(doc, 0, 10);
        if (paras == null || paras.length == 0) {
            return;
        }
        boolean addPermissions = false;
        for (int n = 0; n < paras.length; ++n) {
            String text = paras[n].trim();
            if (text.length() <= 0 || !text.startsWith("#!") || !text.endsWith("python")) continue;
            addPermissions = true;
            break;
        }
        if (addPermissions) {
            Ktw.wasExecutibleWhenOpened = true;
        }
    }

    @Override
    public void execute(File file) {
        if (file == null || !file.exists()) {
            Cutter.setLog("    Error:PythonScriptHandler.execute(File) - input file does not exist");
            return;
        }
        if (BBxt.isPyMelDocument() && !BBxt.isMayaClient() && !BBxt.isPySide2Document()) {
            String[] msg = new String[]{"The script cannot be run because it imports one", "or more maya modules. The script must be run using", "Maya's Script Editor."};
            DialogUtils.showInfoMessage("Cannot Run Script", msg);
            return;
        }
        if (!BBxt.isPySide2Document() && (BBxt.isPyMelDocument() || BBxt.isMayaClient())) {
            String module = TextUtils.removeExtension(file.getName());
            String cmd = "python(\"import " + module + "\"); python(\"reload(" + module + ")\");";
            Cutter.setLog("    Info:PythonScriptHandler.execute(file) cmd >" + cmd + "<");
            KAbstractWindow front = BBxt.frontWindow();
            if (front != null && front instanceof KTextWindow) {
                front.sendPythonToMayaClient(cmd);
                return;
            }
        }
        String cmd = Preferences.get(Preferences.PYTHON_COMMAND);
        Cutter.setLog("    Info: PythonScriptHandler.execute() using cmd >" + cmd + "<");
        if (cmd.trim().length() == 0) {
            cmd = "python";
        }
        String[] items = new String[]{cmd, file.getPath()};
        ProcessManager fp = new ProcessManager("Python");
        fp.launch(items, file.getParentFile(), false, null, false);
    }

    @Override
    public void executeFromHistory(KTextHistoryWindow window) {
        String str = window.getAllText();
        if (str == null || str.trim().length() == 0) {
            Cutter.setLog("    Info:SlimScriptHandler.executeFromHistory() - no text in history, cannot execute.");
        }
        this.execute(str);
    }

    @Override
    public void execute(String str) {
        KAbstractWindow front = BBxt.frontWindow();
        if (front == null || !(front instanceof KTextWindow)) {
            return;
        }
        File f = BBxt.getWindowFile();
        if (f == null) {
            return;
        }
        this.execute(f);
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(PythonHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return PythonListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Python");
        item.addActionListener(new OpenPythonAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("py", "Python Script");
        return filter;
    }
}

