/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Python;

import UI_Desktop.Cutter;
import UI_Script.Python.PYTHONFunctionsRsrc1;
import UI_Script.Python.PYTHONFunctionsRsrc2;
import UI_Script.ScriptParser.ProcDBItem;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class PythonTokenizer
extends Tokenizer {
    static Hashtable<String, String> pythonOrgModulLUT = new Hashtable();
    static Hashtable<String, String> pythonOrgModul3LUT = new Hashtable();
    static Hashtable<String, String> pythonOrgModul2LUT = new Hashtable();
    static Hashtable<String, String> pythonOrgModul1LUT = new Hashtable();
    public static Hashtable<String, String> pythonBuiltinFunctionsLUT = new Hashtable();
    public static Hashtable<String, String> pythonStringMethodsLUT = new Hashtable();
    static String[] pythonOrgModule3Names = new String[]{"xml.sax.handler", "xml.dom.minidom", "xml.sax.saxutils", "xml.parsers.expat", "xml.etree.ElementTree", "xml.dom.pulldom", "email.mime.text", "xml.sax.xmlreader"};
    static String[] pythonOrgModule2Names = new String[]{"email.parser", "email.message", "email.encoders", "email.errors", "email.header", "email.generator", "email.utils", "email.charset", "wsgiref.handlers", "email.iterators", "compiler.ast", "compiler.visitor", "curses.wrapper", "curses.panel", "curses.textpad", "curses.ascii", "xml.dom", "xml.sax", "wsgiref.simpleserver", "wsgiref.validate", "wsgiref.headers", "wsgiref.util", "test.testsupport", "encodings.idna", "hotshot.stats", "os.path", "encodings.utf-8-sig"};
    static String[] pythonOrgModule1Name = new String[]{"pyclbr", "poplib", "colorsys", "exceptions", "imghdr", "bz2", "subprocess", "rexec", "dummythread", "dis", "gettext", "sha", "httplib", "threading", "UserString", "robotparser", "dl", "dbm", "site", "cookielib", "time", "base64", "fpformat", "al", "msvcrt", "htmllib", "tokenize", "imaplib", "gc", "codecs", "timeit", "asynchat", "wsgiref", "pty", "string", "runpy", "aifc", "profile", "mailcap", "types", "os", "UserDict", "fpectl", "urllib2", "curses", "repr", "mimetools", "mhlib", "cmd", "datetime", "urlparse", "SocketServer", "optparse", "pipes", "unicodedata", "marshal", "sgmllib", "CGIHTTPServer", "doctest", "test", "spwd", "tabnanny", "sunaudiodev-constants", "trace", "statvfs", "SimpleXMLRPCServer", "filecmp", "winsound", "platform", "weakref", "popen2", "pydoc", "fl-constants", "array", "cgi", "compiler", "nis", "netrc", "dumbdbm", "contextlib", "bsddb", "email", "sqlite3", "main", "locale", "inspect", "imageop", "itertools", "webbrowser", "Tkinter", "shelve", "cStringIO", "pprint", "dircache", "gl-constants", "readline", "tty", "rfc822", "difflib", "mutex", "msilib", "zipimport", "ftplib", "crypt", "glob", "hotshot", "re", "imgfile", "nntplib", "wave", "sets", "future", "collections", "select", "random", "xdrlib", "struct", "mimetypes", "traceback", "DEVICE", "textwrap", "pwd", "unittest", "BaseHTTPServer", "xmlrpclib", "calendar", "thread", "shutil", "SimpleHTTPServer", "functools", "htmlentitydefs", "zlib", "decimal", "gopherlib", "ossaudiodev", "cmath", "operator", "Cookie", "smtplib", "fl", "quopri", "stringprep", "fm", "Queue", "cPickle", "mimify", "StringIO", "distutils", "stat", "hmac", "commands", "gdbm", "hashlib", "fileinput", "csv", "code", "linecache", "token", "sched", "fnmatch", "cgitb", "turtle", "flp", "multifile", "termios", "ScrolledText", "dbhash", "al-constants", "zipfile", "pickletools", "pickle", "bisect", "getopt", "chunk", "binhex", "Tix", "builtin", "keyword", "sys", "sndhdr", "sunaudiodev", "tempfile", "binascii", "user", "formatter", "pkgutil", "heapq", "errno", "warnings", "HTMLParser", "ConfigParser", "Bastion", "pdb", "ctypes", "copyreg", "UserList", "copy", "logging", "mailbox", "grp", "dummythreading", "md5", "urllib", "parser", "sunau", "mmap", "math", "codeop", "audioop", "tarfile", "signal", "MimeWriter", "getpass", "atexit", "whichdb", "resource", "anydbm", "smtpd", "rlcompleter", "rgbimg", "gzip", "-winreg", "uu", "syslog", "imp", "cd", "socket", "uuid", "asyncore", "DocXMLRPCServer", "telnetlib", "posix", "symbol", "jpeg", "shlex", "gl", "fcntl", "compileall", "pycompile", "posixfile", "new", "modulefinder"};
    static String[] pythonBuiltinFunctions = new String[]{"round", "hasattr", "id", "raw_input", "oct", "delattr", "compile", "locals", "pow", "eval", "max", "tuple", "list", "zip", "chr", "divmod", "super", "dict", "isinstance", "frozenset", "__import__", "cmp", "slice", "execfile", "classmethod", "int", "unicode", "setattr", "basestring", "range", "reload", "float", "str", "globals", "reversed", "any", "filter", "getattr", "enumerate", "issubclass", "bool", "reduce", "input", "long", "set", "sorted", "dir", "min", "unichr", "file", "ord", "len", "vars", "hex", "xrange", "staticmethod", "help", "abs", "property", "map", "iter", "object", "type", "callable", "open", "all", "repr", "sum", "hash", "complex", "print"};
    static String[] pythonStringMethods = new String[]{"endswith", "capitalize", "isalpha", "isupper", "ljust", "join", "rfind", "rjust", "strip", "encode", "lstrip", "rstrip", "startswith", "rpartition", "center", "expandtabs", "upper", "isspace", "swapcase", "isdigit", "partition", "find", "istitle", "split", "islower", "decode", "replace", "rsplit", "translate", "count", "title", "index", "isalnum", "splitlines", "lower", "rindex"};
    public static final String SPECIAL_VARIABLE = "special_variable";
    public static final String METHOD = "method";
    public static final String MODULE = "module";
    public static final String BUILT_IN = "built_in";
    public static final String CONSTANT = "constant";
    public static final String LANGUAGE = "language";
    private static ResourceBundle PYTHONFunctionsRes1;
    private static ResourceBundle PYTHONFunctionsRes2;
    public static Hashtable<String, String> language;
    public static boolean _debug_;
    private StringBuffer sb = new StringBuffer();
    boolean singleQuoteLiteral = true;
    boolean doubleQuoteLiteral = true;
    boolean blockQuoteLiteral = true;

    private static int numLanguageItems1() {
        int num = 0;
        try {
            num = ((PYTHONFunctionsRsrc1)PYTHONFunctionsRes1).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read PYTHONFunctionsRsrc1");
        }
        return num;
    }

    private static int numLanguageItems2() {
        int num = 0;
        try {
            num = ((PYTHONFunctionsRsrc2)PYTHONFunctionsRes2).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read PYTHONFunctionsRsrc2");
        }
        return num;
    }

    private static void initHashTable() {
        int i;
        for (i = 0; i < PythonTokenizer.numLanguageItems1(); ++i) {
            language.put(((PYTHONFunctionsRsrc1)PYTHONFunctionsRes1).getKey(i), ((PYTHONFunctionsRsrc1)PYTHONFunctionsRes1).getContent(i));
        }
        for (i = 0; i < PythonTokenizer.numLanguageItems2(); ++i) {
            language.put(((PYTHONFunctionsRsrc2)PYTHONFunctionsRes2).getKey(i), ((PYTHONFunctionsRsrc2)PYTHONFunctionsRes2).getContent(i));
        }
        for (i = 0; i < pythonOrgModule3Names.length; ++i) {
            language.put(pythonOrgModule3Names[i], MODULE);
            pythonOrgModulLUT.put(pythonOrgModule3Names[i], pythonOrgModule3Names[i]);
            pythonOrgModul3LUT.put(pythonOrgModule3Names[i], pythonOrgModule3Names[i]);
        }
        for (i = 0; i < pythonOrgModule2Names.length; ++i) {
            language.put(pythonOrgModule2Names[i], MODULE);
            pythonOrgModulLUT.put(pythonOrgModule2Names[i], pythonOrgModule2Names[i]);
            pythonOrgModul2LUT.put(pythonOrgModule2Names[i], pythonOrgModule2Names[i]);
        }
        for (i = 0; i < pythonOrgModule1Name.length; ++i) {
            language.put(pythonOrgModule1Name[i], MODULE);
            pythonOrgModulLUT.put(pythonOrgModule1Name[i], pythonOrgModule1Name[i]);
            pythonOrgModul1LUT.put(pythonOrgModule1Name[i], pythonOrgModule1Name[i]);
        }
        for (i = 0; i < pythonBuiltinFunctions.length; ++i) {
            pythonBuiltinFunctionsLUT.put(pythonBuiltinFunctions[i], pythonBuiltinFunctions[i]);
        }
        for (i = 0; i < pythonStringMethods.length; ++i) {
            pythonStringMethodsLUT.put(pythonStringMethods[i], pythonStringMethods[i]);
        }
    }

    public PythonTokenizer() {
        this.getComments = true;
        this.addComment("#", "\n");
        this.addQuotation("'", "'", '\\');
        this.addQuotation("\"", "\"", '\\');
        this.addQuotation("\"\"\"", "\"\"\"", '\\');
        this.setSyntaxLength(3);
        this.addEscape("\\\"", "");
        this.addEscape("\\\\", "");
        this.addEscape("\\'", "");
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        String[] ext = new String[]{"py", "PY"};
        Tokenizer.addToRegistry(PythonTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public String[] getImportKeywords() {
        return new String[]{"import", "from"};
    }

    @Override
    public String[] getSysImportBeginEnd() {
        return new String[]{"", ""};
    }

    @Override
    public String[] getUsrImportBeginEnd() {
        return new String[]{"", ""};
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        ProcDBItem out = new ProcDBItem();
        int index = this.getBufferIndex();
        if (this.isComment(str)) {
            this.setBufferIndex(index);
            return null;
        }
        if (!str.equals("def")) {
            this.setBufferIndex(index);
            return null;
        }
        str = this.getNextStr();
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        out.procName = str;
        out.procNameOffset = new int[2];
        out.procNameOffset[1] = this.getBufferIndex();
        out.procNameOffset[0] = out.procNameOffset[1] - str.length();
        String ptext = this.lpGrabProcParams("(", ")");
        if (ptext == null) {
            this.setBufferIndex(index);
            return null;
        }
        int[] offset = this.stringSearch("def", false);
        if (offset == null) {
            offset = new int[2];
            offset[1] = this.getBufferLength() - 1;
        }
        StringBuffer en = new StringBuffer();
        this.lpGetEnclosingNameAtIndex(en, out.procNameOffset[0]);
        String enclosingName = en.toString();
        if (!enclosingName.equals("")) {
            out.procName = enclosingName + "." + out.procName;
        }
        out.procOffset[0] = out.procNameOffset[0];
        out.procOffset[1] = offset[1];
        return out;
    }

    @Override
    protected void lpGetClassInterfaceSpan(String str) {
        if (this.isComment(str)) {
            return;
        }
        if (!str.equals("class")) {
            return;
        }
        int index = this.getBufferIndex();
        String classname = this.getNextStr();
        if (classname.equals("")) {
            return;
        }
        int[] classOffset = this.stringSearch("class", false);
        Tokenizer.ClassInterfaceSpan out = new Tokenizer.ClassInterfaceSpan(this);
        out.name = classname;
        out.span[0] = index;
        out.span[1] = classOffset != null ? classOffset[0] : this.getBufferLength();
        this.listOfClassInterfaceSpans.addElement(out);
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals(LANGUAGE);
        }
        return false;
    }

    @Override
    public boolean isComment(String str) {
        return str.charAt(0) == '#';
    }

    public boolean isBuiltIn(String str) {
        return pythonBuiltinFunctionsLUT.containsKey(str);
    }

    @Override
    public boolean isModule(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals(MODULE);
        }
        return false;
    }

    public int isModule(Tokenizer tok, String str1) {
        int offset = this.getBufferIndex();
        if (tok.peekNextChar() != '.') {
            if (language.containsKey(str1) && language.get(str1).equals(MODULE)) {
                return str1.length();
            }
            return -1;
        }
        this.sb.setLength(0);
        tok.getNextStr();
        String str2 = tok.getNextStr();
        if (str2.equals("")) {
            this.setBufferIndex(offset);
            return -1;
        }
        if (tok.peekNextChar() != '.') {
            this.sb.append(str1).append(".").append(str2);
            if (pythonOrgModul2LUT.get(this.sb.toString()) != null) {
                return this.sb.toString().length();
            }
            if (language.containsKey(str1) && language.get(str1).equals(MODULE)) {
                return str1.length();
            }
        }
        this.sb.setLength(0);
        tok.getNextStr();
        String str3 = tok.getNextStr();
        if (str3.equals("")) {
            this.setBufferIndex(offset);
            return -1;
        }
        this.sb.append(str1).append(".").append(str2).append(".").append(str3);
        if (pythonOrgModul3LUT.get(this.sb.toString()) != null) {
            return this.sb.toString().length();
        }
        this.sb.setLength(0);
        this.sb.append(str1).append(".").append(str2);
        if (pythonOrgModul2LUT.get(this.sb.toString()) != null) {
            return this.sb.toString().length();
        }
        if (language.containsKey(str1) && language.get(str1).equals(MODULE)) {
            return str1.length();
        }
        return -1;
    }

    public boolean isMethod(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals(METHOD);
        }
        return false;
    }

    @Override
    public boolean isFunction(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("function");
        }
        return false;
    }

    public boolean isConstant(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals(CONSTANT);
        }
        return false;
    }

    public boolean isSingleQuoted(String str) {
        return str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'';
    }

    public String __getNextStr() {
        char nextChar;
        char c;
        boolean endOfString = false;
        boolean endOfComment = false;
        boolean method = false;
        this.singleQuoteLiteral = false;
        this.doubleQuoteLiteral = false;
        this.blockQuoteLiteral = false;
        if (this.debug) {
            Cutter.setLog("Entered GetNextStr");
        }
        if ((c = this.readChar()) == '\u0000') {
            if (_debug_) {
                Cutter.setLog("GetNextStr, first readChar() ERROR, char = >" + c + "< index = " + this.getBufferIndex());
            }
            return "";
        }
        this.outBuff.setLength(0);
        if (_debug_) {
            Cutter.setLog("\nGetNextStr, read first char =  >" + c + "<");
        }
        if (this.isSpace(c)) {
            c = this.removeSpace();
        }
        if (c == '\u0000') {
            return "";
        }
        if (_debug_) {
            Cutter.setLog("GetNextStr, appending =  >" + c + "<");
        }
        this.outBuff.append(c);
        if (c == ';') {
            return this.outBuff.toString();
        }
        if (c == '#' && this.peekNextChar() != '\n' && this.getComments) {
            if (_debug_) {
                Cutter.setLog("GetNextStr, found #");
            }
            if ((c = this.readChar()) == '\u0000' || c == '\r' || c == '\n') {
                return this.outBuff.toString();
            }
            do {
                if (_debug_) {
                    Cutter.setLog("GetNextStr, in comment loop");
                }
                this.outBuff.append(c);
                c = this.readChar();
                if (c != '\u0000') continue;
                return this.outBuff.toString();
            } while (c != '\r' && c != '\n');
            this.ungetChar();
            return this.outBuff.toString();
        }
        if (c == '.' && (nextChar = this.peekNextChar()) != '\u0000' && !Character.isDigit(nextChar) && !this.isDelimitor(nextChar)) {
            method = true;
        }
        if (!method && this.isDelimitor(c)) {
            if (_debug_) {
                Cutter.setLog("GetNextStr, " + c + " is punctuation. Returning >" + this.outBuff.toString() + "<");
            }
            return this.outBuff.toString();
        }
        if (c == '\'') {
            if (_debug_) {
                Cutter.setLog("found kQuote singleQuoteLiteral = true");
            }
            this.singleQuoteLiteral = true;
            this.outBuff.append(c);
        } else if (c == '\"') {
            this.singleQuoteLiteral = false;
            if (_debug_) {
                Cutter.setLog("possible blockQuoteLiteral peeking next two chars");
            }
            char[] next2 = this.peekNextChars(2);
            if (_debug_) {
                if (next2 == null) {
                    Cutter.setLog("peek(2) return null");
                } else {
                    Cutter.setLog("peek(2) >" + next2[0] + "< >" + next2[1] + "<");
                }
            }
            if (next2 != null && next2[0] == '\"' && next2[1] == '\"') {
                this.outBuff.append(c).append(this.readChar()).append(this.readChar());
                this.blockQuoteLiteral = true;
                if (_debug_) {
                    Cutter.setLog("possible blockQuoteLiteral = " + this.blockQuoteLiteral);
                }
            } else {
                this.outBuff.append(c);
                this.doubleQuoteLiteral = true;
                if (_debug_) {
                    Cutter.setLog("possible doubleQuoteLiteral = " + this.doubleQuoteLiteral);
                }
            }
        }
        if (_debug_) {
            Cutter.setLog("GetNextStr, before main loop |" + c + "|");
        }
        if (_debug_) {
            Cutter.setLog("GetNextStr, before main loop   singleQuoteLiteral = " + this.singleQuoteLiteral + "  doubleQuoteLiteral = " + this.doubleQuoteLiteral + "  blockQuoteLiteral = " + this.blockQuoteLiteral);
        }
        while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            switch (c) {
                case '\u0000': {
                    if (_debug_) {
                        Cutter.setLog("case 0 returning >" + this.outBuff.toString() + "<");
                    }
                    return this.outBuff.toString();
                }
                case '\\': {
                    if (this.singleQuoteLiteral || this.doubleQuoteLiteral || this.blockQuoteLiteral) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\'': {
                    if (this.doubleQuoteLiteral || this.blockQuoteLiteral) break;
                    if (this.singleQuoteLiteral) {
                        this.outBuff.append(c);
                        if (_debug_) {
                            Cutter.setLog("singleQuoteLiteral returning |" + this.outBuff.toString() + "|");
                        }
                        return this.outBuff.toString();
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\"': {
                    if (this.blockQuoteLiteral) {
                        char[] next2 = this.peekNextChars(2);
                        if (next2 == null || next2[0] != '\"' || next2[1] != '\"') break;
                        this.outBuff.append(c).append(this.readChar()).append(this.readChar());
                        if (_debug_) {
                            Cutter.setLog("blockQuoteLiteral returning |" + this.outBuff.toString() + "|");
                        }
                        return this.outBuff.toString();
                    }
                    if (this.singleQuoteLiteral) break;
                    if (this.doubleQuoteLiteral) {
                        this.outBuff.append(c);
                        if (_debug_) {
                            Cutter.setLog("doubleQuoteLiteral returning |" + this.outBuff.toString() + "|");
                        }
                        return this.outBuff.toString();
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\t': 
                case ' ': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '}': {
                    if (this.singleQuoteLiteral || this.doubleQuoteLiteral || this.blockQuoteLiteral) break;
                    if (_debug_) {
                        Cutter.setLog("ungetting  c >" + c + "< returning |" + this.outBuff.toString() + "|");
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\n': 
                case '/': {
                    if (this.singleQuoteLiteral || this.doubleQuoteLiteral || this.blockQuoteLiteral) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
            }
            if (_debug_) {
                Cutter.setLog("append  c >" + c + "< to outBuff");
            }
            this.outBuff.append(c);
        }
        if (_debug_) {
            Cutter.setLog("getNextStr() is returning:" + this.outBuff.toString());
        }
        return this.outBuff.toString();
    }

    public boolean __isDelimitor(char c) {
        switch (c) {
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEscaped(char c0, char c1) {
        if (c0 != '\\') {
            return false;
        }
        switch (c1) {
            case '\t': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\\': {
                return true;
            }
            case '\'': {
                return true;
            }
        }
        return false;
    }

    public int _isOpenString(Segment segment, int from) {
        char ahead2;
        if (from < 0 || from >= segment.count) {
            return -1;
        }
        int abs = from + segment.offset;
        char c0 = segment.array[abs];
        char back2 = from - 2 < 0 ? (char)'\u0000' : segment.array[abs - 2];
        char back1 = from - 1 < 0 ? (char)'\u0000' : segment.array[abs - 1];
        char ahead1 = from + 1 >= segment.count ? (char)'\u0000' : segment.array[abs + 1];
        char c = ahead2 = from + 2 >= segment.count ? (char)'\u0000' : segment.array[abs + 2];
        if (back2 == '\"' && back1 == '\"' && c0 == '\"') {
            return from - 2;
        }
        if (back1 == '\"' && c0 == '\"' && ahead1 == '\"') {
            return from - 1;
        }
        if (c0 == '\"' && ahead1 == '\"' && ahead2 == '\"') {
            return from;
        }
        if (c0 == '\'' || c0 == '\"') {
            return from;
        }
        return -1;
    }

    static {
        language = new Hashtable();
        try {
            PYTHONFunctionsRes1 = ResourceBundle.getBundle("UI_Script.Python.PYTHONFunctionsRsrc1");
            PYTHONFunctionsRes2 = ResourceBundle.getBundle("UI_Script.Python.PYTHONFunctionsRsrc2");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: PYTHONFunctionsRsrc = " + mre);
        }
        PythonTokenizer.initHashTable();
        _debug_ = false;
        try {
            Field[] fields = new Field[]{PythonTokenizer.class.getDeclaredField("_debug_")};
            Cutter.addDebug(PythonTokenizer.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: PythonTokenizer.static - " + ex.toString());
        }
    }
}

