/*
 * Decompiled with CFR 0.152.
 */
package UI_Script;

import UI_Desktop.Cutter;
import Utilities.SegmentUtils;
import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.swing.text.Segment;

public class Quotation {
    public static boolean _isOpenQuotation = false;
    public static boolean _isCloseQuotation = false;
    public static boolean debug = false;
    public String openStr = null;
    public char[] openQuote = null;
    public int openLen = 0;
    public String closeStr = null;
    public char[] closeQuote = null;
    public int closeLen = 0;
    private char[] escChars = null;
    private static Hashtable<Quotation, Quotation> table;
    public final int LOOK_FORWARD = 0;
    public final int LOOK_BACK = 1;

    public Quotation(String open, String close, char[] esc_chars) {
        int n;
        this.openStr = open;
        int n2 = this.openLen = open == null ? 0 : open.length();
        if (open != null) {
            this.openQuote = new char[this.openLen];
            for (n = 0; n < this.openLen; ++n) {
                this.openQuote[n] = this.openStr.charAt(n);
            }
        }
        this.closeStr = close;
        int n3 = this.closeLen = close == null ? 0 : close.length();
        if (close != null) {
            this.closeQuote = new char[this.closeLen];
            for (n = 0; n < this.closeLen; ++n) {
                this.closeQuote[n] = this.closeStr.charAt(n);
            }
        }
        if (esc_chars != null) {
            this.escChars = esc_chars;
        }
        table.put(this, this);
    }

    public String toString() {
        String esc = this.escChars == null ? "NONE" : new String(this.escChars);
        return this.getName() + " [ " + (this.openStr == null ? "NULL" : this.openStr) + " ], [ " + (this.closeStr == null ? "NULL" : this.closeStr) + ", Escapes >" + esc + "]";
    }

    public String getName() {
        if (this.openStr.equals("\"")) {
            return "Standard quotation";
        }
        if (this.openStr.equals("'")) {
            return "Single quotation";
        }
        if (this.openStr.equals("\"\"\"")) {
            return "Triple quotations";
        }
        return "Unknown quotation[" + (this.openStr == null ? "NULL" : this.openStr) + "]";
    }

    public char[] getEscapeChars() {
        return this.escChars;
    }

    public boolean isEscapeChar(char c) {
        if (this.escChars == null) {
            return false;
        }
        return new String(this.escChars).indexOf(c) != -1;
    }

    public boolean isOpenQuotation(char c) {
        if (this.openStr == null) {
            return false;
        }
        return this.openStr.length() == 1 && this.openStr.charAt(0) == c;
    }

    public boolean isCloseQuotation(char c) {
        if (this.closeStr == null) {
            return false;
        }
        return this.closeStr.length() == 1 && this.closeStr.charAt(0) == c;
    }

    private boolean isXXXXQuotation(Segment segment, int at, String xxxxStr) {
        if (xxxxStr == null) {
            return false;
        }
        String segStr = null;
        if (this.escChars == null || this.escChars.length == 0) {
            segStr = SegmentUtils.toString(segment, at, xxxxStr.length());
            if (segStr == null) {
                return false;
            }
            return segStr.startsWith(xxxxStr);
        }
        if (this.escChars != null && this.escChars.length > 0) {
            segStr = SegmentUtils.toString(segment, at, xxxxStr.length() + 1);
            if (segStr == null) {
                return false;
            }
            if (segStr.startsWith(this.openStr)) {
                return true;
            }
            for (int n = 0; n < this.escChars.length; ++n) {
                if (!segStr.startsWith(this.escChars[n] + xxxxStr)) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isOpenQuotation(Segment segment, int at) {
        return this.isXXXXQuotation(segment, at, this.openStr);
    }

    public boolean isCloseQuotation(Segment segment, int at) {
        return this.isCloseQuotation(segment, at, 0);
    }

    private boolean isCloseQuotation(Segment segment, int at, int direction) {
        if (direction == 0) {
            return this.isXXXXQuotation(segment, at, this.closeStr);
        }
        return this._isCloseQuotation(segment, at);
    }

    public boolean _isCloseQuotation(Segment segment, int at) {
        if (this.closeStr == null) {
            return false;
        }
        String segStr = null;
        segStr = SegmentUtils.toString(segment, at - this.closeLen, this.closeLen);
        if (segStr == null) {
            return false;
        }
        if (!segStr.startsWith(this.closeStr)) {
            return false;
        }
        segStr = SegmentUtils.toString(segment, at - (this.closeLen + 1), 1);
        if (segStr == null || segStr.length() != 1) {
            return true;
        }
        if (this.escChars != null && this.escChars.length > 0) {
            for (int n = 0; n < this.escChars.length; ++n) {
                int num;
                if (segStr.charAt(0) != this.escChars[n] || (num = SegmentUtils.numEscapesBackFrom(segment, at - (this.closeLen + 1))) % 2 == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOpenQuotation(char[] chars) {
        return this.isOpenQuotation(new String(chars));
    }

    public boolean isCloseQuotation(char[] chars) {
        return this.isCloseQuotation(new String(chars));
    }

    public boolean isOpenQuotation(String str) {
        if (str == null) {
            return false;
        }
        if (this.openStr == null) {
            return false;
        }
        str = str.trim();
        if (this.escChars != null && this.escChars.length > 0 && str.length() >= this.openStr.length() + 1) {
            for (int i = 0; i < this.escChars.length; ++i) {
                String tmp = this.escChars[i] + this.openStr;
                if (!str.startsWith(tmp)) continue;
                return false;
            }
        }
        return str.length() >= this.openStr.length() && str.startsWith(this.openStr);
    }

    public boolean isCloseQuotation(String str) {
        if (str == null) {
            return false;
        }
        if (this.closeStr == null) {
            return false;
        }
        str = str.trim();
        if (this.escChars != null && this.escChars.length > 0 && str.length() >= this.closeStr.length() + 1) {
            for (int i = 0; i < this.escChars.length; ++i) {
                String tmp = this.escChars[i] + this.closeStr;
                if (!str.startsWith(tmp)) continue;
                return false;
            }
        }
        return str.length() >= this.closeStr.length() && str.startsWith(this.closeStr);
    }

    public int findOpenQuotation(String str) {
        if (this.openStr == null || str.length() < this.openLen) {
            return -1;
        }
        int offset = str.indexOf(this.openStr.charAt(0), 0);
        if (offset != -1 && offset + this.openLen < str.length()) {
            if (this.escChars != null && this.escChars.length > 0) {
                str = str.substring(offset, offset + this.openLen);
            }
            if (str.equals(this.openStr)) {
                return offset;
            }
        }
        return -1;
    }

    public int findOpenQuotation(Segment segment, int from) {
        if (this.openStr == null) {
            return -1;
        }
        int foundAt = -1;
        boolean match = false;
        for (int n = from; n < segment.count - this.openLen; ++n) {
            if (segment.array[n + segment.offset] != this.openQuote[0]) continue;
            foundAt = n;
            match = true;
            for (int j = 0; j < this.openLen; ++j) {
                if (segment.array[n + j + segment.offset] == this.openQuote[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return foundAt + this.openLen;
        }
        return -1;
    }

    public boolean balancedQuotations(Segment segment, int from) {
        int n;
        if (this.openStr == null) {
            return false;
        }
        if (from + this.openLen > segment.count || from + this.closeLen > segment.count) {
            return false;
        }
        int count = 0;
        for (n = from; n < segment.count - this.openLen; ++n) {
            if (!this.isOpenQuotation(segment, n)) continue;
            ++count;
        }
        if (count % 2 == 1) {
            return false;
        }
        count = 0;
        for (n = from; n < segment.count - this.openLen; ++n) {
            if (!this.isCloseQuotation(segment, n)) continue;
            ++count;
        }
        return count % 2 != 1;
    }

    public boolean balancedQuotations(String str) {
        if (this.openStr == null) {
            return false;
        }
        int count = 0;
        int offset = str.indexOf(this.openStr.charAt(0), 0);
        while (offset != -1 && offset + this.openLen < str.length()) {
            if (!(str = str.substring(offset, offset + this.openLen)).equals(this.openStr)) continue;
            ++count;
        }
        if (count % 2 == 1) {
            return false;
        }
        offset = str.indexOf(this.closeStr.charAt(0), 0);
        while (offset != -1 && offset + this.closeLen < str.length()) {
            if (!(str = str.substring(offset, offset + this.closeLen)).equals(this.closeStr)) continue;
            ++count;
        }
        return count % 2 != 1;
    }

    public int findCloseQuotation(Segment segment, int from) {
        if (from + this.closeLen > segment.count) {
            return -1;
        }
        int foundAt = -1;
        boolean match = false;
        char prevChar = '\u0000';
        if (debug) {
            Cutter.setLog(this.getName() + " _________________ ");
        }
        for (int n = from; n < segment.count - this.closeLen; ++n) {
            char c0 = segment.array[n + segment.offset];
            if (debug) {
                Cutter.setLog("comparing c0 >" + c0 + "< to >" + this.closeQuote[0] + "<");
            }
            if (c0 == this.closeQuote[0] && prevChar != '\\') {
                foundAt = n;
                match = true;
                for (int j = 0; j < this.closeLen; ++j) {
                    if (debug) {
                        Cutter.setLog("    comparing >" + segment.array[n + j + segment.offset] + "< to >" + this.closeQuote[j] + "<");
                    }
                    if (segment.array[n + j + segment.offset] == this.closeQuote[j]) continue;
                    match = false;
                    break;
                }
                if (match) {
                    if (debug) {
                        Cutter.setLog("match at " + (foundAt + this.closeLen));
                    }
                    return foundAt + this.closeLen;
                }
            }
            prevChar = c0;
        }
        if (debug) {
            Cutter.setLog("no match from " + from);
        }
        return -1;
    }

    public boolean isPartialOpenQuotation(String str) {
        for (int n = 0; n < str.length(); ++n) {
            for (int i = 0; i < this.openStr.length(); ++i) {
                if (str.charAt(n) != this.openStr.charAt(i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAnyQuotation(String str) {
        if (this.containsOpenQuotation(str)) {
            return true;
        }
        return this.containsClosingQuotation(str);
    }

    public boolean containsOpenQuotation(String str) {
        if (str.length() < this.openLen) {
            return false;
        }
        int offset = str.indexOf(this.openQuote[0], 0);
        return offset != -1 && offset + this.openLen <= str.length() && (str = str.substring(offset, offset + this.openLen)).equals(this.openStr);
    }

    public boolean containsClosingQuotation(String str) {
        if (str.length() < this.closeLen) {
            return false;
        }
        int offsetQuote = str.indexOf(this.closeQuote[0], 0);
        int offsetBSlash = str.indexOf(92, 0);
        if (offsetBSlash != -1 && offsetBSlash != -1 && offsetBSlash == offsetQuote - 1) {
            return false;
        }
        return offsetQuote != -1 && offsetQuote + this.closeLen <= str.length() && (str = str.substring(offsetQuote, offsetQuote + this.closeLen)).equals(this.closeStr);
    }

    public boolean containsEscapedQuotation(String str) {
        if (this.escChars == null || this.escChars.length == 0) {
            return false;
        }
        for (int n = 0; n < this.escChars.length; ++n) {
            String esc = this.escChars[n] + this.openStr;
            if (!str.matches("(" + esc + ")+")) continue;
            return true;
        }
        return false;
    }

    public boolean endsWithEscape(String str) {
        if (this.escChars == null || this.escChars.length == 0) {
            return false;
        }
        for (int n = 0; n < this.escChars.length; ++n) {
            String esc = "" + this.escChars[n];
            if (!str.endsWith(esc)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            Field[] fields = new Field[]{Quotation.class.getDeclaredField("debug"), Quotation.class.getDeclaredField("_isOpenQuotation"), Quotation.class.getDeclaredField("_isCloseQuotation")};
            Cutter.addDebug(Quotation.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: Quotation.static - " + ex.toString());
        }
        table = new Hashtable();
    }
}

