/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.Animation;

import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Rib.Animation.Statement;
import UI_Script.Rib.Animation.Tween;
import UI_Tools.Rman.RenderInfo;
import Utilities.FileUtils;
import Utilities.GraphicsFileUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;
import kernal.Tokenizers.Tokenizer;

public class KeyFrame {
    public static Vector<KeyFrame> listOfKeyFrames = new Vector();
    public static String imageName;
    public static boolean singleFrameMode;
    public static String fileTypeTiff;
    public static boolean usesITDisplayDriver;
    public static String DISPLAY_PRIMARY;
    public static String DISPLAY_SECONDARY;
    public Vector<Statement> listOfStatements = new Vector();
    public int id;

    public static int size() {
        return listOfKeyFrames.size();
    }

    public static void init() {
        for (int n = 0; n < listOfKeyFrames.size(); ++n) {
            listOfKeyFrames.elementAt(n).removeStatements();
        }
        listOfKeyFrames.removeAllElements();
        Statement.init();
    }

    public static String debugKeyframes() {
        String output = "Getting All Frames\n";
        for (int n = 0; n < listOfKeyFrames.size(); ++n) {
            output = output + "#KeyFrame " + n + "\n";
            output = output + listOfKeyFrames.elementAt(n).getText();
            output = output + "\n";
        }
        return output;
    }

    public String toString() {
        return "number of statements = " + this.listOfStatements.size();
    }

    public KeyFrame(int id) {
        this.id = id;
        listOfKeyFrames.addElement(this);
    }

    public void addStatement(Statement statement) {
        this.listOfStatements.addElement(statement);
    }

    public void removeStatements() {
        for (int n = 0; n < this.listOfStatements.size(); ++n) {
            this.listOfStatements.elementAt(n).removeParameters();
        }
    }

    public String getText() {
        String output = "";
        for (int n = 0; n < this.listOfStatements.size(); ++n) {
            output = output + this.listOfStatements.elementAt(n).toString();
            output = output + "\n";
        }
        return output + "\n";
    }

    private static Statement getPrimaryDisplayStatement() {
        KeyFrame header = listOfKeyFrames.elementAt(0);
        if (header == null) {
            Cutter.setLog("    Error:KeyFrame.getPrimaryDisplayStatement() - listOfKeyFrames does not have any items!");
            return null;
        }
        for (int h = 0; h < header.listOfStatements.size(); ++h) {
            Statement statement = header.listOfStatements.elementAt(h);
            if (!statement.name.equals("Display") || statement.isaSecondaryDisplay) continue;
            return statement;
        }
        Cutter.setLog("    Error:KeyFrame.getPrimaryDisplayStatement() - cannot find the primary Display statement");
        return null;
    }

    public static String[] getImageName() {
        return KeyFrame.getImageName(KeyFrame.getPrimaryDisplayStatement());
    }

    public static String[] getImageName(Statement statement) {
        if (statement == null) {
            Cutter.setLog("    Error:KeyFrame.getImageName() - input was null!");
            return null;
        }
        if (!statement.name.equals("Display")) {
            Cutter.setLog("    Warning:KeyFrame.getImageName() - cannot get image name from \"" + statement.name + "\"");
            return null;
        }
        Object param = statement.listOfParams.elementAt(0);
        if (param == null) {
            Cutter.setLog("    Warning:KeyFrame.getImageName() - expected to read the first parameter but got null instead!");
            return null;
        }
        if (!(param instanceof String)) {
            Cutter.setLog("    Warning:KeyFrame.getImageName() - expected a string parameter but got datatype \"" + param.getClass().getName() + "\"");
            return null;
        }
        String fullPath = (String)param;
        imageName = new File(fullPath).getName();
        imageName = TextUtils.trimLeadingChar(imageName, '\"');
        imageName = TextUtils.trimTrailingChar(imageName, '\"');
        boolean isSecondaryDisplay = false;
        if (imageName.startsWith("+")) {
            isSecondaryDisplay = true;
        }
        imageName = TextUtils.trimLeadingChar(imageName, '+');
        if ((fullPath = TextUtils.removeQuotes(fullPath)).startsWith("+")) {
            isSecondaryDisplay = true;
        }
        fullPath = TextUtils.trimLeadingChar(fullPath, '+');
        String[] out = new String[]{imageName, TextUtils.removeQuotes(fullPath), isSecondaryDisplay ? DISPLAY_SECONDARY : DISPLAY_PRIMARY};
        return out;
    }

    public static boolean createFrames(StringBuffer strBuffer, boolean debug) {
        Statement statement;
        int numframe = 1;
        boolean numstatements = true;
        double param1 = 0.0;
        double param2 = 0.0;
        Statement displayStatement = null;
        Vector<Statement> listOfSecondaryDisplayStatements = new Vector<Statement>();
        Cutter.setLog("KeyFrame.createFrames() 1");
        singleFrameMode = Tween.frameToRender != -1;
        int frameToRender = Tween.frameToRender = Tween.frameToRender > Tween.totalFrames() ? Tween.totalFrames() : Tween.frameToRender;
        KeyFrame header = listOfKeyFrames.elementAt(0);
        for (int h = 0; h < header.listOfStatements.size(); ++h) {
            statement = header.listOfStatements.elementAt(h);
            if (!statement.name.equals("Display")) continue;
            if (statement.isaSecondaryDisplay) {
                listOfSecondaryDisplayStatements.addElement(statement);
                continue;
            }
            if (statement.isXFrameDenoise) {
                displayStatement = statement;
                continue;
            }
            displayStatement = statement;
            if (displayStatement.hasParamNamed("\"it\"", true)) {
                usesITDisplayDriver = true;
                continue;
            }
            if (displayStatement.hasParamNamed("\"openexr\"", true)) {
                usesITDisplayDriver = false;
                continue;
            }
            usesITDisplayDriver = false;
            if (statement.replaceParam("\"framebuffer\"", fileTypeTiff, true) || statement.replaceParam("\"tiff\"", fileTypeTiff, true)) continue;
            Cutter.setLog("    Warning: KeyFrame.createFrames() cannot find the name of a\n           display driver to replace with " + fileTypeTiff);
        }
        header.listOfStatements.removeElement(displayStatement);
        for (int n = 0; n < listOfSecondaryDisplayStatements.size(); ++n) {
            statement = (Statement)listOfSecondaryDisplayStatements.elementAt(n);
            header.listOfStatements.removeElement(statement);
        }
        strBuffer.append(header.getText());
        String tiffCompression = "";
        if (RenderInfo.activeRendererIs("pixar")) {
            tiffCompression = " \"compression\" [\"lzw\"]";
        }
        for (int n = 0; n < Tween.listOfTweens.size(); ++n) {
            Tween tween = Tween.listOfTweens.elementAt(n);
            if (tween.from < 1 || tween.to < 1 || tween.frames < 1) continue;
            KeyFrame fromKey = listOfKeyFrames.elementAt(tween.from);
            KeyFrame toKey = listOfKeyFrames.elementAt(tween.to);
            if (fromKey.id == toKey.id) {
                KeyFrame.showError("Duplicate KeyFrame Index Numbers", "The animation has defined two Keyframes with the same index number!", "Keyframes must have different index numbers.");
                return false;
            }
            if (fromKey == null || toKey == null) {
                System.out.println("null keys at indices " + fromKey + " and " + toKey);
                return false;
            }
            Runtime runtime = Runtime.getRuntime();
            int j = 0;
            while (j < tween.frames) {
                int frame = j + 1;
                if (!singleFrameMode || numframe == frameToRender) {
                    strBuffer.append("\nFrameBegin " + numframe + "\n");
                    Cutter.setLog("KeyFrame.createFrames() numframe = " + numframe);
                    if (displayStatement != null) {
                        String out = displayStatement.name + " ";
                        String[] imageData = KeyFrame.getImageName(displayStatement);
                        String image = imageData[0];
                        if (image == null) {
                            image = "ERROR.tif";
                        }
                        String fullPath = imageData[1];
                        File parentDir = null;
                        String parentPath = null;
                        if (fullPath != null && fullPath.trim().length() > 0 && (parentDir = new File(fullPath).getParentFile()) != null) {
                            parentPath = parentDir.getPath();
                            if (!new File(parentPath = TextUtils.trimLeadingChar(parentPath, '/')).exists()) {
                                if (j == 0) {
                                    KeyFrame.showError("Incorrect Path", "The path specified in the Display statement,\n    \"" + parentPath + "\"\ndoes not exist.", "Cutter will attempt to save the rendered images\nin the \"frames\" directory. The location of the\ndirectory can be set using the Preferences Tool,\n    Rman->User->Rendered Frames");
                                }
                                parentPath = null;
                            }
                        }
                        image = parentPath != null ? fullPath : "\"" + RenderInfo.get(12).replace('\\', '/') + "/" + image + "\"";
                        if (!displayStatement.hasParamNamed("\"it\"", true)) {
                            String driver = displayStatement.getDisplayDriver();
                            String extension = GraphicsFileUtils.getExtFromDriver(driver);
                            String numericName = FileUtils.addNumericExtension(Tokenizer.removeQuotes(image), numframe, extension);
                            numericName = numericName.replace('\\', '/');
                            out = out + "\"" + numericName + "\"";
                            for (int q = 1; q < displayStatement.listOfParams.size(); ++q) {
                                out = out + " " + displayStatement.listOfParams.elementAt(q);
                            }
                            if (driver.equals("tiff")) {
                                strBuffer.append(out + tiffCompression);
                            } else {
                                strBuffer.append(out);
                            }
                            strBuffer.append("\n");
                        } else {
                            strBuffer.append(out + " ");
                            image = Tokenizer.removeQuotes(image);
                            String[] strs = TextUtils.tokenize(image, "/");
                            if (strs != null && strs.length > 0) {
                                strBuffer.append("\"" + strs[strs.length - 1] + "\" ");
                            }
                            StringBuffer sb = new StringBuffer();
                            for (int q = 1; q < displayStatement.listOfParams.size(); ++q) {
                                sb.append(" " + displayStatement.listOfParams.elementAt(q));
                            }
                            strBuffer.append(sb.toString() + "\n");
                        }
                    }
                    Vector<Statement> list1 = fromKey.listOfStatements;
                    Vector<Statement> list2 = toKey.listOfStatements;
                    for (int i = 0; i < list1.size(); ++i) {
                        Statement statement1 = list1.elementAt(i);
                        Statement statement2 = list2.elementAt(i);
                        if (!statement1.name.equals(statement2.name)) {
                            KeyFrame.showError("Dissimilar Statements Error", tween.from, tween.to, i + 1, statement1.toString(), statement2.toString());
                            return false;
                        }
                        if (statement1.name.equals("WorldBegin")) {
                            for (int k = 0; k < listOfSecondaryDisplayStatements.size(); ++k) {
                                Statement statement3 = (Statement)listOfSecondaryDisplayStatements.elementAt(k);
                                String[] imageData = KeyFrame.getImageName(statement3);
                                String imageName = imageData[0];
                                String fullPath = imageData[1];
                                boolean isSecondary = imageData[2].equals(DISPLAY_SECONDARY);
                                Object parentPath = null;
                                File parentFile = null;
                                if (imageName == null) break;
                                String out = statement3.name + " ";
                                String driver = displayStatement.getDisplayDriver();
                                String extension = GraphicsFileUtils.getExtFromDriver(driver);
                                String numericName = FileUtils.addNumericExtension(imageName, numframe, extension);
                                numericName = numericName.replace('\\', '/');
                                parentFile = new File(fullPath).getParentFile();
                                if (parentFile == null) {
                                    String userFramesPath = RenderInfo.get(12).replace('\\', '/');
                                    fullPath = userFramesPath + "/" + numericName;
                                } else {
                                    fullPath = new File(parentFile, numericName).getPath();
                                }
                                fullPath = fullPath.replace('\\', '/');
                                out = out + "\"+" + fullPath + "\"";
                                Vector<Object> params = statement3.listOfParams;
                                for (int q = 1; q < statement3.listOfParams.size(); ++q) {
                                    out = out + " " + statement3.listOfParams.elementAt(q);
                                }
                                strBuffer.append(out + "\n");
                            }
                        }
                        strBuffer.append(statement1.name);
                        Vector<Object> pList1 = statement1.listOfParams;
                        Vector<Object> pList2 = statement2.listOfParams;
                        if (pList1.size() != pList2.size()) {
                            KeyFrame.showError("Dissimilar Number of Parameters Error", tween.from, tween.to, i + 1, statement1.toString(), statement2.toString());
                            return false;
                        }
                        for (int k = 0; k < pList1.size(); ++k) {
                            String numStr;
                            if (pList1.elementAt(k) instanceof Double) {
                                param1 = ((Number)pList1.elementAt(k)).doubleValue();
                                if (Math.abs(param1 - (param2 = ((Number)pList2.elementAt(k)).doubleValue())) > 0.001) {
                                    numStr = NumberUtils.clip(Tween.interpolate(tween, param1, param2, frame));
                                    strBuffer.append(" " + numStr);
                                    continue;
                                }
                                strBuffer.append(" " + param1);
                                continue;
                            }
                            if (pList1.elementAt(k) instanceof Integer) {
                                double para2;
                                int para1 = ((Number)pList1.elementAt(k)).intValue();
                                if ((double)para1 != (para2 = ((Number)pList2.elementAt(k)).doubleValue())) {
                                    numStr = NumberUtils.clip(Tween.interpolate(tween, para1, para2, frame));
                                    strBuffer.append(" " + numStr);
                                    continue;
                                }
                                strBuffer.append(" " + para1);
                                continue;
                            }
                            if (pList1.elementAt(k) instanceof Character || pList2.elementAt(k) instanceof Character) {
                                strBuffer.append(" " + pList1.elementAt(k));
                                continue;
                            }
                            String str = KeyFrame.handleEmbeddedNumbers(tween, frame, statement1, (String)pList1.elementAt(k), (String)pList2.elementAt(k), k);
                            strBuffer.append(" " + str);
                        }
                        strBuffer.append("\n");
                    }
                    strBuffer.append("FrameEnd\n");
                }
                ++j;
                ++numframe;
            }
        }
        return true;
    }

    private static String handleEmbeddedNumbers(Tween tween, int frame, Statement s1, String p1, String p2, int paramIndex) {
        if (s1.name.equals("Procedural") && paramIndex == 2) {
            return p1;
        }
        if (!(p1.startsWith("\"") && p1.endsWith("\"") && p2.startsWith("\"") && p2.endsWith("\""))) {
            return p1;
        }
        String str1 = p1.substring(1, p1.length() - 1);
        String str2 = p2.substring(1, p2.length() - 1);
        if (str1.trim().length() == 0 || str2.trim().length() == 0) {
            return p1;
        }
        str1 = str1.replace('\\', '/');
        str2 = str2.replace('\\', '/');
        String[] strs1 = TextUtils.tokenize(str1);
        String[] strs2 = TextUtils.tokenize(str2);
        if (strs1 == null || strs1.length == 0 || strs2 == null || strs2.length == 0) {
            return p1;
        }
        StringBuffer out = new StringBuffer();
        for (int n = 0; n < strs1.length; ++n) {
            String itemA = strs1[n];
            String itemB = strs2[n];
            boolean handled = KeyFrame.handlePaddedNumber(tween, frame, itemA, itemB, out);
            if (handled) continue;
            try {
                double d = Tween.interpolate(tween, Double.parseDouble(itemA), Double.parseDouble(itemB), frame);
                if (Tokenizer.isOfType(itemA) == 2 || Tokenizer.isOfType(itemB) == 2) {
                    out.append(NumberUtils.clip(d) + " ");
                    continue;
                }
                out.append(NumberUtils.doubleToIntStr(d) + " ");
                continue;
            }
            catch (NumberFormatException ex) {
                out.append(itemA + " ");
            }
        }
        String outStr = "\"" + out.toString().trim() + "\"";
        return outStr;
    }

    static boolean handlePaddedNumber(Tween tween, int frame, String itemA, String itemB, StringBuffer out) {
        if (itemA == null || itemA.trim().length() == 0 || itemB == null || itemB.trim().length() == 0) {
            return false;
        }
        String itemACopy = itemA.replace('\\', '/');
        String itemBCopy = itemB.replace('\\', '/');
        String[] pathTokensA = TextUtils.tokenize(itemACopy, "/");
        String[] pathTokensB = TextUtils.tokenize(itemBCopy, "/");
        if (pathTokensA == null || pathTokensA.length == 0 || pathTokensB == null || pathTokensB.length == 0) {
            return false;
        }
        String fileNameA = pathTokensA[pathTokensA.length - 1];
        String fileNameB = pathTokensB[pathTokensB.length - 1];
        String[] nameTokensA = TextUtils.tokenize(fileNameA, ".");
        String[] nameTokensB = TextUtils.tokenize(fileNameB, ".");
        if (nameTokensA == null || nameTokensB == null) {
            return false;
        }
        if (nameTokensA.length < 3 || nameTokensB.length < 3 || nameTokensA.length != nameTokensB.length) {
            return false;
        }
        Vector<String> list = new Vector<String>();
        for (int n = 0; n < nameTokensA.length; ++n) {
            if (nameTokensA[n].equals(nameTokensB[n])) {
                list.addElement(nameTokensA[n]);
                continue;
            }
            int paddingA = NumberUtils.isPaddedIntStr(nameTokensA[n]);
            int paddingB = NumberUtils.isPaddedIntStr(nameTokensB[n]);
            if (paddingA == -1 || paddingB == -1) {
                list.addElement(nameTokensA[n]);
                continue;
            }
            int intA = NumberUtils.getIntFromPaddedStr(nameTokensA[n]);
            int intB = NumberUtils.getIntFromPaddedStr(nameTokensB[n]);
            try {
                double d = Tween.interpolate(tween, Double.parseDouble(intA + ""), Double.parseDouble(intB + ""), frame);
                String str = NumberUtils.doubleToIntStr(d);
                list.addElement(NumberUtils.intToPaddedStr(str, paddingA));
                continue;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (list.size() == 0) {
            return false;
        }
        StringBuffer fileNameBuf = new StringBuffer();
        for (int n = 0; n < list.size(); ++n) {
            fileNameBuf.append((String)list.elementAt(n));
            if (n >= list.size() - 1) continue;
            fileNameBuf.append(".");
        }
        StringBuffer pathBuf = new StringBuffer();
        for (int n = 0; n < pathTokensA.length - 1; ++n) {
            pathBuf.append(pathTokensA[n]);
            pathBuf.append("/");
        }
        String fullPath = pathBuf.toString().trim() + fileNameBuf.toString().trim();
        out.append(fullPath);
        return true;
    }

    static boolean _handlePaddedNumber(Tween tween, int frame, String itemA, String itemB, StringBuffer out) {
        int n;
        String[] strs2;
        String[] strs1;
        if (itemA.indexOf("/") == -1) {
            strs1 = TextUtils.tokenize(itemA, ".");
            strs2 = TextUtils.tokenize(itemB, ".");
            if (strs1 == null || strs2 == null) {
                return false;
            }
            if (strs1.length < 3 || strs2.length < 3 || strs1.length != strs2.length) {
                return false;
            }
        } else {
            int n2;
            File fa = new File(itemA);
            File fb = new File(itemB);
            String faName = fa.getName();
            String fbName = fb.getName();
            String faPath = fa.getParent().replace('\\', '/');
            String fbPath = fb.getParent().replace('\\', '/');
            String[] ta = TextUtils.tokenize(faName, ".");
            String[] tb = TextUtils.tokenize(fbName, ".");
            strs1 = new String[ta.length + 1];
            strs2 = new String[tb.length + 1];
            strs1[0] = faPath;
            strs2[0] = fbPath;
            for (n2 = 0; n2 < ta.length; ++n2) {
                strs1[n2 + 1] = ta[n2];
            }
            for (n2 = 0; n2 < tb.length; ++n2) {
                strs2[n2 + 1] = tb[n2];
            }
        }
        Vector<String> list = new Vector<String>();
        for (n = 0; n < strs1.length; ++n) {
            if (strs1[n].equals(strs2[n])) {
                list.addElement(strs1[n]);
                continue;
            }
            int paddingA = NumberUtils.isPaddedIntStr(strs1[n]);
            int paddingB = NumberUtils.isPaddedIntStr(strs2[n]);
            if (paddingA == -1 || paddingB == -1) {
                list.addElement(strs1[n]);
                continue;
            }
            int intA = NumberUtils.getIntFromPaddedStr(strs1[n]);
            int intB = NumberUtils.getIntFromPaddedStr(strs2[n]);
            try {
                double d = Tween.interpolate(tween, Double.parseDouble(intA + ""), Double.parseDouble(intB + ""), frame);
                String str = NumberUtils.doubleToIntStr(d);
                list.addElement(NumberUtils.intToPaddedStr(str, paddingA));
                continue;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (list.size() == 0) {
            return false;
        }
        out.append((String)list.elementAt(0));
        out.append("/");
        for (n = 1; n < list.size(); ++n) {
            out.append((String)list.elementAt(n));
            if (n >= list.size() - 1) continue;
            out.append(".");
        }
        return true;
    }

    private static void showError(String title, int from, int to, int index, String statement1, String statement2) {
        String str1 = statement1.toString().replace('\n', ' ');
        String str2 = statement2.toString().replace('\n', ' ');
        if (title.equals("Dissimilar Statements Error")) {
            KeyFrame.showError(title, "In keyframes " + from + " and " + to + " the (#" + index + ") pairs of statements,\n    " + str1 + "\n    " + str2 + "\ndo not match!", "Only the parameter values of the statements,\nbut not the statements themselves, can vary.");
        } else if (title.equals("Dissimilar Number of Parameters Error")) {
            KeyFrame.showError(title, "In keyframes " + from + " and " + to + " the (#" + index + ") pairs of statements,\n    " + str1 + "\n    " + str2 + "\nhave different parameters!", "The statements shown above must have the same\nnumber, and sequence, of parameters.");
        }
    }

    private static void showError(String title, String error, String suggestion) {
        JOptionPane.showMessageDialog(KDesktop.desktopPane, error + "\n\n" + suggestion, title, 0);
    }

    static {
        singleFrameMode = true;
        fileTypeTiff = "\"tiff\"";
        usesITDisplayDriver = false;
        DISPLAY_PRIMARY = "primary";
        DISPLAY_SECONDARY = "secondary";
    }
}

