/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.Animation;

import UI_Actions.TextShiftAction;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Rib.Animation.RibBuffer;
import UI_Script.Rib.Animation.RibIterator;
import UI_Script.Rib.Parsers.AnimParser;
import UI_Script.Rib.RibScriptHandler;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.Qtvr.QtvrTool;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Tabs.Rib.RenderManager;
import Utilities.FileUtils;
import Utilities.SegmentUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.text.Segment;

public class MultiFramer
extends AnimParser {
    public static final String KEYFRAME_EXT = ".key";
    private StringBuffer buffer = new StringBuffer(409600);
    private static int animationCounter = 1;

    public void generateKeyFrames() {
        this.generateKeyFrames(true, false, -1, -1, -1, -1);
    }

    private StringBuffer generateKeyFrames(boolean outputToWindow, boolean isQTVR, int rows, int columns, int startVPan, int endVPan) {
        String ext;
        String[] lines;
        Segment srcStr = BBxt.getWindowText(null);
        boolean doCrossFrameDenoise = false;
        boolean doShiftRight = true;
        String selection = BBxt.getSelection();
        if (selection != null && (selection = selection.trim()).length() > 0 && (lines = TextUtils.tokenize(selection, '\n')) != null && lines.length > 0) {
            String beginStr = lines[0].trim();
            String endStr = lines[lines.length - 1].trim();
            if (beginStr.startsWith("FrameBegin") && endStr.startsWith("FrameEnd")) {
                int n;
                StringBuffer frameBuffer = new StringBuffer();
                StringBuffer headBuffer = new StringBuffer();
                for (n = 1; n < lines.length - 1; ++n) {
                    frameBuffer.append(lines[n]).append("\n");
                }
                lines = TextUtils.tokenize(srcStr.toString(), '\n');
                for (n = 0; n < lines.length && !lines[n].trim().startsWith("FrameBegin"); ++n) {
                    headBuffer.append(lines[n]).append("\n");
                }
                headBuffer.append(frameBuffer.toString());
                srcStr = SegmentUtils.toSegment(headBuffer.toString());
                doShiftRight = false;
            } else {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "A selection of rib statements can be converted to    \na KeyFrame document but only if the selection\nbegins with \"FrameBegin\" and ends with \"FrameEnd\".   \n", "Selection Not a Frame Block Error\n\n", 0);
                return null;
            }
        }
        String srcCameraBlock = RibScriptHandler.getCameraBlock(srcStr);
        String worldBlock = RibScriptHandler.getWorldBlock(srcStr);
        String title = BBxt.getWindowTitle();
        this.buffer.setLength(0);
        if (!(srcStr == null || title == null || title.length() == 0 || (ext = FileUtils.getExtension(title)) != null && ext.equalsIgnoreCase(".rib"))) {
            Cutter.setLog("    Info:MultiFramer.generateKeyFrames() - ignoring front window. Using default template.");
            return null;
        }
        RibBuffer primaryCamera = new RibBuffer();
        Vector primaryCamList = new Vector();
        RibBuffer secondCamera = new RibBuffer();
        RibBuffer archives = new RibBuffer();
        RibBuffer options = new RibBuffer();
        RibBuffer postTransformsOptions = new RibBuffer();
        RibBuffer displays = new RibBuffer();
        RibBuffer displaychannels = new RibBuffer();
        RibBuffer remainder = new RibBuffer();
        RibBuffer shutter = new RibBuffer();
        RibBuffer cameraAttrs = new RibBuffer();
        RibBuffer ifblock = new RibBuffer();
        String imagerShader = "";
        String depthOfField = "";
        RibTokenizer docTypeTokenizer = new RibTokenizer();
        docTypeTokenizer.setBuffer(srcStr);
        int docType = docTypeTokenizer.scriptIsTypeOf();
        docTypeTokenizer = null;
        boolean isDualCameraRib = false;
        RibIterator iter = new RibIterator(srcCameraBlock);
        String[] strs = null;
        int count = 0;
        Vector<String[]> tmp = new Vector<String[]>();
        String qtvrTranslate = "";
        boolean transformsHasBegun = false;
        try {
            while (true) {
                if ((strs = iter.prevLine())[1].trim().length() == 0 || strs[1].startsWith("#")) {
                    ++count;
                    continue;
                }
                if (strs[1].startsWith("Shutter")) {
                    shutter.append(strs);
                    continue;
                }
                if (iter.isDepthOfField(strs)) {
                    depthOfField = strs[1];
                    ++count;
                    continue;
                }
                if (iter.isTransform(strs)) {
                    transformsHasBegun = true;
                    ++count;
                    tmp.add(strs);
                    continue;
                }
                if (iter.isDisplayFilter(strs)) {
                    imagerShader = strs[1];
                    continue;
                }
                if (iter.isOption(strs)) {
                    postTransformsOptions.append(strs);
                    ++count;
                    continue;
                }
                if (!transformsHasBegun) {
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        iter.trim(count);
        if (tmp.size() > 0) {
            for (int n = tmp.size() - 1; n >= 0; --n) {
                String[] s = (String[])tmp.elementAt(n);
                primaryCamera.append(s);
            }
        }
        try {
            while (true) {
                if ((strs = iter.nextLine(true))[1].startsWith("ReadArchive")) {
                    doCrossFrameDenoise = RibIterator.isReferencingDenoiseRib(strs[1]);
                }
                if (strs[1].startsWith("ArchiveBegin")) {
                    while (!strs[1].startsWith("ArchiveEnd")) {
                        archives.append(strs);
                        strs = iter.nextLine(true);
                    }
                    archives.append(strs);
                    continue;
                }
                if (strs[1].startsWith("Projection") || strs[1].startsWith("ShadingRate") || strs[1].startsWith("DisplayFilter")) {
                    cameraAttrs.append(strs);
                    continue;
                }
                if (iter.isOption(strs)) {
                    options.append(strs);
                    continue;
                }
                if (strs[1].startsWith("DisplayChannel")) {
                    displaychannels.append(strs);
                    continue;
                }
                if (strs[1].startsWith("Display")) {
                    displays.append(strs);
                    continue;
                }
                if (strs[1].startsWith("IfBegin")) {
                    while (!strs[1].startsWith("IfEnd")) {
                        options.append(strs);
                        strs = iter.nextLine(true);
                    }
                    options.append(strs);
                    continue;
                }
                if (strs[1].startsWith("TransformBegin")) {
                    while (!strs[1].startsWith("TransformEnd")) {
                        if (strs[1].startsWith("Camera")) {
                            isDualCameraRib = true;
                        }
                        secondCamera.append(strs);
                        strs = iter.nextLine(true);
                    }
                    secondCamera.append(strs);
                    continue;
                }
                if (strs[1].startsWith("FrameBegin") || strs[1].startsWith("FrameEnd")) continue;
                if (strs[1].startsWith("DisplayFilter")) {
                    imagerShader = strs[1];
                    continue;
                }
                if (strs[1].startsWith("DepthOfField")) {
                    depthOfField = strs[1];
                    continue;
                }
                remainder.append(strs);
            }
        }
        catch (Exception n) {
            if (primaryCamera.isEmpty() || worldBlock == null) {
                Cutter.setLog("    Error:MultiFramer.generateKeyFrames()\n        failed to find either a camera or a world block");
                return null;
            }
            String[] lines2 = options.toStrings();
            String user_renderer = RibScriptHandler.getUserOptionRenderer(lines2);
            if (user_renderer == null) {
                user_renderer = RenderInfo.get(3);
            }
            Vector v = MultiFramer.getDisplayStatementsFromCB(ifblock.toString(), user_renderer);
            displays.append(v);
            if (outputToWindow) {
                BBxt.newDocument("animation" + animationCounter++ + KEYFRAME_EXT);
            }
            if (!doShiftRight) {
                options.removeTabs(1);
                archives.removeTabs(1);
                displaychannels.removeTabs(1);
                displays.removeTabs(1);
                remainder.removeTabs(1);
            }
            if (!options.isEmpty()) {
                this.buffer.append(options.toString()).append("\n");
            }
            if (!postTransformsOptions.isEmpty()) {
                this.buffer.append(postTransformsOptions.toString()).append("\n");
            }
            if (!archives.isEmpty()) {
                this.buffer.append(archives.toString()).append("\n");
            }
            if (!displaychannels.isEmpty()) {
                this.buffer.append(displaychannels.toString()).append("\n");
            }
            if (!displays.isEmpty()) {
                this.buffer.append(displays.toString());
            }
            if (!remainder.isEmpty()) {
                this.buffer.append(remainder.toString()).append("\n");
            }
            if (isQTVR) {
                for (int r = 1; r <= rows * 2; r += 2) {
                    this.buffer.append("Tween \"from\" " + r + " \"to\" " + (r + 1) + " \"frames\" " + columns + "\n");
                }
            } else {
                this.buffer.append("Tween \"from\" 1 \"to\" 2 \"frames\" 30\n");
            }
            this.buffer.append("Tween \"output\" \"all\"\n");
            this.buffer.append("#Tween \"output\" 1\n");
            TextShiftAction shiftRight = new TextShiftAction(2);
            StringBuffer frameBlock = new StringBuffer();
            if (isQTVR) {
                Object str = null;
                float xdist = 0.0f;
                float ydist = 0.0f;
                float zdist = 0.0f;
                float startRmanVPan = -90.0f - (float)startVPan;
                int k = 1;
                float incr = rows - 1 > 0 ? (float)((startVPan - endVPan) / (rows - 1)) : 0.0f;
                for (int n2 = 0; n2 < rows; ++n2) {
                    this.buffer.append("KeyFrameBegin " + k++ + "\n");
                    frameBlock.setLength(0);
                    frameBlock.append(cameraAttrs.toString());
                    frameBlock.append(qtvrTranslate);
                    frameBlock.append("\n");
                    frameBlock.append("Rotate " + (startRmanVPan + incr * (float)n2) + " 1 0 0");
                    frameBlock.append("\n");
                    frameBlock.append("Rotate 0  0 0 1");
                    frameBlock.append("\n");
                    frameBlock.append("WorldBegin" + worldBlock + "\nWorldEnd\n");
                    this.buffer.append(shiftRight.shiftText(frameBlock.toString()));
                    this.buffer.append("KeyFrameEnd\n\n");
                    this.buffer.append("KeyFrameBegin " + k++ + "\n");
                    frameBlock.setLength(0);
                    frameBlock.append(cameraAttrs.toString());
                    frameBlock.append("Translate " + xdist + " " + ydist + " " + zdist);
                    frameBlock.append("\n");
                    frameBlock.append("Rotate " + (startRmanVPan + incr * (float)n2) + " 1 0 0");
                    frameBlock.append("\n");
                    frameBlock.append("Rotate 360  0 0 1");
                    frameBlock.append("\n");
                    frameBlock.append("WorldBegin" + worldBlock + "\nWorldEnd\n");
                    this.buffer.append(shiftRight.shiftText(frameBlock.toString()));
                    this.buffer.append("KeyFrameEnd\n\n");
                }
            } else {
                for (int n3 = 0; n3 < 2; ++n3) {
                    if (n3 == 0) {
                        this.buffer.append("#------------------------------------------\n");
                    }
                    this.buffer.append("KeyFrameBegin ").append(n3 + 1).append("\n");
                    frameBlock.setLength(0);
                    frameBlock.append(cameraAttrs.toString());
                    if (!depthOfField.equals("")) {
                        frameBlock.append(depthOfField);
                    }
                    if (isDualCameraRib) {
                        frameBlock.append(secondCamera.toString());
                    }
                    frameBlock.append(primaryCamera.toString());
                    if (!imagerShader.equals("")) {
                        frameBlock.append(imagerShader);
                    }
                    if (!shutter.isEmpty()) {
                        frameBlock.append(shutter.toString());
                    }
                    if (!doShiftRight) {
                        frameBlock.append("\tWorldBegin");
                    } else {
                        frameBlock.append("WorldBegin");
                    }
                    frameBlock.append(worldBlock);
                    frameBlock.append("WorldEnd\n");
                    if (doShiftRight) {
                        this.buffer.append(shiftRight.shiftText(frameBlock.toString()));
                    } else {
                        this.buffer.append(frameBlock.toString());
                    }
                    this.buffer.append("KeyFrameEnd\n");
                    this.buffer.append("#------------------------------------------\n");
                }
            }
            if (doCrossFrameDenoise) {
                this.buffer.append("ReadArchive \"./XFrameDenoise.rib\"\n");
                File f = new File(FileUtils.getPWD(), "XFrameDenoise.rib");
                StringBuffer b = new StringBuffer();
                b.append("# The contents of this file will be created by Cutter when the\n");
                b.append("# keyframe file is rendered.\n");
                FileUtils.writeFile(f, b.toString());
            }
            if (!outputToWindow) {
                return this.buffer;
            }
            BBxt.paste(this.buffer.toString());
            return null;
        }
    }

    private String getCopyOf(String source, String target, int beginAt) {
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer(source);
        tok.setBufferIndex(beginAt);
        int start = tok.searchFor(target, false);
        Cutter.setLog("found >" + target + "< at " + start);
        if (start == -1) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        char[] chars = tok.getBuffer();
        for (int n = start; n < chars.length; ++n) {
            if (chars[n] == '\r' && chars[n + 1] == '\n') {
                return out.toString();
            }
            if (chars[n] == '\r' && chars[n + 1] != '\n') {
                return out.toString();
            }
            if (chars[n] == '\n') {
                return out.toString();
            }
            out.append(chars[n]);
        }
        return out.toString();
    }

    public static Vector getDisplayStatementsFromCB(String block, String renderer) {
        Vector<String> tmp;
        String[] lines;
        block11: {
            String rnd = renderer.trim().length() == 0 ? "useElse" : renderer;
            lines = TextUtils.tokenize(block, "\n");
            if (lines == null || lines.length == 0) {
                return null;
            }
            int maxcounter = lines.length - 1;
            tmp = new Vector<String>();
            int counter = 0;
            do {
                String line;
                if ((line = lines[counter].trim()).equals("Else")) {
                    line = lines[++counter].trim();
                    while (!line.startsWith("IfEnd")) {
                        if (line.startsWith("Display")) {
                            tmp.addElement(line);
                        }
                        line = lines[++counter].trim();
                    }
                } else {
                    String token;
                    String[] tokens = TextUtils.tokenize(line, "==");
                    if (tokens == null || tokens.length != 2 || !(token = tokens[1].replace('\"', ' ').replace('\'', ' ').trim()).equals(rnd)) continue;
                    line = lines[++counter].trim();
                    while (!line.startsWith("IfElse") && !line.startsWith("Else")) {
                        if (line.startsWith("Display")) {
                            tmp.addElement(line);
                        }
                        line = lines[++counter].trim();
                    }
                }
                break block11;
            } while (++counter <= maxcounter);
            return null;
        }
        Vector<String> primary = new Vector<String>();
        Vector<String> secondary = new Vector<String>();
        for (int n = 0; n < tmp.size(); ++n) {
            String str = (String)tmp.elementAt(n);
            if (str.indexOf(43) == -1) {
                primary.addElement(str);
                continue;
            }
            secondary.addElement(str);
        }
        if (primary.size() != 1) {
            Cutter.setLog("    Error:MultiFramer.getDisplayStatementsFromCB() - unable to find primary\n             display statement in the conditional block:");
            Cutter.setLog(lines, 2);
            return null;
        }
        return VectorUtils.combine(primary, secondary);
    }

    private static Vector __getDisplayStatementsFromCB(String block, String renderer) {
        String[] lines = TextUtils.tokenize(block, "\n");
        boolean grabStatements = false;
        Vector<String> tmp = new Vector<String>();
        for (int n = 0; n < lines.length; ++n) {
            String[] tokens;
            String line = lines[n].trim();
            if (line.equals("Else") && n < lines.length - 1 && lines[n + 1].trim().startsWith("Display")) {
                Cutter.setLog("adding >" + lines[n + 1].trim() + "<");
                tmp.addElement(lines[n + 1].trim());
            }
            if ((tokens = TextUtils.tokenize(line, "==")) != null && tokens.length == 2) {
                String token = tokens[1].replace('\"', ' ').replace('\'', ' ').trim();
                if (!token.equals(renderer)) continue;
                grabStatements = true;
                continue;
            }
            if (!grabStatements) continue;
            if (line.trim().startsWith("Display")) {
                tmp.addElement(line.trim());
                continue;
            }
            grabStatements = false;
        }
        Vector<String> primary = new Vector<String>();
        Vector<String> secondary = new Vector<String>();
        for (int n = 0; n < tmp.size(); ++n) {
            String str = (String)tmp.elementAt(n);
            if (str.indexOf(43) == -1) {
                primary.addElement(str);
                continue;
            }
            secondary.addElement(str);
        }
        if (primary.size() != 1) {
            Cutter.setLog("    Error:MultiFramer.getDisplayStatementsFromCB() - unable to find primary\n             display statement in the conditional block:");
            Cutter.setLog(lines, 2);
            return null;
        }
        return VectorUtils.combine(primary, secondary);
    }

    public void generateQTVR() {
        if (!QtvrTool.doCalc()) {
            return;
        }
        if (!RenderInfo.getDeferRender()) {
            StringBuffer buf = this.generateKeyFrames(false, true, QtvrTool.rows, QtvrTool.cols, QtvrTool.startVPan, QtvrTool.endVPan);
            if (buf != null) {
                this.setBuffer(buf);
                this.fileNameSuffix = "qtvr";
                File[] files = this.generateSequence();
                this.fileNameSuffix = "";
                if (files != null && files.length == 1) {
                    RenderManager.renderFile(files[0]);
                }
            }
            return;
        }
        if (BBxt.getWindowTitle().endsWith(".rib") || BBxt.getWindowTitle().endsWith(".rib*")) {
            this.setBuffer(BBxt.getWindowText(null));
            if (this.scriptIsTypeOf() == 2) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "The QuickTimeVR tool has found the animation\nstatements Tween and KeyFrameBegin/End.\n\nOnly non-animation ie. standard RIB documents\ncan be converted to a VR animations.", "Inappropriate Rib Document Error", 0);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "The QuickTimeVR tool cannot find a document of\nthe correct type to convert to a VR animation.\n\nMake sure the active ie. front window, is a\nstandard RIB document.", "Inappropriate Document Error", 0);
            return;
        }
        this.generateKeyFrames(true, true, QtvrTool.rows, QtvrTool.cols, QtvrTool.startVPan, QtvrTool.endVPan);
    }
}

