/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.Animation;

import Utilities.TextUtils;
import java.util.Vector;

public class RibBuffer {
    private StringBuffer sb = new StringBuffer();

    public RibBuffer() {
    }

    public RibBuffer(RibBuffer src) {
        this.sb.append(src.toString());
    }

    public void reset(Vector v) {
        this.sb = new StringBuffer();
        this.append(v);
    }

    public void append(Vector v) {
        if (v == null || v.isEmpty()) {
            return;
        }
        for (int n = 0; n < v.size(); ++n) {
            String s = (String)v.elementAt(n);
            if (s.endsWith("\n")) {
                this.sb.append(v.elementAt(n));
                continue;
            }
            this.sb.append(v.elementAt(n)).append("\n");
        }
    }

    public void append(String[] s) {
        if (s[1].trim().length() > 0) {
            this.sb.append(s[0]).append(s[1]);
        }
    }

    public void append(String prefix, String str) {
        if (str.trim().length() > 0) {
            this.sb.append(prefix).append(str);
        }
    }

    public String toString() {
        return this.isEmpty() ? "" : this.sb.toString();
    }

    public String[] toStrings() {
        return TextUtils.tokenize(this.sb.toString(), '\n');
    }

    public boolean isEmpty() {
        return this.sb.length() == 0;
    }

    public boolean remove(String item) {
        int n;
        StringBuffer tmp = new StringBuffer();
        String[] lines = this.toStrings();
        if (lines == null || lines.length == 0) {
            return false;
        }
        for (n = 0; n < lines.length; ++n) {
            String line = lines[n];
            if (line.trim().equals(item.trim())) continue;
            tmp.append(line).append("\n");
        }
        this.sb.setLength(0);
        if (tmp.length() > 0) {
            lines = TextUtils.tokenize(tmp.toString(), '\n');
            for (n = 0; n < lines.length; ++n) {
                this.sb.append(lines[n]).append("\n");
            }
        }
        return true;
    }

    public void additionalTabs(int tabs) {
        int n;
        String[] lines = this.toStrings();
        if (lines == null || lines.length == 0) {
            return;
        }
        StringBuffer tmp = new StringBuffer();
        for (n = 0; n < lines.length; ++n) {
            for (int i = 0; i < tabs; ++i) {
                tmp.append("\t");
            }
            tmp.append(lines[n]).append("\n");
        }
        this.sb.setLength(0);
        if (tmp.length() > 0) {
            lines = TextUtils.tokenize(tmp.toString(), '\n');
            for (n = 0; n < lines.length; ++n) {
                this.sb.append(lines[n]).append("\n");
            }
        }
    }

    public void removeTabs(int tabs) {
        int n;
        String[] lines = this.toStrings();
        if (lines == null || lines.length == 0) {
            return;
        }
        StringBuffer tmp = new StringBuffer();
        block0: for (n = 0; n < lines.length; ++n) {
            int num = 0;
            String line = lines[n];
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (!Character.isWhitespace(c)) {
                    if ((num -= tabs) > 0) {
                        for (int j = 0; j < num; ++j) {
                            tmp.append("\t");
                        }
                    }
                    tmp.append(line.trim()).append("\n");
                    continue block0;
                }
                ++num;
            }
        }
        this.sb.setLength(0);
        if (tmp.length() > 0) {
            lines = TextUtils.tokenize(tmp.toString(), '\n');
            for (n = 0; n < lines.length; ++n) {
                this.sb.append(lines[n]).append("\n");
            }
        }
    }
}

