/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.Animation;

import UI_Script.Rib.Animation.MultiFramer;
import UI_Script.Rib.Animation.RibBuffer;
import UI_Script.Rib.RibDocGenerator;
import UI_Script.Rib.RibScriptHandler;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.Rman.RenderInfo;
import Utilities.FinderUtils;
import Utilities.NumberUtils;
import Utilities.RegExpUtils;
import Utilities.SegmentUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Vector;
import javax.swing.text.Segment;

public class RibIterator {
    private int index;
    private int count;
    private int backindex;
    private String[] lines = null;
    private StringBuffer buf = new StringBuffer();
    private RibTokenizer ribtokernizer = new RibTokenizer();
    public static RibBuffer primaryCamera = new RibBuffer();
    public static Vector<String[]> primaryCamList = new Vector();
    public static RibBuffer secondCamera = new RibBuffer();
    public static RibBuffer archives = new RibBuffer();
    public static RibBuffer options = new RibBuffer();
    public static RibBuffer displays = new RibBuffer();
    public static RibBuffer displaychannels = new RibBuffer();
    public static RibBuffer remainder = new RibBuffer();
    public static RibBuffer shutter = new RibBuffer();
    public static RibBuffer cameraAttrs = new RibBuffer();
    public static RibBuffer ifblock = new RibBuffer();
    public static RibBuffer world = new RibBuffer();
    public static String imagerShader = "";
    public static boolean trace = false;
    public static String depthOfField = "";
    public static String bakePass = "Option \"user\" \"string pass_class\" [\"Bake\"]\n";
    public static String beautyPass = "Option \"user\" \"string pass_class\" [\"Final\"]\n";
    public static String qualityGood = "Option \"user\" \"string quality\" [\"Good\"]\n";
    public static String qualityPoor = "Option \"user\" \"string quality\" [\"Preview\"]\n";
    public static int END_OF_FRAME = 0;
    public static int FILENAME = 1;
    public static int XML_PATH_OPEN = 2;
    public static int XML_PATH_CLOSE = 3;
    public static String[] stats = new String[]{"Option \"statistics\" \"int endofframe\" [1]\n", "Option \"statistics\" \"string filename\" [\"stdout\"]\n", "Option \"statistics\" \"string xmlfilename\" [\"", "\"]\n"};
    public static String photonShadingModels = "Attribute \"photon\" \"shadingmodel\" [\"matte\"|\"translucent\"|\"chrome\"|\"glass\"|\"water\"|\"transparent\"]\n";
    public static String photonShadingModel = "Attribute \"photon\" \"shadingmodel\" [\"glass\"]\n";

    public RibIterator(String src) {
        RibTokenizer t = new RibTokenizer();
        t.setBuffer(src);
        String statement = t.getNextRibStatement();
        StringBuffer buf = new StringBuffer();
        while (!statement.equals("")) {
            buf.append(statement).append("\n");
            statement = t.getNextRibStatement();
        }
        this.lines = TextUtils.tokenize(buf.toString(), '\n');
        this.index = 0;
        this.count = this.lines.length;
        this.backindex = this.count - 1;
    }

    public void setIndex(int i) {
        this.index = i < 0 ? 0 : i;
    }

    public int getIndex() {
        return this.index;
    }

    public void trim(int n) {
        this.count -= n;
        this.count = this.count < 0 ? 0 : this.count;
    }

    public String[] peekNextLine() throws Exception {
        String[] result = this.nextLine(true);
        --this.index;
        return result;
    }

    public String[] nextLine(boolean removeComments) throws Exception {
        removeComments = true;
        if (this.index >= this.count) {
            throw new Exception("Index exceeded count. index = " + this.index + ": count = " + this.count);
        }
        String line = this.lines[this.index];
        if (line == null) {
            throw new Exception("no more lines of text");
        }
        ++this.index;
        String leadingWhiteSpace = this.getIndent(line);
        if ((line = line.trim()).length() == 0) {
            return this.nextLine(removeComments);
        }
        if (removeComments && line.startsWith("#")) {
            return this.nextLine(removeComments);
        }
        String[] result = new String[]{leadingWhiteSpace, line + "\n"};
        return result;
    }

    public String[] prevLine() throws Exception {
        if (this.backindex < 0) {
            throw new Exception("backindex less than 0");
        }
        String line = this.lines[this.backindex];
        if (line == null) {
            throw new Exception("no more lines of text");
        }
        --this.backindex;
        String leadingWhiteSpace = this.getIndent(line);
        line = line.trim();
        String[] result = new String[]{leadingWhiteSpace, line + "\n"};
        return result;
    }

    private String getIndent(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        this.buf.setLength(0);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '[') {
                return this.buf.toString();
            }
            if (Character.isLetterOrDigit(c)) {
                return this.buf.toString();
            }
            this.buf.append(c);
        }
        return "";
    }

    public static boolean isReferencingDenoiseRib(String str) {
        int quoteBegin = str.indexOf(34, 0);
        if (quoteBegin == -1) {
            return false;
        }
        int quoteEnd = str.indexOf(34, quoteBegin + 1);
        if (quoteEnd == -1) {
            return false;
        }
        String pathToArchive = str.substring(quoteBegin + 1, quoteEnd);
        return pathToArchive.endsWith("DenoiseOptions.rib");
    }

    public boolean isRibStatement(String[] strs) {
        if (strs == null || strs.length != 2 || strs[1].trim().length() == 0) {
            return false;
        }
        String[] tok = TextUtils.tokenize(strs[1].trim());
        return this.ribtokernizer.isRibStatement(tok[0]);
    }

    public boolean isTransform(String[] strs) {
        String s = strs[1];
        return s.startsWith("Translate") || s.startsWith("Rotate") || s.startsWith("Scale") || s.startsWith("Skew") || s.startsWith("Translate") || s.startsWith("ConcatTransform") || s.startsWith("Identity") || s.startsWith("MotionBegin") || s.startsWith("MotionEnd");
    }

    public boolean isAttribute(String str, String s1, String s2) {
        String[] tok = TextUtils.tokenize(str, '\"');
        return tok != null && tok.length >= 3 && tok[1].equals(s1) && tok[3].endsWith(s2);
    }

    public boolean isGeometry(String[] strs) {
        String s = strs[1];
        return s.startsWith("Geometry") || s.startsWith("HierarchicalSubdivisionMesh") || s.startsWith("SubdivisionMesh") || s.startsWith("Blobby") || s.startsWith("Curves") || s.startsWith("Points") || s.startsWith("Polygon") || s.startsWith("GeneralPolygon") || s.startsWith("PointsPolygons") || s.startsWith("PointsGeneralPolygons") || s.startsWith("Patch") || s.startsWith("PatchMesh") || s.startsWith("NuPatch") || s.startsWith("PatchMesh") || s.startsWith("Sphere") || s.startsWith("Cone") || s.startsWith("Cylinder") || s.startsWith("Hyperboloid") || s.startsWith("Paraboloid") || s.startsWith("Disk") || s.startsWith("Torus") || s.startsWith("Procedural") || s.startsWith("ReadArchive") || s.startsWith("SolidBegin") || s.startsWith("ObjectInstance");
    }

    public boolean isOption(String[] strs) {
        String s = strs[1];
        return s.startsWith("Option") || s.startsWith("Hider") || s.startsWith("PixelFilter") || s.startsWith("PixelVariance") || s.startsWith("Integrator");
    }

    public boolean isDisplayFilter(String[] strs) {
        String s = strs[1];
        return s.startsWith("DisplayFilter");
    }

    public boolean isDepthOfField(String[] strs) {
        String s = strs[1];
        return s.startsWith("DepthOfField");
    }

    public static float[] getTranslate(String[] strs) {
        String s = strs[1];
        String[] tokens = TextUtils.tokenize(s);
        if (tokens.length < 4) {
            return null;
        }
        float[] result = new float[]{(float)NumberUtils.strToDouble(tokens[1]), (float)NumberUtils.strToDouble(tokens[2]), (float)NumberUtils.strToDouble(tokens[3])};
        return result;
    }

    public float[] getYRotate(String[] strs) {
        String s = strs[1];
        if (!s.startsWith("Rotate")) {
            return null;
        }
        String[] tokens = TextUtils.tokenize(s);
        if (tokens.length < 5) {
            return null;
        }
        float y = (float)NumberUtils.strToDouble(tokens[3]);
        if ((double)y != 0.0) {
            float[] out = new float[]{(float)NumberUtils.strToDouble(tokens[1]), 0.0f};
            return out;
        }
        return null;
    }

    public String[] getPrimaryDisplay(RibBuffer buf) {
        String[] strs = buf.toStrings();
        if (strs == null || strs.length == 0) {
            return null;
        }
        String[] out = new String[3];
        for (int n = 0; n < strs.length; ++n) {
            String str = strs[n];
            String[] tokens = TextUtils.tokenize(str, " \"");
            if (tokens == null || tokens.length < 3 || tokens[1].startsWith("+")) continue;
            out[0] = tokens[1];
            out[1] = tokens[2];
            out[2] = str;
            return out;
        }
        return null;
    }

    public static void removeAll(RibBuffer ribbuf, String statement, boolean doComment) {
        RibTokenizer tokenizer = new RibTokenizer();
        Vector<String> v = new Vector<String>();
        String[] lines = ribbuf.toStrings();
        if (lines == null) {
            return;
        }
        boolean skip = false;
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n];
            int tabs = TextUtils.countTabs(line);
            String[] tokens = TextUtils.tokenize(line);
            if (line.trim().startsWith(statement)) {
                skip = true;
                if (!doComment) continue;
                v.addElement(TextUtils.getTabString(tabs) + "# " + line.trim());
                continue;
            }
            if (tokens != null && tokens.length > 0 && tokenizer.isRibStatement(tokens[0])) {
                skip = false;
            }
            if (skip) {
                if (!doComment) continue;
                v.addElement(TextUtils.getTabString(tabs) + "# " + line.trim());
                continue;
            }
            v.addElement(line);
        }
        ribbuf.reset(v);
    }

    public static void iterateCamera(Segment segment, boolean removeComments) {
        String[] strs;
        String cameraBlock = RibScriptHandler.getCameraBlock(segment);
        primaryCamera = new RibBuffer();
        primaryCamList = new Vector();
        secondCamera = new RibBuffer();
        archives = new RibBuffer();
        options = new RibBuffer();
        displays = new RibBuffer();
        displaychannels = new RibBuffer();
        remainder = new RibBuffer();
        shutter = new RibBuffer();
        cameraAttrs = new RibBuffer();
        ifblock = new RibBuffer();
        imagerShader = "";
        depthOfField = "";
        trace = false;
        RibIterator iter = new RibIterator(cameraBlock);
        int count = 0;
        Vector<String[]> tmp = new Vector<String[]>();
        boolean transformsHasBegun = false;
        try {
            while (true) {
                if ((strs = iter.prevLine())[1].trim().length() == 0 || strs[1].startsWith("#")) {
                    ++count;
                    continue;
                }
                if (iter.isTransform(strs)) {
                    transformsHasBegun = true;
                    ++count;
                    tmp.add(strs);
                    primaryCamList.addElement(strs);
                    continue;
                }
                if (!transformsHasBegun) {
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (true) {
                if ((strs = iter.nextLine(removeComments))[1].startsWith("ArchiveBegin")) {
                    while (!strs[1].startsWith("ArchiveEnd")) {
                        archives.append(strs);
                        strs = iter.nextLine(removeComments);
                    }
                    archives.append(strs);
                    continue;
                }
                if (strs[1].startsWith("Shutter")) {
                    shutter.append(strs);
                    continue;
                }
                if (strs[1].startsWith("Projection") || strs[1].startsWith("ShadingRate") || strs[1].startsWith("Format")) {
                    cameraAttrs.append(strs);
                    continue;
                }
                if (iter.isOption(strs)) {
                    options.append(strs);
                    continue;
                }
                if (strs[1].startsWith("DisplayChannel")) {
                    displaychannels.append(strs);
                    continue;
                }
                if (strs[1].startsWith("Display")) {
                    displays.append(strs);
                    continue;
                }
                if (strs[1].startsWith("IfBegin")) {
                    while (!strs[1].startsWith("IfEnd")) {
                        ifblock.append(strs);
                        strs = iter.nextLine(removeComments);
                    }
                    ifblock.append(strs);
                    continue;
                }
                if (strs[1].startsWith("Imager")) {
                    imagerShader = strs[1];
                    continue;
                }
                if (strs[1].startsWith("DepthOfField")) {
                    depthOfField = strs[1];
                    continue;
                }
                remainder.append(strs);
            }
        }
        catch (Exception exception) {
            String[] lines = options.toStrings();
            String user_renderer = RibScriptHandler.getUserOptionRenderer(lines);
            if (user_renderer == null) {
                user_renderer = RenderInfo.get(3);
            }
            Vector v = MultiFramer.getDisplayStatementsFromCB(ifblock.toString(), user_renderer);
            displays.append(v);
            Vector<String> vec = new Vector<String>();
            for (int n = 0; n < lines.length; ++n) {
                String line = lines[n];
                FinderUtils.FindDB db = FinderUtils.doFind(line, "pass_class", 0, false, true);
                if (db.absBegin != -1) continue;
                db = FinderUtils.doFind(line, "quality", 0, false, true);
                if (db.absBegin != -1) continue;
                vec.addElement(line);
            }
            options.reset(vec);
            return;
        }
    }

    public static boolean iterateWorld(Segment segment, String passType, boolean commentGeo, String[] params, boolean removeComments) {
        String worldBlock = RibScriptHandler.getWorldBlock(segment);
        world = new RibBuffer();
        boolean usesPPShader = false;
        RibIterator iter = new RibIterator(worldBlock);
        try {
            block2: while (true) {
                String[] strs;
                if ((strs = iter.nextLine(removeComments))[1].startsWith("Surface")) {
                    if (passType.equals(RibDocGenerator.PBO_PassType) || passType.equals(RibDocGenerator.BRICK_PassType) || passType.equals(RibDocGenerator.FGATHER_PassType)) {
                        strs = iter.peekNextLine();
                        while (strs[1].trim().length() == 0) {
                            strs = iter.nextLine(removeComments);
                            strs = iter.peekNextLine();
                        }
                        if (iter.isRibStatement(strs)) continue;
                        block4: while (true) {
                            if (iter.isRibStatement(strs)) continue block2;
                            strs = iter.nextLine(removeComments);
                            strs = iter.peekNextLine();
                            while (true) {
                                if (strs[1].trim().length() != 0) continue block4;
                                strs = iter.nextLine(removeComments);
                                strs = iter.peekNextLine();
                            }
                            break;
                        }
                    }
                    if (passType.equals(RibDocGenerator.SSS_PassType)) {
                        String[] tokens = TextUtils.tokenize(strs[1], '\"');
                        if (tokens.length >= 2 && (tokens[1].equals("ppMatte") || tokens[1].equals("ppAshikhminShirley") || tokens[1].equals("plausibleMatte") || tokens[1].equals("helloAS"))) {
                            usesPPShader = true;
                            if (params != null) {
                                Vector<String> out = new Vector<String>();
                                out.addElement(strs[0] + strs[1]);
                                for (int j = 0; j < params.length; ++j) {
                                    out.addElement("\t\t" + strs[0] + params[j]);
                                }
                                world.append(out);
                                continue;
                            }
                            world.append(strs);
                            continue;
                        }
                        world.append(strs);
                        continue;
                    }
                    if (passType.equals(RibDocGenerator.CPM_PassType)) {
                        String[] tokens = TextUtils.tokenize(strs[1], '\"');
                        boolean isaMatteShader = false;
                        if (tokens.length >= 2) {
                            FinderUtils.FindDB db = FinderUtils.doFind(tokens[1], "matte", 0, true, false);
                            if (db.error == null) {
                                isaMatteShader = true;
                            }
                        }
                        if (isaMatteShader) {
                            usesPPShader = true;
                            if (params == null) continue;
                            Vector<String> out = new Vector<String>();
                            out.addElement(strs[0] + strs[1]);
                            for (int j = 0; j < params.length; ++j) {
                                out.addElement("\t\t" + strs[0] + params[j]);
                            }
                            world.append(out);
                            continue;
                        }
                        world.append(strs);
                        continue;
                    }
                    world.append(strs);
                    continue;
                }
                if ((iter.isGeometry(strs) || strs[1].startsWith("\"st\"") || strs[1].startsWith("\"s\"") || strs[1].startsWith("\"t\"")) && commentGeo) {
                    world.append(strs[0], "#");
                    world.append("", strs[1]);
                    continue;
                }
                if (iter.isGeometry(strs)) {
                    if (passType.equals(RibDocGenerator.CPM_PassType)) {
                        world.append(strs[0], photonShadingModel);
                    }
                    world.append(strs);
                    continue;
                }
                if (strs[1].startsWith("Attribute")) {
                    trace = iter.isAttribute(strs[1], "visibility", "trace");
                    boolean isTransmission = iter.isAttribute(strs[1], "visibility", "transmission");
                    boolean isHitMode = iter.isAttribute(strs[1], "shade", "transmissionhitmode");
                    if (passType.equals(RibDocGenerator.PBO_PassType)) {
                        if (trace || isTransmission || isHitMode) continue;
                        world.append(strs);
                        continue;
                    }
                    world.append(strs);
                    continue;
                }
                world.append(strs);
            }
        }
        catch (Exception exception) {
            return usesPPShader;
        }
    }

    public static void addTab() {
        archives.additionalTabs(1);
        displaychannels.additionalTabs(1);
        cameraAttrs.additionalTabs(1);
        displays.additionalTabs(1);
        shutter.additionalTabs(1);
        remainder.additionalTabs(1);
        primaryCamera.additionalTabs(1);
    }

    public static void addTabToWorld() {
        world.additionalTabs(1);
    }

    public static RibBuffer removeTabs(RibBuffer item) {
        String[] strs = item.toStrings();
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < strs.length; ++n) {
            String s = strs[n].trim();
            v.addElement(s);
        }
        RibBuffer rb = new RibBuffer();
        rb.append(v);
        return rb;
    }

    public static String[] getOptions(Segment segment, boolean removeComments) {
        if (segment == null) {
            return null;
        }
        String str = segment.toString();
        int[] fBegin = null;
        Object fEnd = null;
        boolean ignoreCase = false;
        boolean wholeWord = true;
        String s = null;
        fBegin = RegExpUtils.findFirstOccuranceOf(str, "FrameBegin", ignoreCase, wholeWord);
        s = fBegin != null ? str.substring(0, fBegin[0]) : str;
        Vector<String> v = new Vector<String>();
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        RibIterator iter = new RibIterator(s);
        try {
            String[] strs = iter.nextLine(removeComments);
            while (strs != null) {
                if (iter.isOption(strs)) {
                    v.addElement(strs[0] + strs[1].trim());
                }
                strs = iter.nextLine(removeComments);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return VectorUtils.toStringArray(v);
    }

    public static String[] getFrameBlock(Segment segment) {
        if (segment == null) {
            return null;
        }
        String str = segment.toString();
        int[] fBegin = null;
        int[] fEnd = null;
        boolean ignoreCase = false;
        boolean wholeWord = true;
        fBegin = RegExpUtils.findFirstOccuranceOf(str, "FrameBegin", ignoreCase, wholeWord);
        if (fBegin == null) {
            return null;
        }
        String rem = str.substring(fBegin[1], str.length());
        if (rem == null || rem.trim().length() == 0) {
            return null;
        }
        fEnd = RegExpUtils.findFirstOccuranceOf(rem, "FrameEnd", ignoreCase, wholeWord);
        if (fEnd == null) {
            return null;
        }
        String block = rem.substring(0, fEnd[0]);
        String[] strs = TextUtils.tokenize(block, '\n');
        StringBuffer buf = new StringBuffer();
        for (int n = 1; n < strs.length; ++n) {
            buf.append(strs[n]).append("\n");
        }
        String[] result = new String[]{buf.toString(), rem.substring(fEnd[1])};
        return result;
    }

    public static String[] getFrameBlocks(Segment segment) {
        Vector<String> v = new Vector<String>();
        String[] strs = RibIterator.getFrameBlock(segment);
        while (strs != null) {
            if (strs[0] != null) {
                v.addElement(strs[0]);
            }
            Segment s = SegmentUtils.toSegment(strs[1]);
            strs = RibIterator.getFrameBlock(s);
        }
        return VectorUtils.toStringArray(v);
    }
}

