/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.Animation;

import UI_Desktop.Cutter;
import Utilities.TextUtils;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;

public class Statement {
    public static Vector<Statement> listOfStatements = new Vector();
    public String name;
    public boolean isaSecondaryDisplay = false;
    public Vector<Object> listOfParams = new Vector();
    public boolean isXFrameDenoise = false;

    public static void init() {
        listOfStatements.removeAllElements();
    }

    public static String toText() {
        String output = "";
        for (int n = 0; n < listOfStatements.size(); ++n) {
            Statement statement = listOfStatements.elementAt(n);
            output = output + "\n" + statement.name + " ";
            for (int i = 0; i < statement.listOfParams.size(); ++i) {
                Object object = statement.listOfParams.elementAt(i);
                output = object instanceof Integer ? output + (Integer)object + " " : (object instanceof Double ? output + (Double)object + " " : (object instanceof String ? output + object + " " : (object instanceof Character ? output + ((Character)object).charValue() + " " : output + "error object = " + object)));
            }
        }
        return output;
    }

    public static void replaceName(String target, String replacement, boolean ignoreCase) {
        for (int n = 0; n < listOfStatements.size(); ++n) {
            Statement statement = listOfStatements.elementAt(n);
            if (ignoreCase && statement.name.equalsIgnoreCase(target)) {
                statement.name = replacement;
                continue;
            }
            if (ignoreCase || !statement.name.equals(target)) continue;
            statement.name = replacement;
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.name).append(" ");
        for (int n = 0; n < this.listOfParams.size(); ++n) {
            Object object = this.listOfParams.elementAt(n);
            if (object instanceof Integer) {
                buff.append((Integer)object + " ");
                continue;
            }
            if (object instanceof Double) {
                buff.append((Double)object + " ");
                continue;
            }
            if (object instanceof String) {
                buff.append(object + " ");
                continue;
            }
            if (object instanceof Character) {
                buff.append(((Character)object).charValue() + " ");
                continue;
            }
            buff.append("error object = " + object);
        }
        return buff.toString();
    }

    public Statement(String name) {
        this.name = name;
        listOfStatements.addElement(this);
    }

    public boolean addParameter(String param) {
        int dataType = Tokenizer.isOfType(param);
        if (dataType == 4 && !param.equals("[") && !param.equals("]")) {
            Cutter.setLog("    Error: Statement.addParameter() - input param >" + param + "<");
            return false;
        }
        if (this.name.equals("Display") && param.startsWith("\"+")) {
            this.isaSecondaryDisplay = true;
        }
        try {
            switch (dataType) {
                case 1: {
                    if (this.name.equalsIgnoreCase("lightsource") && this.listOfParams.size() == 1) {
                        this.listOfParams.addElement(param);
                        break;
                    }
                    this.listOfParams.addElement(Integer.valueOf(param));
                    break;
                }
                case 2: {
                    this.listOfParams.addElement(Double.valueOf(param));
                    break;
                }
                case 3: {
                    this.listOfParams.addElement(param);
                    break;
                }
                case 4: {
                    this.listOfParams.addElement(Character.valueOf(param.charAt(0)));
                }
            }
        }
        catch (NumberFormatException ex) {
            Cutter.setLog("    Exception: Statement.addParameter() " + ex.toString());
            return false;
        }
        return true;
    }

    public boolean replaceParam(String target, String replacement, boolean ignoreCase) {
        boolean hit = false;
        for (int n = 0; n < this.listOfParams.size(); ++n) {
            Object param = this.listOfParams.elementAt(n);
            if (!(param instanceof String) || (!ignoreCase || !((String)param).equalsIgnoreCase(target)) && (ignoreCase || !((String)param).equals(target))) continue;
            this.listOfParams.removeElementAt(n);
            this.listOfParams.insertElementAt(replacement, n);
            hit = true;
        }
        return hit;
    }

    public boolean hasParamNamed(String name, boolean ignoreCase) {
        for (int n = 0; n < this.listOfParams.size(); ++n) {
            Object param = this.listOfParams.elementAt(n);
            if (!(param instanceof String) || (!ignoreCase || !((String)param).equalsIgnoreCase(name)) && (ignoreCase || !((String)param).equals(name))) continue;
            return true;
        }
        return false;
    }

    public String getDisplayDriver() {
        if (!this.name.equals("Display")) {
            return null;
        }
        if (this.listOfParams.size() > 1) {
            String name = (String)this.listOfParams.elementAt(1);
            return TextUtils.removeQuotes(name);
        }
        return null;
    }

    public void removeParameters() {
        this.listOfParams.removeAllElements();
    }
}

