/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.Animation;

import UI_Desktop.Cutter;
import Utilities.TextUtils;
import java.util.Vector;
import javax.swing.JOptionPane;
import kernal.Tokenizers.Tokenizer;

public class Tween {
    public static Vector<Tween> listOfTweens = new Vector();
    public static int frameToRender = -1;
    static final double MAX_GRADIENT = 3.0;
    public int index;
    public int from;
    public int to;
    public int frames;
    public double recipNumFrames;
    public double easein;
    public double easeout;
    public double ratio;
    public double a;
    public double b;
    public double c;
    public double d;
    public boolean smooth = false;
    public boolean constant = true;
    public boolean monoSegment;
    public CubicType seg1 = new CubicType();
    public CubicType seg2 = new CubicType();

    public static int totalFrames() {
        int totalFrames = 0;
        for (int n = 0; n < listOfTweens.size(); ++n) {
            totalFrames += Tween.listOfTweens.elementAt((int)n).frames;
        }
        return totalFrames;
    }

    public static void preCalc() {
        for (int n = 0; n < listOfTweens.size(); ++n) {
            Tween tween = listOfTweens.elementAt(n);
            tween.preCalcCubicCoefficients();
        }
    }

    static void printAll() {
        System.out.println("size = " + listOfTweens.size());
        for (int n = 0; n < listOfTweens.size(); ++n) {
            System.out.println(listOfTweens.elementAt(n).toString());
        }
    }

    public static void init() {
        listOfTweens.removeAllElements();
    }

    public Tween() {
        listOfTweens.addElement(this);
    }

    private int parseInt(String name, String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            str = TextUtils.removeQuotes(str);
            JOptionPane.showMessageDialog(Cutter.desktop, "The value following the Tween parameter \"" + name + "\" \nshould be a number but found \"" + str + "\"!\nA default value of " + defaultValue + " will be used instead.\nThis error can be caused by a mis-spelt \"Tween\"\nstatement.", "Number Format Error (int)", 0);
            return defaultValue;
        }
    }

    private double parseDouble(String name, String str, double defaultValue) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            str = TextUtils.removeQuotes(str);
            JOptionPane.showMessageDialog(Cutter.desktop, "The value following the Tween parameter \"" + name + "\" \nshould be a number but found \"" + str + "\"!\nA default value of " + defaultValue + " will be used instead.\nThis error can be caused by a mis-spelt \"Tween\"\nstatement.", "Number Format Error (double)", 0);
            return defaultValue;
        }
    }

    public void add(String name, String value) {
        if ((name = Tokenizer.removeQuotes(name)).equalsIgnoreCase("from")) {
            this.from = Integer.parseInt(value);
        } else if (name.equalsIgnoreCase("to")) {
            this.to = Integer.parseInt(value);
        } else if (name.equalsIgnoreCase("frames")) {
            this.frames = this.parseInt(name, value, Default.frames);
            this.recipNumFrames = 1.0 / (double)this.frames;
        } else if (name.equalsIgnoreCase("easein")) {
            this.easein = this.parseDouble(name, value, Default.easein);
            this.constant = false;
        } else if (name.equalsIgnoreCase("easeout")) {
            this.easeout = this.parseDouble(name, value, Default.easeout);
            this.constant = false;
        } else if (name.equalsIgnoreCase("output")) {
            frameToRender = Tokenizer.isOfType(value) == 3 && value.equalsIgnoreCase("\"all\"") ? -1 : this.parseInt(name, value, Default.output);
        }
    }

    public String toString() {
        return "Tween: from, to, frames, frameToRender, easein, easeout = " + this.from + ", " + this.to + ", " + this.frames + ", " + frameToRender + ", " + this.easein + ", " + this.easeout;
    }

    public static double interpolate(Tween tween, double para1, double para2, int frame) {
        double diff = para2 - para1;
        double x = 0.0;
        double yVal = 0.0;
        if (tween.constant) {
            x = ((double)frame - 1.0) * tween.recipNumFrames;
            yVal = para1 + diff * x;
        } else if (tween.smooth) {
            x = ((double)frame - 1.0) * tween.recipNumFrames;
            yVal = tween.a * (x * x * x) + tween.b * (x * x) + tween.c * x + tween.d;
            yVal = para1 + yVal * diff;
        } else if (tween.monoSegment) {
            x = ((double)frame - 1.0) * tween.recipNumFrames;
            yVal = tween.a * (x * x * x) + tween.b * (x * x) + tween.c * x + tween.d;
            yVal = para1 + yVal * diff;
        } else if (!tween.monoSegment) {
            double diffSeg1 = diff * tween.ratio;
            if ((double)(frame - 1) <= tween.seg1.numIntervals) {
                x = ((double)frame - 1.0) * tween.seg1.recipNumIntervals;
                yVal = tween.seg1.a * (x * x * x) + tween.seg1.b * (x * x) + tween.seg1.c * x + tween.seg1.d;
                yVal = para1 + yVal * diffSeg1;
            } else {
                x = ((double)(frame - 1) - tween.seg1.numIntervals) * tween.seg2.recipNumIntervals;
                yVal = tween.seg2.a * (x * x * x) + tween.seg2.b * (x * x) + tween.seg2.c * x + tween.seg2.d;
                double diffSeg2 = diff - diffSeg1;
                yVal = para1 + (diffSeg1 + yVal * diffSeg2);
            }
        }
        return yVal;
    }

    public void preCalcCubicCoefficients() {
        double y0;
        double m0 = 0.0;
        double m1 = 0.0;
        this.recipNumFrames = 1.0 / (double)(this.frames - 1);
        this.monoSegment = true;
        if (this.constant) {
            return;
        }
        if (this.easein + this.easeout > 1.0) {
            this.easeout = 1.0 - this.easein;
        }
        if (this.easein > 1.0) {
            this.easein = 1.0;
        }
        if (this.easeout > 1.0) {
            this.easeout = 1.0;
        }
        if (this.smooth) {
            y0 = 0.0;
            m1 = 0.0;
            m0 = 0.0;
            double y1 = 1.0;
        } else {
            double interval = 1.0 - (this.easeout + this.easein);
            double grad = interval <= 0.0 ? 3.0 : 1.0 / interval;
            if (grad >= 3.0) {
                grad = 3.0;
            }
            if (this.easein == 0.0 || this.easeout == 0.0) {
                this.monoSegment = true;
                if (this.easein == 0.0) {
                    m0 = grad;
                    m1 = 0.0;
                }
                if (this.easeout == 0.0) {
                    m0 = 0.0;
                    m1 = grad;
                }
                y0 = 0.0;
                double y1 = 1.0;
            } else {
                this.monoSegment = false;
                if (this.easein == this.easeout) {
                    this.ratio = 0.5;
                    this.seg1.frames = this.frames / 2;
                } else if (this.easein < this.easeout) {
                    this.ratio = Math.abs(0.5 - this.easein / this.easeout);
                    this.seg1.frames = (int)((double)this.frames * (this.easein + this.ratio * interval));
                } else {
                    this.ratio = Math.abs(1.0 - this.easeout / this.easein);
                    this.seg1.frames = (int)((double)this.frames * (this.easein + this.ratio * interval));
                }
                this.seg2.frames = this.frames - this.seg1.frames;
                this.seg1.numIntervals = (double)(this.frames - 1) * this.ratio;
                this.seg2.numIntervals = (double)(this.frames - 1) - this.seg1.numIntervals;
                this.seg1.recipNumIntervals = 1.0 / this.seg1.numIntervals;
                this.seg2.recipNumIntervals = 1.0 / this.seg2.numIntervals;
                double y02 = 0.0;
                m0 = 0.0;
                m1 = grad;
                double y1 = 1.0;
                this.seg1.a = m0 + m1 - 2.0;
                this.seg1.b = 3.0 - m1 - 2.0 * m0;
                this.seg1.c = m0;
                this.seg1.d = y02;
                m0 = grad;
                y02 = 0.0;
                m1 = 0.0;
                y1 = 1.0;
                this.seg2.a = m0 + m1 - 2.0;
                this.seg2.b = 3.0 - m1 - 2.0 * m0;
                this.seg2.c = m0;
                this.seg2.d = y02;
                return;
            }
        }
        this.a = m0 + m1 - 2.0;
        this.b = 3.0 - m1 - 2.0 * m0;
        this.c = m0;
        this.d = y0;
    }

    private class CubicType {
        public double a;
        public double b;
        public double c;
        public double d;
        public double numIntervals;
        public double recipNumIntervals;
        public int frames;

        private CubicType() {
        }
    }

    private static class Default {
        public static int output = 1;
        public static int from = 1;
        public static int to = 2;
        public static int frames = 1;
        public static double easein = 0.5;
        public static double easeout = 0.5;

        private Default() {
        }
    }
}

