/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.Parsers;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Rib.Animation.KeyFrame;
import UI_Script.Rib.Animation.RibIterator;
import UI_Script.Rib.Animation.Statement;
import UI_Script.Rib.Animation.Tween;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.Rman.Ris21RibStrings;
import Utilities.FileUtils;
import Utilities.MultiRibUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import kernal.Tokenizers.Tokenizer;

public class AnimParser
extends RibTokenizer {
    private static ResourceBundle HeaderInfoRes;
    public StringBuffer stringBuffer = new StringBuffer(1024000);
    private boolean fatalError = false;
    protected File inputFile = null;
    protected String fileNameSuffix = "";
    private String sourceName;
    private String xframeImageName;
    private boolean xframeIsActive = false;
    private static String denoise;
    private boolean debug = false;

    public static String getHeaderString(String nm) {
        String str;
        try {
            str = HeaderInfoRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public AnimParser() {
    }

    public AnimParser(File in) throws FileNotFoundException, IOException {
        super(in.getPath());
        this.inputFile = in;
    }

    public AnimParser(String buffer) {
        this.setBuffer(buffer);
    }

    @Override
    public String getNextStr() {
        String str = super.getNextStr();
        while (!str.equals("") && str.trim().startsWith("#")) {
            str = super.getNextStr();
        }
        return str;
    }

    public File[] generateSequence() {
        boolean success = true;
        int n = 1;
        if (this.scriptIsTypeOf() != 2) {
            return null;
        }
        Tween.init();
        if (this.stringBuffer == null) {
            this.stringBuffer = new StringBuffer(1024000);
        }
        this.stringBuffer.setLength(0);
        KeyFrame.init();
        this.readTweens();
        Tween.preCalc();
        this.rewindBuffer();
        this.xframeImageName = this.createXframeImageName();
        if (!this.readFromTo(null, "keyframebegin", 0)) {
            return null;
        }
        while (success) {
            success = this.readFromTo("keyframebegin", "keyframeend", n++);
        }
        if (this.fatalError) {
            this.fatalError = false;
            return null;
        }
        File outfile = this.createOutputFile(this.inputFile);
        KeyFrame.getImageName();
        if (!KeyFrame.createFrames(this.stringBuffer, false)) {
            Cutter.setLog("    Error:AnimParser.generateSequence() - KeyFrame.createFrames() unable to complete because the string buffer is too small.");
            return null;
        }
        if (this.xframeIsActive) {
            StringBuffer preamble = new StringBuffer();
            preamble.append(Ris21RibStrings.lpeOptions);
            preamble.append(Ris21RibStrings.denoiseChannels);
            preamble.append(this.stringBuffer);
            this.stringBuffer = preamble;
            int frameCount = Tween.totalFrames();
            this.stringBuffer.append("\nFrameBegin ").append(frameCount + 1).append("\n");
            String archiveName = KeyFrame.singleFrameMode ? this.saveFrameDenoiseArchive(Tween.frameToRender) : this.saveXframeDenoiseArchive();
            this.stringBuffer.append("ReadArchive \"./" + archiveName + "\"\n");
            this.stringBuffer.append("FrameEnd\n");
        }
        if (Preferences.get(Preferences.KEYFRAMER_RIB_SINGLE).equals("false")) {
            MultiRibUtils mru = new MultiRibUtils();
            File[] files = mru.multiFrameRib2MultiRibs(this.stringBuffer, true);
            return files;
        }
        try {
            FileWriter fw = new FileWriter(outfile);
            fw.write(this.stringBuffer.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: AnimParser.generateSequence()\n" + e.toString());
        }
        File[] out = new File[]{outfile};
        return out;
    }

    private String createXframeImageName() {
        Calendar calendar = Calendar.getInstance();
        return "untitled_" + calendar.get(10) + calendar.get(12) + calendar.get(13);
    }

    private String saveFrameDenoiseArchive(int frameNumber) {
        String padded = NumberUtils.intToPaddedStr(frameNumber, 4);
        String ribName = "SingleFrameDenoise.rib";
        String str = denoise;
        String userFramesPath = Preferences.get(Preferences.PATH_USER_FRAMES);
        String srcImagePath = userFramesPath + "/" + this.xframeImageName + "." + padded;
        str = str.replaceAll("(__SRC_IMAGE__)", srcImagePath);
        String filteredImagePath = userFramesPath + "/" + this.xframeImageName + "_filtered." + padded;
        str = str.replaceAll("(__FILTERED_IMAGE__)", filteredImagePath);
        File f = new File(FileUtils.getPWD(), ribName);
        FileUtils.writeFile(f, str);
        return ribName;
    }

    private String saveXframeDenoiseArchive() {
        String ribName = "XFrameDenoise.rib";
        String str = Ris21RibStrings.xframeDenoise;
        String userFramesPath = Preferences.get(Preferences.PATH_USER_FRAMES);
        str = str.replaceAll("(__IMAGE_PATH__)", userFramesPath + "/" + this.xframeImageName);
        int frameCount = Tween.totalFrames();
        StringBuffer buf = new StringBuffer();
        for (int n = 1; n <= frameCount; ++n) {
            String padded = NumberUtils.intToPaddedStr(n, 4);
            buf.append(padded);
            if (n >= frameCount) continue;
            buf.append(",");
        }
        str = str.replaceAll("(__FRAME_NUMBERS__)", buf.toString());
        String systemCall = "System \"\\\\\"\\${RMANTREE}/bin/sho\\\\\"  -dspy it ";
        buf.setLength(0);
        for (int n = 1; n <= frameCount; ++n) {
            String padded = NumberUtils.intToPaddedStr(n, 4);
            buf.append(systemCall).append(userFramesPath).append("/").append(this.xframeImageName).append("_filtered.").append(padded).append(".exr\"\n");
        }
        str = str.replaceAll("(__SHO_DSPY__)", buf.toString());
        File f = new File(FileUtils.getPWD(), ribName);
        FileUtils.writeFile(f, str);
        return ribName;
    }

    public boolean usesITDisplayDriver() {
        return KeyFrame.usesITDisplayDriver;
    }

    private File createOutputFile(File inputFile) {
        File out;
        if (inputFile == null) {
            this.sourceName = BBxt.getWindowTitle();
            String title = TextUtils.removeExtension(this.sourceName) + "_" + this.fileNameSuffix + "_" + Tween.totalFrames() + "frames.rib";
            out = BBxt.getFrontWindowFile() == null ? new File(title) : new File(BBxt.getFrontWindowFile().getParent(), title);
        } else {
            this.sourceName = inputFile.getName();
            String title = TextUtils.removeExtension(this.sourceName) + "_" + this.fileNameSuffix + "_" + Tween.totalFrames() + "frames.rib";
            out = new File(inputFile.getParent(), title);
        }
        return out;
    }

    private void writeHeader() {
        String[] lineNum = TextUtils.tokenize(AnimParser.getHeaderString("header comments"));
        String header = "";
        if (lineNum == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        String date = " " + calendar.get(2) + "." + calendar.get(5) + "." + calendar.get(1);
        String time = " " + calendar.get(10) + ":" + calendar.get(12) + ":" + calendar.get(13);
        time = calendar.get(0) == 0 ? time + " AM" : time + " PM";
        Tokenizer tok = new Tokenizer();
        for (int n = 0; n < lineNum.length; ++n) {
            String line = AnimParser.getHeaderString(lineNum[n]);
            tok.setBuffer(line);
            tok.replaceString("@DATE", date, true);
            tok.replaceString("@TIME", time, false);
            tok.replaceString("@FRAMECOUNT", " " + Tween.totalFrames(), false);
            tok.replaceString("@SOURCE", " \"" + this.sourceName + "\"", false);
            tok.replaceString("@VERSION", " " + Cutter.version, false);
            String s = new String(tok.getBuffer());
            header = header + "\n" + s.trim();
        }
        this.stringBuffer.append(header + "\n\n");
    }

    private boolean readFromTo(String fromStr, String toStr, int id) {
        boolean endOfBlock = false;
        boolean endOfParameters = false;
        String token = "";
        Statement statement = null;
        int keyFrameID = 0;
        if (fromStr != null && this.searchFor(fromStr, true) == -1) {
            return false;
        }
        token = this.getNextStr();
        if (token.equals("")) {
            return false;
        }
        if (fromStr != null) {
            try {
                keyFrameID = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "The statement KeyFrameBegin must be followed by\na unique index number.\n\nFor example, KeyFrameBegin 1\n\nBut found \"" + token + "\" instead!", "Missing KeyFrameBegin Index", 0);
                this.fatalError = true;
                return false;
            }
        }
        if (!this.isRibStatement(token) && (token = this.getNextRibStatement(null)).equals("")) {
            return false;
        }
        KeyFrame keyframe = new KeyFrame(keyFrameID);
        while (!endOfBlock) {
            if (token.equalsIgnoreCase(toStr)) {
                return true;
            }
            if (keyFrameID == 0 && token.equals("Hider")) {
                token = this.getNextRibStatement(null);
                continue;
            }
            if (keyFrameID > 0 && token.equals("WorldBegin")) {
                Statement replacementHider = new Statement("Hider");
                keyframe.addStatement(replacementHider);
                replacementHider.addParameter("\"raytrace\"");
                replacementHider.addParameter("\"int adaptall\" [0]");
                replacementHider.addParameter("\"int incremental\" [1]");
                replacementHider.addParameter("\"string pixelfiltermode\" [\"importance\"]");
                replacementHider.addParameter("\"int minsamples\" [0]");
                replacementHider.addParameter("\"int minextrasamples\" [0]");
                replacementHider.addParameter("\"int maxsamples\" [128]");
                replacementHider.addParameter("\"float darkfalloff\" [0.025]");
            }
            if (keyFrameID == 0 && token.equals("ReadArchive")) {
                int bufIndex = this.getBufferIndex();
                String param = this.getNextStr();
                if (!RibIterator.isReferencingDenoiseRib("ReadArchive " + param)) {
                    statement = new Statement("ReadArchive");
                    keyframe.addStatement(statement);
                    statement.addParameter(param);
                    token = "will_be_ignored";
                } else {
                    this.xframeIsActive = true;
                    statement = new Statement("Display");
                    keyframe.addStatement(statement);
                    String userPath = Preferences.get(Preferences.PATH_USER_FRAMES) + "/" + this.xframeImageName;
                    statement.addParameter("\"" + userPath + ".exr\"");
                    statement.addParameter("\"openexr\"");
                    statement.addParameter("\"Ci,a,mse,albedo,albedo_var,diffuse,diffuse_mse,specular,specular_mse,z,z_var,normal,normal_var,forward,backward,\"");
                    statement.addParameter("\"int asrgba\" [1] ");
                    statement.addParameter("\"string filter\" [\"gaussian\"]");
                    statement.addParameter("\"float[2] filterwidth\" [2 2]");
                    statement.addParameter("\"int[4] quantize\" [0 0 0 0]");
                    statement.addParameter("\"float dither\" [0] ");
                    statement.addParameter("\"float[2] exposure\" [1 1]");
                    statement.addParameter("\"float[3] remap\" [0 0 0]");
                    token = param;
                    continue;
                }
            }
            if (this.isRibStatement(token)) {
                statement = new Statement(token);
                keyframe.addStatement(statement);
            }
            if ((token = this.getNextStr()).equals("")) {
                return true;
            }
            if (token.equalsIgnoreCase(toStr)) {
                this.ungetString(token);
                return true;
            }
            if (this.isAnimStatement(token)) {
                while (this.isAnimStatement(token)) {
                    token = this.getNextRibStatement(toStr);
                    if (token.equalsIgnoreCase(toStr)) {
                        this.ungetString(token);
                        return true;
                    }
                    if (this.isRibStatement(token)) {
                        if (token.equalsIgnoreCase(toStr)) {
                            return true;
                        }
                        statement = new Statement(token);
                        keyframe.addStatement(statement);
                        token = this.getNextStr();
                        continue;
                    }
                    if (token.equalsIgnoreCase(toStr)) {
                        this.ungetString(token);
                        return true;
                    }
                    return false;
                }
            }
            if (!this.isRibStatement(token)) {
                endOfParameters = false;
                while (!endOfParameters) {
                    boolean innerDebug = false;
                    if (!statement.addParameter(token)) {
                        int line;
                        JOptionPane.showMessageDialog(Cutter.desktop, "Error when generating the animation sequence.\nExpected a number but found,\n\n    \"" + token + "\"\n", "Number Format Error", 0);
                        this.fatalError = true;
                        this.rewindBuffer();
                        int[] offset = this.charSearch(token, true);
                        if (offset != null && (line = BBxt.getLineNumberAtOffset(offset[0])) != -1) {
                            BBxt.hilitLineNumber(line + 1);
                        }
                        return false;
                    }
                    token = this.getNextStr();
                    if (token.equals("")) {
                        return true;
                    }
                    if (this.isRibStatement(token)) {
                        endOfParameters = true;
                        break;
                    }
                    if (token.equalsIgnoreCase(toStr)) {
                        this.ungetString(token);
                        return true;
                    }
                    if (this.isAnimStatement(token)) {
                        token = this.getNextRibStatement(toStr);
                        if (token.equals("")) {
                            return false;
                        }
                        endOfParameters = true;
                        break;
                    }
                    if (!token.equalsIgnoreCase(toStr)) continue;
                    this.ungetString(token);
                    return true;
                }
            }
            if (!token.equalsIgnoreCase(toStr)) continue;
            this.ungetString(token);
            return true;
        }
        return true;
    }

    @Override
    public int scriptIsTypeOf() {
        String token;
        boolean endOfText = false;
        boolean foundTweenStatement = false;
        boolean foundKeyFrameStatement = false;
        boolean offset = false;
        int numKeyBegin = 0;
        int numKeyEnd = 0;
        int scriptType = 1;
        this.rewindBuffer();
        if (this.searchFor("Tween", true) != -1) {
            foundTweenStatement = true;
        }
        while (!(token = this.getNextStr()).equals("")) {
            if (AnimParser.isOfType(token) != 4) continue;
            if (token.equalsIgnoreCase("keyframebegin")) {
                foundKeyFrameStatement = true;
                ++numKeyBegin;
                scriptType = 2;
                continue;
            }
            if (!token.equalsIgnoreCase("keyframeend")) continue;
            foundKeyFrameStatement = true;
            ++numKeyEnd;
            scriptType = 2;
        }
        this.rewindBuffer();
        if (scriptType == 0) {
            return 0;
        }
        if (scriptType == 2) {
            if (numKeyBegin < 2 || numKeyEnd < 2) {
                return -1;
            }
            return 2;
        }
        return 1;
    }

    private boolean isAnimStatement(String str) {
        return str.equalsIgnoreCase("tween") || str.equalsIgnoreCase("keyframebegin") || str.equalsIgnoreCase("keyframeend");
    }

    private int readTweens() {
        boolean endOfValues = false;
        boolean endOfTween = false;
        boolean findEndOf = true;
        boolean endOfText = false;
        int offset = 0;
        int numTween = 0;
        this.rewindBuffer();
        offset = this.searchFor("Tween", findEndOf);
        if (offset == -1) {
            this.rewindBuffer();
            return numTween;
        }
        while (!endOfText) {
            ++numTween;
            Tween tween = new Tween();
            String token = this.getNextStr();
            if (token.equals("")) break;
            String parameterName = token;
            if (AnimParser.isOfType(token) == 3) {
                endOfTween = false;
                block1: while (!endOfTween) {
                    endOfValues = false;
                    while (!endOfValues) {
                        token = this.getNextStr();
                        if (token.equals("")) {
                            endOfText = true;
                            endOfTween = true;
                            continue block1;
                        }
                        tween.add(parameterName, token);
                        token = this.getNextStr();
                        if (token.equalsIgnoreCase("tween")) {
                            this.ungetString(token);
                            endOfTween = true;
                            continue block1;
                        }
                        if (AnimParser.isOfType(token) == 4 && this.isRibStatement(token)) {
                            endOfValues = true;
                            endOfTween = true;
                            continue;
                        }
                        if (AnimParser.isOfType(token) == 4 && this.isAnimStatement(token)) {
                            endOfValues = true;
                            token = this.getNextStr();
                            if (AnimParser.isOfType(token) == 3) {
                                parameterName = token;
                                continue;
                            }
                            endOfText = true;
                            endOfTween = true;
                            endOfValues = true;
                            continue block1;
                        }
                        if (AnimParser.isOfType(token) != 3) continue;
                        endOfValues = true;
                        parameterName = token;
                    }
                }
            }
            if (!token.equals("") && (offset = this.searchFor("Tween", findEndOf)) != -1) continue;
        }
        this.rewindBuffer();
        return numTween;
    }

    private String getTime() {
        String s = new String();
        Calendar c = Calendar.getInstance();
        switch (c.get(2)) {
            case 0: {
                s = s + "Jan";
                break;
            }
            case 1: {
                s = s + "Feb";
                break;
            }
            case 2: {
                s = s + "Mar";
                break;
            }
            case 3: {
                s = s + "Apr";
                break;
            }
            case 4: {
                s = s + "May";
                break;
            }
            case 5: {
                s = s + "Jun";
                break;
            }
            case 6: {
                s = s + "Jul";
                break;
            }
            case 7: {
                s = s + "Aug";
                break;
            }
            case 8: {
                s = s + "Sep";
                break;
            }
            case 9: {
                s = s + "Oct";
                break;
            }
            case 10: {
                s = s + "Nov";
                break;
            }
            case 11: {
                s = s + "Dec";
            }
        }
        switch (c.get(7)) {
            case 1: {
                s = s + "Sun";
                break;
            }
            case 2: {
                s = s + "Mon";
                break;
            }
            case 3: {
                s = s + "Tue";
                break;
            }
            case 4: {
                s = s + "Wed";
                break;
            }
            case 5: {
                s = s + "Thu";
                break;
            }
            case 6: {
                s = s + "Fri";
                break;
            }
            case 7: {
                s = s + "Sat";
            }
        }
        s = s + c.get(5);
        s = s + "_";
        s = s + c.get(10);
        s = s + c.get(12);
        s = s + c.get(13);
        return s;
    }

    static {
        try {
            HeaderInfoRes = ResourceBundle.getBundle("UI_Script.Rib.Animation.Resources.HeaderInfoRsrc");
        }
        catch (MissingResourceException mre) {
            System.err.println("AnimParser - A resource file is missing --> " + mre);
        }
        denoise = "Option \"ribparse\" \"varsubst\" [\"\"]\nOption \"ribparse\" \"varsubst\" [\"$\"]\nSystem \"\\\"${RMANTREE}/bin/denoise\\\" --override gpuIndex 0 -f default.filter.json \\\"__SRC_IMAGE__.exr\\\"\"\nSystem \"\\\"${RMANTREE}/bin/sho\\\" -dspy it \\\"__SRC_IMAGE__.exr\\\"\"\nSystem \"\\\"${RMANTREE}/bin/sho\\\" -dspy it \\\"__FILTERED_IMAGE__.exr\\\"\"";
    }
}

