/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.Parsers;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.Rman.RenderInfo;
import Utilities.DocumentUtils;
import Utilities.NumberUtils;
import Utilities.Point3D;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import Utilities.TransformUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class ShadowParser
extends RibTokenizer {
    public static String STANDARD_SHADOW = "standard";
    public static String DEEP_SHADOW = "deep";
    private static StringBuffer b = new StringBuffer(1024);
    private String headerText;
    private String worldText;
    private String shadowname;
    private String shadername;
    private String lightsourceText;
    private String[] transforms = null;
    private static String userTexExt = ".tx";

    public ShadowParser(Segment buffer) {
        userTexExt = ".tx";
        this.setBuffer(buffer);
    }

    public File generateShadow(File outfile, String shadowType) {
        boolean success = true;
        boolean n = true;
        String title = null;
        b.setLength(0);
        this.transforms = null;
        if (!this.getLightSourceInfo()) {
            Cutter.setLog("   Error: ShadowParser.generateShadow() - getLightSourceInfo() returned false");
            return null;
        }
        title = this.makeShadowDoc(shadowType);
        if (title == null) {
            Cutter.setLog("    Error: ShadowParser.generateShadow() - makeShadowDoc() return null");
            return null;
        }
        if (outfile == null) {
            BBxt.newDocument(title, b);
            return null;
        }
        File parent = outfile.getParentFile();
        File out = new File(parent, title);
        try {
            FileWriter fw = new FileWriter(out);
            fw.write(b.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Cutter.setLog("   Exception: ShadowParser.generateShadow() " + e.toString());
        }
        return out;
    }

    public static String isShadowSpot() {
        String str;
        int sel_start;
        String selectedText = BBxt.getSelection();
        int selectedtextLen = BBxt.getSelectionLength();
        int original_sel_start = sel_start = BBxt.getSelectionStart();
        int beginOffset = 0;
        int endOffset = 0;
        Segment segment = BBxt.getWindowText(null);
        if (segment == null) {
            BBxt.setSelection(sel_start, sel_start);
            return null;
        }
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer(segment);
        if (selectedtextLen == 0) {
            int open = tok.find(sel_start, '\"', false);
            int close = tok.find(sel_start, '\"', true);
            if (open < 0 || close < 0) {
                BBxt.setSelection(original_sel_start, original_sel_start);
                return null;
            }
            BBxt.setSelection(open + 1, close);
        }
        sel_start = BBxt.getSelectionStart();
        int sel_end = BBxt.getSelectionEnd();
        String shadowname = BBxt.getSelection();
        if (!(shadowname.endsWith(".tx") || shadowname.endsWith(".tex") || shadowname.endsWith(".shw") || shadowname.endsWith(".dtex") || shadowname.endsWith(".rat"))) {
            BBxt.setSelection(original_sel_start, original_sel_start);
            return null;
        }
        userTexExt = shadowname.endsWith(".tex") ? ".tex" : (shadowname.endsWith(".tx") ? ".tx" : (shadowname.endsWith(".shw") ? ".shw" : (shadowname.endsWith(".dtex") ? ".dtex" : ".rat")));
        String s = segment.toString();
        int[] test = RegExpUtils.findLastOccuranceOf(s.substring(0, sel_start), "LightSource", false, true);
        if (test == null) {
            BBxt.setSelection(original_sel_start, original_sel_start);
            return null;
        }
        beginOffset = test[0];
        endOffset = test[1];
        tok.setBufferIndex(endOffset);
        while (!(str = tok.getNextStr()).equals("")) {
            if (Tokenizer.isOfType(str) != 4 || !tok.isRibStatement(str)) continue;
            endOffset = tok.getBufferIndex() - str.length();
            break;
        }
        if (--beginOffset < 0 || --endOffset < 0) {
            BBxt.setSelection(original_sel_start, original_sel_start);
            return null;
        }
        BBxt.setSelection(beginOffset, endOffset);
        String lightsourceText = BBxt.getSelection();
        BBxt.setSelection(sel_start, sel_start);
        if (TextUtils.search(true, lightsourceText, "\"shadowspot\"") || TextUtils.search(true, lightsourceText, "\"shadowspot_prman\"") || TextUtils.search(true, lightsourceText, "\"mtorSpotLight\"")) {
            return TextUtils.removeExtension(shadowname);
        }
        BBxt.setSelection(original_sel_start, original_sel_start);
        return null;
    }

    private boolean getLightSourceInfo() {
        char[] c;
        int newlineOffset;
        String str;
        String selectedText = BBxt.getSelection();
        int selectedtextLen = BBxt.getSelectionLength();
        int sel_start = BBxt.getSelectionStart();
        int beginOffset = 0;
        int endOffset = 0;
        if (selectedtextLen == 0) {
            this.transforms = this.getPrecedingTransforms(BBxt.getSelectionStart());
            int open = this.find(sel_start, '\"', false);
            int close = this.find(sel_start, '\"', true);
            if (open < 0 || close < 0) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cannot find the name of the LightSource\nshadow texture.\n\nEither double click on the name of the\nshadow texture or place the cursor within\nthe quotations containing the name of the\nshadow texture and try again.", "Error 1 -  Shadow Pass", 0);
                return false;
            }
            BBxt.setSelection(open + 1, close);
        }
        sel_start = BBxt.getSelectionStart();
        int sel_end = BBxt.getSelectionEnd();
        this.shadowname = BBxt.getSelection();
        if (!(this.shadowname.endsWith(".tx") || this.shadowname.endsWith(".tex") || this.shadowname.endsWith(".shw") || this.shadowname.endsWith(".dtex") || this.shadowname.endsWith(".rat"))) {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "The name of the LightSource shadow texture\ndoes not contain a \".tx\", \".tex\", \".shw\", \".dtex\"\nor \".rat\" extension.\n\nFor example, a shadow texture named \"spot.tx\", \n\"spot.tex\" or \"spot.shw\" would be acceptable.  ", "Naming Error - Shadow Pass", 0);
            return false;
        }
        userTexExt = this.shadowname.endsWith(".tex") ? ".tex" : (this.shadowname.endsWith(".tx") ? ".tx" : (this.shadowname.endsWith(".shw") ? ".shw" : (this.shadowname.endsWith(".dtex") ? ".dtex" : ".rat")));
        String s = new String(this.getBuffer());
        int[] test = RegExpUtils.findLastOccuranceOf(s.substring(0, sel_start), "LightSource", false, true);
        if (test == null) {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cannot find the beginning of the LightSource\nstatement.\n\nCheck the spelling of your LightSource statement\nand try again.", "Error 3 -  Shadow Pass", 0);
            return false;
        }
        int beginLightOffset = test[0];
        beginOffset = test[0];
        endOffset = test[1];
        this.setBufferIndex(endOffset);
        while (!(str = this.getNextStr()).equals("")) {
            if (Tokenizer.isOfType(str) != 4) continue;
            RibTokenizer tok = new RibTokenizer();
            tok.setBuffer(str);
            if (!tok.isRibStatement(str)) continue;
            endOffset = this.getBufferIndex() - str.length();
            break;
        }
        if (--beginOffset < 0 || --endOffset < 0) {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cannot find all the parameters of the LightSource\nstatement.\n\nRemove any LightSource statements that have been\ncommented and try again.", "Error 4 -  Shadow Pass", 0);
            return false;
        }
        BBxt.setSelection(beginOffset, endOffset);
        this.lightsourceText = BBxt.getSelection();
        this.setBufferIndex(0);
        if (!(TextUtils.search(true, this.lightsourceText, "\"shadowspot\"") || TextUtils.search(true, this.lightsourceText, "\"shadowspot_prman\"") || TextUtils.search(true, this.lightsourceText, "\"mtorSpotLight\""))) {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "Currently a shadow pass can only be automatically\ngenerated for the folowing LightSource shaders:\n     \"shadowspot\", and\n     \"shadowspot_prman\", and\n     \"mtorSpotLight\"\n\nCheck you are using one of these shaders.", "Error 5 -  Shadow Pass", 0);
            return false;
        }
        this.setBufferIndex(test[1]);
        this.shadername = TextUtils.removeQuotes(this.getNextStr());
        if (Cutter.input.debug) {
            Cutter.setLog("    Debug:ShadowParser.getLightSourceInfo() - at offset " + test[1] + "\n           specifies this light source shader " + this.shadername);
        }
        if (!(this.shadername.equals("shadowspot") || this.shadername.equals("shadowspot_prman") || this.shadername.equals("mtorSpotLight"))) {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "Currently a shadow pass can only be automatically\ngenerated for the folowing LightSource shaders:\n     \"shadowspot\", and\n     \"shadowspot_prman\", and\n     \"mtorSpotLight\"\n\nThe LightSource is using a shader named\n      " + this.shadername + "\nAlso, ensure there are no comments within the\nspecification of the light source parameters.", "Shadow Pass Error - unrecognized shader", 0);
            Cutter.setLog("    Error:ShadowParser.getLightSourceInfo() - cannot generate shadow pass.\n            Wrong shader - may be caused by a comment.");
            return false;
        }
        this.setBufferIndex(0);
        int worldBeginOffset = this.searchFor("WorldBegin", false);
        int worldEndOffset = this.searchFor("WorldEnd", true);
        if (worldBeginOffset == -1 || worldEndOffset == -1) {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "Either the WorldBegin and or the WorldEnd statements\ncannot be found.\n\nCheck the spelling of these two statements and try again.", "Error 6 -  Shadow Pass", 0);
            return false;
        }
        BBxt.setSelection(worldBeginOffset, worldEndOffset);
        this.worldText = BBxt.getSelection();
        this.setBufferIndex(0);
        int displayOffset = this.searchFor("Display", false);
        this.setBufferIndex(0);
        int projectionOffset = this.searchFor("Projection", false);
        this.setBufferIndex(0);
        int formatOffset = this.searchFor("Format", false);
        int endOfHeaderOffset = displayOffset < projectionOffset ? displayOffset : projectionOffset;
        int n = endOfHeaderOffset = formatOffset < endOfHeaderOffset ? formatOffset : endOfHeaderOffset;
        if (endOfHeaderOffset == -1) {
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "The header statements upto the \"Display\" statement\nmust be found.\n\nCheck your document contains the statements\n\"Display\", \"Format\" and \"Projection\" and try again.", "Error 7 -  Shadow Pass", 0);
            return false;
        }
        BBxt.setSelection(0, endOfHeaderOffset);
        this.headerText = BBxt.getSelection();
        this.setBufferIndex(0);
        int clippingOffset = this.searchFor("Clipping", false);
        if (clippingOffset > endOfHeaderOffset && (newlineOffset = this.findNewline(clippingOffset)) != -1 && (c = this.getBuffer(clippingOffset, newlineOffset)) != null) {
            this.headerText = this.headerText + "\n";
            this.headerText = this.headerText + new String(c);
        }
        if (this.headerText == null) {
            this.headerText = "";
        }
        BBxt.setSelection(beginLightOffset, beginLightOffset);
        this.shadowname = new File(this.shadowname).getName();
        return true;
    }

    private String makeShadowDoc(String shadowType) {
        double[] F = new double[3];
        double[] T = new double[3];
        double[] xrot = new double[1];
        double[] zrot = new double[1];
        String[] lightName = new String[1];
        Integer[] lightID = new Integer[1];
        String shadowSize = Preferences.get(Preferences.RENDERER_SHADOW_SIZE);
        double[] tforms = null;
        Point3D from = null;
        Point3D to = null;
        if (this.shadername.equals("shadowspot") || this.shadername.equals("shadowspot_prman")) {
            if (!this.extractFromTo(this.lightsourceText, F, T)) {
                Cutter.setLog("    Error:ShadowParser.makeShadowDoc() - extractFromTo() returned false.");
                return null;
            }
            if (!this.extractNameID(this.lightsourceText, lightName, lightID)) {
                Cutter.setLog("    Error:ShadowParser.makeShadowDoc() - extractNameID() returned false");
                return null;
            }
            from = new Point3D(F);
            to = new Point3D(T);
            tforms = TransformUtils.aimZ(from, to);
            if (tforms == null) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cutter is unable to generate a shadow pass\nusing the following values of the light:\n        \"from\"   " + from.toString() + "\n        \"to\"        " + to.toString() + "\nThe values of \"from\" and \"to\" must be different\notherwise the light is pointing at itself!", "Shadow Pass Error", 0);
                return null;
            }
        }
        this.shadowname = TextUtils.removeExtension(this.shadowname);
        String srcWindowName = TextUtils.removeExtension(BBxt.getWindowTitle());
        String shadStr = shadowType.equals(STANDARD_SHADOW) ? "shd" : "deepShd";
        String windowTitle = srcWindowName + "." + this.shadowname + "_" + shadStr + ".rib";
        String utp = RenderInfo.get(14).replace('\\', '/');
        if (utp.trim().equals("")) {
            utp = ".";
        }
        utp = TextUtils.trimTrailingChar(utp, '/');
        String fullpath = utp + '/' + this.shadowname + userTexExt;
        String hiderStr = "";
        String displayStr = "";
        String optionStr = "";
        String attrStr = "";
        if (shadowType.equals(STANDARD_SHADOW)) {
            hiderStr = "Hider \"hidden\" \"int jitter\" [0] \"string depthfilter\" [\"midpoint\"]\n\n";
            displayStr = "Display \"" + fullpath + "\" \"shadow\" \"z\"\n";
            if (RenderInfo.activeRendererIs("pixar")) {
                optionStr = "Option \"user\" \"string pass_class\" [\"Shadow\"]\n";
            }
            if (RenderInfo.activeRendererIs("3delight")) {
                attrStr = "Attribute \"user\" \"float ShadowMapRendering\" [1]\n";
            }
        } else {
            if (RenderInfo.activeRendererIs("pixar")) {
                optionStr = "Option \"user\" \"string pass_class\" [\"DeepShadow\"]\n";
                hiderStr = "";
                displayStr = "Display \"null\" \"null\" \"z\"\nDisplay \"+" + fullpath + "\" \"deepshad\" \"deepopacity\"\n";
            }
            if (RenderInfo.activeRendererIs("3delight")) {
                attrStr = "Attribute \"user\" \"float ShadowMapRendering\" [1]\n";
                hiderStr = "Hider \"hidden\"\n\n";
                displayStr = "Display \"" + fullpath + "\" \"dsm\" \"rgbaz\" \"string volumeinterpretation\" [\"discrete\"] # [\"continuous\"]\n";
            }
        }
        if (RenderInfo.activeRendererIs("3delight")) {
            b.append("PixelSamples 4 4\n");
        } else {
            b.append("PixelSamples 4 4\n");
        }
        b.append("PixelFilter \"box\" 1 1\n");
        b.append(hiderStr);
        String frameNumber = "1";
        String[] lines = TextUtils.tokenize(this.headerText, '\n');
        if (lines != null) {
            StringBuffer buf = new StringBuffer();
            for (int n = 0; n < lines.length; ++n) {
                String[] tok;
                String s = lines[n];
                if (s == null) continue;
                if (s.trim().startsWith("Option")) {
                    boolean doAdd = true;
                    String[] tok2 = TextUtils.tokenize(s, '\"');
                    if (tok2 != null) {
                        for (int j = 0; j < tok2.length; ++j) {
                            if (!tok2[j].trim().endsWith("pass_class") && !tok2[j].trim().endsWith("ShadowMapRendering")) continue;
                            doAdd = false;
                        }
                    }
                    if (!doAdd) continue;
                    buf.append(s).append("\n");
                    continue;
                }
                if (s.trim().startsWith("FrameBegin")) {
                    frameNumber = s.trim().substring(10);
                    continue;
                }
                if (s.trim().startsWith("IfBegin") || RenderInfo.activeRendererIs("3delight") && s.trim().startsWith("Hider") && (tok = TextUtils.tokenize(s, '\"')) != null && tok.length > 1 && tok[1].equals("stochastic") || RenderInfo.activeRendererIs("pixar") && s.trim().startsWith("Hider") && (tok = TextUtils.tokenize(s, '\"')) != null && tok.length > 1 && tok[1].equals("photon")) continue;
                buf.append(s).append("\n");
            }
            this.headerText = buf.toString();
        }
        b.append("FrameBegin " + frameNumber.trim() + "\n");
        if (!optionStr.equals("")) {
            b.append(optionStr);
        }
        b.append(this.headerText + "\n");
        b.append(displayStr);
        b.append("Projection \"perspective\" \"fov\" 65\n");
        b.append("Format " + shadowSize + " " + shadowSize + " 1\n");
        b.append("ShadingRate 1\n\n");
        if (this.shadername.equals("shadowspot") || this.shadername.equals("shadowspot_prman")) {
            b.append("Translate 0 0 " + NumberUtils.clip(tforms[2]) + "\n");
            b.append("Rotate " + (tforms[0] > 0.0 ? " " : "") + NumberUtils.clip(tforms[0]) + "   1 0 0\n");
            b.append("Rotate " + (tforms[1] > 0.0 ? " " : "") + NumberUtils.clip(tforms[1]) + "   0 1 0\n");
            b.append("Translate " + NumberUtils.clip(to.x * -1.0) + " " + NumberUtils.clip(to.y * -1.0) + " " + NumberUtils.clip(to.z) + "\n");
        }
        if (this.transforms != null) {
            String[] tokens;
            if (this.shadername.equals("mtorSpotLight")) {
                b.append("\t# mtorSpotLight: note the swapping of Translate X and Z.\n");
                for (int j = this.transforms.length - 1; j >= 0; --j) {
                    if (this.transforms[j].startsWith("Translate")) {
                        tokens = TextUtils.tokenize(this.transforms[j]);
                        if (tokens.length < 4) continue;
                        b.append("\tTranslate " + tokens[1] + " " + tokens[3] + " " + tokens[2] + "\n");
                        continue;
                    }
                    b.append("\t" + this.transforms[j]).append("\n");
                }
                b.append("\t# End mtorSpotLight transforms\n");
            } else {
                b.append("\t# shadowspot: note the negation of any Z rotations.\n");
                for (int j = this.transforms.length - 1; j >= 0; --j) {
                    if (this.transforms[j].startsWith("Rotate")) {
                        tokens = TextUtils.tokenize(this.transforms[j]);
                        if (tokens.length >= 5 && !tokens[4].equals("0")) {
                            try {
                                double rot = NumberUtils.strToDouble(tokens[1]);
                                b.append("\tRotate " + (rot *= -1.0) + " " + tokens[2] + " " + tokens[3] + " " + tokens[4] + "\n");
                            }
                            catch (Exception ex) {
                                Cutter.setLog("    Exception:ShadowParser.makeShadowDoc()\n           " + ex.toString());
                                b.append("\t").append(this.transforms[j]).append("\n");
                            }
                            continue;
                        }
                        b.append("\t").append(this.transforms[j]).append("\n");
                        continue;
                    }
                    b.append("\t").append(this.transforms[j]).append("\n");
                }
                b.append("\t# End shadowspot transforms\n");
            }
        }
        b.append("Scale 1 1 -1");
        b.append("\n");
        if (!attrStr.equals("")) {
            b.append(attrStr);
        }
        this.setBuffer(this.worldText);
        int offset = 0;
        int prevOffset = 0;
        int len = this.getBufferLength();
        int beginningOfWorld = b.length() + 1;
        while (offset < len) {
            this.setBufferIndex(offset);
            int liteIndex = this.searchFor("LightSource", false);
            this.setBufferIndex(offset);
            int colIndex = this.searchFor("Color", false);
            if (liteIndex == -1) {
                liteIndex = this.getBufferIndex();
            }
            if (colIndex == -1) {
                colIndex = this.getBufferIndex();
            }
            prevOffset = offset;
            offset = liteIndex == -1 && colIndex == -1 ? len - 1 : (liteIndex < colIndex ? liteIndex : colIndex);
            b.append(this.worldText.substring(prevOffset, offset));
            if (offset >= len) break;
            this.setBufferIndex(offset);
            this.getNextStr();
            this.getNextRibStatement(null, false);
            offset = Character.isWhitespace(this.peekPrevChar()) ? this.getBufferIndex() - 1 : this.getBufferIndex();
            if (offset == 0) {
                offset = len;
            }
            prevOffset = offset;
        }
        for (int n = beginningOfWorld; n < b.length(); ++n) {
            if (b.charAt(n) != '\n' || b.charAt(n - 1) != '\n') continue;
            b.setCharAt(n - 1, ' ');
        }
        b.append("\n");
        b.append("FrameEnd\n");
        return windowTitle;
    }

    public boolean worldToCamera(double[] from, double[] to, double[] xrot, double[] zrot) {
        double[] dir = new double[3];
        for (int i = 0; i < 3; i = (int)((short)(i + 1))) {
            dir[i] = to[i] - from[i];
        }
        if (Math.abs(dir[0]) < 1.0E-6 && Math.abs(dir[1]) < 1.0E-6 && Math.abs(dir[2]) < 1.0E-6) {
            return false;
        }
        double xylen = Math.sqrt(dir[0] * dir[0] + dir[1] * dir[1]);
        if (xylen == 0.0) {
            zrot[0] = 0.0;
            xrot[0] = dir[2] < 0.0 ? -180.0 : 0.0;
            return true;
        }
        zrot[0] = 180.0 * Math.asin(dir[0] * -1.0 / xylen) / Math.PI;
        if (dir[1] > 0.0) {
            zrot[0] = 180.0 - zrot[0];
        }
        double len = Math.sqrt(dir[2] * dir[2] + xylen * xylen);
        xrot[0] = 180.0 * Math.acos(dir[2] / len) / Math.PI;
        xrot[0] = xrot[0] * -1.0;
        return true;
    }

    private boolean extractNameID(String input, String[] lightName, Integer[] lightID) {
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer(input);
        String str = tok.getNextStr();
        if (str.equals("")) {
            return false;
        }
        if (str.equalsIgnoreCase("LightSource")) {
            str = tok.getNextStr();
            if (str.equals("")) {
                return false;
            }
            if (RibTokenizer.isOfType(str) != 3) {
                return false;
            }
            lightName[0] = new String(str);
            str = tok.getNextStr();
            if (str.equals("")) {
                return false;
            }
            if (RibTokenizer.isOfType(str) == 1) {
                lightID[0] = Integer.valueOf(str);
            }
        }
        tok = null;
        return true;
    }

    private boolean extractFromTo(String input, double[] from, double[] to) {
        String str;
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer(input);
        while (!(str = tok.getNextStr()).equals("")) {
            int n;
            if (tok.isComment(str)) {
                Cutter.setLog("    Info:ShadowParser.extractFromTo() ignoring comment " + str.trim());
                continue;
            }
            if (str.trim().startsWith("\"point")) {
                str = "\"" + str.substring(6).trim();
            }
            if (RegExpUtils.split(str, "\"from\"", false, true) != null) {
                str = tok.getNextStr();
                if (str.equals("")) {
                    tok = null;
                    return false;
                }
                if (!str.equals("[")) {
                    tok = null;
                    Cutter.setLog("    Error:ShadowParser.extractFromTo() - after \"from\" could not find '[' ");
                    return false;
                }
                for (n = 0; n < 3; n = (int)((short)(n + 1))) {
                    str = tok.getNextStr();
                    if (str.equals("")) {
                        tok = null;
                        Cutter.setLog("    Error:ShadowParser.extractFromTo() - failded to find 3 values after \"from\"");
                        return false;
                    }
                    from[n] = Double.valueOf(str);
                }
            }
            if (RegExpUtils.split(str, "\"to\"", false, true) == null) continue;
            str = tok.getNextStr();
            if (str.equals("")) {
                tok = null;
                Cutter.setLog("    Error:ShadowParser.extractFromTo() - after \"to\" could not find '[' ");
                return false;
            }
            if (!str.equals("[")) {
                tok = null;
                Cutter.setLog("    Error:ShadowParser.extractFromTo() expected [ but got >" + str + "<");
                return false;
            }
            for (n = 0; n < 3; n = (int)((short)(n + 1))) {
                str = tok.getNextStr();
                if (str.equals("")) {
                    tok = null;
                    Cutter.setLog("    Error:ShadowParser.extractFromTo() - failed to find 3 values after \"to\"");
                    return false;
                }
                to[n] = Double.valueOf(str);
            }
        }
        tok = null;
        return true;
    }

    private String[] getPrecedingTransforms(int offset) {
        String[] lines;
        Document doc = BBxt.getWindowDocument();
        if (doc == null) {
            Cutter.setLog("    Error:ShadowParser.getEnclosingBlock() couldn't get front window document.");
            return null;
        }
        int startLineNumber = BBxt.getLineNumberAtOffset(offset);
        if (startLineNumber == -1) {
            Cutter.setLog("    Error:ShadowParser.getEnclosingBlock() couldn't get line number.");
            return null;
        }
        if ((lines = DocumentUtils.getParagraphs(doc, 1, ++startLineNumber + 1)) == null) {
            Cutter.setLog("    Error:ShadowParser.getEnclosingBlock() couldn't get lines of text from 1 to " + startLineNumber);
            return null;
        }
        Vector<String> listOfTransforms = new Vector<String>();
        int blockBegin = -1;
        boolean beginSearch = false;
        for (int n = lines.length - 1; n >= 1; --n) {
            String line = lines[n].trim();
            if (line.startsWith("LightSource")) {
                beginSearch = true;
                continue;
            }
            if (!beginSearch || line.startsWith("#")) continue;
            if (line.startsWith("TransformBegin")) {
                blockBegin = n + 1;
                break;
            }
            if (line.startsWith("TransformEnd") || line.startsWith("AttributeEnd") || line.startsWith("ReverseOrientation") || line.startsWith("WorldBegin")) {
                listOfTransforms.removeAllElements();
                break;
            }
            if (!line.startsWith("Rotate") && !line.startsWith("Translate") && !line.startsWith("Scale") && !line.startsWith("Skew")) continue;
            listOfTransforms.addElement(line);
        }
        if (listOfTransforms.size() == 0) {
            return null;
        }
        return VectorUtils.toStringArray(listOfTransforms);
    }
}

