/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib.RIS;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import Utilities.FileUtils;
import Utilities.RibUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;

public class RibToTCL {
    static File mel_tmp = new File(FileUtils.getPWDFile().getPath());
    static String mel;

    static String[] fixPaths(String[] input) {
        for (int n = 0; n < input.length; ++n) {
            String line = input[n];
            if (!line.trim().startsWith("Surface") && !line.trim().startsWith("Displacement") || !TextUtils.contains(line, "\"RMSDisplacement\"", false)) continue;
            String fullpath = Preferences.get(Preferences.PATH_USER_SHADERS);
            if (fullpath.startsWith(".")) {
                fullpath = FileUtils.relativeToFull(FileUtils.getPWD(), fullpath);
            }
            fullpath = fullpath + "/RMSDisplacement";
            input[n] = TextUtils.replaceAll(line, "RMSDisplacement", fullpath, false, false);
        }
        return input;
    }

    public static String getCustomTCL(String ribText, boolean shiftIsDown) {
        Param param;
        int n;
        String value;
        Object line;
        int n2;
        String[] inputLines = TextUtils.tokenize(ribText, "\n");
        if (inputLines == null || inputLines.length == 0) {
            return "";
        }
        inputLines = RibToTCL.fixPaths(inputLines);
        RibBlock ribBlock = null;
        Vector<RibBlock> ribDB = new Vector<RibBlock>();
        for (n2 = 0; n2 < inputLines.length; ++n2) {
            line = inputLines[n2];
            if (RibUtils.beginsWithStatement((String)line)) {
                if (ribBlock != null) {
                    ribBlock.endIndex = n2 - 1;
                    ribDB.addElement(ribBlock);
                    ribBlock = null;
                }
                ribBlock = ((String)line).trim().startsWith("Pattern") && TextUtils.contains((String)line, "\"PxrOSL\"", false) ? new RibBlock(true, n2) : new RibBlock(shiftIsDown, n2);
                ribBlock.getNodeInstanceName((String)line);
            }
            if (ribBlock == null) continue;
            ribBlock.lines.add((String)line);
        }
        if (ribBlock != null) {
            ribBlock.endIndex = inputLines.length - 1;
            ribDB.addElement(ribBlock);
        }
        for (n2 = 0; n2 < ribDB.size(); ++n2) {
            line = (RibBlock)ribDB.elementAt(n2);
        }
        boolean usesOSLNodes = false;
        for (int n3 = 0; n3 < ribDB.size(); ++n3) {
            RibBlock block = (RibBlock)ribDB.elementAt(n3);
            if (!block.isOSL) continue;
            usesOSLNodes = true;
            for (int i = 1; i < block.lines.size(); ++i) {
                String[] param2;
                String[] t;
                String line2 = block.lines.elementAt(i);
                String[] tokens = TextUtils.tokenize(line2.trim(), '\"');
                if (tokens != null && tokens.length == 2) {
                    t = TextUtils.tokenize(tokens[0]);
                    if (t == null || t.length != 2) continue;
                    param2 = new String[]{t[0], t[1], tokens[1]};
                    block.addParam(param2);
                    continue;
                }
                if (tokens != null && tokens.length == 3) {
                    t = TextUtils.tokenize(tokens[0]);
                    if (t == null || t.length != 2) continue;
                    param2 = new String[]{t[0], t[1], "EMPTY_STRING"};
                    block.addParam(param2);
                    continue;
                }
                if (tokens == null || tokens.length != 4) continue;
                t = TextUtils.tokenize(tokens[0]);
                if (tokens[0].startsWith("reference")) {
                    block.addReferenceParam(line2);
                }
                if (t == null || t.length != 2) continue;
                value = tokens[2];
                String[] param3 = new String[]{t[0], t[1], value};
                block.addParam(param3);
            }
        }
        StringBuffer buf = new StringBuffer();
        if (!usesOSLNodes && (n = 0) < ribDB.size()) {
            RibBlock block = (RibBlock)ribDB.elementAt(n);
            for (int i = 0; i < block.lines.size(); ++i) {
                String line3 = block.lines.elementAt(i);
                buf.append(line3).append("\n");
            }
            return RibToTCL.getGenericTCL(buf.toString());
        }
        buf.setLength(0);
        buf.append("// SCRIPT_BEGIN\n");
        buf.append("{\n");
        buf.append("// Execute this entire MEL script in Maya's script editor (MEL tab).\n");
        for (n = 0; n < ribDB.size(); ++n) {
            RibBlock block = (RibBlock)ribDB.elementAt(n);
            if (!block.isOSL) continue;
            for (int i = 0; i < block.params.size(); ++i) {
                param = block.params.elementAt(i);
                if (param.isReferncedInput.booleanValue()) continue;
                String param_dn = block.nodeInstanceName + "_" + param.dn;
                if (param.dt.equals("int")) {
                    buf.append("addIntAttr(\"").append(param_dn).append("\",").append(param.dv).append(");\n");
                }
                if (param.dt.equals("float")) {
                    buf.append("addFloatAttr(\"").append(param_dn).append("\",").append(param.dv).append(");\n");
                    continue;
                }
                if (param.dt.trim().equals("string")) {
                    value = param.dv;
                    if (value.equals("EMPTY_STRING")) {
                        buf.append("addStringAttr(\"").append(param_dn).append("\",\"\");\n");
                        continue;
                    }
                    buf.append("addStringAttr(\"").append(param_dn).append("\",\"").append(value).append("\");\n");
                    continue;
                }
                if (!param.dt.equals("color") && !param.dt.equals("vector") && !param.dt.equals("normal")) continue;
                String values = param.dv.replace(' ', ',');
                values = values.replace('[', ' ');
                values = values.replace(']', ' ');
                if (param.dt.trim().equals("color")) {
                    buf.append("addColorAttr(\"").append(param_dn).append("\",").append(values).append(");\n");
                    continue;
                }
                buf.append("addVectorAttr(\"").append(param_dn).append("\",").append(values).append(");\n");
            }
        }
        buf.append("}\n");
        buf.append(mel);
        BBxt.newDocument("untitled.mel", buf.toString());
        buf.setLength(0);
        buf.append("# Save this TCL script in the Maya project directory that will\n");
        buf.append("# use your OSL shader. Make sure the OSL shader is also in the\n");
        buf.append("# project directory.\n\n");
        buf.append("proc lookgen { objname } {").append("\n");
        for (n = 0; n < ribDB.size(); ++n) {
            RibBlock block = (RibBlock)ribDB.elementAt(n);
            if (!block.isOSL) continue;
            for (int i = 0; i < block.params.size(); ++i) {
                param = block.params.elementAt(i);
                if (param.isReferncedInput.booleanValue()) continue;
                String node_dn = block.nodeInstanceName + "_" + param.dn;
                buf.append("\tset ").append(node_dn).append(" [mel \"getAttr $objname.").append(node_dn).append("\"]\n");
            }
        }
        buf.append("\n");
        StringBuffer b = new StringBuffer();
        for (int n4 = 0; n4 < ribDB.size(); ++n4) {
            RibBlock block = (RibBlock)ribDB.elementAt(n4);
            b.append(block.toTclString(block.nodeInstanceName));
        }
        buf.append(RibToTCL.getProcBody(b.toString()));
        buf.append(RibToTCL.getPostHints());
        return buf.toString();
    }

    static String getGenericTCL(String ribText) {
        String[] lines = TextUtils.tokenize(ribText, "\n");
        if (lines == null || lines.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("# Save this TCL script in the Maya project directory that will\n");
        buf.append("# use your OSL shader. Make sure the OSL shader is also in the\n");
        buf.append("# project directory.\n\n");
        buf.append("proc lookgen { objname } {").append("\n");
        buf.append(RibToTCL.getGenericHints());
        buf.append(RibToTCL.getProcBody(ribText));
        buf.append(RibToTCL.getPostHints());
        return buf.toString();
    }

    private static String addEscapes(String line) {
        StringBuffer b = new StringBuffer();
        for (int j = 0; j < line.length(); ++j) {
            char c = line.charAt(j);
            if (c == '\"' || c == '[' || c == ']') {
                b.append("\\");
            }
            b.append(c);
        }
        return b.toString();
    }

    private static String getProcBody(String ribText) {
        StringBuffer buf = new StringBuffer();
        String[] lines = TextUtils.tokenize(ribText, "\n");
        if (lines == null || lines.length == 0) {
            return "";
        }
        buf.append("\t").append("set rib \"\"").append("\n");
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n].trim();
            buf.append("\t").append("append rib \"");
            if (!RibUtils.beginsWithStatement(line)) {
                buf.append("\t");
            }
            for (int j = 0; j < line.length(); ++j) {
                char c = line.charAt(j);
                if (c == '\"' || c == '[' || c == ']') {
                    buf.append("\\");
                }
                buf.append(c);
            }
            buf.append("\\n\"").append("\n");
        }
        buf.append("\t").append("return $rib").append("\n");
        buf.append("\t").append("}").append("\n");
        return buf.toString();
    }

    private static String getGenericHints() {
        StringBuffer buf = new StringBuffer();
        buf.append("\t").append("# Example of how to get and use an attribute value").append("\n");
        buf.append("\t").append("# set freq [mel \"getAttr $objname.freq\"]").append("\n");
        buf.append("\t").append("# append rib \"\\\"float freq\\\" $freq \\").append("n\"").append("\n");
        return buf.toString();
    }

    private static String getPostHints() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        buf.append("# Edit FILENAME so that it matches the name of this TCL document.\n");
        buf.append("# Copy the text to the RIB Box in Maya then remove the comments.\n\n");
        buf.append("#---- snip ----- snip ---- snip ----\n");
        buf.append("#[").append("\n");
        buf.append("#source [file join $RMSPROJ FILENAME.tcl]").append("\n");
        buf.append("#set rib [lookgen $OBJNAME]").append("\n");
        buf.append("#return $rib").append("\n");
        buf.append("#]").append("\n");
        buf.append("#---- snip ----- snip ---- snip ----\n");
        return buf.toString();
    }

    static {
        mel_tmp = new File(mel_tmp, "Cutter_Help");
        mel_tmp = new File(mel_tmp, "rman_tool_docs");
        mel_tmp = new File(mel_tmp, "mel");
        mel_tmp = new File(mel_tmp, "addAttrs.mel");
        mel = FileUtils.read(mel_tmp);
    }

    static class RibBlock {
        private boolean isOSL = false;
        private int beginIndex = -1;
        public int endIndex = -1;
        public Vector<String> lines = new Vector();
        public Vector<Param> params = new Vector();
        public String nodeInstanceName = null;

        public RibBlock(boolean flag, int index) {
            this.isOSL = flag;
            this.beginIndex = index;
        }

        public void getNodeInstanceName(String line) {
            line = line.trim();
            String[] tokens = TextUtils.tokenize(line);
            if (line.startsWith("Bxdf") || line.startsWith("Pattern") || line.startsWith("LightSource") || line.startsWith("AreaLightSource")) {
                if (tokens == null || tokens.length < 3) {
                    return;
                }
                this.nodeInstanceName = TextUtils.removeQuotes(tokens[2]);
            }
            if (line.startsWith("Surface")) {
                if (tokens == null || tokens.length < 2) {
                    return;
                }
                String maybeFullPath = TextUtils.removeQuotes(tokens[1]);
                if ((tokens = TextUtils.tokenize(maybeFullPath, "/")) == null) {
                    return;
                }
                this.nodeInstanceName = tokens[tokens.length - 1];
            }
            if (this.nodeInstanceName == null) {
                return;
            }
            char first = this.nodeInstanceName.charAt(0);
            if (Character.isLowerCase(first)) {
                this.nodeInstanceName = Character.toUpperCase(first) + this.nodeInstanceName.substring(1);
            }
        }

        public void addParam(String[] param) {
            param[2] = param[2].trim();
            if (param[2].startsWith("[") && param[2].endsWith("]")) {
                param[2] = param[2].substring(1, param[2].length() - 1);
            }
            this.params.add(new Param(param, this.nodeInstanceName));
        }

        public void addReferenceParam(String refparam) {
            this.params.add(new Param(refparam));
        }

        public String toString() {
            int n;
            StringBuffer b = new StringBuffer();
            b.append("isOSL: ").append(this.isOSL).append("\n");
            b.append("Start: ").append(this.beginIndex).append(" End: ").append(this.endIndex).append("\n");
            for (n = 0; n < this.lines.size(); ++n) {
                b.append(this.lines.elementAt(n)).append("\n");
            }
            for (n = 0; n < this.params.size(); ++n) {
                Param param = this.params.elementAt(n);
                b.append(param.dt).append(" ").append(param.dn).append(" ").append(param.dv).append("\n");
            }
            return b.toString();
        }

        public String toTclString(String nodeInstanceName) {
            StringBuffer b = new StringBuffer();
            b.append(this.lines.elementAt(0)).append("\n");
            if (!this.isOSL) {
                for (int n = 1; n < this.lines.size(); ++n) {
                    b.append(this.lines.elementAt(n)).append("\n");
                }
            } else {
                for (int n = 0; n < this.params.size(); ++n) {
                    Param param = this.params.elementAt(n);
                    if (param.isReferncedInput.booleanValue()) {
                        b.append(param.literalText).append("\n");
                        continue;
                    }
                    if (param.dt.equals("string")) {
                        b.append("\"").append(param.dt).append(" ").append(param.dn).append("\" [\"").append(param.tclVar).append("\"]\n");
                        continue;
                    }
                    b.append("\"").append(param.dt).append(" ").append(param.dn).append("\" [").append(param.tclVar).append("]\n");
                }
            }
            return b.toString();
        }
    }

    static class Param {
        Boolean isReferncedInput = false;
        String literalText = null;
        String dt = null;
        String dn = null;
        String dv = null;
        String tclVar = null;

        public Param(String[] arr, String nodeInstanceName) {
            this.dt = arr[0].trim();
            this.dn = arr[1].trim();
            this.dv = arr[2].trim();
            this.tclVar = nodeInstanceName == null ? "$" + this.dn : "$" + nodeInstanceName + "_" + this.dn;
        }

        public Param(String ref) {
            this.isReferncedInput = true;
            this.literalText = ref;
        }
    }
}

