/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import Utilities.RibUtils;
import Utilities.TextUtils;
import Utilities.TransformUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ReformatStatementAction
extends AbstractAction {
    private static String[] validRibStatements = new String[]{"Surface", "Displacement", "Attribute", "AreaLightSource", "Procedural2", "LightSource", "Shader", "Imager", "Volume", "Procedural", "Display", "Option", "ConcatTransform", "Transform", "Pattern", "Bxdf", "Hider", "Integrator", "Light", "Displace"};
    private KTextPane textpane;
    private String formatAction = "reformat";
    private String ribStatement;

    public static boolean canBeReformatted(String statement) {
        for (int n = 0; n < validRibStatements.length; ++n) {
            if (!statement.equals(validRibStatements[n])) continue;
            return true;
        }
        return false;
    }

    public ReformatStatementAction(KTextPane textpane, String shadertype, String formataction) {
        this.textpane = textpane;
        this.formatAction = formataction;
        this.ribStatement = shadertype;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int begin = BBxt.getSelectionStart();
        int end = BBxt.getSelectionEnd();
        String sel = BBxt.getSelection();
        if (this.formatAction.equals("Convert To Multi Line")) {
            this.convertToMultiLine(sel, begin, end, this.textpane);
        } else {
            this.convertToSingleLine(sel, begin, end, this.textpane);
        }
    }

    private void convertToSingleLine(String statement, int begin, int end, KTextPane textpane) {
        int len = textpane.getDocument().getLength() - end;
        RibUtils r = new RibUtils();
        RibUtils.ParamBlock pblock = r.getParamBlock(textpane, statement, end);
        String text = this.ribStatement.equals("Transform") || this.ribStatement.equals("ConcatTransform") ? pblock.getParamsAsMatrixStr() : pblock.getParamsAsPlainStr();
        BBxt.setSelection(pblock.paramBeginOffset, pblock.paramEndOffset);
        BBxt.replaceSelection(" " + text);
        BBxt.setSelection(begin, begin);
    }

    private void convertToMultiLine(String statement, int begin, int endOfStatement, KTextPane textpane) {
        RibUtils ributils = new RibUtils();
        RibUtils.ParamBlock pblock = ributils.getParamBlock(textpane, statement, endOfStatement);
        if (pblock == null) {
            Cutter.setLog("    Error:ReformatStatementAction.convertToMultiLine() - can't find parameters for \"" + statement + "\"");
            return;
        }
        if (this.ribStatement.equals("Transform") || this.ribStatement.equals("ConcatTransform")) {
            int n;
            String[] lines = TransformUtils.reformatTransformMatrix(pblock.params[0]);
            if (lines == null || lines.length == 0) {
                Cutter.setLog("    Error:ReformatStatementAction.convertToMultiLine() - pblock.params[0]\n");
                Cutter.setLog("            \"" + pblock.params[0] + "\"");
                return;
            }
            StringBuffer b = new StringBuffer();
            StringBuffer t = new StringBuffer();
            for (n = 0; n < pblock.leadingTabs + 2; ++n) {
                t.append('\t');
            }
            for (n = 0; n < lines.length; ++n) {
                b.append(t.toString()).append(lines[n]).append('\n');
            }
            BBxt.setSelection(pblock.paramBeginOffset, pblock.paramEndOffset);
            String str = TextUtils.trimTrailingChar(b.toString(), '\n');
            BBxt.replaceSelection("\n" + str);
            return;
        }
        BBxt.setSelection(pblock.paramBeginOffset, pblock.paramEndOffset);
        BBxt.replaceSelection("\n" + pblock.getParamesAsIndentedBlock(1, 0));
    }
}

