/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Rib.Animation.RibIterator;
import UI_Script.Rib.RibTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.RenderInfo;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.FinderUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.text.Segment;

public class RibDocGenerator {
    private static String RIB_ROOT_DIR = "rman_tool_docs";
    private static String RIB_DIR = "rib";
    private static String DECLARE_DATATYPES_DIR = "declare_datatypes";
    private static String INLINE_DATATYPES_DIR = "inline_datatypes";
    private static String OMIT_DATATYPES_DIR = "omit_datatypes";
    public static String CLASSIC_BEAUTY_RIB = "classic_beauty.rib";
    public static String PLAUSIBLE_BEAUTY_RIB = "plausible_beauty.rib";
    public static String SSS_PassType = "SSS_PassType";
    public static String CPM_PassType = "CPM_PassType";
    public static String PBO_PassType = "PBO_PassType";
    public static String BRICK_PassType = "BRICK_PassType";
    public static String FGATHER_PassType = "FGATHER_PassType";
    public static boolean DO_NOT_REPLACE_OPTIONS = true;
    private static ResourceBundle ribdocRes;
    private static File inline_datatype_dir;
    private static File declare_datatype_dir;
    private static File omit_datatype_dir;
    protected static StringBuffer newDocBuffer;
    private static int stereoCounter;

    public static String getDocString(String nm) {
        String str = null;
        try {
            str = ribdocRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        if (str != null) {
            return str;
        }
        return str;
    }

    protected static boolean usesPlausible(Segment segment) {
        boolean isPP = false;
        FinderUtils.FindDB db = FinderUtils.doFind(segment.toString(), "ppAreaLight", 0, false, true);
        if (db.absBegin != -1) {
            isPP = true;
        }
        if (!isPP) {
            db = FinderUtils.doFind(segment.toString(), "ppHeadLight", 0, false, true);
        }
        if (db.absBegin != -1) {
            isPP = true;
        }
        return isPP;
    }

    public static void createDocument(String title, String docType) {
        RibDocGenerator.createDocument(false, title, docType);
    }

    private static String[] getRibFromHelp(String ribtype) {
        String datatype_style = "omit";
        if (RenderInfo.get(18).equals("declare")) {
            datatype_style = "declare";
        } else if (RenderInfo.get(18).equals("inline")) {
            datatype_style = "inline";
        }
        File f = null;
        if (ribtype.equals(CLASSIC_BEAUTY_RIB)) {
            f = datatype_style.equals("declare") ? new File(declare_datatype_dir, CLASSIC_BEAUTY_RIB) : (datatype_style.equals("inline") ? new File(inline_datatype_dir, CLASSIC_BEAUTY_RIB) : new File(omit_datatype_dir, CLASSIC_BEAUTY_RIB));
        }
        if (ribtype.equals(PLAUSIBLE_BEAUTY_RIB)) {
            f = datatype_style.equals("declare") ? new File(declare_datatype_dir, PLAUSIBLE_BEAUTY_RIB) : (datatype_style.equals("inline") ? new File(inline_datatype_dir, PLAUSIBLE_BEAUTY_RIB) : new File(omit_datatype_dir, PLAUSIBLE_BEAUTY_RIB));
        }
        if (f == null || !f.exists()) {
            return null;
        }
        String text = FileUtils.read(f);
        StringTokenizer t = new StringTokenizer(text, "\n");
        Vector<String> v = new Vector<String>();
        while (t.hasMoreTokens()) {
            String str = t.nextToken();
            v.addElement(str);
        }
        return VectorUtils.toStringArray(v);
    }

    public static void createDocument(boolean includeVendor, String title, String docType) {
        String[] lineItems = RibDocGenerator.getRibFromHelp(docType);
        newDocBuffer.setLength(0);
        if (docType.equals(CLASSIC_BEAUTY_RIB) || docType.equals(PLAUSIBLE_BEAUTY_RIB)) {
            if (RenderInfo.activeRendererIs("pixar")) {
                newDocBuffer.append(RibIterator.beautyPass);
                newDocBuffer.append("#").append(RibIterator.qualityPoor);
            }
            newDocBuffer.append(RenderInfo.getOption("ribparse", ""));
            String rmspath = Preferences.get(Preferences.PATH_PIXAR_RMS);
            if (rmspath.trim().length() > 0) {
                rmspath = rmspath.replace('\\', '/');
                rmspath = TextUtils.trimTrailingChar(rmspath, '/');
                newDocBuffer.append("IfBegin \"!defined(RMSTREE)\"\n");
                newDocBuffer.append("\tOption \"user\" \"string RMSTREE\" [\"" + rmspath + "/\"]\n");
                newDocBuffer.append("IfEnd\n");
            } else {
                Cutter.setLog("    Warning:RibDocGenerator.createDocument() - no path to RMSTREE");
            }
            newDocBuffer.append(RenderInfo.getOption("searchpath", "shader"));
            if (!docType.equals(CLASSIC_BEAUTY_RIB) && !docType.equals(PLAUSIBLE_BEAUTY_RIB)) {
                newDocBuffer.append(RenderInfo.getOption("searchpath", "rixplugin"));
            }
            newDocBuffer.append(RenderInfo.getOption("searchpath", "texture"));
            newDocBuffer.append(RenderInfo.getOption("searchpath", "archive"));
            boolean ribForSLRequired = false;
            for (int n = 0; n < lineItems.length; ++n) {
                String line = lineItems[n] + "\n";
                if (!includeVendor) {
                    if (TextUtils.contains(line, "Display", true) && RenderInfo.activeRendererIs("pixar")) {
                        newDocBuffer.append("\nDisplay \"untitled\" \"it\" \"rgba\"\n");
                        continue;
                    }
                    if (TextUtils.contains(line, "Display", true) && RenderInfo.activeRendererIs("3delight")) {
                        newDocBuffer.append("\nDisplay \"untitled\" \"idisplay\" \"rgba\"\n\n");
                        continue;
                    }
                }
                if (TextUtils.contains(line, "Format", true)) {
                    String[] tokens;
                    String fs = Preferences.get(Preferences.FRAME_SIZE);
                    if (fs == null || (tokens = TextUtils.tokenize(fs = fs.trim())).length != 2) continue;
                    newDocBuffer.append("Format ").append(fs).append(" 1\n");
                    continue;
                }
                if (TextUtils.contains(line, "Display", true) && includeVendor && (RenderInfo.activeRendererIs("pixar") || RenderInfo.activeRendererIs("3delight"))) {
                    String cmd = RenderInfo.activeNameOfRenderer();
                    if (cmd.equals("pixar")) {
                        cmd = "prman";
                    }
                    if (cmd.equals("3delight")) {
                        cmd = "renderdl";
                    }
                    newDocBuffer.append("Option \"user\" \"string renderer\" [\"" + cmd + "\"]\n");
                    newDocBuffer.append("\nIfBegin \"$user:renderer == 'prman'\"\n");
                    newDocBuffer.append("\tDisplay \"untitled\" \"it\" \"rgba\"\n");
                    newDocBuffer.append("Else\n");
                    newDocBuffer.append("\tDisplay \"untitled\" \"idisplay\" \"rgba\"\n");
                    newDocBuffer.append("IfEnd\n\n");
                    continue;
                }
                newDocBuffer.append(line);
                if (!TextUtils.contains(line, "WorldBegin", true) || !RenderInfo.get(2).equalsIgnoreCase("bmrt")) continue;
                newDocBuffer.append("\tAttribute \"render\" \"truedisplacement\" [1]\n");
                newDocBuffer.append("\tAttribute \"render\" \"string casts_shadows\" [\"shade\"]\n");
                newDocBuffer.append("\tDeclare \"shadows\" \"string\" \n");
                newDocBuffer.append("\tAttribute \"light\" \"shadows\" \"on\"\n");
            }
        }
    }

    protected static Segment preProcess(Segment segment) {
        return null;
    }

    public static boolean replaceOptions(KTextPane textpane) {
        if (textpane == null) {
            return true;
        }
        if (DO_NOT_REPLACE_OPTIONS) {
            return true;
        }
        Segment segment = DocumentUtils.getSegment(textpane.getDocument(), 0, textpane.getDocument().getLength());
        RibTokenizer tok = new RibTokenizer();
        String[] so = TextUtils.tokenize(RenderInfo.getOption("searchpath", "shader"), "\"");
        String[] to = TextUtils.tokenize(RenderInfo.getOption("searchpath", "texture"), "\"");
        boolean replaced = false;
        if (so == null || to == null) {
            return false;
        }
        String shaderPath = so[so.length - 1] == null ? "" : so[so.length - 1];
        String texturePath = to[to.length - 1] == null ? "" : to[to.length - 1];
        shaderPath = TextUtils.removeQuotes(shaderPath);
        texturePath = TextUtils.removeQuotes(texturePath);
        tok.setBuffer(segment);
        int[] offset = tok.charSearch("Option", false);
        if (offset != null) {
            Segment seg = BBxt.getWindowText(offset[0]);
            String[] token = TextUtils.tokenize(seg.toString(), "\"");
            for (int n = 0; n < token.length; ++n) {
                int[] lineOffset;
                if (token[n].equals("shader") && n + 1 <= token.length - 1 && !token[n + 1].equals(shaderPath)) {
                    lineOffset = DocumentUtils.getElementOffsets(textpane.getDocument(), offset[0]);
                    BBxt.setSelection(lineOffset[1], lineOffset[2]);
                    BBxt.paste(RenderInfo.getOption("searchpath", "shader"));
                    replaced = true;
                }
                if (!token[n].equals("texture") || n + 1 > token.length - 1 || token[n + 1].equals(texturePath)) continue;
                lineOffset = DocumentUtils.getElementOffsets(textpane.getDocument(), offset[0]);
                BBxt.setSelection(lineOffset[1], lineOffset[2]);
                BBxt.paste(RenderInfo.getOption("searchpath", "texture"));
                replaced = true;
            }
        }
        return replaced;
    }

    private static void nullWindowFileError() {
        Cutter.setLog("RmanTool.newDocWithText() - BBxt.getWindowFile() return null");
        JOptionPane.showMessageDialog(KDesktop.desktopPane, "Please save your document before continuing.", "Document Not Saved Error", 0);
    }

    private static void nullSLNameError() {
        Cutter.setLog("RmanTool.newDocWithText() - BBxt.slGetShaderName() return null");
        JOptionPane.showMessageDialog(KDesktop.desktopPane, "Please ensure your document is the active window by clicking on its title bar", "Document Not Selected Error", 0);
    }

    protected static String getTraceAttributes() {
        StringBuffer b = new StringBuffer();
        b.append("\t\tAttribute \"visibility\" \"int diffuse\" 1   # make objects visible for raytracing\n");
        b.append("\t\tAttribute \"visibility\" \"int specular\" 1\n");
        b.append("\t\tAttribute \"visibility\" \"int transmission\" 1\n");
        b.append("\t\tAttribute \"shade\" \"string transmissionhitmode\" \"primitive\"\n");
        b.append("\t\tAttribute \"trace\" \"bias\" 0.01\n");
        b.append("\t\tAttribute \"trace\" \"displacements\" 1\n");
        return b.toString();
    }

    protected static String getCullAttributes() {
        StringBuffer b = new StringBuffer();
        b.append("\t\tAttribute \"cull\" \"hidden\" 0       # don't cull hidden surfaces\n");
        b.append("\t\tAttribute \"cull\" \"backfacing\" 0   # don't cull backfacing surfaces\n");
        b.append("\t\tAttribute \"dice\" \"rasterorient\" 0 # turn viewdependent gridding off\n");
        return b.toString();
    }

    protected static String pathToOutputDir(int flag) {
        File tdir;
        String tpath = RenderInfo.get(flag);
        if (tpath.trim().length() == 0) {
            tdir = FileUtils.getPWDFile();
        } else {
            tdir = tpath.startsWith(".") ? FileUtils.resolveRelativePath(FileUtils.getPWDFile(), tpath) : new File(tpath);
            if (!tdir.exists()) {
                tdir = FileUtils.getPWDFile();
            }
        }
        return tdir.getPath().replace('\\', '/');
    }

    static {
        inline_datatype_dir = null;
        declare_datatype_dir = null;
        omit_datatype_dir = null;
        try {
            ribdocRes = ResourceBundle.getBundle("UI_Script.Rib.RibDocumentsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Exception:RibDocGenerator: a resource file is missing --> " + mre);
        }
        File f = new File(FileUtils.getPWDFile(), "Cutter_Help");
        f = new File(f, RIB_ROOT_DIR);
        File rib_dir = new File(f, RIB_DIR);
        inline_datatype_dir = new File(rib_dir, INLINE_DATATYPES_DIR);
        declare_datatype_dir = new File(rib_dir, DECLARE_DATATYPES_DIR);
        omit_datatype_dir = new File(rib_dir, OMIT_DATATYPES_DIR);
        newDocBuffer = new StringBuffer(1024);
        stereoCounter = 1;
    }
}

