/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.Url;
import UI_Script.Rib.Parsers.ShadowParser;
import UI_Script.Rib.RIS.RibToTCL;
import UI_Script.Rib.ReformatStatementAction;
import UI_Script.Rib.RibTokenizer;
import UI_Script.Rib.StringsAttributes;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Monitor.Monitor;
import UI_Tools.Rman.RIS.OslShaderReader;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Ris21PluginArgsReader;
import UI_Tools.Rman.Ris21RibStrings;
import UI_Tools.Rman.Tabs.Rib.RenderManager;
import UI_Tools.Rman.Tabs.Rib.RibTabPanel;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.NumberUtils;
import Utilities.RegExpUtils;
import Utilities.RibUtils;
import Utilities.SegmentUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class RibHelp
extends KAbstractHelp
implements ProcListener {
    protected static KAbstractHelp ribhelp = null;
    protected static String sysDocsShadersPath;
    protected static String ext;
    protected static String toc;
    private static String SHADER_DOCS_NOT_FOUND_URL;
    static String[] fileTypes;
    private static Hashtable<String, String> languageTable;
    private static Hashtable<String, String> osoTable;
    private static String[] integrators;
    private static OslShaderReader osr;
    private static Ris21PluginArgsReader argsReader;
    public static final String REFORMAT_DOC = "Apply Indentation";
    public static final String CONVERT_TO_TCL = "Export as MEL & TCL";
    private Hashtable candidatesTable = languageTable;
    private String[][] attrCandidatesList = null;
    private ShadowParser parser = null;
    private File shadowFile = null;
    private String shadowName = null;
    private File ptcFile = null;
    public static final String TO_MULTILINE = "Convert To Multi Line";
    public static final String TO_SINGLELINE = "Convert To Single Line";

    public RibHelp(KTextPane textpane) {
        super(textpane);
        RibHelp.initPaths();
        RenderInfo.addListener(this);
        this.completer.completionActivate();
        this.completer.setListeners(textpane, this);
        char[] delims = new char[]{'\n', '\t', ' ', '\"'};
        this.completer.setWordStartDelims(delims);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        this.candidatesTable = languageTable;
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        String first = this.completer.getFirstWordOnTargetLine();
        if (first.equals("Attribute") && !str.equals("Attribute") && Character.isLowerCase(str.charAt(0))) {
            this.attrCandidatesList = StringsAttributes.subnames;
            for (int n = 0; n < this.attrCandidatesList.length; ++n) {
                String key = this.attrCandidatesList[n][0];
                if (!key.startsWith(str)) continue;
                return true;
            }
            return false;
        }
        this.attrCandidatesList = null;
        if ((str.startsWith("Px") || str.startsWith("px")) && str.trim().length() < 4) {
            return false;
        }
        return str.length() >= 3;
    }

    @Override
    public void completionHappenedAt(String str, int offset) {
        if (this.attrCandidatesList != null) {
            String nextStr = this.textpane.getCharAt(offset);
            if (nextStr == null || !nextStr.equals("\"")) {
                return;
            }
            try {
                this.textpane.getDocument().remove(offset, 1);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception: RibHelp.completionHappenedAt() - " + ex.toString());
            }
        } else {
            Ris21PluginArgsReader.PluginArgsDB plug = null;
            Ris21PluginArgsReader.PluginArgsDB[] plugs = Ris21PluginArgsReader.getAllPlugins();
            int strLen = str.length();
            for (int n = 0; n < plugs.length; ++n) {
                if (!plugs[n].name.equals(str)) continue;
                plug = plugs[n];
                break;
            }
            String plugText = null;
            int tabCount = DocumentUtils.countTabStopsAtOffset(this.textpane.document, offset);
            if (plug != null) {
                plugText = this.handleSpecialCompletions(plug, tabCount);
            } else if (osoTable.containsKey(str.toLowerCase())) {
                plugText = osr.getRibDeclaration(osoTable.get(str.toLowerCase()) + ".oso");
            }
            if (plugText == null) {
                return;
            }
            try {
                if (offset >= strLen) {
                    this.textpane.getDocument().remove(offset - strLen, strLen);
                    this.textpane.getDocument().insertString(offset - strLen, plugText, null);
                }
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception: RibHelp.completionHappenedAt() - " + ex.toString());
            }
        }
    }

    private String handleSpecialCompletions(Ris21PluginArgsReader.PluginArgsDB plugin, int tabCount) {
        if (plugin.name.equals("PxrSurface")) {
            Vector<Ris21PluginArgsReader.PluginArgsDB> basicPxrSurface = new Vector<Ris21PluginArgsReader.PluginArgsDB>();
            Vector<File> listOfFiles1 = new Vector<File>();
            listOfFiles1.add(Ris21PluginArgsReader.basicSurfArgs);
            argsReader.parsePlugins("Bxdf", basicPxrSurface, listOfFiles1, false);
            Ris21PluginArgsReader.PluginArgsDB db = basicPxrSurface.elementAt(0);
            return db.getRibStatement(tabCount);
        }
        if (plugin.type.equals("Light")) {
            String rib = plugin.getRibStatement(tabCount + 1);
            String attrBlock = plugin.name.equals("PxrEnvDayLight") ? Ris21RibStrings.DaylightAttributeBlock : (plugin.name.equals("PxrDomeLight") ? Ris21RibStrings.DomelightAttributeBlock : (plugin.name.equals("PxrSphereLight") ? Ris21RibStrings.SpherelightAttributeBlock : (plugin.name.equals("PxrMeshLight") ? Ris21RibStrings.MeshLightAttributeBlock : (plugin.name.equals("PxrDistantLight") ? Ris21RibStrings.DistantLightAttributeBlock : Ris21RibStrings.LightAttributeBlock))));
            return attrBlock.replaceAll("(__PXR_LIGHT__)", rib);
        }
        return plugin.getRibStatement(tabCount);
    }

    @Override
    public String[] completionCandidates(String str) {
        if (this.attrCandidatesList == null) {
            String[] lang = this.completionCandidates(str, languageTable);
            String[] names = osr.getUsrShaderNames();
            if (names == null) {
                return lang;
            }
            osoTable.clear();
            for (int n = 0; n < names.length; ++n) {
                String name = TextUtils.removeExtension(names[n]);
                osoTable.put(name.toLowerCase(), name);
            }
            String[] oso = this.completionCandidates(str, osoTable);
            return VectorUtils.toStringArray(lang, oso);
        }
        Vector<String> candidates = new Vector<String>();
        for (int n = 0; n < this.attrCandidatesList.length; ++n) {
            String key = this.attrCandidatesList[n][0];
            if (!key.startsWith(str)) continue;
            candidates.add(this.attrCandidatesList[n][1]);
        }
        return VectorUtils.toStringArray(candidates);
    }

    public static void initPaths() {
        String pathToMainDocs = new File(Preferences.get(Preferences.PATH_PIXAR_RENDERMAN_DOCS_INDEX)).getParent();
        sysDocsShadersPath = RenderInfo.get(15);
        sysDocsShadersPath = RibHelp.configurePath(sysDocsShadersPath);
        ext = RenderInfo.get(16);
        toc = RenderInfo.get(17);
    }

    public static String getAppNotesDirPath() {
        return RibHelp.getRPSDocsIndex();
    }

    public static String getUserGuideDirPath() {
        return RibHelp.getRPSDocsIndex();
    }

    public static String getRispec_htmlDirPath() {
        return RibHelp.getRPSDocsIndex();
    }

    public static String getDelightDocsIndex() {
        String delightDocsIndexPath = RibHelp.configurePath(Preferences.get(Preferences.PATH_3DELIGHT_DOCS_SHADERS));
        String toc = Preferences.get(Preferences.PATH_3DELIGHT_DOCS_SHADERS_TOC);
        if (delightDocsIndexPath.equals("")) {
            return null;
        }
        return delightDocsIndexPath + "/" + toc;
    }

    public static boolean delightURLIsValid() {
        String str = RibHelp.getDelightDocsIndex();
        if (str == null || str.length() == 0) {
            return false;
        }
        return KAbstractHelp.docsIndexURLIsValid(str);
    }

    public static float getRPSDocsVersion() {
        float result;
        String rpsDocsPath = RibHelp.getRPSDocsRoot();
        if (rpsDocsPath == null || rpsDocsPath.trim().length() == 0) {
            return 0.0f;
        }
        String[] tokens = TextUtils.tokenize(rpsDocsPath = rpsDocsPath.replace('\\', '/'), '/');
        if (tokens == null || tokens.length == 0 || tokens.length - 1 < 0) {
            return 0.0f;
        }
        String lastToken = tokens[tokens.length - 1];
        StringBuffer buf = new StringBuffer();
        for (int n = lastToken.length() - 1; n >= 0; --n) {
            char c = lastToken.charAt(n);
            if (c != '.' && !Character.isDigit(c)) continue;
            buf.append(c);
        }
        if (buf.length() == 0) {
            return 0.0f;
        }
        buf = buf.reverse();
        try {
            result = Float.valueOf(buf.toString()).floatValue();
        }
        catch (NumberFormatException e) {
            Cutter.setLog("    Error:RibHelp.getRPSDocsVersion() - unable to convert string \"" + lastToken + "\" to a floating point version number!");
            return 0.0f;
        }
        Cutter.setLog("    Debug: RibHelp.getRPSDocsVersion() version \"" + result + "\"");
        return result;
    }

    public static String getRPSDocsIndex() {
        return RibHelp.getRMSDocsIndex();
    }

    public static String getRPSDocsRoot() {
        return RibHelp.getRMSDocsRoot();
    }

    public static String getRMSDocsRoot() {
        String url = RibHelp.getRMSDocsIndex();
        if (url.endsWith("home.html")) {
            return url.substring(0, url.length() - 9);
        }
        if (url.endsWith("home.php")) {
            return url.substring(0, url.length() - 8);
        }
        if (url.endsWith("RenderMan")) {
            return url.substring(0, url.length() - 9);
        }
        return url;
    }

    public static String getRMSDocsIndex() {
        String rmsDocsIndexPath = RibHelp.configurePath(Preferences.get(Preferences.PATH_PIXAR_RENDERMAN_DOCS_INDEX));
        if (rmsDocsIndexPath.trim().equals("")) {
            return "https://renderman.pixar.com/resources/RenderMan_20/home.html";
        }
        return rmsDocsIndexPath;
    }

    public static boolean rpsURLIsValid() {
        String str = RibHelp.getRPSDocsIndex();
        if (str == null || str.length() == 0) {
            return false;
        }
        return KAbstractHelp.docsIndexURLIsValid(str);
    }

    public static boolean rmsURLIsValid() {
        String str = RibHelp.getRMSDocsIndex();
        if (str == null || str.length() == 0) {
            return false;
        }
        return KAbstractHelp.docsIndexURLIsValid(str);
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        if (e.getModifiers() < 20) {
            Cutter.setLog("    Debug:RibHelp.showDocFor() - return false because e.getModifiers() < 20");
            return false;
        }
        this.useCutterBrowser = false;
        return this.launchBrowser(item);
    }

    @Override
    protected void lookup(String item) {
        String name;
        int n;
        int lastSlash;
        if (item == null) {
            Cutter.setLog("    Debug:RibHelp.lookup() - been passed item = null");
            return;
        }
        String docExt = ".html";
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer(item);
        String rpsDocsRoot = Preferences.get(Preferences.PATH_PIXAR_RENDERMAN_LEGACY_DOCS_INDEX);
        if (rpsDocsRoot.trim().length() == 0) {
            rpsDocsRoot = "https://renderman.pixar.com/resources/RenderMan_20/home.html";
        }
        if ((lastSlash = rpsDocsRoot.lastIndexOf(47)) == -1) {
            rpsDocsRoot = "https://renderman.pixar.com/resources/RenderMan_20";
            rpsDocsRoot = "https://renderman.pixar.com/resources/RenderMan_20";
        } else {
            rpsDocsRoot = rpsDocsRoot.substring(0, lastSlash);
        }
        Cutter.setLog("    Debug: RibHelp.lookup() - rpsDocsRoot is \"" + rpsDocsRoot + "\"");
        if (RenderInfo.prmanMajorVersionNumber() >= 21) {
            String hack = null;
            if (item.startsWith("Pxr")) {
                hack = "https://rmanwiki.pixar.com/display/REN/" + item;
            } else if (item.equals("Light")) {
                hack = "https://rmanwiki.pixar.com/display/REN/Lighting+in+Maya";
            } else if (item.equals("Integrator")) {
                hack = "https://rmanwiki.pixar.com/display/REN/Integrators";
            }
            if (hack != null) {
                this.setHelpPage(hack);
                return;
            }
        }
        if (item.equals("RMSDisplacement") || item.equals("RMSGeoAreaLight")) {
            this.setHelpPage(Url.join(rpsDocsRoot, item + ".html"));
            return;
        }
        Vector<Ris21PluginArgsReader.PluginArgsDB> pxrPlugins = new Vector<Ris21PluginArgsReader.PluginArgsDB>();
        pxrPlugins.addAll(Ris21PluginArgsReader.rpsBxdfs);
        pxrPlugins.addAll(Ris21PluginArgsReader.rpsPatts);
        for (n = 0; n < integrators.length; ++n) {
            name = integrators[n];
            if (name == null || !name.equals(item)) continue;
            this.setHelpPage(Url.join(rpsDocsRoot, item + docExt));
            return;
        }
        for (n = 0; n < pxrPlugins.size(); ++n) {
            name = ((Ris21PluginArgsReader.PluginArgsDB)pxrPlugins.elementAt((int)n)).name;
            if (name == null || !name.equals(item)) continue;
            if (item.startsWith("PxrLM")) {
                this.setHelpPage(Url.join(rpsDocsRoot, "PxrLMMaterials" + docExt));
            } else {
                this.setHelpPage(Url.join(rpsDocsRoot, item + docExt));
            }
            return;
        }
        if (RibTokenizer.isQuadric(item)) {
            this.setHelpPage(Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#quadrics"));
            return;
        }
        if (RibTokenizer.isPolygon(item)) {
            this.setHelpPage(Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#polygons"));
            return;
        }
        if (RibTokenizer.isSolids(item)) {
            this.setHelpPage(Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#solids-and-spatial-set-operations"));
            return;
        }
        if (RibTokenizer.isPatch(item)) {
            this.setHelpPage(Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#patches"));
            return;
        }
        if (RibTokenizer.isProcedural(item)) {
            this.setHelpPage(Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#procedural-primitives"));
            return;
        }
        if (item.equals("Blobby")) {
            this.setHelpPage(Url.join(rpsDocsRoot, "risBlobbies" + docExt));
            return;
        }
        if (item.equals("Volume")) {
            this.setHelpPage(Url.join(rpsDocsRoot, "volume_rendering" + docExt + "#rivolume"));
            return;
        }
        if (item.equals("Points") || item.equals("Curves")) {
            this.setHelpPage(Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#point-and-curve-primitives"));
            return;
        }
        if (item.equals("Geometry")) {
            this.setHelpPage(Url.join(rpsDocsRoot, "geometricPrimitives" + docExt + "#implementation-specific-geometric-primitives"));
            return;
        }
        if (item.equals("ReadArchive")) {
            this.setHelpPage(Url.join(rpsDocsRoot, "usingExternalResources" + docExt + "#archive-files"));
            return;
        }
        if (item.equals("ArchiveBegin") || item.equals("ArchiveEnd")) {
            this.setHelpPage(Url.join(rpsDocsRoot, "usingExternalResources" + docExt + "#inline-archives"));
            return;
        }
        if (item.equals("IfBegin") || item.equals("IfEnd") || item.equals("Else") || item.equals("ElseIf")) {
            this.setHelpPage(Url.join(rpsDocsRoot, "usingExternalResources" + docExt + "#conditional-evaluation"));
            return;
        }
        if (item.equals("DelayedReadArchive")) {
            this.setHelpPage(Url.join(rpsDocsRoot, "proceduralPrimitives" + docExt + "#delayed-rib-file-reading"));
            return;
        }
        if (RibTokenizer.isRIS(item)) {
            if (item.equals("Integrator")) {
                this.setHelpPage(Url.join(rpsDocsRoot, "risIntegrators" + docExt));
                return;
            }
            if (item.equals("Bxdf")) {
                this.setHelpPage(Url.join(rpsDocsRoot, "risShaders" + docExt));
                return;
            }
            if (item.equals("Pattern")) {
                this.setHelpPage(Url.join(rpsDocsRoot, "risPatterns" + docExt));
                return;
            }
            String str = "ri" + item.toLowerCase();
            this.setHelpPage(Url.join(rpsDocsRoot, "risProcedures" + docExt + "#" + str));
            return;
        }
        if (item.equals("PxrStdEnvDayLight") || item.equals("PxrStdAreaLight") || item.equals("PxrStdEnvMapLight") || item.equals("PxrLightEmission") || item.equals("PxrAreaLight") || item.equals("RMSDisplacement")) {
            this.setHelpPage(Url.join(rpsDocsRoot, item + docExt));
            return;
        }
        if (item.equals("Attribute")) {
            this.setHelpPage("https://renderman.pixar.com/resources/current/RenderMan/risAttributes.html");
            return;
        }
        if (item.equals("Option")) {
            this.setHelpPage("https://renderman.pixar.com/resources/current/RenderMan/risOptions.html#index");
            return;
        }
        if (RibTokenizer.isAttribute(item)) {
            String str = "ri" + item.toLowerCase();
            this.setHelpPage(Url.join(rpsDocsRoot, "attributes" + docExt + "#" + str));
            return;
        }
        if (RibTokenizer.isGraphicState(item)) {
            String str = "ri" + item.toLowerCase();
            this.setHelpPage(Url.join(rpsDocsRoot, "graphicsState" + docExt + "#" + str));
            return;
        }
        if (RibTokenizer.isOption(item)) {
            String str = "ri" + item.toLowerCase();
            this.setHelpPage(Url.join(rpsDocsRoot, "options" + docExt + "#" + str));
            return;
        }
        this.setHelpPage(Url.join(rpsDocsRoot, item + docExt));
    }

    protected boolean _setHelpPage(String urlStr, boolean showWarningMessage) {
        if (RenderInfo.prmanMajorVersionNumber() < 21) {
            return super.setHelpPage(urlStr, true);
        }
        String base = urlStr;
        if (urlStr.endsWith(".html")) {
            base = urlStr.substring(0, urlStr.length() - 5);
        } else if (urlStr.endsWith(".php")) {
            base = urlStr.substring(0, urlStr.length() - 4);
        }
        String[] t = TextUtils.tokenize(base, "/");
        if (t == null || t.length == 0) {
            return super.setHelpPage(urlStr, true);
        }
        String item = t[t.length - 1];
        if (item.startsWith("Pxr")) {
            return super.setHelpPage(base, true);
        }
        return super.setHelpPage(urlStr, true);
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    @Override
    protected KAbstractHelp.KPopupMenuItem getDefaultExecute() {
        return null;
    }

    @Override
    protected KAbstractHelp.KPopupMenuItem getDefaultSelectBlockMenu() {
        return null;
    }

    @Override
    protected KAbstractHelp.KPopupMenuItem getDefaultOpenPathMenu() {
        return null;
    }

    private KAbstractHelp.KPopupMenuItem getRenderAllFramesMenu() {
        KAbstractHelp.KPopupMenuItem mi = super.getDefaultExecute();
        int begin = BBxt.getSelectionStart();
        int end = BBxt.getSelectionEnd();
        if (begin != -1 && end != -1) {
            BBxt.setSelection(begin, begin);
        }
        mi.setText("Render All Frames");
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem getOpenPathMenu() {
        return super.getDefaultOpenPathMenu();
    }

    @Override
    public void popupOnlineHelp(Point pnt, final String selection, final int end, MouseEvent e) {
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, end - selection.length(), end);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        popup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                int begin = end - selection.length();
                if (begin >= 0 && end >= 0) {
                    BBxt.setSelection(begin, end);
                }
            }
        });
        popup.add(this.getOpenPathMenu());
        popup.add(this.getRenderAllFramesMenu());
        popup.add(this.getFramesMenu());
        popup.add(this.getRenderShadowMapItems());
        popup.add(this.getSelectRibBlockMenu());
        KAbstractHelp.KPopupMenuItem item = this.getReformatStatementItem();
        if (item != null) {
            popup.add(item);
        }
        popup.add(this.getReformatDocItem());
        popup.add(this.getOpenRLFMenu());
        popup.add(this.getConvertToTCLMenu());
        popup.add(new JSeparator());
        popup.add(defaultMenu);
        popup.pack();
        popup.show(this.textpane, pnt.x, pnt.y);
    }

    private KAbstractHelp.KPopupMenuItem getFramesMenu() {
        SyntaxListener listener = this.textpane.getSyntaxListener();
        Tokenizer tok = null;
        if (listener != null) {
            tok = listener.tok;
        }
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Render Frame #");
        mi.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BBxt.setSelection(RibHelp.this.selRawBegin, RibHelp.this.selRawBegin);
            }
        });
        mi.setEnabled(false);
        String sel = "";
        if (this.selRawStr == null) {
            this.selRawStr = "";
        }
        if (this.selRawStr.equals("")) {
            int selDeltaBegin = this.selRawBegin - this.lineBegin;
            sel = this.doOrderedExpansion(selDeltaBegin, selDeltaBegin);
        } else {
            sel = this.initialSelection;
        }
        int begin = BBxt.getSelectionStart();
        final int end = BBxt.getSelectionEnd();
        if (sel != null && sel.equals("FrameBegin") && tok != null) {
            tok.setBufferIndex(end);
            String num = tok.getNextStr();
            if (NumberUtils.isInteger(num)) {
                mi.setText("Render Frame " + num);
                mi.setEnabled(true);
            }
        } else if (tok != null) {
            int[] fBegin = null;
            int[] fEnd = null;
            fBegin = RegExpUtils.findLastOccuranceOf(new String(tok.getBuffer(0, end)), "FrameBegin", false, true);
            if (fBegin != null) {
                char[] tmp = tok.getBuffer(end);
                String s = "";
                if (tmp == null || tmp.length == 0) {
                    fEnd = null;
                } else {
                    s = new String(tok.getBuffer(end));
                }
                fEnd = s == null ? null : RegExpUtils.findFirstOccuranceOf(s, "FrameEnd", false, true);
                if (fBegin != null && fEnd != null) {
                    final int absFrameBegin = fBegin[0];
                    final int absFrameEnd = end + fEnd[1];
                    final Tokenizer t = tok;
                    tok.setBufferIndex(fBegin[1]);
                    String num = tok.getNextStr();
                    if (NumberUtils.isInteger(num)) {
                        mi.setText("Render Frame " + num);
                        mi.setEnabled(true);
                    }
                    ActionListener action = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            RibHelp.this.textpane.setSelectionStart(end);
                            RibHelp.this.textpane.setSelectionEnd(end);
                            Document doc = RibHelp.this.textpane.getDocument();
                            int[] header = RegExpUtils.findFirstOccuranceOf(new String(t.getBuffer()), "FrameBegin", false, true);
                            String headerStr = header == null || header[0] == 0 ? "" : new String(t.getBuffer(0, header[0] - 1));
                            ScriptHandler handler = ScriptRegistry.getHandlerForExtension(".rib");
                            if (handler != null) {
                                String frameStr = new String(t.getBuffer(absFrameBegin, absFrameEnd));
                                handler.execute(headerStr + frameStr);
                            }
                        }
                    };
                    mi.addActionListener(action);
                }
            }
        }
        return mi;
    }

    private JMenu getRenderShadowMapItems() {
        int selDeltaBegin;
        JMenu menu = new JMenu("Render Shadow Map");
        menu.addMouseListener(new KAbstractHelp.KSelectionExpander());
        menu.setEnabled(false);
        KAbstractHelp.KPopupMenuItem[] items = new KAbstractHelp.KPopupMenuItem[]{new KAbstractHelp.KPopupMenuItem("Standard"), new KAbstractHelp.KPopupMenuItem("Deep")};
        items[0].addMouseListener(new KAbstractHelp.KSelectionExpander());
        items[1].addMouseListener(new KAbstractHelp.KSelectionExpander());
        items[0].setEnabled(false);
        items[1].setEnabled(false);
        int selDeltaEnd = selDeltaBegin = this.selRawBegin - this.lineBegin;
        String s = this.doOrderedExpansion(selDeltaBegin, selDeltaEnd);
        int sel_start = BBxt.getSelectionStart();
        int sel_end = BBxt.getSelectionEnd();
        this.shadowName = ShadowParser.isShadowSpot();
        BBxt.setSelection(sel_start, sel_start);
        if (this.shadowName == null || this.shadowName.trim().length() == 0) {
            return menu;
        }
        if (this.shadowName != null && this.shadowName.length() > 0) {
            items[0].setEnabled(true);
            items[1].setEnabled(true);
        }
        items[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Document document = RibHelp.this.textpane.getDocument();
                Segment segment = DocumentUtils.getSegment(document, 0, document.getLength());
                if (segment != null) {
                    RibHelp.this.parser = new ShadowParser(segment);
                    if (RibHelp.this.textpane.getFrameFile() == null) {
                        RibHelp.this.shadowFile = new File(RibHelp.this.shadowName);
                    } else {
                        RibHelp.this.shadowFile = new File(BBxt.getFrontWindowFile().getParent(), RibHelp.this.shadowName);
                    }
                    RibHelp.this.shadowFile = RibHelp.this.parser.generateShadow(RibHelp.this.shadowFile, ShadowParser.STANDARD_SHADOW);
                    RenderManager.renderFile(RibHelp.this.shadowFile, RenderManager.RENDERING_STANDARD_SHADOW, true, true);
                }
            }
        });
        items[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Document document = RibHelp.this.textpane.getDocument();
                Segment segment = DocumentUtils.getSegment(document, 0, document.getLength());
                if (segment != null) {
                    RibHelp.this.parser = new ShadowParser(segment);
                    if (RibHelp.this.textpane.getFrameFile() == null) {
                        RibHelp.this.shadowFile = new File(RibHelp.this.shadowName + ".rib");
                    } else {
                        RibHelp.this.shadowFile = new File(BBxt.getFrontWindowFile().getParent(), RibHelp.this.shadowName + ".rib");
                    }
                    RibHelp.this.shadowFile = RibHelp.this.parser.generateShadow(RibHelp.this.shadowFile, ShadowParser.DEEP_SHADOW);
                    if (RibHelp.this.shadowFile != null) {
                        RenderManager.renderFile(RibHelp.this.shadowFile, RenderManager.RENDERING_DEEP_SHADOW, true, true);
                    }
                }
            }
        });
        menu.add(items[1]);
        menu.add(items[0]);
        menu.setEnabled(true);
        return menu;
    }

    private JMenu _getSetVendorMenu() {
        JMenu menu = new JMenu("Switch Renderer");
        menu.setEnabled(false);
        final KAbstractHelp.KPopupMenuItem[] items = new KAbstractHelp.KPopupMenuItem[]{new KAbstractHelp.KPopupMenuItem("Pixar"), new KAbstractHelp.KPopupMenuItem("3Delight")};
        items[0].setEnabled(false);
        items[1].setEnabled(false);
        items[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenderInfo.setActiveRender("pixar");
                Preferences.write(Preferences.RENDERER_DEFAULT, "pixar");
                String preferredStyle = RenderInfo.getRendererDataTypeStyle();
                RenderInfo.setDataTypeStyle(preferredStyle);
                RenderInfo ri2 = RenderInfo.getActiveRender();
                RenderInfo.notifyListeners(ri2);
                RibTabPanel.setRenderButtonLabel(RenderInfo.PRMAN);
            }
        });
        items[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenderInfo.setActiveRender("3delight");
                Preferences.write(Preferences.RENDERER_DEFAULT, "3delight");
                String preferredStyle = RenderInfo.getRendererDataTypeStyle();
                RenderInfo.setDataTypeStyle(preferredStyle);
                RenderInfo ri2 = RenderInfo.getActiveRender();
                RenderInfo.notifyListeners(ri2);
                RibTabPanel.setRenderButtonLabel(RenderInfo.RENDERDL);
            }
        });
        JPopupMenu pop = menu.getPopupMenu();
        pop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (RenderInfo.activeRendererIs("pixar")) {
                    items[0].setArmed(true);
                    items[1].setArmed(false);
                } else {
                    items[0].setArmed(false);
                    items[1].setArmed(true);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        menu.add(items[0]);
        menu.add(items[1]);
        items[0].setEnabled(true);
        items[1].setEnabled(true);
        menu.setEnabled(true);
        return menu;
    }

    private KAbstractHelp.KPopupMenuItem getConvertToBrickmapItem() {
        int selDeltaEnd;
        int selDeltaBegin;
        String s;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Convert to BrickMap");
        mi.addMouseListener(new KAbstractHelp.KSelectionExpander());
        mi.setEnabled(false);
        if (this.selRawStr == null || this.selRawStr.indexOf(10) != -1) {
            return mi;
        }
        if (this.selRawStr.equals("") && (s = this.doOrderedExpansion(selDeltaBegin, selDeltaEnd = (selDeltaBegin = this.selRawBegin - this.lineBegin))) != null && !s.equals("")) {
            File f = this.convertSelectionToFile(this.selRawStr);
            if (f != null && !f.isDirectory() && f.exists()) {
                String ext = FileUtils.getExtension(f);
                if (ext.endsWith(".ptc")) {
                    mi.setEnabled(true);
                    this.ptcFile = f;
                } else {
                    this.ptcFile = null;
                }
            } else {
                this.ptcFile = null;
            }
        }
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (RibHelp.this.ptcFile == null) {
                    return;
                }
                String brickname = TextUtils.removeExtension(RibHelp.this.ptcFile.getName()) + ".bkm";
                ProcessManager fp = new ProcessManager("BrickMake");
                String[] item = new String[]{"brickmake", "\"" + RibHelp.this.ptcFile.getName() + "\"", "\"" + brickname + "\""};
                fp.launch(item, RibHelp.this.ptcFile.getParentFile(), true, RibHelp.this, false);
            }
        });
        return mi;
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
    }

    @Override
    public void processFinished(String[] progarray) {
        Monitor.finalizePanelText("BrickMake", "Completed:\n");
    }

    protected KAbstractHelp.KPopupMenuItem getOpenRLFMenu() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Open RLF");
        File f = this.textpane.getFrameFile();
        if (f == null) {
            mi.setEnabled(false);
            return mi;
        }
        String ribname = f.getName();
        String rlfname = TextUtils.removeExtension(ribname) + ".rlf";
        final File rlf = new File(f.getParent(), rlfname);
        if (!rlf.exists()) {
            mi.setEnabled(false);
            return mi;
        }
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.newDocument(rlf);
            }
        };
        mi.addActionListener(action);
        return mi;
    }

    protected KAbstractHelp.KPopupMenuItem getSelectRibBlockMenu() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Select Rib Block");
        if (this.selRawStr == null || this.selRawStr.trim().length() > 1) {
            mi.setEnabled(false);
            return mi;
        }
        mi.addActionListener(new SelectBlockAction(this.textpane, this.selRawBegin));
        return mi;
    }

    public KAbstractHelp.KPopupMenuItem getConvertToTCLMenu() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(CONVERT_TO_TCL);
        String sel = BBxt.getSelection();
        if (sel.trim().length() == 0) {
            mi.setEnabled(false);
        }
        ActionListener reformatAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String sel = BBxt.getSelection();
                SyntaxListener listener = BBxt.getSyntaxListener();
                if (listener == null) {
                    Cutter.setLog("    Error:RibHelp.getConvertToTCLMenu() - cannot get syntax listener.");
                    return;
                }
                Tokenizer tokenizer = listener.getTokenizer();
                if (tokenizer == null) {
                    Cutter.setLog("    Error:RibHelp.getConvertToTCLMenu() - cannot get tokenizer.");
                    return;
                }
                Comment[] cmnts = tokenizer.comments;
                if (cmnts == null) {
                    Cutter.setLog("    Error:RibHelp.getConvertToTCLMenu() - cannot get array of comments.");
                    return;
                }
                sel = DocumentUtils.removeComments(sel, cmnts);
                int mod = evt.getModifiers();
                String tcl = "";
                String mel = "";
                tcl = (mod & 1) != 0 || (mod & 2) != 0 || (mod & 8) != 0 || (mod & 4) != 0 ? RibToTCL.getCustomTCL(sel, true) : RibToTCL.getCustomTCL(sel, false);
                if (tcl.trim().length() > 0) {
                    BBxt.newDocument("untitled.tcl", tcl);
                }
            }
        };
        mi.addActionListener(reformatAction);
        return mi;
    }

    public KAbstractHelp.KPopupMenuItem getReformatDocItem() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(REFORMAT_DOC);
        ActionListener reformatAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int cursorAt = BBxt.getSelectionStart();
                String src = BBxt.getWindowText();
                if (src == null || src.trim().length() == 0) {
                    return;
                }
                String[] result = RibUtils.reformat(src);
                if (result == null) {
                    return;
                }
                BBxt.selectAll();
                BBxt.paste(result[1]);
                if (cursorAt != -1) {
                    BBxt.setSelection(cursorAt, cursorAt);
                }
            }
        };
        mi.addActionListener(reformatAction);
        mi.setEnabled(true);
        return mi;
    }

    public KAbstractHelp.KPopupMenuItem getReformatStatementItem() {
        String actionType = TO_MULTILINE;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(TO_MULTILINE);
        mi.setEnabled(false);
        String sel = "";
        if (this.selRawStr.equals("")) {
            int selDeltaBegin;
            int selDeltaEnd = selDeltaBegin = this.selRawBegin - this.lineBegin;
            sel = this.doOrderedExpansion(selDeltaBegin, selDeltaEnd);
        } else {
            sel = this.initialSelection;
        }
        int beginOffset = BBxt.getSelectionStart();
        int endOffset = BBxt.getSelectionEnd();
        if (endOffset == -1) {
            Cutter.setLog("    Error:RibHelp.getReformatStatementItem() - cannot find the end offset of the current selection.");
            return null;
        }
        if (sel == null) {
            sel = "";
        }
        if (beginOffset == endOffset) {
            endOffset = beginOffset + sel.length();
            BBxt.setSelection(beginOffset, endOffset);
        }
        if (ReformatStatementAction.canBeReformatted(sel)) {
            mi.setEnabled(true);
            mi.addMouseListener(new KAbstractHelp.KSelectionExpander());
            RibUtils r = new RibUtils();
            RibUtils.ParamBlock paramsBlock = r.getParamBlock(this.textpane, sel, endOffset);
            if (paramsBlock == null) {
                Cutter.setLog("    Error:RibHelp:getReformatStatementItem() - cannot get parameters for \"" + sel + "\"");
                return null;
            }
            if (paramsBlock.numNewlines > 1) {
                actionType = TO_SINGLELINE;
                mi.setText(TO_SINGLELINE);
            }
            ReformatStatementAction rsa = new ReformatStatementAction(this.textpane, sel, actionType);
            mi.addActionListener(rsa);
        }
        return mi;
    }

    static {
        SHADER_DOCS_NOT_FOUND_URL = HELP_DOCS_BASE_URL + "/shaders/notfound.html";
        fileTypes = new String[]{".rib"};
        languageTable = new Hashtable();
        osoTable = new Hashtable();
        integrators = new String[]{"PxrVCM", "PxrPathTracer", "PxrDirectLighting", "PxrDefault", "PxrDebugShadingContext", "PxrValidateBxdf", "PxrVisualizer"};
        osr = new OslShaderReader();
        argsReader = new Ris21PluginArgsReader();
        listOfSubClasses.addElement(RibHelp.class);
        Enumeration<String> e = RibTokenizer.statements.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String val = RibTokenizer.statements.get(key);
            languageTable.put(key.toLowerCase(), val);
        }
        argsReader = new Ris21PluginArgsReader();
        argsReader.resetDatabase();
        argsReader.readAllArgFiles();
        Ris21PluginArgsReader.PluginArgsDB[] plugs = argsReader.getAllPlugins();
        for (int n = 0; n < plugs.length; ++n) {
            String plugName = plugs[n].name;
            languageTable.put(plugName.toLowerCase(), plugName);
        }
        String[] names = osr.getUsrShaderNames();
        if (names != null) {
            for (int n = 0; n < names.length; ++n) {
                String name = TextUtils.removeExtension(names[n]);
                osoTable.put(name.toLowerCase(), name);
            }
        }
    }

    public static class SelectBlockAction
    extends AbstractAction {
        private KTextPane textpane = null;
        private Document doc = null;
        private Segment segment = null;
        SyntaxListener listener = null;
        private int caretAt = -1;
        private static int COMMENT = 1;
        private Color cmntColor = null;
        private Color strColor = null;
        private static int STRING = 10;

        public SelectBlockAction(KTextPane textpane, int caretAt) {
            this.textpane = textpane;
            this.doc = textpane.getDocument();
            this.listener = textpane.getSyntaxListener();
            this.segment = DocumentUtils.getSegment(this.doc, 0, this.doc.getLength());
            this.caretAt = caretAt;
            this.cmntColor = StyleConstants.getForeground(textpane.styleContext.commentStyle1);
            this.strColor = StyleConstants.getForeground(textpane.styleContext.stringStyle1);
        }

        private boolean doIgnore(int offset) {
            Color c = DocumentUtils.getCharacterStyleColor(this.doc, offset);
            return c == this.cmntColor || c == this.strColor;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String wStr;
            String eStr;
            String bStr;
            char c;
            int blockOpenOffset = -1;
            int blockCloseOffset = -1;
            int beginAt = this.segment.offset + this.caretAt;
            int tOpenCount = 1;
            int aOpenCount = 1;
            int wOpenCount = 1;
            int fOpenCount = 1;
            int sOpenCount = 1;
            int closeDelta = 12;
            for (int offset = beginAt; offset < this.segment.count; ++offset) {
                c = this.segment.array[offset + this.segment.offset];
                if (this.doIgnore(offset) || c != 'T' && c != 'A' && c != 'W' && c != 'F' && c != 'S') continue;
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 14);
                eStr = SegmentUtils.toNonNullString(this.segment, offset, 12);
                if (bStr.equals("TransformBegin")) {
                    ++tOpenCount;
                } else if (bStr.equals("AttributeBegin")) {
                    ++aOpenCount;
                } else if (eStr.equals("TransformEnd")) {
                    --tOpenCount;
                } else if (eStr.equals("AttributeEnd")) {
                    --aOpenCount;
                }
                wStr = SegmentUtils.toNonNullString(this.segment, offset, 10);
                if (wStr.equals("FrameBegin")) {
                    ++fOpenCount;
                }
                if (wStr.equals("WorldBegin")) {
                    ++wOpenCount;
                }
                if (wStr.equals("SolidBegin")) {
                    ++sOpenCount;
                }
                if ((wStr = SegmentUtils.toNonNullString(this.segment, offset, 8)).equals("FrameEnd")) {
                    --fOpenCount;
                }
                if (wStr.equals("WorldEnd")) {
                    --wOpenCount;
                }
                if (wStr.equals("SolidEnd")) {
                    --sOpenCount;
                }
                if (tOpenCount != 0 && aOpenCount != 0 && wOpenCount != 0 && fOpenCount != 0 && sOpenCount != 0) continue;
                if (wOpenCount == 0) {
                    closeDelta = 8;
                }
                if (fOpenCount == 0) {
                    closeDelta = 8;
                }
                if (sOpenCount == 0) {
                    closeDelta = 8;
                }
                blockCloseOffset = offset;
                break;
            }
            if (blockCloseOffset == -1) {
                return;
            }
            int tCloseCount = 0;
            int aCloseCount = 0;
            int wCloseCount = 0;
            int fCloseCount = 0;
            int sCloseCount = 0;
            boolean isTBlock = tOpenCount == 0;
            boolean isABlock = aOpenCount == 0;
            boolean isWBlock = wOpenCount == 0;
            boolean isFBlock = fOpenCount == 0;
            boolean isSBlock = sOpenCount == 0;
            for (int offset = beginAt = blockCloseOffset; offset >= this.segment.offset; --offset) {
                c = this.segment.array[offset + this.segment.offset];
                if (this.doIgnore(offset) || c != 'T' && c != 'A' && c != 'W' && c != 'F' && c != 'S') continue;
                eStr = SegmentUtils.toNonNullString(this.segment, offset, 12);
                bStr = SegmentUtils.toNonNullString(this.segment, offset, 14);
                if (eStr.equals("TransformEnd")) {
                    ++tCloseCount;
                } else if (eStr.equals("AttributeEnd")) {
                    ++aCloseCount;
                } else if (bStr.equals("TransformBegin")) {
                    --tCloseCount;
                } else if (bStr.equals("AttributeBegin")) {
                    --aCloseCount;
                }
                wStr = SegmentUtils.toNonNullString(this.segment, offset, 8);
                if (wStr.equals("WorldEnd")) {
                    ++wCloseCount;
                }
                if (wStr.equals("FrameEnd")) {
                    ++fCloseCount;
                }
                if (wStr.equals("SolidEnd")) {
                    ++sCloseCount;
                }
                if ((wStr = SegmentUtils.toNonNullString(this.segment, offset, 10)).equals("WorldBegin")) {
                    --wCloseCount;
                }
                if (wStr.startsWith("FrameBegin")) {
                    --fCloseCount;
                }
                if (wStr.startsWith("SolidBegin")) {
                    --sCloseCount;
                }
                if (!(isTBlock && tCloseCount == 0 || isABlock && aCloseCount == 0 || isWBlock && wCloseCount == 0 || isFBlock && fCloseCount == 0) && (!isSBlock || sCloseCount != 0)) continue;
                blockOpenOffset = offset;
                break;
            }
            if (blockOpenOffset == -1) {
                return;
            }
            this.textpane.setSelectionStart(blockOpenOffset);
            this.textpane.setSelectionEnd(blockCloseOffset + closeDelta);
            this.textpane.requestFocus();
        }
    }
}

