/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Rib.RibListenerDialog;
import UI_Script.Rib.RibTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.RibInZipListener;
import Utilities.RibInZipUtils;
import Utilities.RibUtils;
import java.io.File;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;

public class RibListener
extends SyntaxListener
implements RibInZipListener {
    RibListenerDialog binaryToAsciiDialog = null;

    public RibListener(KTextPane textpane) {
        super(textpane, new RibTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] delim = new char[]{'-', '$'};
        textpane.removeWordDelimitors(delim, delim);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_RIB_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RIB_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RIB_STATEMENT));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RIB_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_RIB_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.startsWith("\"reference ")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle1, true);
            editList.addEdit(begin + 1, 9, this.textpane.styleContext.stringStyle2, true);
            return true;
        }
        return false;
    }

    @Override
    public void catribFinished(File f) {
        String str = FileUtils.read(f);
        String[] result = RibUtils.reformat(str);
        Cutter.setLog("    Info:RibListener.catribFinished() - input file \"" + f.getPath() + "\"");
        if (result != null) {
            FileUtils.writeFile(f, result[1]);
        }
        try {
            KTextWindow tw = BBxt.getTextWindow();
            tw.canBeRecycled = false;
            tw.setClosed(true);
            BBxt.newDocument(f);
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:RibListener.catribFinished()\n" + ex.toString());
        }
        if (this.binaryToAsciiDialog != null) {
            this.binaryToAsciiDialog.setVisible(false);
        }
    }

    @Override
    protected synchronized void parse(Segment segment, int offset) {
        if (segment != null && offset == 0) {
            boolean isBinary = false;
            for (int n = 0; n < segment.count; ++n) {
                char c = segment.array[segment.offset + n];
                if (c <= '\ufde8') continue;
                isBinary = true;
                break;
            }
            if (isBinary) {
                File f = this.textpane.getFrameFile();
                if (f == null) {
                    return;
                }
                this.binaryToAsciiDialog = new RibListenerDialog(250);
                this.binaryToAsciiDialog.showSelf();
                RibInZipUtils utils = new RibInZipUtils(this);
                utils.pixarBinRibToAsciiRib(f, false);
                return;
            }
        }
        super.parse(segment, offset);
    }
}

