/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib;

import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Vector;

public class RibParamIterator {
    private Vector<Param> params = new Vector();

    public RibParamIterator(String shadertype, String input) {
        if (shadertype.equals("ConcatTransform") || shadertype.equals("Transform")) {
            input = input.trim();
            input = TextUtils.trimLeadingChar(input, '[');
            input = TextUtils.trimTrailingChar(input, ']');
            this.params.add(new Param(input.trim(), null));
            return;
        }
        if (shadertype.equals("Procedural") || shadertype.equals("Procedural2")) {
            String[] parts = this.getValue(input);
            while (parts != null) {
                String str = parts[0];
                this.params.add(new Param(str, null));
                parts = this.getValue(parts[1]);
            }
        } else if (shadertype.equals("Display")) {
            String[] parts = this.getIdentifier(input);
            if (parts == null) {
                return;
            }
            this.params.add(new Param(parts[0], null));
            parts = this.getIdentifier(parts[1]);
            if (parts == null) {
                return;
            }
            this.params.add(new Param(parts[0], null));
            parts = this.getIdentifier(parts[1]);
            if (parts == null) {
                return;
            }
            this.params.add(new Param(parts[0], null));
            this.parse(parts[1]);
        } else if (shadertype.equals("Shader") || shadertype.equals("LightSource") || shadertype.equals("AreaLightSource") || shadertype.equals("Bxdf") || shadertype.equals("Pattern") || shadertype.equals("Integrator") || shadertype.equals("Light") || shadertype.equals("Displace")) {
            this.parse(input);
        } else if (shadertype.equals("Surface") || shadertype.equals("Displacement") || shadertype.equals("Imager") || shadertype.equals("Volume") || shadertype.equals("Option") || shadertype.equals("Attribute") || shadertype.equals("Hider")) {
            String[] parts = this.getIdentifier(input);
            if (parts == null) {
                return;
            }
            String name = parts[0];
            this.params.add(new Param(name, null));
            this.parse(parts[1]);
        }
    }

    public String[] getParams() {
        if (this.params.size() == 0) {
            return null;
        }
        Vector<String> out = new Vector<String>();
        for (int n = 0; n < this.params.size(); ++n) {
            Param param = this.params.elementAt(n);
            out.addElement(param.toString());
        }
        return VectorUtils.toStringArray(out);
    }

    private void parse(String src) {
        if (src == null || src.trim().length() == 0) {
            return;
        }
        String[] parts = this.getIdentifier(src);
        if (parts == null) {
            return;
        }
        String name = parts[0];
        if ((parts = this.getValue(parts[1])) == null) {
            return;
        }
        String value = parts[0];
        try {
            Float.parseFloat(value);
            if (value.startsWith(".")) {
                value = "0" + value;
            } else if (value.endsWith(".")) {
                value = value + "0";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.params.add(new Param(name, value));
        this.parse(parts[1]);
    }

    private String[] getIdentifier(String src) {
        if (src == null || src.trim().length() == 0) {
            return null;
        }
        if (!(src = src.trim()).startsWith("\"")) {
            return null;
        }
        StringBuffer name = new StringBuffer();
        name.append('\"');
        for (int n = 1; n < src.length(); ++n) {
            char ch = src.charAt(n);
            if (ch == '\"') {
                src = src.substring(n + 1).trim();
                break;
            }
            name.append(ch);
        }
        name.append('\"');
        return new String[]{name.toString(), src};
    }

    private String[] getValue(String src) {
        if (src == null || src.trim().length() == 0) {
            return null;
        }
        String begin = "";
        String close = "";
        if (src.startsWith("\"")) {
            begin = "\"";
            close = "\"";
        } else if (src.startsWith("[")) {
            begin = "[";
            close = "]";
        }
        StringBuffer value = new StringBuffer();
        if (src.startsWith(".")) {
            value.append("0.");
        } else if (begin.equals("")) {
            value.append(src.charAt(0));
        } else {
            value.append(begin);
        }
        for (int n = 1; n < src.length(); ++n) {
            char ch = src.charAt(n);
            if (begin.equals("") && Character.isWhitespace(ch)) {
                src = src.substring(n + 1).trim();
                break;
            }
            if (!begin.equals("") && ch == close.charAt(0)) {
                src = src.substring(n + 1).trim();
                break;
            }
            value.append(ch);
        }
        value.append(close);
        return new String[]{value.toString(), src};
    }

    private class Param {
        private String name = null;
        private String value = null;

        private Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            if (this.value == null) {
                return this.name;
            }
            if (this.name == null) {
                return this.value;
            }
            return this.name + " " + this.value;
        }
    }
}

