/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Rib.OpenRibAction;
import UI_Script.Rib.RibHelp;
import UI_Script.Rib.RibListener;
import UI_Script.Rib.RibTokenizer;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.ScriptRegistry;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.Tabs.Rib.RenderManager;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class RibScriptHandler
extends ScriptHandler {
    private static Hashtable<String, String> tableOfWarnings = new Hashtable();

    @Override
    public boolean canRunSelection() {
        return false;
    }

    public RibScriptHandler() {
        this.ext = new String[4];
        this.ext[0] = ".rib";
        this.ext[1] = ".RIB";
        this.ext[2] = ".key";
        this.ext[3] = ".KEY";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new RibTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.rib");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Rib";
    }

    @Override
    public String getExecuteLabel() {
        return "Render " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        RenderManager.doRender(file);
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.rib");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return RibListener.class.getName();
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(RibHelp.class.getName(), textpane);
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Rib");
        item.addActionListener(new OpenRibAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    public static String[] getDisplayDriver() {
        Segment segment = BBxt.getWindowText(null);
        if (segment == null) {
            return null;
        }
        String block = RibScriptHandler.getCameraBlock(segment);
        if (block == null || block.trim().length() == 0) {
            return null;
        }
        String[] tokens = TextUtils.tokenize(block.toString());
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        String[] out = new String[]{"", ""};
        boolean displayStatementFound = false;
        boolean imageNameFound = false;
        boolean displayDriverFound = false;
        for (int n = 0; n < tokens.length; ++n) {
            String token = tokens[n].trim();
            if (!displayStatementFound && token.equals("Display")) {
                displayStatementFound = true;
            }
            if (displayStatementFound && !imageNameFound && token.startsWith("\"") && token.endsWith("\"")) {
                imageNameFound = true;
                out[0] = token.substring(1, token.length() - 1);
                continue;
            }
            if (!displayStatementFound || !imageNameFound || !token.startsWith("\"") || !token.endsWith("\"")) continue;
            out[1] = token.substring(1, token.length() - 1);
            return out;
        }
        return null;
    }

    public static String getCameraBlock(Segment seg) {
        return RibScriptHandler.getBlock(seg, null, "WorldBegin");
    }

    public static String getWorldBlock(Segment seg) {
        return RibScriptHandler.getBlock(seg, "WorldBegin", "WorldEnd");
    }

    public static String getBlock(Segment src, String start, String end) {
        int endOffset;
        RibTokenizer tok = new RibTokenizer();
        tok.setBuffer(src);
        int startOffset = start == null ? 0 : tok.searchFor(start, true);
        int n = endOffset = end == null ? src.count - 1 : tok.searchFor(end, false);
        if (startOffset == -1 || endOffset == -1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int n2 = startOffset; n2 < endOffset; ++n2) {
            buffer.append(src.array[src.offset + n2]);
        }
        return buffer.toString();
    }

    @Override
    public File[] getSystemHeadersDirs(File f) {
        if (f == null || !f.exists() || f.isDirectory()) {
            Cutter.setLog("    Error:RibScriptHandler.getSystemHeadersDirs() has been passed an unusable file");
            return null;
        }
        KAbstractWindow w = KAbstractDesktop.getWindowWithFile(f);
        if (w == null || !(w instanceof KTextWindow)) {
            Cutter.setLog("    Error:RibScriptHandler.getSystemHeadersDirs() - KAbstractDesktop.getWindowWithFile()\n           returned null for the file \"" + f.getPath() + "\"");
            return null;
        }
        KTextPane textpane = ((KTextWindow)w).getTextPane();
        Document doc = textpane.getDocument();
        String[] lines = DocumentUtils.getParagraphs(doc, 0, 50);
        File[] paths = this.getAllSearchPaths(f, lines);
        return paths;
    }

    private File[] getAllSearchPaths(File f, String[] lines) {
        if (lines == null) {
            return null;
        }
        Pattern p = Pattern.compile("(Option)\\s+(\"searchpath\")\\s+(\"[^\"]*\")\\s+\"(([^\"])*)\"");
        Vector<File> v = new Vector<File>();
        for (int n = 0; n < lines.length; ++n) {
            String[] strs;
            Matcher m;
            String line = lines[n];
            if (line == null || line.trim().length() == 0) continue;
            line = line.trim();
            line = line.replace('[', ' ');
            line = line.replace(']', ' ');
            if (!(line = line.trim()).startsWith("Option") || !(m = p.matcher(line)).matches() || m.groupCount() != 5 || (strs = TextUtils.tokenize(m.group(4), ":")) == null) continue;
            File parentFile = f.getParentFile();
            for (int j = 0; j < strs.length; ++j) {
                File temp = strs[j].startsWith(".") && parentFile != null ? FileUtils.resolveRelativePath(FileUtils.getPWDFile(), strs[j]) : new File(strs[j]);
                if (temp.isAbsolute() && temp.exists()) {
                    v.addElement(temp);
                    continue;
                }
                temp = FileUtils.resolveRelativePath(f.getParentFile(), strs[j]);
                if (!temp.exists()) continue;
                v.addElement(temp);
            }
        }
        if (v.size() == 0) {
            return null;
        }
        Vector<File> vv = new Vector<File>();
        for (int i = 0; i < v.size(); ++i) {
            File fi = (File)v.elementAt(i);
            if (fi == null) continue;
            String path = fi.getPath();
            if (path.endsWith(".")) {
                path = path.substring(0, path.length() - 1);
            }
            vv.addElement(new File(path));
        }
        return VectorUtils.toFileArray(vv);
    }

    public static int[] getOffsetsOfCameraTransforms(String cameraBlock) {
        int i;
        if (cameraBlock == null || cameraBlock.trim().length() == 0) {
            return null;
        }
        Vector<StringBuffer> v = new Vector<StringBuffer>();
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < cameraBlock.length(); ++i) {
            if (cameraBlock.charAt(i) == '\n') {
                sb.append(cameraBlock.charAt(i));
                v.addElement(sb);
                sb = new StringBuffer();
                continue;
            }
            sb.append(cameraBlock.charAt(i));
        }
        String[] line = new String[v.size()];
        for (i = 0; i < line.length; ++i) {
            line[i] = ((StringBuffer)v.elementAt(i)).toString();
        }
        int begin = -1;
        int end = -1;
        for (int n = 0; n < line.length; ++n) {
            if (line[n] == null || line[n].trim().length() == 0) continue;
            line[n] = line[n].trim().toLowerCase();
            if (!line[n].startsWith("translate") && !line[n].startsWith("rotate") && !line[n].startsWith("scale") && !line[n].startsWith("skew")) continue;
            if (begin == -1) {
                begin = n;
            }
            end = n;
        }
        begin = begin == -1 ? -1 : begin + 1;
        int n = end = end == -1 ? -1 : end + 1;
        if (begin == -1 || end == -1) {
            return null;
        }
        int[] out = new int[]{begin, end};
        return out;
    }

    private void ___CHANGE_RIB_DOC__METHODS________() {
    }

    public static boolean setUserOptionVendor(File file) {
        KAbstractWindow w = KAbstractDesktop.getWindowWithFile(file);
        if (w == null || !(w instanceof KTextWindow)) {
            return false;
        }
        KTextPane textpane = ((KTextWindow)w).getTextPane();
        if (textpane == null) {
            return false;
        }
        Document doc = textpane.getDocument();
        return RibScriptHandler.setUserOptionRenderer(doc);
    }

    public static String getUserOptionRenderer(File file) {
        KAbstractWindow w = KAbstractDesktop.getWindowWithFile(file);
        if (w == null || !(w instanceof KTextWindow)) {
            return null;
        }
        KTextPane textpane = ((KTextWindow)w).getTextPane();
        if (textpane == null) {
            return null;
        }
        Document doc = textpane.getDocument();
        Vector<int[]> listOfOffsets = new Vector<int[]>();
        String[] lines = DocumentUtils.getParagraphs(doc, 0, 50, listOfOffsets);
        return RibScriptHandler.getUserOptionRenderer(lines);
    }

    public static String getUserOptionRenderer(String[] lines) {
        if (lines == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < lines.length; ++n) {
            String[] tokens;
            String line = lines[n];
            if (line == null || !line.trim().startsWith("Option") || (tokens = TextUtils.tokenize(line, '\"')) == null) continue;
            v.setSize(0);
            for (int j = 0; j < tokens.length; ++j) {
                String tok = tokens[j];
                if (tok == null) continue;
                if (tok.trim().startsWith("string")) {
                    v.addElement(tok.substring(6).trim());
                    continue;
                }
                if (tok.trim().equals("[") || tok.trim().equals("]")) continue;
                v.add(tok.trim());
            }
            tokens = VectorUtils.toStringArray(v);
            if (tokens == null || tokens.length < 4 || !tokens[1].equals("user") || !tokens[tokens.length - 2].equals("renderer")) continue;
            String user_renderer = tokens[tokens.length - 1];
            if (user_renderer == null) {
                return null;
            }
            return user_renderer;
        }
        return null;
    }

    public static String getUserOption(File file, String datatype, String name) {
        Vector<int[]> listOfOffsets;
        KAbstractWindow w = KAbstractDesktop.getWindowWithFile(file);
        if (w == null || !(w instanceof KTextWindow)) {
            return null;
        }
        KTextPane textpane = ((KTextWindow)w).getTextPane();
        if (textpane == null) {
            return null;
        }
        Document doc = textpane.getDocument();
        String[] lines = DocumentUtils.getParagraphs(doc, 0, 50, listOfOffsets = new Vector<int[]>());
        if (lines == null) {
            return null;
        }
        Vector<String> tmp = new Vector<String>();
        for (int n = 0; n < lines.length; ++n) {
            int offset = lines[n].indexOf("#");
            if (offset == -1) {
                tmp.addElement(lines[n]);
                continue;
            }
            tmp.addElement(lines[n].substring(0, offset));
        }
        lines = VectorUtils.toStringArray(tmp);
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < lines.length; ++n) {
            String[] tokens;
            String line = lines[n];
            if (line == null || !line.trim().startsWith("Option") || (tokens = TextUtils.tokenize(line, '\"')) == null) continue;
            v.setSize(0);
            for (int j = 0; j < tokens.length; ++j) {
                String tok = tokens[j];
                if (tok == null) continue;
                if (tok.trim().startsWith(datatype)) {
                    v.addElement(tok.substring(6).trim());
                    continue;
                }
                if (tok.trim().equals("[") || tok.trim().equals("]")) continue;
                v.add(tok.trim());
            }
            tokens = VectorUtils.toStringArray(v);
            if (tokens == null || tokens.length < 4 || !tokens[1].equals("user") || !tokens[tokens.length - 2].equals(name)) continue;
            String value = tokens[tokens.length - 1];
            if (value == null) {
                return null;
            }
            return value;
        }
        return null;
    }

    private static boolean setUserOptionRenderer(Document doc) {
        Vector<int[]> listOfOffsets = new Vector<int[]>();
        String[] lines = DocumentUtils.getParagraphs(doc, 0, 50, listOfOffsets);
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < lines.length; ++n) {
            String[] tokens;
            String line = lines[n];
            if (line == null || !line.trim().startsWith("Option") || (tokens = TextUtils.tokenize(line, '\"')) == null) continue;
            v.setSize(0);
            for (int j = 0; j < tokens.length; ++j) {
                String tok = tokens[j];
                if (tok == null) continue;
                if (tok.trim().startsWith("string")) {
                    v.addElement(tok.substring(6).trim());
                    continue;
                }
                if (tok.trim().equals("[") || tok.trim().equals("]")) continue;
                v.add(tok.trim());
            }
            tokens = VectorUtils.toStringArray(v);
            if (tokens == null || tokens.length < 4 || !tokens[1].equals("user") || !tokens[tokens.length - 2].equals("renderer")) continue;
            String user_renderer = tokens[tokens.length - 1];
            if (user_renderer == null) {
                return false;
            }
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:RibScriptHandler.setUserOptionVendor() - user:renderer is \"" + user_renderer + "\"");
            }
            if (RenderInfo.activeNameOfRendererIs(user_renderer)) {
                return false;
            }
            int[] offsets = listOfOffsets.elementAt(n);
            if (offsets == null) {
                return false;
            }
            try {
                String current = RenderInfo.activeNameOfRenderer();
                if (current.equals("3delight")) {
                    current = "renderdl";
                } else if (current.equals("pixar")) {
                    current = "prman";
                }
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:RibScriptHandler.setUserOptionVendor() - RenderInfo.activeNameOfRenderer() \"" + current + "\"");
                }
                String str = "Option \"user\" \"string renderer\" [\"" + current + "\"]\n";
                doc.remove(offsets[1], offsets[0]);
                doc.insertString(offsets[1], str, null);
                continue;
            }
            catch (BadLocationException e) {
                Cutter.setLog("    Exception:RibScriptHandler.setUserOptionVendor() - " + e.toString());
                return false;
            }
        }
        return true;
    }

    public static void checkSearchPaths(File file) {
        File[] files;
        if (file == null) {
            return;
        }
        Segment segment = BBxt.getWindowText(null);
        if (segment != null && RibScriptHandler.getCameraBlock(segment) == null) {
            Cutter.setLog("    Info:RibScriptHandler.checkSearchPaths() - front document is a pre-bake rib");
            return;
        }
        if (tableOfWarnings.get(file.getPath()) != null) {
            return;
        }
        if (RegExpUtils.findFirstOccuranceOf(segment.toString(), "FrameBegin", false, true) != null) {
            return;
        }
        ScriptHandler handler = ScriptRegistry.getHandlerForFile(file);
        if (handler != null && handler instanceof RibScriptHandler && ((files = ((RibScriptHandler)handler).getSystemHeadersDirs(file)) == null || files.length == 0)) {
            tableOfWarnings.put(file.getPath(), file.getPath());
            String[] msgs = new String[]{"Rib files generally have at least one search path.", "For example,\n", "    Option \"searchpath\" \"shader\" \"Path1:Path2\"\n", "Do you want Cutter to add the relevent paths?", "This warning will only be shown once per file.\n"};
            if (FileUtils.isRMSRibFile(file) == null && DialogUtils.confirm("No Search Paths", "ignored", msgs)) {
                KAbstractWindow kaw = KAbstractDesktop.getWindowWithFile(file);
                if (kaw == null || !(kaw instanceof KTextWindow)) {
                    return;
                }
                StringBuffer buff = new StringBuffer();
                buff.append(RenderInfo.getOption("ribparse", ""));
                buff.append(RenderInfo.getOption("searchpath", "shader"));
                buff.append(RenderInfo.getOption("searchpath", "rixplugin"));
                buff.append(RenderInfo.getOption("searchpath", "texture"));
                buff.append(RenderInfo.getOption("searchpath", "archive"));
                buff.append("#------------------------------------------------------");
                KTextWindow ktw = (KTextWindow)kaw;
                ktw.prependText(buff.toString());
                ktw.saveFile();
            }
        }
    }

    private static void nullWindowFileError() {
        Cutter.setLog("RmanTool.newDocWithText() - BBxt.getWindowFile() return null");
        JOptionPane.showMessageDialog(KDesktop.desktopPane, "Please save your document before continuing.", "Document Not Saved Error", 0);
    }

    private static void nullSLNameError() {
        Cutter.setLog("RmanTool.newDocWithText() - BBxt.slGetShaderName() return null");
        JOptionPane.showMessageDialog(KDesktop.desktopPane, "Please ensure your document is the active window by clicking on its title bar", "Document Not Selected Error", 0);
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("rib", "RenderMan Rib");
        return filter;
    }
}

