/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rib;

import UI_Script.Rib.RIBStatementsRsrc;
import UI_Script.Rib.RIS.StringsRIS;
import UI_Script.Rib.StringsAttribute;
import UI_Script.Rib.StringsGraphicState;
import UI_Script.Rib.StringsOption;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.TextUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class RibTokenizer
extends Tokenizer {
    private static ResourceBundle RiStatementsRes;
    public static Hashtable<String, String> statements;
    public static final int INSUFFICIENT_KEYFRAMES = -1;
    public static final int RIB = 1;
    public static final int ANIMATION = 2;
    public static final int IMPORT = 3;
    public boolean getSquareBrackets = true;
    public boolean parseComments = false;

    private static String getStatement(String nm) {
        String str;
        try {
            str = RiStatementsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numStatements() {
        int num = 0;
        try {
            num = ((RIBStatementsRsrc)RiStatementsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read RIBStatementsRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < RibTokenizer.numStatements(); ++i) {
            statements.put(((RIBStatementsRsrc)RiStatementsRes).getKey(i), ((RIBStatementsRsrc)RiStatementsRes).getContent(i));
        }
    }

    public RibTokenizer() {
        this.addComment("#", "\n");
        this.addQuotation("\"", "\"", '\\');
        this.setSyntaxLength(1);
        String[] ext = new String[]{"rib", "RIB"};
        Tokenizer.addToRegistry(RibTokenizer.class, ext, this.getComments(), this.getDelimitors());
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor(".-");
    }

    public RibTokenizer(String filename) throws FileNotFoundException, IOException {
        super(filename);
        this.addComment("#", "\n");
        this.setSyntaxLength(1);
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor(".-");
    }

    public boolean isRibStatement(String str) {
        return this.isFunction(str);
    }

    @Override
    public boolean isFunction(String str) {
        boolean result = statements.containsKey(str.toLowerCase());
        String obj = null;
        if (result) {
            obj = statements.get(str.toLowerCase());
        }
        if (obj == null) {
            return false;
        }
        return ((String)obj).equals(str);
    }

    public static boolean isQuadric(String str) {
        return str.equals("Sphere") || str.equals("Cylinder") || str.equals("Cone") || str.equals("Torus") || str.equals("Paraboloid") || str.equals("Hyperboloid") || str.equals("Disk");
    }

    public static boolean isPolygon(String str) {
        return str.equals("Polygon") || str.equals("GeneralPolygon") || str.equals("PointsPolygons") || str.equals("PointsGeneralPolygons");
    }

    public static boolean isPatch(String str) {
        return str.equals("Basis") || str.equals("Patch") || str.equals("PatchMesh") || str.equals("NuPatch") || str.equals("TrimCurve");
    }

    public static boolean isSolids(String str) {
        return str.equals("SolidBegin") || str.equals("SolidEnd");
    }

    public static boolean isRIS(String str) {
        for (int n = 0; n < StringsRIS.names.length; ++n) {
            if (!str.equals(StringsRIS.names[n])) continue;
            return true;
        }
        return false;
    }

    public static boolean isAttribute(String str) {
        for (int n = 0; n < StringsAttribute.names.length; ++n) {
            if (!str.equals(StringsAttribute.names[n])) continue;
            return true;
        }
        return false;
    }

    public static boolean isGraphicState(String str) {
        for (int n = 0; n < StringsGraphicState.names.length; ++n) {
            if (!str.equals(StringsGraphicState.names[n])) continue;
            return true;
        }
        return false;
    }

    public static boolean isOption(String str) {
        for (int n = 0; n < StringsOption.names.length; ++n) {
            if (!str.equals(StringsOption.names[n])) continue;
            return true;
        }
        return false;
    }

    public static boolean isProcedural(String str) {
        return str.equals("Procedural");
    }

    @Override
    public String _getNextStr() {
        boolean literal = false;
        boolean endOfString = false;
        boolean endOfComment = false;
        this.outBuff.setLength(0);
        char c = this.readChar();
        if (c == '\u0000') {
            return "";
        }
        if (this.isSpace(c)) {
            c = this.removeSpace();
        }
        if (c == '\u0000') {
            return "";
        }
        if (c == '#' && this.getComments && this.peekAtChar() != '#') {
            do {
                this.outBuff.append(c);
                c = this.readChar();
                if (c != '\u0000') continue;
                return this.outBuff.toString();
            } while (c != '\n');
            this.ungetChar();
            return this.outBuff.toString();
        }
        if ((c == '#' && !this.getComments && !this.parseComments || this.isSpace(c)) && (c = this.nextValidChar()) == '\u0000') {
            return "";
        }
        while (c == '[' || c == ']') {
            int action = 0;
            if (this.getSquareBrackets) {
                action = 1;
            }
            switch (action) {
                case 0: {
                    c = this.readChar();
                    if (c != '#' && !this.isSpace(c) || (c = this.nextValidChar()) != '\u0000') break;
                    return "";
                }
                case 1: {
                    return "" + c;
                }
            }
        }
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.append(c);
        if (c == '\"') {
            literal = true;
        }
        while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            switch (c) {
                case '\u0000': {
                    return "";
                }
                case '\"': {
                    if (literal) {
                        this.outBuff.append(c);
                        return this.outBuff.toString();
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case ']': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\t': 
                case ' ': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\n': 
                case '\r': {
                    if (this.getCR_Newlines) {
                        this.outBuff.append(c);
                        return this.outBuff.toString();
                    }
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '#': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        return this.outBuff.toString();
    }

    private char nextValidChar() {
        this.ungetChar();
        char c = this.readChar();
        if (this.getComments && c == '#') {
            return c;
        }
        while (c == '#' || this.isSpace(c)) {
            if (this.isSpace(c) && (c = this.removeSpace()) == '\u0000') {
                return '\u0000';
            }
            while (c == '#' && !this.getComments) {
                while (c != '\r' && c != '\n') {
                    c = this.readChar();
                    if (!this.mEndOfBuffer) continue;
                    return '\u0000';
                }
                c = this.readChar();
                if (!this.isSpace(c) || (c = this.removeSpace()) != '\u0000') continue;
                return '\u0000';
            }
            if (!this.mEndOfBuffer) continue;
            return '\u0000';
        }
        return c;
    }

    @Override
    public boolean isNamedSpace(String s) {
        return false;
    }

    public String getNextRibStatement(String terminatorStr) {
        return this.getNextRibStatement(terminatorStr, true);
    }

    public String getNextRibStatement(String terminatorStr, boolean findEndOf) {
        String token = "";
        while (!(token = this.getNextStr()).equals("")) {
            if ((terminatorStr == null || !token.equalsIgnoreCase(terminatorStr)) && !this.isFunction(token)) continue;
            if (!findEndOf) {
                for (int i = 0; i < token.length() + 1; ++i) {
                    this.ungetChar();
                }
                return token;
            }
            return token;
        }
        return token;
    }

    public String getNextRibStatement() {
        String str = this.getNextStr();
        while (!str.equals("")) {
            if (str.startsWith("#")) {
                return str;
            }
            if (this.isFunction(str)) {
                String statement;
                int endIndex;
                int startIndex = this.getBufferIndex() - str.length();
                String next = this.getNextRibStatement(null, true);
                if (next.equals("")) {
                    endIndex = this.getBufferIndex();
                    statement = new String(this.getBuffer(startIndex));
                } else {
                    endIndex = this.getBufferIndex() - (next.length() + 1);
                    statement = new String(this.getBuffer(startIndex, endIndex));
                }
                String[] lines = TextUtils.tokenize(statement, '\n');
                if (lines != null && lines.length > 0) {
                    StringBuffer buf = new StringBuffer();
                    for (int n = 0; n < lines.length; ++n) {
                        String line = lines[n];
                        if (this.isComment(line)) continue;
                        int commentBegin = line.indexOf(35);
                        if (commentBegin != -1) {
                            line = line.substring(0, commentBegin);
                        }
                        buf.append(line);
                    }
                    statement = buf.toString();
                }
                this.setBufferIndex(endIndex);
                return statement;
            }
            str = this.getNextStr();
        }
        return "";
    }

    @Override
    public boolean isComment(String str) {
        return str.startsWith("#");
    }

    public int scriptIsTypeOf() {
        String token;
        boolean endOfText = false;
        boolean foundTweenStatement = false;
        boolean foundKeyFrameStatement = false;
        boolean offset = false;
        int numKeyBegin = 0;
        int numKeyEnd = 0;
        int scriptType = 0;
        if (this.searchFor("Tween", true) != -1) {
            foundTweenStatement = true;
        }
        this.rewindBuffer();
        while (!(token = this.getNextStr()).equals("")) {
            if (RibTokenizer.isOfType(token) != 4) continue;
            if (token.equalsIgnoreCase("worldbegin")) {
                scriptType = 1;
            }
            if (token.equalsIgnoreCase("keyframebegin")) {
                foundKeyFrameStatement = true;
                ++numKeyBegin;
                scriptType = 2;
                continue;
            }
            if (!token.equalsIgnoreCase("keyframeend")) continue;
            foundKeyFrameStatement = true;
            ++numKeyEnd;
            scriptType = 2;
        }
        if (scriptType == 0) {
            return 0;
        }
        if (scriptType == 2) {
            if (numKeyBegin < 2 || numKeyEnd < 2) {
                return -1;
            }
            return 2;
        }
        return 1;
    }

    public String remove(String target) {
        int n;
        this.rewindBuffer();
        int start = this.searchFor(target, false);
        if (start == -1) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (n = 0; n < start; ++n) {
            out.append(this.mBuff[n]);
        }
        boolean doCopy = false;
        for (n = start + 1; n < this.mBuff.length && this.mBuff[n] != '\n'; ++n) {
        }
        out.append(this.mBuff, n, this.mBuff.length - n);
        return out.toString();
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        ProcDBItem out = new ProcDBItem();
        out.procNameOffset = new int[2];
        int index = this.getBufferIndex();
        if (!str.equals("Attribute")) {
            this.setBufferIndex(index);
            return null;
        }
        out.procType = "Attribute";
        str = this.getNextStr();
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        if (!str.equals("\"identifier\"")) {
            this.setBufferIndex(index);
            return null;
        }
        str = this.getNextStr();
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        str = TextUtils.removeQuotes(str);
        Tokenizer t = new Tokenizer();
        t.setBuffer(str);
        if (t.stringSearch("name", true) == null) {
            this.setBufferIndex(index);
            return null;
        }
        StringBuffer buff = new StringBuffer();
        int[] offsets = new int[2];
        str = this.getNextStr();
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        if (str.equals("[")) {
            this.setBufferIndex(this.getBufferIndex() - 1);
            offsets = this.lpGrabProcBody("[", "]", buff);
            if (offsets == null) {
                this.setBufferIndex(index);
                return null;
            }
        } else {
            out.procName = str;
            out.procNameOffset[0] = this.getBufferIndex() - str.length();
            out.procNameOffset[1] = this.getBufferIndex();
            out.procOffset[0] = out.procNameOffset[0];
            out.procOffset[1] = out.procNameOffset[1];
            return out;
        }
        out.procNameOffset[0] = offsets[0];
        out.procName = TextUtils.remove(buff.toString(), ']');
        out.procNameOffset[1] = offsets[1];
        out.procOffset[0] = out.procNameOffset[0];
        out.procOffset[1] = out.procNameOffset[1];
        return out;
    }

    public String getStatementNamed(String target) {
        int beginOffset = this.searchFor(target, false);
        if (beginOffset == -1) {
            return null;
        }
        this.setBufferIndex(beginOffset + target.length());
        String str = this.getNextRibStatement(null, false);
        if (str.equals("")) {
            return null;
        }
        int endOffset = this.getBufferIndex();
        char[] buff = this.getBuffer(beginOffset, endOffset);
        if (buff == null) {
            return null;
        }
        return new String(buff);
    }

    static {
        statements = new Hashtable();
        try {
            RiStatementsRes = ResourceBundle.getBundle("UI_Script.Rib.RIBStatementsRsrc");
        }
        catch (MissingResourceException mre) {
            System.err.println("A resource file is missing --> " + mre);
        }
        RibTokenizer.initHashTable();
    }
}

