/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rlf;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Rlf.RlfHelp;
import UI_Script.Rlf.RlfJSONPayload;
import UI_Text.KTextPane.KTextPane;
import Utilities.DocumentUtils;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import javax.swing.AbstractAction;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class ReformatPayloadAction
extends AbstractAction {
    private KTextPane textpane;
    private String formatAction = RlfHelp.OPEN_PAYLOAD;

    public ReformatPayloadAction(KTextPane textpane, String formatAction) {
        this.textpane = textpane;
        this.formatAction = formatAction;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int begin = BBxt.getSelectionStart();
        if (this.formatAction.equals(RlfHelp.CLOSE_ALL_PAYLOADS)) {
            this.closeAllPayloads();
            BBxt.setSelection(begin, begin);
            return;
        }
        int end = BBxt.getSelectionEnd();
        if (begin == end) {
            Cutter.setLog("    Warning:ReformatPayloadAction.actionPerformed() - no selection");
            return;
        }
        if (this.formatAction.equals(RlfHelp.OPEN_PAYLOAD)) {
            this.convertToMultiLine(begin, end);
        } else if (this.formatAction.equals(RlfHelp.CLOSE_PAYLOAD)) {
            this.convertToInline(begin, end);
            BBxt.setSelection(begin, begin);
        }
    }

    private void closeAllPayloads() {
        RlfJSONPayload p = new RlfJSONPayload();
        RlfJSONPayload.PayloadLine[] lines = p.getOpenPayloadLines(this.textpane);
        for (int n = lines.length - 1; n >= 0; --n) {
            RlfJSONPayload.PayloadLine data = lines[n];
            int[] d = RlfJSONPayload.findPayloadString(this.textpane, data.begin, data.end);
            if (d == null || d.length != 2) continue;
            this.convertToInline(d[0] + data.begin, d[1] + data.begin);
        }
        BBxt.setSelection(0, 0);
    }

    private void convertToInline(int begin, int end) {
        String raw = this.getPayloadText(end);
        RlfJSONPayload payload = new RlfJSONPayload(this.textpane, raw, end + 1);
        BBxt.setSelection(payload.absOpenColon + 1, payload.absEndComma);
        BBxt.replaceSelection(payload.convertToEscapedStr());
        this.textpane.parseAll();
    }

    private void convertToMultiLine(int begin, int end) {
        String raw = this.getPayloadText(end);
        RlfJSONPayload payload = new RlfJSONPayload(this.textpane, raw, end + 1);
        String s = payload.getPayloadAsIndentedBlock(0, 5);
        BBxt.setSelection(payload.absOpenQuote, payload.absEndQuote);
        BBxt.replaceSelection("\n" + s);
        this.textpane.parseAll();
    }

    private String getPayloadText(int begin) {
        int len = this.textpane.getDocument().getLength() - begin;
        Segment segment = DocumentUtils.getSegment(this.textpane.getDocument(), begin, len);
        if (segment == null) {
            Cutter.setLog("    Error:ReformatPayloadAction.getPayloadStr() 1 - no document text!");
            return null;
        }
        String str = segment.toString();
        if (str == null) {
            Cutter.setLog("    Error:ReformatPayloadAction.getPayloadStr() 2 - no document text!");
            return null;
        }
        int offset = str.indexOf(44);
        if (offset == -1) {
            Cutter.setLog("    Error:ReformatPayloadAction.getPayloadStr() 3 - rlf is not properly structured!");
            return null;
        }
        str = str.substring(1, offset + 1);
        return str;
    }

    private String replaceEscapes(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        CharArrayWriter out = new CharArrayWriter();
        Tokenizer t = new Tokenizer();
        t.setBuffer(txt);
        char c = t.readChar();
        while (c != '\u0000') {
            if (c != '\\') {
                out.append(c);
                c = t.readChar();
                continue;
            }
            char ch = this.convertEscape(t.peekNextChar());
            if (ch != '\u0000') {
                out.append(ch);
                c = t.readChar();
                if (c == '\u0000') {
                    return out.toString();
                }
            }
            c = t.readChar();
        }
        return out.toString();
    }

    private char convertEscape(char c1) {
        switch (c1) {
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return '\u0000';
    }

    private String convertToEscapedStr(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        Tokenizer t = new Tokenizer();
        t.setBuffer(txt);
        char c = t.readChar();
        boolean addedSpace = false;
        while (c != '\u0000') {
            switch (c) {
                case '\n': {
                    out.append("\\").append("n");
                    addedSpace = true;
                    break;
                }
                case '\t': {
                    out.append("\\").append("t");
                    addedSpace = false;
                    break;
                }
                case '\"': {
                    out.append("\\").append("\"");
                    addedSpace = false;
                    break;
                }
                case ' ': {
                    if (addedSpace) break;
                    out.append(" ");
                    addedSpace = true;
                    break;
                }
                default: {
                    out.append(c);
                    addedSpace = false;
                }
            }
            c = t.readChar();
        }
        return out.toString();
    }

    private class PayLoad {
        public int beginOffset;
        public int openQuoteOffset;
        public int endQuoteOffset;
        public int openColonOffset;
        public int endCommaOffset;
        public int absOpenQuote;
        public int absOpenColon;
        public int absEndQuote;
        public int absEndComma;
        public String text = null;

        public PayLoad(String str, int begin) {
            this.beginOffset = begin;
            this.openColonOffset = str.indexOf(58);
            this.openQuoteOffset = str.indexOf(34);
            this.endQuoteOffset = str.lastIndexOf(34);
            this.endCommaOffset = str.lastIndexOf(44);
            this.text = str.substring(this.openQuoteOffset + 1, this.endQuoteOffset);
            this.absOpenColon = this.openColonOffset + begin;
            this.absOpenQuote = this.openQuoteOffset + begin;
            this.absEndQuote = this.endQuoteOffset + begin;
            this.absEndComma = this.endCommaOffset + begin;
            Cutter.setLog("begin " + begin);
            Cutter.setLog("absOpenQuote " + this.absOpenQuote);
            Cutter.setLog("absEndQuote " + this.absEndQuote);
            Cutter.setLog("absEndComma " + this.absEndComma);
            Cutter.setLog("Payload----------------------");
            Cutter.setLog(">" + this.text + "<");
            Cutter.setLog("-----------------------------");
        }

        public String[] replaceEscapes() {
            this.text = ReformatPayloadAction.this.replaceEscapes(this.text);
            return TextUtils.tokenize(this.text, '\n');
        }

        public int[] getAbsoluteOffsets() {
            int[] out = new int[]{this.openColonOffset, this.absOpenQuote, this.absEndQuote, this.absEndComma};
            return out;
        }

        public String toString() {
            return "";
        }
    }
}

