/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rlf;

import Processes.ProcListener;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Rib.ReformatStatementAction;
import UI_Script.Rib.RibTokenizer;
import UI_Script.Rlf.ReformatPayloadAction;
import UI_Script.Rlf.RlfJSONPayload;
import UI_Script.Rlf.RlfXMLTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.Tabs.Rib.RenderManager;
import Utilities.DocumentUtils;
import Utilities.RibUtils;
import Utilities.RlfUtils;
import Utilities.TextUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.text.Segment;

public class RlfHelp
extends KAbstractHelp
implements ProcListener {
    public static String OPEN_PAYLOAD;
    public static String CLOSE_PAYLOAD;
    public static String CLOSE_ALL_PAYLOADS;
    private static Hashtable<String, String> languageTable;
    public static final String INDENTATION_DOC = "Apply Indentation";

    public RlfHelp(KTextPane textpane) {
        super(textpane);
        this.completer.completionActivate();
        this.completer.setWordStartDelims(null);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        return Character.isUpperCase(str.charAt(0));
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    @Override
    protected KAbstractHelp.KPopupMenuItem getDefaultExecute() {
        return null;
    }

    @Override
    public void popupOnlineHelp(Point pnt, final String selection, final int end, MouseEvent e) {
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, end - selection.length(), end);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        popup.add(this.getReformatStatementItem());
        popup.add(new JSeparator());
        popup.add(this.getAppyIndentationItem());
        popup.add(this.getOpenRIBItem());
        popup.add(this.getRenderRIBItem());
        popup.add(new JSeparator());
        popup.add(defaultMenu);
        popup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                int begin = end - selection.length();
                if (begin >= 0 && end >= 0) {
                    BBxt.setSelection(begin, end);
                }
            }
        });
        popup.pack();
        popup.show(this.textpane, pnt.x, pnt.y);
    }

    public KAbstractHelp.KPopupMenuItem getAppyIndentationItem() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(INDENTATION_DOC);
        ActionListener reformatAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int cursorAt = BBxt.getSelectionStart();
                String src = BBxt.getWindowText();
                if (src == null || src.trim().length() == 0) {
                    return;
                }
                String[] result = RlfUtils.reformat(src);
                if (result == null) {
                    return;
                }
                BBxt.selectAll();
                BBxt.paste(result[1]);
                if (cursorAt != -1) {
                    BBxt.setSelection(cursorAt, cursorAt);
                }
            }
        };
        mi.addActionListener(reformatAction);
        mi.setEnabled(true);
        return mi;
    }

    public KAbstractHelp.KPopupMenuItem getReformatStatementItem() {
        String action = "Convert To Multi Line";
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Convert To Multi Line");
        mi.setEnabled(false);
        String sel = "";
        if (this.selRawStr.equals("")) {
            int selDeltaBegin;
            int selDeltaEnd = selDeltaBegin = this.selRawBegin - this.lineBegin;
            sel = this.doOrderedExpansion(selDeltaBegin, selDeltaEnd);
        } else {
            sel = this.initialSelection;
        }
        if (sel == null || sel.trim().length() == 0) {
            return mi;
        }
        int beginOffset = BBxt.getSelectionStart();
        int endOffset = BBxt.getSelectionEnd();
        if (endOffset == -1) {
            Cutter.setLog("    Error:RibHelp.getReformatStatementItem() - cannot find the end offset of the current selection.");
            return null;
        }
        if (ReformatStatementAction.canBeReformatted(sel)) {
            mi.setEnabled(true);
            mi.addMouseListener(new KAbstractHelp.KSelectionExpander());
            RibUtils r = new RibUtils();
            RibUtils.ParamBlock paramsBlock = r.getParamBlock(this.textpane, sel, endOffset);
            if (paramsBlock == null) {
                Cutter.setLog("    Error:RibHelp:getReformatStatementItem() - cannot get parameters for \"" + sel + "\"");
                return null;
            }
            if (paramsBlock.numNewlines > 1) {
                action = "Convert To Single Line";
                mi.setText("Convert To Single Line");
            }
            ReformatStatementAction rsa = new ReformatStatementAction(this.textpane, sel, action);
            mi.addActionListener(rsa);
        }
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem getCloseAllPayloadsItem() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(CLOSE_ALL_PAYLOADS);
        mi.setEnabled(false);
        RlfJSONPayload p = new RlfJSONPayload();
        RlfJSONPayload.PayloadLine[] lines = p.getOpenPayloadLines(this.textpane);
        if (lines.length > 0) {
            mi.setEnabled(true);
            ReformatPayloadAction action = new ReformatPayloadAction(this.textpane, CLOSE_ALL_PAYLOADS);
            mi.addActionListener(action);
        }
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem getReformatPayloadItem() {
        boolean reformat = true;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(OPEN_PAYLOAD);
        mi.setEnabled(false);
        int offset = BBxt.getSelectionEnd();
        int[] line = DocumentUtils.getLineNumberAt(this.textpane.getDocument(), offset);
        if (line == null) {
            return mi;
        }
        Segment lineSegment = DocumentUtils.getSegment(this.textpane.getDocument(), line[1], line[2] - line[1]);
        if (lineSegment == null) {
            return mi;
        }
        String linetxt = lineSegment.toString().trim();
        if (linetxt.startsWith("\"payload\"")) {
            mi.setEnabled(true);
        }
        if (!linetxt.endsWith(",")) {
            reformat = false;
            mi.setText(CLOSE_PAYLOAD);
        }
        mi.addMouseListener(new PayloadSelectionExpander(line[1], line[2]));
        ReformatPayloadAction action = new ReformatPayloadAction(this.textpane, mi.getText());
        mi.addActionListener(action);
        return mi;
    }

    protected KAbstractHelp.KPopupMenuItem getRenderRIBItem() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Render Parent RIB");
        File f = this.textpane.getFrameFile();
        if (f == null) {
            mi.setEnabled(false);
        }
        String rlfname = f.getName();
        String ribname = TextUtils.removeExtension(rlfname) + ".rib";
        final File ribfile = new File(f.getParent(), ribname);
        if (!ribfile.exists()) {
            mi.setEnabled(false);
        }
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RlfHelp.this.textpane.parseAll();
                RenderManager.renderFile(ribfile, "", false, true);
            }
        };
        mi.addActionListener(action);
        return mi;
    }

    protected KAbstractHelp.KPopupMenuItem getOpenRIBItem() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Open Parent RIB");
        File f = this.textpane.getFrameFile();
        if (f == null) {
            mi.setEnabled(false);
            return mi;
        }
        String rlfname = f.getName();
        String ribname = TextUtils.removeExtension(rlfname) + ".rib";
        final File rib = new File(f.getParent(), ribname);
        if (!rib.exists()) {
            mi.setEnabled(false);
        }
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.newDocument(rib);
            }
        };
        mi.addActionListener(action);
        return mi;
    }

    @Override
    protected void lookup(String item) {
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        return false;
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
    }

    @Override
    public void processFinished(String[] progarray) {
    }

    static {
        String str;
        OPEN_PAYLOAD = "Open Payload";
        CLOSE_PAYLOAD = "Close Payload";
        CLOSE_ALL_PAYLOADS = "Close All Payloads";
        languageTable = new Hashtable();
        Enumeration<String> e = RlfXMLTokenizer.language.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        e = RibTokenizer.statements.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            languageTable.put(str, RibTokenizer.statements.get(str));
        }
    }

    protected class PayloadSelectionExpander
    extends MouseAdapter {
        int payloadBegin = -1;
        int payloadEnd = -1;

        public PayloadSelectionExpander(int begin, int end) {
            int[] offsets = RlfJSONPayload.findPayloadString(RlfHelp.this.textpane, begin, end);
            if (offsets == null) {
                return;
            }
            this.payloadBegin = offsets[0] + begin;
            this.payloadEnd = offsets[1] + begin;
            BBxt.setSelection(this.payloadBegin, this.payloadEnd);
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            if (this.payloadBegin != -1 && this.payloadEnd != -1) {
                BBxt.setSelection(this.payloadBegin, this.payloadEnd);
            }
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            if (this.payloadBegin != -1 && this.payloadEnd != -1) {
                BBxt.setSelection(this.payloadBegin, this.payloadEnd);
            }
        }
    }
}

