/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rlf;

import Preferences.Preferences;
import UI_Script.Rib.RibTokenizer;
import UI_Script.Rlf.RlfJSONTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import Utilities.DocumentUtils;
import java.awt.Color;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class RlfJSONListener
extends SyntaxListener {
    boolean assembly_nameOpen = false;

    public RlfJSONListener(KTextPane textpane) {
        super(textpane, new RlfJSONTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void addComments() {
        this.addComments("//");
        this.addComments("/*", "*/");
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_RLF_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RLF_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_RLF_KEYWORD));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RLF_STRING));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RLF_RIB));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_RLF_ESCAPE));
        Color RLD = Preferences.getColor(Preferences.TEXT_COLOR_RLF_KEYWORD).darker();
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, RLD);
        StyleConstants.setBold(textpane.styleContext.keywordStyle3, true);
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (this.tok.isNamedSpace(str)) {
            if (str.equals("\"assembly-name\"")) {
                this.assembly_nameOpen = true;
            }
            editList.addEdit(begin + 1, str.length() - 2, this.textpane.styleContext.keywordStyle2, true);
            return true;
        }
        RlfJSONTokenizer rlfTok = (RlfJSONTokenizer)this.tok;
        int payloadBeginChars = rlfTok.isPayloadBegin(str);
        if (payloadBeginChars > 0) {
            int loadbegin = rlfTok.getBufferIndex() - str.length();
            int loadend = -1;
            String s = rlfTok.getNextStr();
            while (!s.equals("")) {
                if (rlfTok.isPayloadEnd(s)) {
                    loadend = rlfTok.getBufferIndex();
                    break;
                }
                s = rlfTok.getNextStr();
            }
            if (loadend == -1) {
                rlfTok.addDelimitor(' ');
                editList.addEdit(loadbegin, str.length(), this.textpane.styleContext.stringStyle2, true);
                return true;
            }
            Document doc = this.textpane.getDocument();
            Segment seg = DocumentUtils.getSegment(doc, loadbegin, loadend - loadbegin);
            String payload = seg.toString();
            if ((payload = RlfJSONListener.replaceEscapes(payload)).startsWith("\"")) {
                payload = payload.substring(1);
            }
            if (payload.endsWith("\",")) {
                payload = payload.substring(0, payload.length() - 2);
            }
            RibTokenizer rt = new RibTokenizer();
            rt.setBuffer(payload);
            editList.addEdit(loadbegin, loadend - loadbegin, this.textpane.styleContext.stringStyle2, true);
            String strn = rt.getNextStr();
            while (!strn.equals("")) {
                int offset = rt.getBufferIndex() - strn.length() + loadbegin + (payloadBeginChars == 3 ? 1 : 0);
                if (rt.isRibStatement(strn)) {
                    editList.addEdit(offset, strn.length(), this.textpane.styleContext.keywordStyle1, true);
                } else if (rt.isComment(strn)) {
                    if (strn.endsWith(" \n")) {
                        editList.addEdit(offset, strn.length() - 2, this.textpane.styleContext.commentStyle1, true);
                    } else {
                        editList.addEdit(offset, strn.length(), this.textpane.styleContext.commentStyle1, true);
                    }
                } else {
                    editList.addEdit(offset, strn.length(), this.textpane.styleContext.stringStyle1, true);
                }
                strn = rt.getNextStr();
            }
            return true;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            if (this.assembly_nameOpen) {
                this.assembly_nameOpen = false;
                editList.addEdit(begin + 1, str.length() - 2, this.textpane.styleContext.plainStyle, true);
            } else {
                editList.addEdit(begin + 1, str.length() - 2, this.textpane.styleContext.stringStyle1, true);
            }
            return true;
        }
        if (str.startsWith("\"RenderMan")) {
            char[] chs = this.tok.peekNextChars(11);
            if (chs == null) {
                return false;
            }
            String s = new String(chs);
            if (s.equals(" Look Data\"")) {
                int b = this.tok.getBufferIndex() - 10;
                editList.addEdit(b + 1, 19, this.textpane.styleContext.keywordStyle3, true);
                this.tok.setBufferIndex(this.tok.getBufferIndex() + 11);
                return true;
            }
        }
        return false;
    }

    public static String replaceEscapes(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        Tokenizer t = new Tokenizer();
        t.setBuffer(txt);
        char c = t.readChar();
        while (c != '\u0000') {
            if (c != '\\') {
                out.append(c);
                c = t.readChar();
                continue;
            }
            String temp = RlfJSONListener.convertEscape(c, t.peekNextChar());
            out.append(temp);
            c = t.readChar();
            if (c == '\u0000') {
                return out.toString();
            }
            c = t.readChar();
        }
        return out.toString();
    }

    public static String convertEscape(char c0, char c1) {
        if (c0 != '\\') {
            return "" + c0 + c1;
        }
        switch (c1) {
            case 't': {
                return " \t";
            }
            case 'n': {
                return " \n";
            }
            case '\"': {
                return " \"";
            }
            case '\'': {
                return " '";
            }
        }
        return "" + c0 + c1;
    }
}

