/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rlf;

import UI_Desktop.Cutter;
import UI_Script.Rib.RibTokenizer;
import UI_Text.KTextPane.KTextPane;
import Utilities.DocumentUtils;
import Utilities.RibUtils;
import Utilities.TextUtils;
import java.io.CharArrayWriter;
import java.util.Vector;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class RlfJSONPayload {
    public int beginOffset;
    public int openQuoteOffset;
    public int endQuoteOffset;
    public int openColonOffset;
    public int endCommaOffset;
    public int absOpenQuote;
    public int absOpenColon;
    public int absEndQuote;
    public int absEndComma;
    public int leadingTabs = 0;
    public int leadingSpaces = 0;
    public String text = null;
    public KTextPane textpane;

    public static int[] findPayloadString(KTextPane textpane, int begin, int end) {
        Segment lineSegment = DocumentUtils.getSegment(textpane.getDocument(), begin, end - begin);
        if (lineSegment == null) {
            return null;
        }
        String raw = lineSegment.toString();
        String trimmed = raw.trim();
        if (!trimmed.startsWith("\"payload\"")) {
            return null;
        }
        Tokenizer tok = new Tokenizer();
        tok.setBuffer(raw);
        int strBegin = tok.findForward(0, '\"') + 1;
        int strEnd = tok.findForward(strBegin, '\"');
        return new int[]{strBegin, strEnd};
    }

    public RlfJSONPayload() {
    }

    public RlfJSONPayload(KTextPane textpane, String str, int begin) {
        this.textpane = textpane;
        this.beginOffset = begin;
        this.openColonOffset = str.indexOf(58);
        this.openQuoteOffset = str.indexOf(34);
        this.endQuoteOffset = str.lastIndexOf(34);
        this.endCommaOffset = str.lastIndexOf(44);
        this.text = str.substring(this.openQuoteOffset + 1, this.endQuoteOffset);
        this.absOpenColon = this.openColonOffset + begin;
        this.absOpenQuote = this.openQuoteOffset + begin;
        this.absEndQuote = this.endQuoteOffset + begin;
        this.absEndComma = this.endCommaOffset + begin;
        this.leadingTabs = DocumentUtils.countTabStopsAtOffset(textpane.getDocument(), begin);
        int[] offsets = DocumentUtils.getLineNumberAt(textpane.getDocument(), begin);
        if (offsets != null) {
            int length = begin - offsets[1];
            Segment segment = DocumentUtils.getSegment(textpane.getDocument(), offsets[1], length);
            if (segment != null) {
                for (int n = 0; n < segment.length(); ++n) {
                    if (segment.charAt(n) != ' ') continue;
                    ++this.leadingSpaces;
                }
            }
        }
    }

    private String tabCountToString(int count) {
        if (count <= 0) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        for (int n = 0; n < count; ++n) {
            b.append('\t');
        }
        return b.toString();
    }

    public String getPayloadAsIndentedBlock(int extraTabs, int extraSpaces) {
        int n;
        String temp = this.replaceEscapes(this.text);
        String[] lines = TextUtils.tokenize(temp, '\n');
        StringBuffer b = new StringBuffer();
        for (n = 0; n < this.leadingTabs + extraTabs; ++n) {
            b.append('\t');
        }
        for (n = 0; n < this.leadingSpaces + extraSpaces; ++n) {
            b.append(" ");
        }
        String indent = b.toString();
        b.setLength(0);
        RibTokenizer tok = new RibTokenizer();
        String ribTabStr = "";
        String prevTabStr = "";
        int ribTabCount = 0;
        boolean isFirstBegin = true;
        for (int n2 = 0; n2 < lines.length; ++n2) {
            String prefix = TextUtils.getPrefixSpaces(lines[n2]);
            tok.setBuffer(lines[n2]);
            String statement = tok.getNextRibStatement(null, true);
            if (statement.endsWith("Begin")) {
                ++ribTabCount;
                prevTabStr = ribTabStr;
            }
            if (statement.endsWith("End")) {
                --ribTabCount;
            }
            ribTabStr = this.tabCountToString(ribTabCount);
            if (n2 == 0) {
                b.append(ribTabStr);
                b.append(indent).append("\"").append(lines[n2]);
            } else {
                if (statement.endsWith("Begin")) {
                    b.append(prevTabStr);
                } else {
                    b.append(ribTabStr);
                }
                if (statement.equals("Surface") || statement.equals("Displacement") || statement.equals("Shader")) {
                    RibUtils ributils = new RibUtils();
                    lines[n2] = lines[n2].replaceAll("\n", "");
                    RibUtils.ParamBlock block = ributils.getParamBlock(lines[n2], statement, tok.getBufferIndex());
                    if (block == null) {
                        Cutter.setLog("    Error:RlfPayload.getPayloadAsIndentedBlock() - cannot get parameters for:");
                        Cutter.setLog("           \"" + statement + "\"");
                        return "";
                    }
                    if (block.params.length > 1) {
                        b.append(indent).append(prefix).append(block.currStatment).append('\n');
                        b.append(block.getParamesAsIndentedBlock(ribTabCount, 23)).append('\n');
                        continue;
                    }
                    b.append(indent).append(lines[n2]).append('\n');
                    continue;
                }
                b.append(indent).append(lines[n2]);
            }
            if (n2 >= lines.length - 1) continue;
            b.append('\n');
        }
        return b.toString();
    }

    private String replaceEscapes(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        CharArrayWriter out = new CharArrayWriter();
        Tokenizer t = new Tokenizer();
        t.setBuffer(txt);
        char c = t.readChar();
        while (c != '\u0000') {
            if (c != '\\') {
                out.append(c);
                c = t.readChar();
                continue;
            }
            char ch = this.convertEscape(t.peekNextChar());
            if (ch == '\u0000') {
                c = t.readChar();
            } else {
                out.append(ch);
                c = t.readChar();
                if (c == '\u0000') {
                    return out.toString();
                }
            }
            c = t.readChar();
        }
        return out.toString();
    }

    private char convertEscape(char c1) {
        switch (c1) {
            case 't': {
                return '\u0000';
            }
            case 'n': {
                return '\n';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return '\u0000';
    }

    public String convertToEscapedStr() {
        RibTokenizer ribtok = new RibTokenizer();
        StringBuffer b = new StringBuffer();
        String[] lines = TextUtils.tokenize(this.text, '\n');
        for (int n = 0; n < lines.length; ++n) {
            String s = lines[n].trim();
            if (n == lines.length - 1) {
                b.append(lines[n]);
                continue;
            }
            if (n < lines.length - 1) {
                String trimmed = lines[n + 1].trim();
                String[] t = TextUtils.tokenize(trimmed);
                if (ribtok.isFunction(t[0]) || trimmed.startsWith("version")) {
                    if (s.endsWith("\"")) {
                        b.append(lines[n]).append(" \n");
                        continue;
                    }
                    b.append(lines[n]).append("\n");
                    continue;
                }
                b.append(lines[n]).append(" ");
                continue;
            }
            b.append(lines[n]).append("\n");
        }
        this.text = b.toString();
        if (this.text.endsWith("\n")) {
            this.text = this.text.substring(0, this.text.length() - 2);
        }
        if (this.text == null || this.text.trim().length() == 0) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        Tokenizer t = new Tokenizer();
        t.setBuffer(this.text);
        char c = t.readChar();
        boolean addedNoneWhite = false;
        boolean addedNewline = false;
        while (c != '\u0000') {
            switch (c) {
                case '\n': {
                    out.append("\\").append("n");
                    addedNoneWhite = false;
                    break;
                }
                case '\t': {
                    out.append("\\").append("t");
                    addedNoneWhite = false;
                    break;
                }
                case '\"': {
                    out.append("\\").append("\"");
                    addedNoneWhite = true;
                    break;
                }
                case ' ': {
                    if (!addedNoneWhite) break;
                    out.append(' ');
                    addedNoneWhite = false;
                    break;
                }
                default: {
                    out.append(c);
                    addedNoneWhite = true;
                    addedNewline = false;
                }
            }
            c = t.readChar();
        }
        String str = out.toString();
        str = str.substring(0, str.length());
        str = " \"" + str + " \\n\"";
        return str;
    }

    public PayloadLine[] getOpenPayloadLines(KTextPane textpane) {
        Document doc = textpane.getDocument();
        Element[] elements = DocumentUtils.getElements(doc, 0, doc.getLength());
        Vector<PayloadLine> listOfElements = new Vector<PayloadLine>();
        try {
            for (int n = 0; n < elements.length; ++n) {
                int end;
                int begin = elements[n].getStartOffset();
                String raw = doc.getText(begin, (end = elements[n].getEndOffset()) - begin);
                String trimmed = raw.trim();
                if (!trimmed.startsWith("\"payload\"") || trimmed.endsWith(",")) continue;
                PayloadLine ped = new PayloadLine();
                ped.e = elements[n];
                ped.begin = begin;
                ped.end = end;
                ped.text = raw;
                listOfElements.addElement(ped);
            }
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:RlfHelp.getCloseAllPayloadsItem() " + ex.toString());
            return null;
        }
        PayloadLine[] out = new PayloadLine[listOfElements.size()];
        for (int n = 0; n < listOfElements.size(); ++n) {
            out[n] = (PayloadLine)listOfElements.elementAt(n);
        }
        return out;
    }

    public class PayloadLine {
        Element e;
        String text = null;
        int begin = -1;
        int end = -1;
    }
}

