/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rlf;

import UI_Desktop.Cutter;
import UI_Script.Rlf.RlfJSONRsrc;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class RlfJSONTokenizer
extends Tokenizer {
    private static ResourceBundle RlfStatementsRes;
    private static Hashtable<String, String> language;
    public boolean payloadIsOpen = false;

    private static String getFunction(String nm) {
        String str;
        try {
            str = RlfStatementsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numFunctions() {
        int num = 0;
        try {
            num = ((RlfJSONRsrc)RlfStatementsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read RlfLanguageRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < RlfJSONTokenizer.numFunctions(); ++i) {
            language.put(((RlfJSONRsrc)RlfStatementsRes).getKey(i), ((RlfJSONRsrc)RlfStatementsRes).getContent(i));
        }
    }

    public RlfJSONTokenizer() {
        this.addComment("/*", "*/");
        this.addComment("//", "\n");
        String[] ext = new String[]{"rlf", "RLF"};
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor(".-");
    }

    @Override
    public boolean isUserVariable(String str) {
        return false;
    }

    @Override
    public boolean isNamedSpace(String str) {
        if (!str.startsWith("\"") && !str.endsWith("\"")) {
            return false;
        }
        if (str.length() < 5) {
            return false;
        }
        if (!language.containsKey(str = str.substring(1, str.length() - 1))) {
            return false;
        }
        return language.get(str).equals("language");
    }

    public int isPayloadBegin(String str) {
        if (str.startsWith("\"##")) {
            this.payloadIsOpen = true;
            this.removeDelimitor(" ");
            return 3;
        }
        if (str.startsWith("##")) {
            this.payloadIsOpen = true;
            this.removeDelimitor(" ");
            return 2;
        }
        return 0;
    }

    public boolean isPayloadEnd(String str) {
        if (!this.payloadIsOpen) {
            return false;
        }
        if (str.trim().equals(",")) {
            this.addDelimitor(' ');
            this.payloadIsOpen = false;
            return true;
        }
        return false;
    }

    public void addDelimitor(char c) {
        this.delimitors = this.delimitors + c;
    }

    static {
        language = new Hashtable();
        try {
            RlfStatementsRes = ResourceBundle.getBundle("UI_Script.Rlf.RlfJSONRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Exception: RlfTokenizer = " + mre);
        }
        RlfJSONTokenizer.initHashTable();
    }
}

