/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rlf;

import UI_Script.Help.KAbstractHelp;
import UI_Script.Rlf.OpenRlfAction;
import UI_Script.Rlf.RlfHelp;
import UI_Script.Rlf.RlfJSONTokenizer;
import UI_Script.Rlf.RlfXMLListener;
import UI_Script.ScriptHandler;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.Tabs.Rib.RenderManager;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import javax.swing.JMenuItem;

public class RlfScriptHandler
extends ScriptHandler {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public RlfScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".rlf";
        this.ext[1] = ".rlf";
        this.setTokenizer();
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(RlfHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        String text = textpane.getText();
        return RlfXMLListener.class.getName();
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("rlf", "RenderMan Look File");
        return filter;
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.rlf");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public void execute(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        String rlfname = file.getName();
        String ribname = TextUtils.removeExtension(rlfname) + ".rib";
        File ribfile = new File(file.getParent(), ribname);
        RenderManager.renderFile(ribfile, "", false, true);
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.rlf");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public String getScriptName() {
        return "Rlf";
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Rlf");
        item.addActionListener(new OpenRlfAction());
        return item;
    }

    @Override
    public String getExecuteLabel() {
        return "Execute " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new RlfJSONTokenizer();
    }
}

