/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rlf;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Script.Html.HtmlListener;
import UI_Script.Rib.RibTokenizer;
import UI_Script.Rlf.RlfXMLTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import java.awt.Color;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class RlfXMLListener
extends HtmlListener {
    private Vanilla vanilla = new Vanilla();
    private Style tagStyle;
    private String str = "";
    private int index;
    private int begin;

    public RlfXMLListener(KTextPane textpane) {
        super(textpane);
        this.setTokenizer(new RlfXMLTokenizer());
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_RLF_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RLF_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RLF_RIB));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_RLF_KEYWORD));
        Color RLD = Preferences.getColor(Preferences.TEXT_COLOR_RLF_KEYWORD).darker();
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, RLD);
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_RLF_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_RLF_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_RLF_ESCAPE));
        Color tagColor = Preferences.getColor(Preferences.TEXT_COLOR_RLF_STRING);
        StyleConstants.setForeground(textpane.styleContext.stringStyle3, tagColor);
        this.tagStyle = textpane.styleContext.stringStyle3;
    }

    protected void colorizeRIB(int begin, String payload, StyleEdits editList) {
        RibTokenizer rt = new RibTokenizer();
        rt.setBuffer(payload);
        String s = rt.getNextStr();
        while (!s.equals("")) {
            int offset = begin + rt.getBufferIndex() - s.length();
            if (rt.isRibStatement(s)) {
                editList.addEdit(offset, s.length(), this.textpane.styleContext.keywordStyle1, true);
            } else if (rt.isComment(s)) {
                editList.addEdit(offset, s.length(), this.textpane.styleContext.commentStyle1, true);
            } else if (rt.isOpenQuotation(s)) {
                editList.addEdit(offset, s.length(), this.textpane.styleContext.stringStyle1, true);
            } else {
                editList.addEdit(offset, s.length(), this.textpane.styleContext.plainStyle, true);
            }
            s = rt.getNextStr();
        }
        editList.addEdit(begin + payload.length(), 3, this.tagStyle, true);
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        String tail;
        if (str.startsWith("<![CDATA[")) {
            editList.addEdit(begin + 1, 8, this.textpane.styleContext.keywordStyle2, true);
            this.colorizeRIB(begin + 9, str.substring(9, str.length() - 3), editList);
            return true;
        }
        editList.addEdit(begin, str.length(), this.tagStyle, true);
        if (str.length() >= 3 && ((tail = str.substring(2)).startsWith("Payload") || tail.startsWith("InjectablePayloads") || tail.startsWith("RenderManLookFile") || tail.startsWith("TightBindings"))) {
            editList.addEdit(begin, 1, this.tagStyle, true);
            editList.addEdit(begin + 1, str.length() - 2, this.textpane.styleContext.keywordStyle2, true);
            editList.addEdit(begin + str.length() - 1, 1, this.tagStyle, true);
            return true;
        }
        this.vanilla.setBuffer(str.substring(1));
        String s = this.vanilla.getNextStr();
        String activeKeyword = "";
        int editBegin = 0;
        int editEnd = 0;
        while (!s.equals("")) {
            int editLen;
            if (this.tok.isLanguageType(s)) {
                activeKeyword = s;
                editLen = s.length();
                editEnd = begin + 1 + this.vanilla.getBufferIndex();
                editBegin = editEnd - editLen;
                editList.addEdit(editBegin, editLen, this.textpane.styleContext.keywordStyle2, true);
            } else if (this.vanilla.isOpenQuotation(s)) {
                editLen = s.length() - 2;
                editEnd = begin + 1 + this.vanilla.getBufferIndex();
                editBegin = editEnd - editLen;
                if (s.equals("\"RenderMan Look Data\"")) {
                    editList.addEdit(editBegin - 1, editLen, this.textpane.styleContext.keywordStyle3, false);
                }
                if (activeKeyword.equals("Key")) {
                    editList.addEdit(editBegin - 1, editLen, this.textpane.styleContext.keywordStyle4, false);
                }
                activeKeyword = "";
            } else {
                editLen = this.vanilla.getBufferIndex() - editEnd;
                editList.addEdit(editEnd, editLen, this.tagStyle, true);
            }
            s = this.vanilla.getNextStr();
        }
        return true;
    }

    @Override
    protected synchronized void parse(Segment segment, int offset) {
        if (!this.doColoration || segment == null || segment.count == 0) {
            return;
        }
        if (this.tok == null) {
            Cutter.setLog("    Error:RlfXMLListener.parse(Segment, int) - null tokenizer");
            return;
        }
        this.tok.setBuffer(segment);
        this.tok.getComments = true;
        this.str = this.tok.getNextStr();
        if (this.str == null) {
            Cutter.setLog("RlfXMLListener.parse() - initial getNextStr() returned a null string");
            return;
        }
        this.editList = new StyleEdits(this);
        while (!this.str.equals("")) {
            this.index = this.tok.getBufferIndex() - 1 < 0 ? 0 : this.tok.getBufferIndex();
            this.index += offset;
            this.begin = this.index - this.str.length();
            if (this.tok.isComment(this.str)) {
                this.editList.addEdit(this.begin, this.str.length(), this.textpane.styleContext.commentStyle1, true);
            } else if (!this.customSyntax(this.str, this.begin, this.editList)) {
                this.editList.addEdit(this.begin, this.str.length(), this.textpane.styleContext.plainStyle, true);
            }
            this.str = this.tok.getNextStr();
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RlfXMLListener.this.editList.applyEdits((DefaultStyledDocument)RlfXMLListener.this.textpane.getDocument());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Vanilla
    extends Tokenizer {
        public Vanilla() {
            this.setDefaultDelimitors();
            this.appendDelimitor("=");
            this.addQuotation("\"", "\"", '\\');
        }
    }
}

